/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import se.datadosen.jalbum.FileListMenuListener;
import se.datadosen.jalbum.JFileMenuItem;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.RecentProjectFiles;

public class JFileListMenu
extends JMenu
implements ActionListener,
RecentProjectFiles.Listener {
    private transient Vector<FileListMenuListener> fileListMenuListeners;
    private final RecentProjectFiles recentFiles;

    public JFileListMenu(RecentProjectFiles recentFiles) {
        this.recentFiles = recentFiles;
        recentFiles.addListener(this);
        this.rebuildMenu();
    }

    public List<File> getFiles() {
        return this.recentFiles.getFiles();
    }

    public void replaceFile(File oldFile, File newFile) {
        this.recentFiles.replaceFile(oldFile, newFile);
    }

    public void addFile(File file) {
        this.recentFiles.addFile(file);
    }

    protected void rebuildMenu() {
        JMenuItem item;
        this.removeAll();
        List<File> files = this.recentFiles.getFiles();
        if (files.size() > 0) {
            item = new JMenuItem("<< " + Msg.get("ui.clearList") + " >>");
            item.addActionListener(e -> {
                int answer = JOptionPane.showConfirmDialog(this, Msg.get("ui.clearList"));
                if (answer == 0) {
                    this.recentFiles.clear();
                }
            });
            this.add(item);
        }
        int i = 0;
        for (File f : files) {
            String view = f.getAbsolutePath();
            if (f.getName().equals("jalbum-settings.jap")) {
                view = f.getParentFile().getAbsolutePath();
            }
            item = new JFileMenuItem(view, f);
            if (i < 3) {
                item.setAccelerator(KeyStroke.getKeyStroke(49 + i, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            item.addActionListener(this);
            this.add(item);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = mgr.getFocusOwner();
        if (focusOwner instanceof JTextComponent) {
            focusOwner.transferFocusUpCycle();
        }
        SwingUtilities.invokeLater(() -> this.fireFileSelected(e));
    }

    public synchronized void removeFileListMenuListener(FileListMenuListener l) {
        if (this.fileListMenuListeners != null && this.fileListMenuListeners.contains(l)) {
            Vector v = (Vector)this.fileListMenuListeners.clone();
            v.removeElement(l);
            this.fileListMenuListeners = v;
        }
    }

    public synchronized void addFileListMenuListener(FileListMenuListener l) {
        Vector v;
        Vector vector = v = this.fileListMenuListeners == null ? new Vector(2) : (Vector)this.fileListMenuListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.fileListMenuListeners = v;
        }
    }

    protected void fireFileSelected(ActionEvent e) {
        if (this.fileListMenuListeners != null) {
            for (FileListMenuListener l : this.fileListMenuListeners) {
                l.fileSelected(e);
            }
        }
    }

    @Override
    public void structureChanged(RecentProjectFiles list) {
        this.rebuildMenu();
    }

    @Override
    public void projectFileRenamed(RecentProjectFiles list, File oldName, File newName) {
        this.rebuildMenu();
    }
}

