/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.datadosen.jalbum.Msg;

public class JErrorFrame
extends JFrame {
    private JTextArea textArea = new JTextArea(30, 60);
    Action copyToClipboardAction = new AbstractAction(Msg.get("ui.copyToClipboard")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(JErrorFrame.this.textArea.getText()), null);
        }
    };

    public JErrorFrame(Throwable t) {
        super("Error initializing jAlbum");
        this.textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.textArea);
        this.setLayout(new BorderLayout());
        this.add(scroller);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.copyToClipboardAction));
        this.add((Component)buttonPanel, "South");
        OutputStream output = new OutputStream(){
            private StringBuilder string = new StringBuilder();

            @Override
            public void write(int b) throws IOException {
                this.string.append((char)b);
            }

            public String toString() {
                return this.string.toString();
            }
        };
        try (PrintWriter out = new PrintWriter(output);){
            t.printStackTrace(out);
        }
        this.textArea.append("We're sorry. jAlbum is unable to start. Please pass this error report to support@jalbum.net\nThank you for your patience.\n\n");
        this.textArea.append("Version: 39\n");
        this.textArea.append("OS: " + System.getProperty("os.name") + "\n");
        this.textArea.append("Architecture: " + System.getProperty("os.arch") + "\n\n");
        this.textArea.append(output.toString());
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }
}

