/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.jalbum.component.JRememberedFrame;
import net.jalbum.component.RememberedName;
import net.jalbum.script.GroovierScriptEngine;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import se.datadosen.component.FindAndReplace;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JSmartSyntaxTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.io.ConsoleStream;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.Paginator;
import se.datadosen.jalbum.ScriptEnginePool;
import se.datadosen.jalbum.ScriptLanguage;
import se.datadosen.util.BeanBinderException;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.MenuAction;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.annotations.Text;

@RememberedName(value="Console window")
public class JConsoleFrame
extends JRememberedFrame {
    private static final String SCRIPT_LANGUAGE = "scriptLanguage";
    private static final String OUTPUT_MODE = "outputMode";
    private static ClassLoader loader;
    private ScriptEnginePool pool;
    private final Preferences prefs = Preferences.userNodeForPackage(JConsoleFrame.class);
    JPanel buttonPanel = new JPanel(new RiverLayout(4, 2));
    @Text(value="ui.scriptingLanguage")
    JLabel languageLabel = new JLabel();
    JComboBox<ScriptLanguage> languages = new JComboBox<ScriptLanguage>(ScriptLanguage.values());
    @Text(value="ui.thread")
    JLabel threadLabel = new JLabel();
    JComboBox<Threads> thread = new JComboBox<Threads>(Threads.values());
    JSmartSyntaxTextArea console = new JSmartSyntaxTextArea();
    RTextScrollPane topScrollPane = new RTextScrollPane((RTextArea)this.console, true);
    AbstractCompletionProvider provider = new DefaultCompletionProvider(){

        protected List<Completion> getCompletionsImpl(JTextComponent comp) {
            this.completions = new ArrayList();
            String alreadyEntered = this.getAlreadyEnteredText(comp);
            Bindings bindings = JConsoleFrame.this.scriptEngine.getBindings(100);
            if (bindings.isEmpty()) {
                JConsoleFrame.this.initVars();
                bindings = JConsoleFrame.this.scriptEngine.getBindings(100);
            }
            for (Map.Entry e : bindings.entrySet()) {
                String name = (String)e.getKey();
                if (!name.startsWith(alreadyEntered)) continue;
                String type = e.getValue() != null ? e.getValue().getClass().getName() : "";
                this.completions.add(new VariableCompletion((CompletionProvider)this, name, type));
            }
            return this.completions;
        }
    };
    AutoCompletion completion = new AutoCompletion((CompletionProvider)this.provider);
    JSplitPane jSplitPane = new JSplitPane();
    JLabel statusBar = new JLabel();
    JScrollPane bottomScrollPane = new JScrollPane();
    JSmartSyntaxTextArea output = new JSmartSyntaxTextArea();
    PrintStream stream = new PrintStream(new ConsoleStream((JTextComponent)((Object)this.output)), true);
    JAlbumFrame ui;
    ScriptEngine scriptEngine;
    private FindAndReplace consoleFindAndReplace = new FindAndReplace(this, (JTextArea)((Object)this.console));
    private FindAndReplace outputFindAndReplace = new FindAndReplace(this, (JTextArea)((Object)this.output));
    private JMenuBar menuBar = new JMenuBar();
    @Text(value="ui.edit")
    private JMenu editMenu = new JMenu();
    private JMenuItem cutMenuItem = new JMenuItem();
    private JMenuItem copyMenuItem = new JMenuItem();
    private JMenuItem pasteMenuItem = new JMenuItem();
    private JMenuItem findMenuItem = new JMenuItem();
    private JMenuItem findNextMenuItem = new JMenuItem();
    private JMenuItem replaceMenuItem = new JMenuItem();
    @Text(value="ui.view")
    private JMenu viewMenu = new JMenu();
    @Text(value="ui.outputMode")
    private JMenu outputModeMenu = new JMenu();
    @Text(value="ui.evaluate")
    Action evalExpression = new TextAction("Eval"){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String expr;
                Object focused = this.getFocusedComponent();
                if (focused == null) {
                    focused = JConsoleFrame.this.console;
                }
                if ((expr = focused == JConsoleFrame.this.output && JConsoleFrame.this.output.getSelectedText() != null ? JConsoleFrame.this.output.getSelectedText() : JConsoleFrame.this.console.getSelectedText()) == null) {
                    expr = JConsoleFrame.this.console.getText();
                }
                JConsoleFrame.this.ui.ui2Engine();
                Stopwatch sw = new Stopwatch().start();
                Object result = JConsoleFrame.this.processExpression(expr);
                System.out.println(String.valueOf(sw) + " ==> " + String.valueOf(result));
                ((JComponent)focused).requestFocusInWindow();
            }
            catch (ScriptException ex) {
                Debug.showStackTraceDialog((Component)((Object)JConsoleFrame.this.console), ex);
            }
            catch (OperationAbortedException ex) {
                JConsoleFrame.this.ui.statusBar.setText(Msg.get("ui.operationAborted"));
            }
            catch (BeanBinderException ex) {
                Debug.showErrorDialog(JConsoleFrame.this, ex);
            }
        }
    };
    JButton evaluateButton = new JButton(this.evalExpression);
    @Text(value="ui.dumpThreads")
    Action dumpThreads = new AbstractAction(null, Icons.small("textdoc")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbum.dumpThreads();
        }
    };
    JButton dumpThreadsButton = new JPlainButton(this.dumpThreads, false);
    Action closeConsoleWindowAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JConsoleFrame.this.setVisible(false);
        }
    };
    Object ret;
    Throwable error;

    public JConsoleFrame(JAlbumFrame ui) {
        this.ui = ui;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void handleFocusedComponent(JTextArea ta) {
        FindAndReplace fr = ta == this.console ? this.consoleFindAndReplace : this.outputFindAndReplace;
        this.cutMenuItem.setAction(new MenuAction(ta.getActionMap().get("cut-to-clipboard")));
        this.copyMenuItem.setAction(new MenuAction(ta.getActionMap().get("copy-to-clipboard")));
        this.pasteMenuItem.setAction(new MenuAction(ta.getActionMap().get("paste-from-clipboard")));
        this.findMenuItem.setAction(fr.findAction);
        this.findNextMenuItem.setAction(fr.findNextAction);
        this.replaceMenuItem.setAction(fr.replaceAction);
    }

    void init() throws Exception {
        this.getRootPane().registerKeyboardAction(this.closeConsoleWindowAction, KeyStroke.getKeyStroke(118, 0), 2);
        this.pool = new ScriptEnginePool(loader);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setIconImages(JAlbumFrameIcons.getInstance().getWindowIcons());
        Msg.maintainTranslated(this);
        ContextHelp.getInstance().add(this.buttonPanel, "SystemConsole");
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 1, 4));
        this.buttonPanel.add(this.languageLabel);
        this.buttonPanel.add(this.languages);
        this.buttonPanel.add(Box.createHorizontalStrut(6));
        this.buttonPanel.add(this.threadLabel);
        this.buttonPanel.add(this.thread);
        this.buttonPanel.add("hfill", Box.createHorizontalGlue());
        this.buttonPanel.add(this.evaluateButton);
        this.buttonPanel.add(this.dumpThreadsButton);
        this.buttonPanel.add(ContextHelp.getInstance().getContext(this).getHelpButton());
        this.languages.addActionListener(e -> {
            ScriptLanguage sl = (ScriptLanguage)this.languages.getSelectedItem();
            this.setScriptEngine(sl);
            this.prefs.put(SCRIPT_LANGUAGE, sl.getLanguageName());
            this.console.setSyntaxEditingStyle(((ScriptLanguage)this.languages.getSelectedItem()).getMimeType());
        });
        this.console.setTabSize(3);
        this.consoleFindAndReplace.onStatus(s -> this.ui.statusBar.setText((String)s));
        this.outputFindAndReplace.onStatus(s -> this.ui.statusBar.setText((String)s));
        this.completion.install((JTextComponent)((Object)this.console));
        this.console.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(32, 128), new LambdaAction(() -> this.completion.doCompletion()));
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setLeftComponent((Component)this.topScrollPane);
        this.jSplitPane.setRightComponent(this.bottomScrollPane);
        this.output.setColumns(100);
        this.output.setRows(20);
        this.output.setFont(new Font("Monospaced", 0, Config.getConfig().getFontSize()));
        Container content = this.getContentPane();
        content.add((Component)this.buttonPanel, "North");
        content.add((Component)this.jSplitPane, "Center");
        content.add((Component)this.statusBar, "South");
        this.bottomScrollPane.getViewport().add((Component)((Object)this.output), null);
        KeyStroke ctrlE = KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.jSplitPane.registerKeyboardAction(this.evalExpression, "evalExpression", ctrlE, 2);
        KeyStroke ctrlEnter = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        this.jSplitPane.registerKeyboardAction(this.evalExpression, "evalExpression", ctrlEnter, 2);
        this.jSplitPane.setDividerLocation(150);
        this.jSplitPane.setPreferredSize(new Dimension(740, 540));
        this.console.setText("// Code input area\n");
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        this.editMenu.add(this.cutMenuItem);
        this.editMenu.add(this.copyMenuItem);
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.findMenuItem);
        this.editMenu.add(this.findNextMenuItem);
        this.editMenu.add(this.replaceMenuItem);
        this.viewMenu.add(this.outputModeMenu);
        ButtonGroup bg = new ButtonGroup();
        for (String style : new String[]{"text/plain", "text/json", "text/html", "text/properties", "text/xml"}) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(style);
            bg.add(item);
            item.addActionListener(ae -> this.setOutputMode(item.getText()));
            this.outputModeMenu.add(item);
        }
        this.getRootPane().setJMenuBar(this.menuBar);
        this.handleFocusedComponent((JTextArea)((Object)this.console));
        this.console.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JConsoleFrame.this.handleFocusedComponent((JTextArea)((Object)JConsoleFrame.this.console));
            }
        });
        this.output.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JConsoleFrame.this.handleFocusedComponent((JTextArea)((Object)JConsoleFrame.this.output));
            }
        });
        this.output.setBracketMatchingEnabled(true);
        this.output.setCodeFoldingEnabled(false);
        this.output.addCaretListener(ce -> this.updateStatusBar());
        this.setOutputMode(this.prefs.get(OUTPUT_MODE, "text/json"));
        if (this.getWidth() < 200 && this.getHeight() < 200) {
            this.pack();
        } else {
            this.validate();
        }
    }

    private void setOutputMode(String mode) {
        for (int i = 0; i < this.outputModeMenu.getItemCount(); ++i) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)this.outputModeMenu.getItem(i);
            if (!mode.equals(item.getText())) continue;
            item.setSelected(true);
            this.output.setSyntaxEditingStyle(item.getText());
            this.updateStatusBar();
            this.prefs.put(OUTPUT_MODE, mode);
            return;
        }
    }

    private void updateStatusBar() {
        int line = this.output.getCaretLineNumber() + 1;
        int col = this.output.getCaretOffsetFromLineStart() + 1;
        this.statusBar.setText(" Mode " + this.output.getSyntaxEditingStyle() + " | Ln " + line + ", Col " + col);
    }

    void setDefaultScriptEngine() {
        try {
            this.languages.setSelectedItem(ScriptLanguage.valueOf(this.prefs.get(SCRIPT_LANGUAGE, ScriptLanguage.GROOVY.getLanguageName())));
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Can't find script language " + this.prefs.get(SCRIPT_LANGUAGE, ""));
            this.languages.setSelectedItem(ScriptLanguage.valueOf(ScriptLanguage.GROOVY.getLanguageName()));
        }
    }

    private void importPackage(String packageName) throws ScriptException {
        this.scriptEngine.eval("import " + packageName + ".*;");
    }

    private String getIntroText(ScriptEngineManager manager, ScriptLanguage language) {
        return "jAlbum " + AlbumBean.getInternalVersion() + " system console running " + String.valueOf(language) + "\nThis section captures debug prints sent to System.out and System.err\nThe top section evaluates expressions.\nPress " + InputEvent.getModifiersExText(Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) + "+E to evaluate an expression. (Evaluates selected text if selection is active)\nYou have access to the basic jAlbum implicit objects such as engine and window\n";
    }

    private void setScriptEngine(ScriptLanguage language) {
        try {
            ScriptEngineManager manager = this.pool.getScriptEngineManager();
            this.scriptEngine = manager.getEngineByName(language.getLookupName());
            if (language == ScriptLanguage.BEANSHELL) {
                this.importPackage("se.datadosen.jalbum");
                this.importPackage("se.datadosen.util");
                this.importPackage("se.datadosen.component");
                this.importPackage("net.jalbum");
                this.importPackage("net.jalbum.util");
                this.importPackage("net.miginfocom.swing");
                this.output.setText(this.getIntroText(manager, language) + "\nSample expressions:\n4*(3+2); // Basic calculations\nengine.getSkin(); // Use of implicit object\nfor (AlbumObject ao : selectedObjects) System.out.println(ao); // Iterate over selected objects\nwindow.messageBox(\"You can interact with any Java object\");\nProfiler.getInstance(); // Print profiling data for last album build\n");
            } else if (language == ScriptLanguage.GROOVY) {
                ((GroovierScriptEngine)((Object)this.scriptEngine)).setRememberImports(true);
                this.output.setText(this.getIntroText(manager, language) + "\nSample expressions:\n4*(3+2); // Basic calculations\nengine.getSkin(); // Use of implicit object\nfor (AlbumObject ao : selectedObjects) println ao; // Iterate over selected objects\nwindow.messageBox(\"You can interact with any Java object\");\nProfiler.instance // Print profiling data for last album build\n");
            } else if (language.getLanguageName().equals("ECMAScript")) {
                this.output.setText(this.getIntroText(manager, language) + "\nSample expressions:\n4*(3+2); // Basic calculations\nalbumEngine.getSkin(); // Use of implicit object\nfor each (ao in selectedObjects) print(ao); // Iterate over selected objects\nwindow.messageBox(\"You can interact with any Java object\");\n");
            } else {
                this.output.setText(this.getIntroText(manager, language));
            }
        }
        catch (ScriptException ex) {
            Logger.getLogger(JConsoleFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setText(String text) {
        this.console.setText(text);
    }

    public String getText() {
        return this.console.getText();
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    private void initVars() {
        Bindings vars = this.scriptEngine.createBindings();
        this.ui.engine.addGlobals(vars, false);
        vars.put("rootFolder", (Object)this.ui.albumExplorer.getRootFolder());
        vars.put("currentFolder", (Object)this.ui.albumExplorer.getCurrentFolder());
        AlbumObject[] sel = this.ui.albumExplorer.explorer.getSelectedAlbumObjects();
        vars.put("children", (Object)new Paginator(this.ui.engine, this.ui.albumExplorer.getCurrentFolder()));
        vars.put("selected", (Object)(sel.length > 0 ? sel[0] : null));
        vars.put("albumEngine", (Object)this.ui.engine);
        vars.put("out", (Object)System.out);
        Map userVariables = this.ui.engine.getUserVariables();
        if (userVariables != null) {
            vars.putAll(userVariables);
        }
        AlbumBean.setVars((Map<String, Object>)vars, this.scriptEngine);
    }

    private Object processExpression(String expr) throws ScriptException {
        this.initVars();
        if (this.thread.getSelectedItem() == Threads.AWT) {
            return this.scriptEngine.eval(expr);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = tk.getSystemEventQueue();
        SecondaryLoop loop = eventQueue.createSecondaryLoop();
        this.error = null;
        this.ret = null;
        Platform.runLater(() -> {
            try {
                this.ret = this.scriptEngine.eval(expr);
                if (this.ret != null) {
                    this.ret = this.ret.toString();
                }
            }
            catch (Throwable ex) {
                this.error = ex;
            }
            finally {
                loop.exit();
            }
        });
        loop.enter();
        if (this.error != null) {
            if (this.error instanceof ScriptException) {
                throw (ScriptException)this.error;
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            throw new RuntimeException(this.error);
        }
        return this.ret;
    }

    static {
        try {
            loader = new URLClassLoader(new URL[]{Config.getConfig().pluginsDir.toURI().toURL()}, JConsoleFrame.class.getClassLoader());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    static enum Threads {
        AWT,
        JAVAFX;

    }
}

