/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import se.datadosen.component.Hour;
import se.datadosen.component.JNotification;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.WaitCursor;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ProjectSettings;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.LambdaAction;

public class JChangeStatus
extends JPlainButton {
    private final JAlbumFrame window;

    public JChangeStatus(final JAlbumFrame window) {
        super((Icon)null);
        this.window = window;
        this.setVisible(false);
        this.addActionListener(ae -> {
            this.refresh();
            JSmartDialog d = new JSmartDialog(this, window, Msg.get("ui.settingsChangesTitle")){
                final /* synthetic */ JChangeStatus this$0;
                {
                    this.this$0 = this$0;
                    super(p0, p1);
                    this.addAction(new LambdaAction(Msg.get("ui.revertSettings"), ae -> {
                        ProjectSettings last = (ProjectSettings)window.getRoot().getProperties().get("projectSettings");
                        if (last != null) {
                            window2.configureCounter.workStarted();
                            Object props = null;
                            try (WaitCursor.WaitToken _wt = window2.waitCursor.getToken();){
                                window2.loadingProject = true;
                                window2.loadHints = false;
                                BeanBinder.setProperties(window2.engine, last.main);
                                window2.engine.setUserVariables(last.user);
                                window2.engine.setSkinVariables(last.skin);
                                window2.mainSettingsPanel.skin.setActionCommand("comboBoxChangedDuringProjectLoading");
                                window2.mainSettingsPanel.setSelectedSkin(window2.engine.getSkin());
                                window.engine2UI();
                                this.setVisible(false);
                            }
                            finally {
                                window2.loadingProject = false;
                                window2.loadHints = true;
                                window2.configureCounter.workDone();
                                SwingUtilities.invokeLater(() -> this.this$0.refresh());
                            }
                        }
                    }));
                    this.registerActions(new LambdaAction(Msg.get("close"), ae -> this.setVisible(false)));
                }
            };
            ProjectSettings last = (ProjectSettings)window.getRoot().getProperties().get("projectSettings");
            if (last != null) {
                ProjectSettings settings = new ProjectSettings(window.engine);
                ProjectSettings.Differences diff = settings.compareUnion(last);
                JTable table = new JTable(new ChangeTableModel(last, settings, diff));
                final TableCellRenderer defRenderer = table.getDefaultRenderer(Object.class);
                table.setDefaultRenderer(JLabel.class, new TableCellRenderer(){
                    final /* synthetic */ JChangeStatus this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JLabel template = (JLabel)defRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        JLabel lab = (JLabel)value;
                        lab.setOpaque(true);
                        lab.setBackground(template.getBackground());
                        return lab;
                    }
                });
                JScrollPane scroller = new JScrollPane(table, 20, 30);
                d.add(scroller);
                d.pack();
                d.setVisible(true);
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        boolean nowVisible = false;
        if (!this.isVisible() && visible) {
            nowVisible = true;
        }
        super.setVisible(visible);
        if (nowVisible) {
            TipOfTheDay.showSpeechBubble(this.window.mainSettingsPanel.makeAlbumButton, new Hour(3), Msg.get("tip.updateChanges", Msg.get("ui.makeAlbum")) + " ", 8);
        }
    }

    void refresh() {
        ProjectSettings last = (ProjectSettings)this.window.getRoot().getProperties().get("projectSettings");
        if (last != null) {
            ProjectSettings current = new ProjectSettings(this.window.engine);
            if (this.window.mainSettingsPanel.isLoadingSkin() || current.unionEquals(last)) {
                this.setVisible(false);
                this.setToolTipText(null);
            } else if (current.imageRelated().unionEquals(last.imageRelated())) {
                this.setIcon(Icons.get("btn-asterisk-normal"));
                this.setToolTipText(Msg.get("ui.settingsChanged"));
                this.setVisible(true);
            } else {
                this.setIcon(Icons.get("btn-asterisk-red"));
                this.setToolTipText(Msg.get("ui.imageSettingsChanged"));
                this.setVisible(true);
            }
        } else {
            this.setVisible(false);
        }
    }

    private static class ChangeTableModel
    implements TableModel {
        private final ProjectSettings old;
        private final ProjectSettings neew;
        String[] main;
        String[] user;
        String[] skin;
        private final String[] colNames = new String[]{Msg.get("ui.name"), Msg.get("ui.new"), Msg.get("ui.old")};

        public ChangeTableModel(ProjectSettings old, ProjectSettings neew, ProjectSettings.Differences diff) {
            this.old = old;
            this.neew = neew;
            this.main = (String[])diff.main.toArray(String[]::new);
            this.user = (String[])diff.user.toArray(String[]::new);
            this.skin = (String[])diff.skin.toArray(String[]::new);
        }

        @Override
        public int getRowCount() {
            return this.main.length + this.skin.length + this.user.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < this.main.length) {
                int i = rowIndex;
                if (columnIndex == 0) {
                    return new JPlainLabel(this.main[i]);
                }
                if (columnIndex == 1) {
                    return this.neew.main.get(this.main[i]);
                }
                if (columnIndex == 2) {
                    return this.old.main.get(this.main[i]);
                }
            } else if (rowIndex < this.main.length + this.user.length) {
                int i = rowIndex - this.main.length;
                if (columnIndex == 0) {
                    JPlainLabel lab = new JPlainLabel(this.user[i]);
                    lab.setForeground(Color.green);
                    lab.setToolTipText(Msg.get("ui.userVariable"));
                    return lab;
                }
                if (columnIndex == 1) {
                    return this.neew.user.get(this.user[i]);
                }
                if (columnIndex == 2) {
                    return this.old.user.get(this.user[i]);
                }
            } else {
                int i = rowIndex - this.main.length - this.user.length;
                if (columnIndex == 0) {
                    JPlainLabel lab = new JPlainLabel(this.skin[i]);
                    lab.setForeground(JNotification.Type.SKIN.color);
                    lab.setToolTipText(Msg.get("ui.skinSetting"));
                    return lab;
                }
                if (columnIndex == 1) {
                    return this.neew.skin.get(this.skin[i]);
                }
                if (columnIndex == 2) {
                    return this.old.skin.get(this.skin[i]);
                }
            }
            throw new RuntimeException("Invalid row/column: " + rowIndex + ", " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }

    private static class JPlainLabel
    extends JLabel {
        public JPlainLabel(String text) {
            super(text);
        }

        @Override
        public String toString() {
            return this.getText();
        }
    }
}

