/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.jalbum.projectgroups.JProjectGroupsComboBox;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.util.Work;
import se.datadosen.component.ControlPanel;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.BackupRestoreBase;
import se.datadosen.jalbum.FileCopier;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.IO;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.annotations.Text;

public final class JBackupFrame
extends BackupRestoreBase {
    @Text(value="ui.backupSelected")
    Action backupSelectedAction = new LambdaAction(ae -> this.backupProjects(this.getSelectedProjects()));
    @Text(value="ui.backupAll")
    Action backupAllAction = new LambdaAction(ae -> this.backupProjects(this.model.projects));
    @Text(value="ui.location")
    JLabel locationLabel = new JLabel();
    JProjectGroupsComboBox projectGroupSelector = new JProjectGroupsComboBox();
    JButton backupSelectedButton;
    JButton backupAllButton;

    private void backupProjects(List<AlbumProject> projects) {
        FileCopier copier = new FileCopier(this);
        copier.setMillisToPopup(0);
        copier.setAllowDuplicates(true);
        copier.setFileFilter(null);
        copier.setCopyDecision(FileCopier.CopyDecision.COPY);
        File bkDir = new File(this.backupDirectory.getText());
        bkDir.mkdirs();
        AlbumObject bkFolder = this.context.getAlbumObjectfactory().createInstance(bkDir);
        for (AlbumProject ap : projects) {
            copier.setTitle(Msg.get("ui.backingUpX", ap.getName()));
            List<File> copied = copier.copyFiles(List.of(ap.getRootFolder().getFile()), bkFolder);
            if (copier.isAborted()) {
                return;
            }
            long backupDate = new Date().getTime();
            ap.getRootFolder().getProperties().put("lastBackupDate", backupDate);
            ap.getRootFolder().getProperties().save();
            for (File f : copied) {
                Work<AlbumObject> work;
                AlbumObject apCopy = this.context.getAlbumObjectfactory().createInstance(f);
                apCopy.getProperties().put("lastBackupDate", backupDate);
                apCopy.getProperties().save();
                if (!this.includeLinkedFiles.isSelected() || !(work = Work.on(apCopy.getDescendants().filter(ao -> !ao.isView())).owner(this).titled(Msg.get("ui.includeLinkedFiles")).filter(ao -> ao.isLink()).forEach(ao -> {
                    LinkFile link = (LinkFile)ao.getFile();
                    if (link.getTarget().exists()) {
                        IO.copyFile(link.getTarget(), link.getLink());
                    }
                })).isAborted()) continue;
                return;
            }
            this.updateTable(ap);
        }
    }

    public JBackupFrame(JAlbumContext context) {
        super(Msg.get("ui.backupProjects"), context);
        this.projectGroupSelector.addActionListener(ae -> this.setProjectGroup(this.projectGroupSelector.getSelectedGroup()));
        this.backupSelectedButton = new JButton(this.backupSelectedAction);
        this.backupAllButton = new JButton(this.backupAllAction);
        this.init();
    }

    @Override
    protected void init() {
        Msg.maintainTranslated(this);
        super.init();
        ContextHelp help = ContextHelp.getInstance();
        help.installHelpButton(this, ContextHelp.Corner.TOP_RIGHT);
        help.add((JComponent)this.getContentPane(), "https://jalbum.net/help/JAlbum/Menus#Backup_projects...");
        this.buttonPanel.add(this.backupSelectedButton);
        this.buttonPanel.add(this.backupAllButton);
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.backupSelectedButton);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int[] selRows = this.table.getSelectedRows();
            this.backupSelectedAction.setEnabled(selRows.length > 0);
        });
        new Thread(() -> this.projectGroupSelector.setSelectedItem(ProjectGroups.getInstance().getCurrentGroup())).start();
        this.pack();
    }

    @Override
    protected void addAdditionalControls(ControlPanel controls) {
        controls.add("br", this.locationLabel);
        controls.add(this.projectGroupSelector);
    }

    private void setProjectGroup(ProjectGroup group) {
        this.model.clear();
        for (AlbumProject ap : group.getProjects()) {
            this.model.addProject(ap);
        }
    }
}

