/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.jalbum.component.JVUMeter;
import net.jalbum.util.MonitoredWorkQueue;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JModalPanel;
import se.datadosen.component.JSmartToggleButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.SmartAction;
import se.datadosen.dnd.FileDropEvent;
import se.datadosen.dnd.FileDropListener;
import se.datadosen.dnd.JFileDropPanel;
import se.datadosen.io.MP3OutputStream;
import se.datadosen.io.SkipBytesOutputStream;
import se.datadosen.io.VUOutputStream;
import se.datadosen.io.WaveRecodingOutputStream;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAudioClipPanel
extends JModalPanel<JAlbumFrame>
implements FileDropListener {
    private final AlbumObject ao;
    private final Attachments att;
    private File mp3File;
    private Media media;
    private MediaPlayer mediaPlayer;
    private static final FileNameExtensionFilter fileFilter = new FileNameExtensionFilter("Music files", "mp3", "m4a", "wav", "aif", "aiff");
    private static FileChooser musicChooser;
    AudioFileFormat.Type fileType = AudioFileFormat.Type.AU;
    TargetDataLine line;
    SwingWorker<File, Void> recorder;
    JFileDropPanel contentPanel = new JFileDropPanel(new RiverLayout());
    @Text(value="ui.record")
    @Icon(value="16x16/record.svg")
    SmartAction recordAction = new SmartAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JAudioClipPanel.this.recordButton.isSelected()) {
                JAudioClipPanel.this.playAction.setEnabled(false);
                JAudioClipPanel.this.attachAction.setEnabled(false);
                JAudioClipPanel.this.deleteAction.setEnabled(false);
                try {
                    JAudioClipPanel.this.mp3File = new File(JAudioClipPanel.this.att.getAttachmentsDir(true), IO.baseName(JAudioClipPanel.this.ao.getFile()) + ".mp3");
                    JAudioClipPanel.this.mp3File.getParentFile().mkdirs();
                    MP3OutputStream mp3Stream = new MP3OutputStream(JAudioClipPanel.this.getAudioFormat(), new FileOutputStream(JAudioClipPanel.this.mp3File));
                    JAudioClipPanel.this.vuStream.setOut(mp3Stream);
                    JAudioClipPanel.this.vuMeter.setEnabled(true);
                }
                catch (FileNotFoundException ex) {
                    JAudioClipPanel.this.recordButton.setSelected(false);
                    Debug.showErrorDialog(JAudioClipPanel.this.window, ex);
                }
            } else {
                JAudioClipPanel.this.stopAction.actionPerformed(e);
            }
        }
    };
    @Text(value="ui.play")
    @Icon(value="16x16/start.svg")
    Action playAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JAudioClipPanel.this.playButton.isSelected()) {
                File audioClipFile;
                if (JAudioClipPanel.this.mediaPlayer != null) {
                    JAudioClipPanel.this.mediaPlayer.stop();
                }
                if ((audioClipFile = JAudioClipPanel.this.att.get(Attachments.Type.AUDIO)) != null && audioClipFile.exists()) {
                    try {
                        String msg = Msg.get("ui.playingName", audioClipFile.getName());
                        ((JAlbumFrame)((JAudioClipPanel)JAudioClipPanel.this).window).statusBar.pushText(msg);
                        JAudioClipPanel.this.mediaPlayer = new MediaPlayer(new Media(audioClipFile.toURI().toString()));
                        JAudioClipPanel.this.mediaPlayer.setOnPlaying(() -> {
                            JAudioClipPanel.this.recordAction.setEnabled(false);
                            JAudioClipPanel.this.attachAction.setEnabled(false);
                            JAudioClipPanel.this.deleteAction.setEnabled(false);
                        });
                        JAudioClipPanel.this.mediaPlayer.setOnEndOfMedia(() -> {
                            JAudioClipPanel.this.playButton.setSelected(false);
                            JAudioClipPanel.this.recordAction.setEnabled(true);
                            JAudioClipPanel.this.attachAction.setEnabled(true);
                            JAudioClipPanel.this.deleteAction.setEnabled(true);
                            ((JAlbumFrame)((JAudioClipPanel)JAudioClipPanel.this).window).statusBar.popText(msg);
                            JAudioClipPanel.this.unloadMedia();
                        });
                        JAudioClipPanel.this.mediaPlayer.setOnStopped(() -> {
                            JAudioClipPanel.this.recordAction.setEnabled(true);
                            JAudioClipPanel.this.attachAction.setEnabled(true);
                            JAudioClipPanel.this.deleteAction.setEnabled(true);
                            ((JAlbumFrame)((JAudioClipPanel)JAudioClipPanel.this).window).statusBar.popText(msg);
                            JAudioClipPanel.this.unloadMedia();
                        });
                        JAudioClipPanel.this.mediaPlayer.play();
                    }
                    catch (MediaException ex) {
                        JAudioClipPanel.this.playButton.setSelected(false);
                        Debug.showErrorDialog(JAudioClipPanel.this.window, ex);
                    }
                    catch (RuntimeException ex) {
                        Debug.showErrorDialog(JAudioClipPanel.this.window, ex);
                    }
                }
            } else {
                JAudioClipPanel.this.stopAction.actionPerformed(e);
            }
        }
    };
    @Text(value="ui.stop")
    @Icon(value="16x16/stop.svg")
    Action stopAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAudioClipPanel.this.attachAction.setEnabled(true);
            JAudioClipPanel.this.deleteAction.setEnabled(true);
            if (JAudioClipPanel.this.mediaPlayer != null) {
                JAudioClipPanel.this.mediaPlayer.stop();
            }
            if (JAudioClipPanel.this.line != null) {
                JAudioClipPanel.this.line.stop();
                JAudioClipPanel.this.line.close();
                JAudioClipPanel.this.line = null;
                JAudioClipPanel.this.vuMeter.setEnabled(false);
            }
        }
    };
    @ToolTipText(value="ui.attachFile")
    @Icon(value="16x16/add2.svg")
    Action attachAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAudioClipPanel.this.attachAudioClip();
        }
    };
    @ToolTipText(value="edit.delete")
    @Icon(value="16x16/delete.svg")
    Action deleteAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAudioClipPanel.this.att.set(null, Attachments.Type.AUDIO);
        }
    };
    JButton attachButton = new JButton(this.attachAction);
    JButton deleteButton = new JButton(this.deleteAction);
    JSmartToggleButton recordButton = new JSmartToggleButton(this.recordAction);
    JSmartToggleButton playButton = new JSmartToggleButton(this.playAction);
    JLabel titleLabel = new JLabel(Msg.get("ui.audioClip"));
    JLabel fileLabel = new JLabel();
    PropertyChangeListener audioClipListener = pce -> this.updateUIState();
    VUOutputStream vuStream;
    JVUMeter vuMeter = new JVUMeter(Short.MAX_VALUE);
    boolean closed;
    private AudioInputStream ais = null;
    private OutputStream os = null;

    private void unloadMedia() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.dispose();
            this.mediaPlayer = null;
            System.gc();
        }
    }

    public JAudioClipPanel(AlbumObject ao, JAlbumFrame window) {
        super(window);
        this.ao = ao;
        this.att = ((AlbumObjectImpl)ao).getAttachments();
        this.mp3File = new File(this.att.getAttachmentsDir(true), IO.baseName(ao.getFile()) + ".mp3");
        this.recordButton.setSelectedIcon(Icons.small("record-selected"));
        this.recordButton.setSelectedText(Msg.get("ui.recording"));
        this.playButton.setSelectedIcon(Icons.small("stop"));
        this.playButton.setSelectedText(Msg.get("ui.playing"));
        this.contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8));
        this.contentPanel.addFileDropListener(this);
        Msg.setTexts(this);
        Msg.setIcons(this);
        this.updateUIState();
        ao.addPropertyChangeListener("properties", this.audioClipListener);
        this.vuMeter.setEnabled(false);
        this.contentPanel.add("center", this.titleLabel);
        this.contentPanel.add("br hfill", this.fileLabel);
        this.contentPanel.add("br left", this.attachButton);
        this.contentPanel.add(this.deleteButton);
        this.contentPanel.add(this.recordButton);
        this.contentPanel.add(this.playButton);
        this.contentPanel.add("br center", this.vuMeter);
        this.add(this.contentPanel);
        this.validate();
    }

    private void updateUIState() {
        File audioClip = this.att.get(Attachments.Type.AUDIO);
        Object fileLabelText = audioClip != null ? audioClip.getName() : " ";
        TimeCode audioClipDuration = this.ao.getProperties().get("audioClipDuration", null);
        if (audioClipDuration != null) {
            fileLabelText = (String)fileLabelText + " (" + audioClipDuration.toShortString() + ")";
        }
        this.fileLabel.setText((String)fileLabelText);
        this.playAction.setEnabled(audioClip != null);
        this.deleteAction.setEnabled(audioClip != null);
    }

    void activateMike() {
        this.recorder = new SwingWorker<File, Void>(){

            @Override
            protected File doInBackground() throws Exception {
                AudioFormat format = JAudioClipPanel.this.getAudioFormat();
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new IllegalStateException(Msg.get("ui.noRecordingDeviceAvailable"));
                }
                JAudioClipPanel.this.line = (TargetDataLine)AudioSystem.getLine(info);
                JAudioClipPanel.this.line.open(format);
                JAudioClipPanel.this.line.start();
                AudioInputStream ais = new AudioInputStream(JAudioClipPanel.this.line);
                JAudioClipPanel.this.vuStream = new VUOutputStream(format, null);
                JAudioClipPanel.this.vuStream.onRefresh(vu -> JAudioClipPanel.this.vuMeter.setValue(vu.shortValue()));
                AudioSystem.write(ais, JAudioClipPanel.this.fileType, new SkipBytesOutputStream(JAudioClipPanel.this.vuStream, 1024));
                JAudioClipPanel.this.vuStream.close();
                if (JAudioClipPanel.this.vuStream.getOut() != null) {
                    File oldClip = JAudioClipPanel.this.att.get(Attachments.Type.AUDIO);
                    if (oldClip != null && !JAudioClipPanel.this.mp3File.equals(oldClip)) {
                        JAudioClipPanel.this.att.set(null, Attachments.Type.AUDIO);
                    }
                    JAudioClipPanel.this.att.set(JAudioClipPanel.this.mp3File, Attachments.Type.AUDIO);
                }
                return null;
            }

            @Override
            protected void done() {
                JAudioClipPanel.this.playAction.setEnabled(true);
                JAudioClipPanel.this.recorder = null;
                JAudioClipPanel.this.line = null;
                try {
                    this.get();
                    if (!JAudioClipPanel.this.closed) {
                        JAudioClipPanel.this.activateMike();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException ex) {
                    JAudioClipPanel.this.recordAction.setEnabled(false);
                    JAudioClipPanel.this.recordAction.putValue("ShortDescription", ex.getCause().getMessage());
                    JAudioClipPanel.this.recordAction.setBlocked(true);
                }
            }
        };
        this.recorder.execute();
    }

    @Override
    public void activate() {
        super.activate();
        this.activateMike();
    }

    AudioFormat getAudioFormat() {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = true;
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        return format;
    }

    public void play() {
        this.playButton.requestFocusInWindow();
        this.playButton.doClick();
    }

    @Override
    public void close() {
        this.closed = true;
        super.close();
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.unloadMedia();
        }
        if (this.line != null) {
            this.line.stop();
            this.line.close();
            this.line = null;
        }
        this.ao.removePropertyChangeListener(this.audioClipListener);
    }

    public void prepareForPlay() {
        this.playButton.requestFocusInWindow();
    }

    public void prepareForRecord() {
        this.recordButton.requestFocusInWindow();
    }

    private static boolean isCompressed(File f) {
        String ext = IO.extensionOf(f).toLowerCase();
        return ext.equals("mp3") || ext.equals("m4a");
    }

    public void attachAudioClip() {
        FileChooser chooser = JAudioClipPanel.getMusicChooser();
        int answer = chooser.showOpenDialog(this.window);
        this.attachAudioClip(chooser.getSelectedFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachAudioClip(File sel) {
        if (sel != null) {
            File dest = new File(this.att.getAttachmentsDir(true), (String)(Config.getConfig().isCompressAudioClips() && !JAudioClipPanel.isCompressed(sel) ? IO.baseName(sel) + ".mp3" : sel.getName()));
            try {
                File old = this.att.get(Attachments.Type.AUDIO);
                if (old != null) {
                    this.att.set(null, Attachments.Type.AUDIO);
                }
                dest.getParentFile().mkdirs();
                if (Config.getConfig().isCompressAudioClips() && !JAudioClipPanel.isCompressed(sel)) {
                    MonitoredWorkQueue queue = new MonitoredWorkQueue(this, Msg.get("ui.compressingAudio"));
                    queue.setAllowInterrupt(false);
                    queue.setMessage(sel.getName());
                    try {
                        AudioFileFormat format = AudioSystem.getAudioFileFormat(sel);
                        this.ais = AudioSystem.getAudioInputStream(sel);
                        AudioFormat inf = this.ais.getFormat();
                        AudioFormat outf = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inf.getSampleRate(), inf.getSampleSizeInBits(), inf.getChannels(), inf.getFrameSize(), inf.getFrameRate(), inf.isBigEndian(), inf.properties());
                        this.os = new WaveRecodingOutputStream(inf, outf, new MP3OutputStream(this.ais.getFormat(), new BufferedOutputStream(new FileOutputStream(dest))));
                        queue.setMaximum((int)this.ais.getFrameLength());
                        queue.submit(() -> {
                            int read;
                            byte[] buffer = new byte[262144];
                            int currentFrame = 0;
                            while ((read = this.ais.read(buffer)) > 0) {
                                this.os.write(buffer, 0, read);
                                queue.setValue(currentFrame += read / this.ais.getFormat().getFrameSize());
                                if (!queue.isAborted()) continue;
                                throw new OperationAbortedException();
                            }
                        });
                        queue.awaitCompletion();
                    }
                    finally {
                        IO.close(this.ais);
                        IO.close(this.os);
                        if (queue.isAborted()) {
                            dest.delete();
                        }
                    }
                    if (!queue.isAborted()) {
                        String result = Msg.get("ui.compressingResult", sel.getName() + " (" + String.valueOf(DataSizeFormatter.formatBytes(sel.length())) + ")", dest.getName() + " (" + String.valueOf(DataSizeFormatter.formatBytes(dest.length())) + ")");
                        ((JAlbumFrame)this.window).statusBar.setText(result);
                    }
                } else {
                    IO.copyFile(sel, dest);
                }
                if (dest.exists()) {
                    this.att.set(dest, Attachments.Type.AUDIO);
                }
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this.window, ex);
            }
            catch (UnsupportedAudioFileException ex) {
                Debug.showErrorDialog(this.window, ex);
            }
        }
    }

    public static FileChooser getMusicChooser() {
        if (musicChooser == null) {
            musicChooser = ChooserFactory.createFileChooser(JAlbumContext.getInstance().getFrame());
            musicChooser.setFileFilter(fileFilter);
            String myMusicPath = System.getProperty("my.music.path");
            if (musicChooser.getCurrentDirectory() == null) {
                if (myMusicPath != null) {
                    musicChooser.setCurrentDirectory(new File(myMusicPath));
                } else {
                    musicChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                }
            }
        }
        return musicChooser;
    }

    @Override
    public void filesDropped(FileDropEvent e) {
        File f = e.getFirstFile();
        if (fileFilter.accept(f)) {
            this.stopAction.actionPerformed(null);
            this.attachAudioClip(f);
        }
    }
}

