/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;

public class JAlbumTrayIcon
extends TrayIcon {
    private static JAlbumTrayIcon instance;
    private static final long DOUBLE_CLICK_THRESHOLD = 500L;
    private PopupMenu popupMenu = new PopupMenu();
    private AtomicInteger workCount = new AtomicInteger(0);
    private Action openAction = new AbstractAction(Msg.get("edit.open")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumContext.getInstance().getFrame().setVisible(true);
            JAlbumContext.getInstance().getFrame().setExtendedState(0);
        }
    };
    private Action exitAction = new AbstractAction(Msg.get("ui.exitMenu")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!JAlbumContext.getInstance().getFrame().askProjectSave(Msg.get("ui.exitMenu"))) {
                return;
            }
            System.exit(0);
        }
    };
    private long lastClick;

    private JAlbumTrayIcon(JAlbumFrame mainWindow) {
        super(mainWindow.icons.getSystemTrayIcon().getImage(), Msg.get("ui.windowTitle"));
        this.popupMenu.add(JAlbumTrayIcon.createMenuItem(this.openAction));
        this.popupMenu.addSeparator();
        this.popupMenu.add(JAlbumTrayIcon.createMenuItem(this.exitAction));
        this.setPopupMenu(this.popupMenu);
        this.addActionListener(e -> {
            if (e.getWhen() - this.lastClick < 500L) {
                this.openAction.actionPerformed(null);
            }
            this.lastClick = e.getWhen();
        });
    }

    public static MenuItem createMenuItem(Action a) {
        MenuItem item = new MenuItem((String)a.getValue("Name"));
        item.addActionListener(a);
        return item;
    }

    public static JAlbumTrayIcon getInstance() throws UnsupportedOperationException {
        if (instance == null) {
            instance = new JAlbumTrayIcon(JAlbumContext.getInstance().getFrame());
        }
        return instance;
    }

    public void workStarted() {
        if (this.workCount.getAndIncrement() == 0) {
            SystemTray tray = SystemTray.getSystemTray();
            try {
                tray.add(this);
            }
            catch (AWTException ex) {
                Logger.getLogger(JAlbumTrayIcon.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void workDone() {
        if (this.workCount.get() > 0) {
            this.workCount.decrementAndGet();
            if (this.workCount.get() == 0) {
                SystemTray tray = SystemTray.getSystemTray();
                tray.remove(this);
            }
        }
    }

    public boolean isVisible() {
        return this.workCount.get() > 0;
    }
}

