/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.component.JBindableLabel;
import net.jalbum.projectgroups.ProjectGroup;
import net.jalbum.projectgroups.ProjectGroups;
import net.jalbum.projectgroups.RecentProjectsGroup;
import net.jalbum.projectgroups.VirtualProjectGroup;
import net.miginfocom.swing.MigLayout;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSiteButton;
import se.datadosen.component.RoundedLineBorder;
import se.datadosen.dnd.TransferableNode;
import se.datadosen.explorer.FolderTreeNode;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.DeletePublishedAlbumTask;
import se.datadosen.jalbum.DragImage;
import se.datadosen.jalbum.FileNameDocument;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumInfo;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.jalbum.RecentProjectFiles;
import se.datadosen.jalbum.TaskManager;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.WebPagePreviewer;
import se.datadosen.util.AliasAction;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.IdleExecutor;
import se.datadosen.util.Multilingual;
import se.datadosen.util.SlowAction;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumManager
extends JPanel
implements RecentProjectFiles.Listener,
Multilingual {
    public static final String PROJECT_ADDED_PROPERTY = "projectAdded";
    public static final String PROJECT_REMOVED_PROPERTY = "projectRemoved";
    private static final ImageIcon newAlbumProjectIcon = Icons.getIcon("big.newAlbumProject");
    private final JTree tree;
    private final JAlbumContext context;
    private ProjectGroup group = ProjectGroups.getInstance().getCurrentGroup();
    private List<AlbumProject> projects = new ArrayList<AlbumProject>();
    private AlbumProject currentProject;
    public static final AlbumProject emptyProject = new AlbumProject(AlbumProject.defaultProjectFile, (AlbumObject)null);
    private final AlbumRootComponent albumRootComponent;
    private final ContentPanel contentPanel;
    private final JPopupMenu albumPopup = new JPopupMenu();
    private IdleExecutor previewTrigger = new IdleExecutor(200, TimeUnit.MILLISECONDS);
    private MouseAdapter previewListener = new MouseAdapter(){
        private final Dimension REP_DIM = new Dimension(350, 350);
        private final Dimension PREVIEW_DIM = new Dimension(500, 500);
        private Component lastComponent;
        private ImageIcon icon = null;

        @Override
        public void mouseExited(MouseEvent e) {
            JAlbumManager.this.previewTrigger.cancel();
            JAlbumManager.this.context.getFrame().previewPanel.setVisible(false);
            this.lastComponent = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handle(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.handle(e);
        }

        private void handle(MouseEvent e) {
            if (e.getPoint().getX() > (double)(AlbumProject.iconSize.width + 20)) {
                return;
            }
            if (e.getComponent() != this.lastComponent) {
                this.lastComponent = e.getComponent();
            }
            AlbumProject ap = this.lastComponent instanceof JAlbumButton ? ((JAlbumButton)this.lastComponent).project : JAlbumManager.this.getCurrentProject();
            JAlbumManager.this.previewTrigger.onIdle(() -> {
                try {
                    this.icon = null;
                    File jAlbumDir = new File(ap.getRootFolder().getFile(), ".jalbum");
                    File previewFile = new File(jAlbumDir, "preview.jpg");
                    long lastMadeDate = ap.getRootFolder().getProperties().get("lastMadeDate", 0L);
                    if (previewFile.exists() && previewFile.lastModified() > lastMadeDate) {
                        try {
                            this.icon = new ImageIcon(JAlbumManager.this.context.getEngine().scaleToFit(ImageIO.read(previewFile), this.PREVIEW_DIM, "ScaleMedium"));
                        }
                        catch (IOException iOException) {}
                    } else {
                        try {
                            BufferedImage bi = WebPagePreviewer.takeSnapshot(ap.getIndexFile().toURI().toURL());
                            FileFilters.saveJPEG(bi, previewFile, JAlbumContext.getInstance().getEngine());
                            this.icon = new ImageIcon(JAlbumManager.this.context.getEngine().scaleToFit(bi, this.PREVIEW_DIM, "ScaleMedium"));
                        }
                        catch (IOException ex) {
                            ex.printStackTrace(System.err);
                        }
                    }
                    if (this.icon == null) {
                        this.icon = ap.getRootFolder().getRepresentingIcon(this.REP_DIM, false);
                    }
                    SwingUtilities.invokeLater(() -> {
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        SwingUtilities.convertPointFromScreen(p, JAlbumManager.this.context.getFrame());
                        Component deepest = SwingUtilities.getDeepestComponentAt(JAlbumManager.this.context.getFrame(), p.x, p.y);
                        if (deepest instanceof AlbumRootLabel || deepest instanceof JAlbumButton) {
                            JAlbumFrame window = JAlbumManager.this.context.getFrame();
                            window.setSkinGlassPane();
                            window.previewPanel.setImage(this.icon);
                            window.previewPanel.setVisible(true);
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    };
    private DragSourceListener dsl = new DragSourceAdapter(){

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                try {
                    AlbumProject movedProject = (AlbumProject)dsde.getDragSourceContext().getTransferable().getTransferData(AlbumProject.ALBUM_PROJECT_FLAVOR);
                    if (dsde.getDropAction() == 2) {
                        JAlbumManager.this.projects.remove(movedProject);
                        JAlbumManager.this.refresh();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(JAlbumManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    };
    private DragGestureListener dgl = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JAlbumButton comp = (JAlbumButton)dge.getComponent();
            JLabel t = new JLabel(comp.getIcon());
            t.setText(comp.getText());
            t.setSize(t.getPreferredSize());
            dge.startDrag(null, DragImage.fromComponent(t, JAlbumManager.this.getGraphicsConfiguration()), new Point(-10, -10), comp.project, JAlbumManager.this.dsl);
        }
    };
    private DragGestureListener openProjectDGL = new DragGestureListener(){

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            AlbumRootLabel comp = (AlbumRootLabel)dge.getComponent();
            JLabel t = new JLabel(comp.getIcon());
            t.setText(comp.getText());
            t.setSize(t.getPreferredSize());
            dge.startDrag(null, DragImage.fromComponent(t, JAlbumManager.this.getGraphicsConfiguration()), new Point(-10, -10), JAlbumManager.this.getCurrentProject(), JAlbumManager.this.dsl);
        }
    };
    @Text(value="ui.collaborativeAlbum")
    JMenu collaborativeMenu = new JMenu();
    @Text(value="ui.monitorChanges")
    @se.datadosen.util.annotations.Icon(value="16x16/eye.svg")
    JMenu monitorChangesMenu = new JMenu();
    private final MouseListener openSettingsMouseListener;
    @Text(value="prefs.doNothing")
    JRadioButtonMenuItem nothingOnChange = new JRadioButtonMenuItem();
    @Text(value="ui.makeAlbum")
    JRadioButtonMenuItem makeAlbumOnChange = new JRadioButtonMenuItem();
    @Text(value="ui.makeAndUpload")
    JRadioButtonMenuItem makeAndUploadAlbumOnChange = new JRadioButtonMenuItem();
    @Text(value="album.info")
    @ToolTipText(value="album.info")
    public Action infoAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.small("information"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Tracer.getInstance().trace("album info presented");
            JAlbumInfo infoFrame = new JAlbumInfo(JAlbumContext.getInstance(), JAlbumManager.this.currentProject);
            Rectangle b = JAlbumManager.this.albumRootComponent.getBounds();
            Point p = JAlbumManager.this.albumRootComponent.getLocationOnScreen();
            infoFrame.setLocation(p.x + b.width + 20, p.y);
            infoFrame.setVisible(true);
        }
    };
    @Text(value="edit.renameFile", postfix="...")
    public Action renameAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumManager.this.albumRootComponent.setEditing(true);
        }
    };
    @ToolTipText(value="ui.more")
    private Action moreAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.small("more"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent source = (JComponent)e.getSource();
            JAlbumManager.this.albumPopup.show((JComponent)e.getSource(), 0, source.getHeight());
        }
    };
    @Text(value="album.removeFromList")
    public Action removeFromListAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AlbumProject oldProject = JAlbumManager.this.currentProject;
            JAlbumFrame window = JAlbumManager.this.context.getFrame();
            if (window.askProjectSave(Msg.get("ui.newProjectMenu"))) {
                window.markAsClean();
                window.markSkinAsClean();
                window.closeProject();
                if (!oldProject.equals(emptyProject)) {
                    JAlbumManager.this.projects.remove(oldProject);
                    JAlbumManager.this.firePropertyChange(JAlbumManager.PROJECT_REMOVED_PROPERTY, null, oldProject);
                }
                if (JAlbumManager.this.group instanceof RecentProjectsGroup) {
                    RecentProjectFiles.getInstance().removeFile(oldProject.getProjectFile());
                } else if (JAlbumManager.this.group instanceof VirtualProjectGroup) {
                    ((VirtualProjectGroup)JAlbumManager.this.group).removeProject(oldProject);
                }
                JAlbumManager.this.validate();
                JAlbumManager.this.repaint();
            }
        }
    };
    @Text(value="album.deletePublishedAlbum", postfix="...")
    public Action deletePublishedAlbumAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int selected;
            AlbumObject root = JAlbumManager.this.currentProject.getRootFolder();
            AlbumObjectProperties props = root.getProperties();
            String albumURL = (String)props.get("albumURL");
            if (albumURL != null && (selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deletePublishedAlbumInfo", albumURL), Msg.get("album.deletePublishedAlbum"), 0, 2)) != 0) {
                return;
            }
            DeletePublishedAlbumTask task = new DeletePublishedAlbumTask(JAlbumManager.this.currentProject, JAlbumManager.this.context);
            if (e != null) {
                task.onError(cause -> {
                    int messageType = cause instanceof InformationException ? 1 : 0;
                    JOptionPane.showMessageDialog(JAlbumManager.this.context.getFrame(), cause.getMessage(), Msg.get("album.deletePublishedAlbum"), messageType);
                });
            }
            task.onDone(() -> {
                if (task.completedNormally()) {
                    JAlbumManager.this.context.getFrame().statusBar.setText("");
                }
            });
            JAlbumManager.this.context.getFrame().progressManager.addTask(task.ts);
            TaskManager<DeletePublishedAlbumTask> mgr = new TaskManager<DeletePublishedAlbumTask>("Background deleter");
            JAlbumManager.this.context.getFrame().statusBar.setText(Msg.get("ui.deletingPublishedAlbum"));
            mgr.submit(task);
        }
    };
    @Text(value="album.deleteLocalAlbum", postfix="...")
    public SlowAction deleteLocalAlbumAction = new SlowAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int selected;
            File projectDir = JAlbumManager.this.currentProject.getProjectFile().getParentFile();
            File webDir = new File(Config.getConfig().getWebDirectory());
            final File outputDir = JAlbumManager.this.context.getEngine().getOutputDir();
            if (e != null && !IO.isSubdirectoryOf(outputDir, projectDir) && !IO.isSubdirectoryOf(outputDir, webDir)) {
                int selected2 = JOptionPane.showOptionDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteLocalAlbumSafetyInfo"), Msg.get("album.deleteLocalAlbum"), 0, 1, null, new Object[]{Msg.get("close"), Msg.get("ui.openFolder")}, Msg.get("ui.openFolder"));
                if (selected2 == 1) {
                    try {
                        BrowserLauncher.openLocal(outputDir);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            if (e != null && (selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteLocalAlbumInfo", outputDir), Msg.get("album.deleteLocalAlbum"), 0, 2)) != 0) {
                return;
            }
            JAlbumManager.this.context.getFrame().progressSpinner.workStarted();
            new SwingWorker<Object, String>(this){
                final /* synthetic */ 10 this$1;
                {
                    this.this$1 = this$1;
                    AlbumObjectProperties props = this.this$1.JAlbumManager.this.getCurrentProject().getRootFolder().getProperties();
                    props.remove("lastMadeDate");
                    props.remove("lastTransformer");
                    props.save();
                    if (this.this$1.getStateListener() != null) {
                        this.addPropertyChangeListener(this.this$1.getStateListener());
                    }
                }

                @Override
                protected Object doInBackground() throws Exception {
                    this.publish(Msg.get("ui.deleting", outputDir) + "...");
                    IO.deleteDir(outputDir);
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    this.this$1.JAlbumManager.this.context.getFrame().statusBar.setText(chunks.get(0));
                }

                @Override
                protected void done() {
                    this.this$1.JAlbumManager.this.context.getFrame().statusBar.setText(Msg.get("edit.doneInfo"));
                    this.this$1.JAlbumManager.this.context.getFrame().progressSpinner.workDone();
                    this.this$1.JAlbumManager.this.context.getFrame().fixUIdisabling();
                }
            }.execute();
        }
    };
    @Text(value="album.deleteEntireProject", postfix="...")
    public Action deleteEntireProjectAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.small("remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final File projectDir = JAlbumManager.this.currentProject.getProjectFile().getParentFile();
            if (e != null && !ProjectGroups.getInstance().getTopGroups().stream().filter(pg -> pg != ProjectGroup.RECENT_PROJECTS_GROUP).anyMatch(pg -> IO.isSubdirectoryOf(projectDir, pg.getLocation()))) {
                int selected = JOptionPane.showOptionDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteEntireProjectSafetyInfo"), Msg.get("album.deleteEntireProject"), 0, 1, null, new Object[]{Msg.get("close"), Msg.get("ui.openFolder")}, Msg.get("ui.openFolder"));
                if (selected == 1) {
                    MyDesktop.getDesktop().browseFileDirectory(projectDir);
                }
                return;
            }
            int selected = JOptionPane.showConfirmDialog(JAlbumManager.this.context.getFrame(), Msg.get("album.deleteEntireProjectInfo", projectDir), Msg.get("album.deleteEntireProject"), 0, 2);
            if (selected != 0) {
                return;
            }
            JAlbumManager.this.deletePublishedAlbumAction.actionPerformed(null);
            JAlbumFrame window = JAlbumManager.this.context.getFrame();
            window.markAsClean();
            window.markSkinAsClean();
            window.albumExplorer.folderPropertyPanel.reset();
            JAlbumManager.this.context.getFrame().progressSpinner.workStarted();
            new SwingWorker<Object, String>(this){
                final /* synthetic */ 11 this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                protected Object doInBackground() throws Exception {
                    this.publish(Msg.get("ui.deleting", projectDir) + "...");
                    File outputDir = this.this$1.JAlbumManager.this.context.getEngine().getOutputDir();
                    File webDir = new File(Config.getConfig().getWebDirectory());
                    if (IO.isSubdirectoryOf(outputDir, webDir)) {
                        IO.deleteDir(outputDir);
                    }
                    IO.deleteDir(projectDir);
                    return null;
                }

                @Override
                protected void process(List<String> chunks) {
                    this.this$1.JAlbumManager.this.context.getFrame().statusBar.setText(chunks.get(0));
                }

                @Override
                protected void done() {
                    this.this$1.JAlbumManager.this.context.getFrame().statusBar.setText(Msg.get("edit.doneInfo"));
                    this.this$1.JAlbumManager.this.context.getFrame().progressSpinner.workDone();
                    File samplesDir = new File(MiniConfig.getMiniConfig().progDir, "samples");
                    File origSampleDir = new File(samplesDir, this.this$1.JAlbumManager.this.currentProject.getName());
                    if (origSampleDir.exists()) {
                        Preferences prefs = Preferences.userNodeForPackage(JAlbum.class).node("deletedSampleProjects");
                        prefs.putBoolean(this.this$1.JAlbumManager.this.currentProject.getName(), true);
                    }
                    ProjectGroups.getInstance().groups().filter(pg -> pg instanceof VirtualProjectGroup).forEach(pg -> ((VirtualProjectGroup)pg).removeProject(this.this$1.JAlbumManager.this.currentProject));
                    RecentProjectFiles.getInstance().removeFile(this.this$1.JAlbumManager.this.currentProject.getProjectFile());
                    this.this$1.JAlbumManager.this.removeFromListAction.actionPerformed(null);
                }
            }.execute();
        }
    };
    @Text(value="ui.publishToolTip")
    Action publishAction;
    @ToolTipText(value="ui.settings")
    Action settingsAction;
    @Text(value="edit.delete")
    private JMenu deleteMenu;
    private JButton moreButton;

    public JAlbumManager(JAlbumContext ctx, JTree tree) {
        this.publishAction = new AliasAction(JAlbumContext.getInstance().getFrame().actions.publishAction);
        this.settingsAction = new AliasAction(JAlbumContext.getInstance().getFrame().actions.settingsAction);
        this.deleteMenu = new JMenu();
        this.moreButton = new JPlainButton(this.moreAction);
        Msg.maintainTranslated(this);
        this.context = ctx;
        this.tree = tree;
        this.projects.add(emptyProject);
        this.openSettingsMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JAlbumManager.this.context.getFrame().actions.settingsAction.actionPerformed(null);
                }
                if (e.getSource() instanceof JComponent) {
                    ((JComponent)e.getSource()).requestFocusInWindow();
                }
            }
        };
        this.albumRootComponent = new AlbumRootComponent();
        this.contentPanel = new ContentPanel();
        this.setBackground(JAlbumColor.text);
        this.setLayout((LayoutManager)new MigLayout("insets 1, gap 0, fillx, wrap 1"));
        this.albumPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AccountManager mgr = AccountManager.getInstance();
                AccountProfile account = mgr.findCurrentAccount(JAlbumManager.this.context.getEngine());
                if (account != null) {
                    JAlbumManager.this.publishAction.putValue("Name", Msg.get("album.publishTo", account.getFtpServer()) + "...");
                } else {
                    JAlbumManager.this.publishAction.putValue("Name", Msg.get("ui.publish") + "...");
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.albumPopup.add(this.context.getFrame().actions.settingsAction);
        this.albumPopup.add(this.context.getFrame().actions.skinSettingsAction);
        this.albumPopup.addSeparator();
        this.collaborativeMenu.add(this.context.getFrame().actions.attachDetachAction);
        this.collaborativeMenu.add(this.context.getFrame().actions.inviteEmailAction);
        this.collaborativeMenu.add(this.context.getFrame().actions.inviteQRAction);
        this.collaborativeMenu.add(this.context.getFrame().actions.fetchNewObjectsAction);
        this.albumPopup.add(this.collaborativeMenu);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.nothingOnChange);
        bg.add(this.makeAlbumOnChange);
        bg.add(this.makeAndUploadAlbumOnChange);
        this.monitorChangesMenu.add(this.nothingOnChange);
        this.monitorChangesMenu.add(this.makeAlbumOnChange);
        this.monitorChangesMenu.add(this.makeAndUploadAlbumOnChange);
        this.albumPopup.add(this.monitorChangesMenu);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.context.getFrame().actions.makeAction);
        this.albumPopup.add(this.context.getFrame().actions.makeInBackgroundAction);
        this.albumPopup.add(this.context.getFrame().actions.makeAndUploadInBackgroundAction);
        this.albumPopup.add(new AliasAction(this.context.getFrame().actions.viewAlbumAction, Icons.small("btn-view")));
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.publishAction);
        this.albumPopup.add(this.context.getFrame().actions.uploadInBackgroundAction);
        this.albumPopup.add(this.context.getFrame().actions.showPublishWindowAction);
        this.albumPopup.add(this.context.getFrame().actions.embedAlbumAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.context.getFrame().actions.closeProjectAction);
        this.albumPopup.addSeparator();
        this.deleteMenu.setIcon(Icons.small("remove"));
        this.deleteMenu.add(this.deleteLocalAlbumAction);
        this.deleteMenu.add(this.deletePublishedAlbumAction);
        this.deleteMenu.add(this.deleteEntireProjectAction);
        this.albumPopup.add(this.deleteMenu);
        this.albumPopup.add(this.removeFromListAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.context.getFrame().actions.duplicateProjectAction);
        this.albumPopup.add(this.renameAction);
        this.albumPopup.addSeparator();
        this.albumPopup.add(this.infoAction);
        RecentProjectFiles.getInstance().addListener(this);
        this.nothingOnChange.addActionListener(ae -> {
            AlbumObjectProperties props = this.currentProject.getRootFolder().getProperties();
            props.put("makeOnChange", false);
            props.put("uploadOnChange", false);
            props.save();
        });
        this.makeAlbumOnChange.addActionListener(ae -> {
            AlbumObjectProperties props = this.currentProject.getRootFolder().getProperties();
            props.put("makeOnChange", true);
            props.put("uploadOnChange", false);
            props.remove("uploadOnChange");
            props.save();
        });
        this.makeAndUploadAlbumOnChange.addActionListener(ae -> {
            AlbumObjectProperties props = this.currentProject.getRootFolder().getProperties();
            props.put("makeOnChange", true);
            props.put("uploadOnChange", true);
            props.save();
        });
        ProjectGroups.getInstance().addPropertyChangeListener(pce -> this.setProjectGroup(ProjectGroups.getInstance().getCurrentGroup(), Config.getConfig().getProjectOrdering()));
        this.setProjectGroup(ProjectGroups.getInstance().getCurrentGroup(), Config.getConfig().getProjectOrdering());
    }

    public List<AlbumProject> getProjects() {
        return this.projects.stream().filter(ap -> ap != emptyProject).collect(Collectors.toList());
    }

    public void setCurrentProject(AlbumProject ap) {
        this.currentProject = ap = this.addAlbumProject(ap);
        this.albumRootComponent.setAlbumProject(ap);
        this.context.getEngine().setCurrentProject(ap);
        this.refresh();
        if (ap != null && ap.getRootFolder() != null) {
            this.albumRootComponent.collaborativeStatus.setModel(ap.getRootFolder().getProperties());
            this.albumRootComponent.monitoredStatus.setModel(ap.getRootFolder().getProperties());
        }
    }

    public final void setProjectGroup(ProjectGroup group, Config.ProjectOrdering ordering) {
        this.group = group;
        this.albumRootComponent.dragGestureRecognizer.setSourceActions(group.getSourceActions());
        this.projects.clear();
        this.projects.addAll(group.getProjects());
        group.sort(this.projects, ordering);
        this.projects.add(emptyProject);
        this.refresh();
        SwingUtilities.invokeLater(() -> {
            this.revalidate();
            this.repaint();
        });
        this.removeFromListAction.setEnabled(group instanceof VirtualProjectGroup || group == ProjectGroup.RECENT_PROJECTS_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlbumProject addAlbumProject(AlbumProject ap) {
        if (ap == null) {
            throw new IllegalArgumentException("Can't add null album");
        }
        int existingIndex = this.projects.indexOf(ap);
        if (existingIndex >= 0) {
            AlbumProject existing = this.projects.get(existingIndex);
            if (!existing.equals(emptyProject)) {
                existing.setRootFolder(ap.getRootFolder());
            }
            return existing;
        }
        List<AlbumProject> list = this.projects;
        synchronized (list) {
            this.projects.add(ap);
            this.firePropertyChange(PROJECT_ADDED_PROPERTY, null, ap);
            if (this.group instanceof VirtualProjectGroup) {
                ((VirtualProjectGroup)this.group).addProject(ap);
            }
        }
        return ap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderBy(Config.ProjectOrdering ordering) {
        List<AlbumProject> list = this.projects;
        synchronized (list) {
            this.projects.remove(emptyProject);
            this.group.sort(this.projects, ordering);
            this.projects.add(emptyProject);
            this.refresh();
        }
    }

    public AlbumRootComponent getAlbumRootComponent() {
        return this.albumRootComponent;
    }

    public AlbumProject getCurrentProject() {
        return this.currentProject;
    }

    public void refresh() {
        SwingUtilities.invokeLater(() -> {
            ArrayList<AlbumProject> projectsClone;
            this.removeAll();
            this.contentPanel.refresh();
            String constraint = "grow";
            List<AlbumProject> list = this.projects;
            synchronized (list) {
                projectsClone = new ArrayList<AlbumProject>(this.projects);
            }
            for (AlbumProject ap : projectsClone) {
                if (ap.equals(this.currentProject)) {
                    this.add((Component)this.contentPanel, constraint);
                    continue;
                }
                this.add((Component)new JAlbumButton(ap), constraint);
            }
            this.validate();
            if (!emptyProject.equals(this.currentProject)) {
                this.scrollRectToVisible(this.contentPanel.getBounds());
            }
            this.repaint();
        });
    }

    @Override
    public void projectFileRenamed(RecentProjectFiles list, File oldName, File newName) {
        ProjectGroups.getInstance().groups().filter(group -> group instanceof VirtualProjectGroup).forEach(group -> ((VirtualProjectGroup)group).replaceFile(oldName, newName));
        for (AlbumProject project : this.projects) {
            if (!project.getProjectFile().equals(oldName)) continue;
            project.setProjectFile(newName);
            project.setRootFolder(this.albumRootComponent.project.getRootFolder());
            break;
        }
        if (this.currentProject.getProjectFile().equals(oldName)) {
            this.currentProject.setProjectFile(newName);
            this.currentProject.setRootFolder(this.albumRootComponent.project.getRootFolder());
        }
    }

    @Override
    public void structureChanged(RecentProjectFiles list) {
        if (this.group == ProjectGroup.RECENT_PROJECTS_GROUP && list.getFiles().isEmpty()) {
            AlbumProject ap = this.getCurrentProject();
            this.projects.clear();
            this.projects.add(ap);
            if (ap != emptyProject) {
                this.projects.add(emptyProject);
            }
            this.refresh();
        }
    }

    @Override
    public void languageUpdated() {
        this.refresh();
    }

    public class AlbumRootComponent
    extends JPanel {
        AlbumProject project;
        private AlbumRootLabel label;
        private DragGestureRecognizer dragGestureRecognizer;
        private JTextField nameField;
        private JLabel iconLabel;
        private boolean editing;
        private JProgressSpinner spinner;
        private JCollaborativeStatus collaborativeStatus;
        private JMonitoredStatus monitoredStatus;
        private final PropertyChangeListener thumbnailListener;

        public AlbumRootComponent() {
            super((LayoutManager)new MigLayout("fillx, aligny 100%"));
            this.nameField = new JTextField();
            this.iconLabel = new JLabel();
            this.editing = false;
            this.spinner = new JProgressSpinner();
            this.collaborativeStatus = new JCollaborativeStatus();
            this.monitoredStatus = new JMonitoredStatus();
            this.thumbnailListener = evt -> {
                this.project.invalidateIcon();
                this.renderThumbnail();
            };
            this.setInheritsPopupMenu(true);
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
            this.nameField.setDocument(new FileNameDocument());
            this.setOpaque(false);
            this.label = new AlbumRootLabel(JAlbumManager.this.tree);
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this.label, JAlbumManager.this.group.getSourceActions(), JAlbumManager.this.openProjectDGL);
            this.label.setInheritsPopupMenu(true);
            this.add((Component)this.label, "dock west");
            this.add((Component)JAlbumManager.this.moreButton, "dock east");
            this.add((Component)this.monitoredStatus, "dock east");
            this.add((Component)this.collaborativeStatus, "dock east");
            this.add((Component)this.spinner, "dock east");
            this.setComponentPopupMenu(JAlbumManager.this.albumPopup);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && AlbumRootComponent.this.label.isSelected() && e.getButton() == 1 && e.getPoint().x > AlbumRootComponent.this.label.getIcon().getIconWidth() + AlbumRootComponent.this.label.getIconTextGap()) {
                        AlbumRootComponent.this.setEditing(true);
                    }
                    if (e.getClickCount() == 2) {
                        JAlbumManager.this.context.getFrame().actions.settingsAction.actionPerformed(null);
                    } else {
                        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)JAlbumManager.this.tree.getModel().getRoot();
                        if (rootNode != null) {
                            JAlbumManager.this.tree.setSelectionPath(new TreePath(rootNode.getPath()));
                            JAlbumManager.this.context.getExplorer().setExplorerView();
                        }
                    }
                }
            });
            this.label.addMouseListener(JAlbumManager.this.previewListener);
            this.label.addMouseMotionListener(JAlbumManager.this.previewListener);
            this.addMouseListener(JAlbumManager.this.openSettingsMouseListener);
            JAlbumManager.this.tree.addTreeSelectionListener(e -> {
                boolean rootSelected = e.getPath().getPathCount() == 1;
                this.label.setSelected(rootSelected);
            });
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 27) {
                        AlbumRootComponent.this.nameField.setText(AlbumRootComponent.this.project.getName());
                        AlbumRootComponent.this.setEditing(false);
                    }
                }
            });
            this.nameField.addActionListener(ae -> this.setEditing(false));
            this.nameField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    AlbumRootComponent.this.setEditing(false);
                }
            });
        }

        boolean isEditing() {
            return this.editing;
        }

        void setEditing(boolean editing) {
            if (this.editing == editing) {
                return;
            }
            if (editing) {
                this.remove(this.label);
                this.iconLabel.setIcon(this.label.getIcon());
                this.nameField.setText(this.project.getName());
                this.add((Component)this.iconLabel, "dock west");
                this.add((Component)this.nameField, "dock west");
                this.validate();
                this.repaint();
                this.editing = editing;
                this.nameField.requestFocusInWindow();
            } else {
                this.remove(this.iconLabel);
                this.remove(this.nameField);
                this.add((Component)this.label, "dock west");
                this.validate();
                this.repaint();
                this.editing = editing;
                String newName = this.nameField.getText();
                if (!newName.equals(this.project.getName())) {
                    if (this.project.getProjectFile().getName().equals("jalbum-settings.jap")) {
                        try {
                            if (JAlbumManager.this.context.getFrame().renameProjectDirectory(newName)) {
                                this.label.setText(newName);
                            }
                        }
                        catch (IOException iOException) {}
                    } else {
                        File newProjectFile;
                        File oldProjectFile = this.project.getProjectFile();
                        if (oldProjectFile.renameTo(newProjectFile = new File(oldProjectFile.getParentFile(), newName + ".jap"))) {
                            JAlbumManager.this.context.getFrame().setProjectName(newName);
                        }
                    }
                }
            }
        }

        void setAlbumProject(AlbumProject ap) {
            AlbumObject ao = this.project != null ? this.project.getRootFolder() : null;
            this.spinner.setModel((BooleanExpression)ap.workingProperty);
            if (ao != null) {
                ao.removePropertyChangeListener(this.thumbnailListener);
            }
            this.project = ap;
            ao = ap.getRootFolder();
            if (ao != null) {
                ao.addPropertyChangeListener("representingAlbumObject", this.thumbnailListener);
                ao.addPropertyChangeListener("children", this.thumbnailListener);
                this.label.setText(ap.getName());
                this.label.setToolTipText(ap.getLongName());
                AlbumObjectProperties props = ap.getRootFolder().getProperties();
                if (props.get("makeOnChange", false).booleanValue()) {
                    if (props.get("uploadOnChange", false).booleanValue()) {
                        JAlbumManager.this.makeAndUploadAlbumOnChange.setSelected(true);
                    } else {
                        JAlbumManager.this.makeAlbumOnChange.setSelected(true);
                    }
                } else {
                    JAlbumManager.this.nothingOnChange.setSelected(true);
                }
            } else {
                this.collaborativeStatus.setModel(null);
                this.monitoredStatus.setModel(null);
            }
            this.renderThumbnail();
        }

        private void renderThumbnail() {
            this.project.forIcon((icon, cached) -> this.label.setIcon((Icon)icon));
        }
    }

    private class ContentPanel
    extends JPanel {
        public ContentPanel() {
            super(new BorderLayout());
            this.setBackground(JAlbumColor.albumHighlight);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), new RoundedLineBorder(JAlbumColor.border)));
            JAlbumManager.this.tree.setBackground(JAlbumColor.albumHighlight);
            JAlbumManager.this.tree.setRootVisible(false);
            JAlbumManager.this.tree.setShowsRootHandles(true);
            JAlbumManager.this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger() && JAlbumManager.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                        JAlbumManager.this.albumPopup.show(JAlbumManager.this.tree, e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger() && JAlbumManager.this.tree.getPathForLocation(e.getX(), e.getY()) == null) {
                        JAlbumManager.this.albumPopup.show(JAlbumManager.this.tree, e.getX(), e.getY());
                    }
                }
            });
            this.addMouseListener(JAlbumManager.this.openSettingsMouseListener);
        }

        private void refresh() {
            this.removeAll();
            if (emptyProject.equals(JAlbumManager.this.currentProject)) {
                JLabel newAlbumLabel = new JLabel(Msg.get("ui.emptyProject"), newAlbumProjectIcon, 10);
                newAlbumLabel.setForeground(JAlbumColor.textInactiveText);
                this.add((Component)newAlbumLabel, "North");
            } else {
                this.add((Component)JAlbumManager.this.albumRootComponent, "North");
                this.add((Component)JAlbumManager.this.tree, "Center");
            }
        }
    }

    private static class JCollaborativeStatus
    extends JLabel
    implements PropertyChangeListener {
        private AlbumObjectProperties model;

        public JCollaborativeStatus() {
            this.init();
        }

        public boolean isBound() {
            return this.model != null;
        }

        public void setModel(AlbumObjectProperties model) {
            if (this.model != null) {
                this.model.removePropertyChangeListener(this);
            }
            this.model = model;
            if (model != null) {
                model.addPropertyChangeListener(this);
                this.propertyChange(null);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!this.model.containsKey("inboxUserName")) {
                this.setIcon(null);
            } else {
                long lastOpened;
                long lastFetched = this.model.get("lastFetchedDate", 0L);
                if (lastFetched > (lastOpened = this.model.get("lastOpenedDate", 0L).longValue())) {
                    this.setIcon(Icons.small("collaborative-new"));
                    this.setToolTipText(Msg.get("ui.newObjectsArrived"));
                } else {
                    this.setIcon(Icons.small("collaborative-1"));
                    this.setToolTipText(Msg.get("ui.collaborativeAlbum"));
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            MouseEvent evt = SwingUtilities.convertMouseEvent(this, e, this.getParent());
            e.consume();
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (evt.getID() != 505) {
                eventQueue.postEvent(evt);
            }
        }

        private void init() {
            this.setToolTipText(Msg.get("ui.collaborativeAlbum"));
        }
    }

    private static class JMonitoredStatus
    extends JBindableLabel
    implements ChangeListener {
        private ReadOnlyBooleanProperty prop;

        public JMonitoredStatus() {
            this.init();
        }

        public boolean isBound() {
            return this.prop != null;
        }

        public void setModel(AlbumObjectProperties model) {
            if (this.prop != null) {
                this.prop.removeListener((ChangeListener)this);
                this.prop = null;
            }
            if (model != null) {
                this.prop = model.getBooleanProperty("makeOnChange");
                this.prop.addListener((ChangeListener)this);
                this.changed((ObservableValue)this.prop, null, this.prop.getValue());
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            MouseEvent evt = SwingUtilities.convertMouseEvent(this, e, this.getParent());
            e.consume();
            EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (evt.getID() != 505) {
                eventQueue.postEvent(evt);
            }
        }

        private void init() {
            this.setToolTipText(Msg.get("ui.monitored"));
        }

        public void changed(ObservableValue ov, Object t, Object newValue) {
            this.setIcon(Boolean.TRUE.equals(newValue) ? Icons.small("eye") : null);
        }
    }

    private class JAlbumButton
    extends JSiteButton
    implements ActionListener,
    DropTargetListener {
        AlbumProject project;
        private JCollaborativeStatus collaborativeStatus;
        private JMonitoredStatus monitoredStatus;
        private JProgressSpinner spinner;

        public JAlbumButton(AlbumProject ap) {
            super(ap.getRootFolder() != null ? ap.getName() : Msg.get("ui.emptyProject"));
            this.collaborativeStatus = new JCollaborativeStatus();
            this.monitoredStatus = new JMonitoredStatus();
            this.spinner = new JProgressSpinner(false);
            this.project = ap;
            this.setLayout(new FlowLayout(4, 2, 0));
            this.add(Box.createVerticalStrut(28));
            this.spinner.setModel((BooleanExpression)ap.workingProperty);
            this.add(this.spinner);
            this.add(this.monitoredStatus);
            this.add(this.collaborativeStatus);
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            this.setContentAreaFilled(false);
            this.setHorizontalAlignment(2);
            this.setBackground(JAlbumColor.albumHover);
            this.addActionListener(this);
            this.addMouseListener(JAlbumManager.this.previewListener);
            this.addMouseMotionListener(JAlbumManager.this.previewListener);
            if (ap.getRootFolder() != null) {
                new DropTarget(this, 2, this);
            }
            this.setToolTipText(ap.getLongName());
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, JAlbumManager.this.group.getSourceActions(), JAlbumManager.this.dgl);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumManager.this.context.getFrame().previewPanel.setVisible(false);
            if (JAlbumManager.this.albumRootComponent.isEditing()) {
                JAlbumManager.this.albumRootComponent.setEditing(false);
            }
            SwingUtilities.invokeLater(() -> {
                if (!this.project.equals(emptyProject)) {
                    JAlbumManager.this.context.getFrame().loadProject(this.project.getProjectFile());
                } else {
                    JAlbumManager.this.context.getFrame().closeProject();
                }
            });
        }

        private void handleDrag(DropTargetDragEvent dtde) {
            if (this.isValidDragDrop(dtde.getCurrentDataFlavors())) {
                dtde.acceptDrag(2);
                this.setFont(this.getFont().deriveFont(1));
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.handleDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.handleDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.setFont(this.getFont().deriveFont(0));
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (!this.isValidDragDrop(dtde.getCurrentDataFlavors())) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(2);
            this.setFont(this.getFont().deriveFont(1));
            Transferable t = dtde.getTransferable();
            ArrayList<AlbumObject> dragged = new ArrayList<AlbumObject>();
            try {
                if (t.isDataFlavorSupported(AlbumObject.albumObjectFlavor)) {
                    for (JAlbumObject jao : JAlbumManager.this.context.getExplorer().explorer.getDraggedObjects()) {
                        dragged.add(jao.ao);
                    }
                } else if (t.isDataFlavorSupported(TransferableNode.NODE_FLAVOR)) {
                    FolderTreeNode node = (FolderTreeNode)t.getTransferData(TransferableNode.NODE_FLAVOR);
                    dragged.add(node.getAlbumObject());
                    JAlbumManager.this.tree.setSelectionPath(new TreePath(node.getParent()));
                }
                this.project.getRootFolder().invalidate();
                this.moveTo(dragged, this.project.getRootFolder());
                JAlbumManager.this.context.getExplorer().refreshAction.actionPerformed(null);
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Debug.showErrorDialog(JAlbumManager.this, ex);
                dtde.dropComplete(false);
            }
        }

        private void moveTo(List<AlbumObject> objects, AlbumObject target) throws IOException {
            for (AlbumObject ao : objects) {
                ao.moveTo(target);
            }
        }

        private boolean isValidDragDrop(DataFlavor[] flavors) {
            for (DataFlavor dropFlavor : flavors) {
                if (!dropFlavor.equals(AlbumObject.albumObjectFlavor) && !dropFlavor.equals(TransferableNode.NODE_FLAVOR)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            this.project.forIcon((icon, cached) -> this.setIcon((Icon)icon));
            if (!this.collaborativeStatus.isBound()) {
                this.project.forRootProperties((props, cached) -> {
                    this.collaborativeStatus.setModel((AlbumObjectProperties)props);
                    this.monitoredStatus.setModel((AlbumObjectProperties)props);
                });
            }
            super.paintComponent(g2d);
        }
    }

    static class InformationException
    extends Exception {
        public InformationException(String message) {
            super(message);
        }
    }

    private static class AlbumRootLabel
    extends JLabel {
        private boolean selected = false;

        public AlbumRootLabel(JTree tree) {
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            Font f = g.getFont();
            if (this.selected) {
                g.setFont(f.deriveFont(1));
            }
            super.paintComponent(g);
        }

        @Override
        public Dimension getPreferredSize() {
            Font f = this.getFont();
            this.setFont(f.deriveFont(1));
            Dimension retDimension = super.getPreferredSize();
            this.setFont(f);
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }
    }
}

