/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FolderVisitResult;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ProgressEvent;
import se.datadosen.jalbum.event.TransferListener;
import se.datadosen.util.BeanBinder;

public class JAlbumConsole
implements AlbumBeanListener,
TransferListener {
    AlbumBean engine;
    UploadBean uploadBean;

    public JAlbumConsole(Properties props) throws Exception {
        block14: {
            this.engine = new AlbumBean();
            this.uploadBean = new UploadBean(this.engine);
            try {
                this.engine.addAlbumBeanListener(this);
                System.out.println(Msg.get("console.startupInfo", AlbumBean.getInternalVersion()));
                AlbumObjectFactory factory = new AlbumObjectFactory(this.engine);
                JAlbumContext.getInstance().setAlbumObjectfactory(factory);
                if (props.containsKey("help") || props.containsKey("?")) {
                    Properties defs = BeanBinder.getProperties((Object)this.engine, true);
                    BeanBinder.getProperties((Object)this.uploadBean, defs);
                    defs.setProperty("projectFile", "");
                    defs.setProperty("programDirectory", Config.getConfig().progDir.toString());
                    defs.setProperty("skinsDirectory", Config.getConfig().skinsDir.toString());
                    defs.setProperty("runTool", "");
                    defs.setProperty("uploadAll", "");
                    defs.setProperty("smartUpload", "");
                    defs.setProperty("uic", "<user identification code>");
                    System.out.println("\n" + Msg.get("console.helpInfo"));
                    for (Map.Entry<Object, Object> e : defs.entrySet()) {
                        if (e.getKey().equals("class") || e.getKey().equals("userVariables") || e.getKey().equals("skinVariables")) continue;
                        System.out.println("-" + String.valueOf(e.getKey()) + " " + String.valueOf(e.getValue()));
                    }
                    System.out.println(Msg.get("console.userVariableInfo"));
                    System.out.println(Msg.get("console.requiredArgumentsInfo"));
                    return;
                }
                String uic = props.getProperty("uic");
                if (uic != null) {
                    LicenseManagerImpl mgr = (LicenseManagerImpl)JAlbumContext.getConsoleInstance().getLicenseManager();
                    mgr.activateLicense(uic);
                }
                File projectFile = null;
                if (props.containsKey("projectFile")) {
                    AccountProfile account;
                    projectFile = new File(props.getProperty("projectFile"));
                    AlbumProject ap = new AlbumProject(projectFile);
                    this.engine.setCurrentProject(ap);
                    Properties fileProps = ap.getProperties();
                    String accountProfileName = fileProps.getProperty("accountProfileName");
                    if (accountProfileName != null && (account = AccountManager.getInstance().findAccountByName(accountProfileName)) != null) {
                        BeanBinder.getProperties((Object)account, fileProps);
                        this.uploadBean.setAccountProperties(account);
                    }
                    fileProps.putAll((Map<?, ?>)props);
                    props = fileProps;
                }
                this.engine.setProperties(props);
                String toolName = props.getProperty("runTool");
                if (toolName != null) {
                    this.engine.init();
                    File script = new File(toolName);
                    if (!script.exists()) {
                        throw new FileNotFoundException(script.getAbsolutePath());
                    }
                    this.engine.processScript(new File(toolName));
                } else if (props.containsKey("uploadAll") || props.containsKey("smartUpload")) {
                    BeanBinder.setProperties(this.uploadBean, props);
                    System.out.println("Connecting to " + this.uploadBean.getFtpServer() + " - " + this.uploadBean.getFtpUser());
                    this.uploadAlbum(props.containsKey("uploadAll"));
                } else {
                    if (props.containsKey("appendImages")) {
                        this.engine.makeAlbum();
                    } else {
                        this.engine.smartMakeAlbum();
                    }
                    System.out.println(Msg.get("console.albumCreationInfo") + " " + this.engine.getOutputDirectory());
                }
            }
            catch (NoClassDefFoundError e) {
                if (!e.getMessage().contains("javafx")) break block14;
                System.err.println("Missing JavaFX runtime. Needed arguments: --module-path=$JAVAFX_HOME/lib --add-modules javafx.graphics,javafx.swing,javafx.web");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
        new JAlbumConsole(commandLineProperties);
    }

    private void uploadAlbum(boolean fullUpdate) throws Exception {
        this.uploadBean.addTransferListener(this);
        this.uploadBean.connect();
        try {
            this.uploadBean.uploadAlbum(this.engine, fullUpdate);
        }
        finally {
            this.uploadBean.disconnect();
        }
    }

    @Override
    public void fileProcessingStarted(ProgressEvent e) {
        if (e.processed == 0L) {
            System.out.println("\n" + Msg.get("console.processingInfo", e.subMessage, this.uploadBean.getFtpServer()));
            System.out.println(e.msg);
        } else {
            System.out.print(Msg.get("console.FileInfo") + " " + e.msg + " (" + e.processed + "/" + e.total + ") ");
        }
    }

    @Override
    public void status(String message) {
        System.out.println(message);
    }

    @Override
    public void fileProcessingFinished(ProgressEvent e) {
        System.out.println(Msg.get("console.processingDoneInfo"));
    }

    @Override
    public FolderVisitResult folderProcessingStarted(AlbumObject folder) {
        System.out.println("\n" + Msg.get("console.processingInfo", folder, this.engine.getOutputDirectory()));
        return FolderVisitResult.proceed;
    }

    @Override
    public void imageProcessingStarted(AlbumBeanEvent e) {
        System.out.print(Msg.get("console.FileInfo") + " " + e.msg + " (" + (e.getProcessedFiles() + 1) + "/" + e.getTotalFiles() + ") ");
    }

    @Override
    public void videoProcessingProgress(AlbumBeanEvent e, float currentObjectProgress) {
        this.imageProcessingStarted(e);
    }

    @Override
    public void imageProcessingFinished(AlbumBeanEvent e) {
        System.out.println(Msg.get("console.processingDoneInfo"));
    }

    @Override
    public void errorOccured(Throwable t, AlbumObject ao) {
        System.err.println(Msg.get("console.errorProcessingInfo", ao.getFile(), t.toString()));
    }

    @Override
    public void errorOccured(Throwable t, File f) {
        System.err.println(Msg.get("console.errorProcessingInfo", f, t.toString()));
    }

    @Override
    public void fileProcessingProgress(ProgressEvent e) {
        System.out.print(".");
    }
}

