/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Color;
import java.awt.SystemColor;
import javax.swing.UIManager;
import se.datadosen.jalbum.Config;
import se.datadosen.util.LaF;

public class JAlbumColor {
    public static Color border = UIManager.getColor("ToolBar.separatorColor");
    public static Color sublimeBorder = Color.decode("#B3B3B3");
    public static Color imageBorder = Color.decode("#dcdcdc");
    public static Color imageBackground = Color.decode("#222222");
    public static Color textSublimeText = Color.decode("#404040");
    public static Color text = UIManager.getColor("text");
    public static Color textText = UIManager.getColor("textText");
    public static Color window = UIManager.getColor("window");
    public static Color textHighlight = UIManager.getColor("textHighlight");
    public static Color textHighlightText = UIManager.getColor("textHighlightText");
    public static Color textInactiveText = UIManager.getColor("textInactiveText");
    public static Color windowText = UIManager.getColor("windowText");
    public static Color linkText = Color.blue;
    public static Color control = UIManager.getColor("control");
    public static Color controlText = UIManager.getColor("controlText");
    public static Color controlShadow = UIManager.getColor("controlShadow");
    public static Color controlDkShadow = UIManager.getColor("controlDkShadow");
    public static Color controlHighlight = UIManager.getColor("controlHighlight");
    public static Color controlLtHighlight = UIManager.getColor("controlLtHighlight");
    public static final Color rubberBand;
    public static final Color albumHighlight;
    public static final Color albumHover;
    public static final Color highlight;

    private JAlbumColor() {
    }

    public static Color getColorFor(Config.LabelType lt) {
        switch (lt) {
            case title: {
                return Color.blue;
            }
            case keywords: {
                return new Color(0, 128, 0);
            }
        }
        return textText;
    }

    public static int grayLevel(Color c) {
        return (c.getRed() * 30 + c.getGreen() * 59 + c.getBlue() * 11) / 100;
    }

    public static Color darken(Color c, int percent) {
        int left = 100 - percent;
        return new Color(c.getRed() * left / 100, c.getGreen() * left / 100, c.getBlue() * left / 100, c.getAlpha());
    }

    public static Color blend(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2, (c1.getAlpha() + c2.getAlpha()) / 2);
    }

    public static Color blend(Color c1, Color c2, double weight) {
        double inv = 1.0 - weight;
        if (c1 == null) {
            throw new NullPointerException("Color c1 is null");
        }
        if (c2 == null) {
            throw new NullPointerException("Color c2 is null");
        }
        return new Color((int)((double)c1.getRed() * inv + (double)c2.getRed() * weight), (int)((double)c1.getGreen() * inv + (double)c2.getGreen() * weight), (int)((double)c1.getBlue() * inv + (double)c2.getBlue() * weight), (int)((double)c1.getAlpha() * inv + (double)c2.getAlpha() * weight));
    }

    private static Color dilute(Color c, int distance) {
        int targetLevel = JAlbumColor.grayLevel(text);
        while (Math.abs(targetLevel - JAlbumColor.grayLevel(c)) > distance) {
            c = JAlbumColor.blend(c, text);
        }
        return c;
    }

    static {
        if (textText == null) {
            textText = SystemColor.textText;
            text = SystemColor.text;
        }
        if (window == null) {
            window = SystemColor.window;
            windowText = SystemColor.windowText;
            controlLtHighlight = SystemColor.controlLtHighlight;
        }
        if (textInactiveText.getAlpha() < 255) {
            textInactiveText = JAlbumColor.blend(text, textInactiveText, 0.24705882352941178);
            textInactiveText = new Color(textInactiveText.getRed(), textInactiveText.getGreen(), textInactiveText.getBlue());
        }
        if (border == null) {
            border = new Color(0, 0, 0, 25);
        }
        rubberBand = new Color(textHighlight.getRed(), textHighlight.getGreen(), textHighlight.getBlue(), 70);
        albumHighlight = JAlbumColor.dilute(textHighlight, 40);
        albumHover = JAlbumColor.dilute(textHighlight, 19);
        highlight = JAlbumColor.dilute(textHighlight, 100);
        if (LaF.isDark()) {
            linkText = new Color(88, 157, 246);
            sublimeBorder = Color.decode("#515151");
            imageBorder = Color.decode("#505050");
            textSublimeText = Color.decode("#dddddd");
            textHighlight = UIManager.getColor("textHighlight").darker();
            textHighlightText = Color.black;
            text = UIManager.getColor("Panel.background").darker();
            imageBackground = UIManager.getColor("Panel.background").darker();
        }
    }
}

