/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.IntelliJTheme;
import com.idrsolutions.image.encoder.OutputFormat;
import com.idrsolutions.imageio.ImageIOSupport;
import java.awt.Color;
import java.awt.Font;
import java.beans.Beans;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import net.jalbum.browser.JxBrowser;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumConsole;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JavaFXInit;
import se.datadosen.jalbum.MiniConfig;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.MyDesktop;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.Shell32Util;
import se.datadosen.jalbum.SkinManager;
import se.datadosen.jalbum.SplashScreen;
import se.datadosen.jalbum.Watchdog;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.util.BeanBinderBase;
import se.datadosen.util.IO;
import se.datadosen.util.LaF;
import se.datadosen.util.Platform;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;

public class JAlbum {
    public static Logger logger = Logger.getLogger("jalbum");
    public static JAlbumFrame mainFrame = null;
    public static final Object initializedOkMonitor = new Object();
    static boolean initialized = false;
    private static Map globals = new HashMap();
    private static PrintStream err = System.err;
    private static SplashScreen splash = null;
    public static Stopwatch stopwatch = new Stopwatch().start();
    private JAlbumAdapter dummyAdapter;
    static final String baseline = "v25";

    private static boolean isActive(StackTraceElement[] elements) {
        if (elements.length > 0) {
            String method = elements[0].getMethodName();
            return !method.contains("park") && !method.contains("wait") && !method.contains("sleep");
        }
        return false;
    }

    public static void dumpThreads() {
        try {
            File logFile = IO.ensureUnique(MiniConfig.getMiniConfig().configDir, "thread-dump.txt");
            try (PrintWriter log = new PrintWriter(new BufferedWriter(new FileWriter(logFile)));){
                StackTraceElement[] elements;
                Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
                log.println("*** Active threads ***");
                for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threads.entrySet()) {
                    elements = threadEntry.getValue();
                    if (!JAlbum.isActive(elements)) continue;
                    log.println(threadEntry.getKey());
                    for (StackTraceElement el : elements) {
                        log.println(el);
                    }
                    log.println("");
                }
                log.println("\n\n*** Passive threads ***");
                for (Map.Entry<Thread, StackTraceElement[]> threadEntry : threads.entrySet()) {
                    elements = threadEntry.getValue();
                    if (JAlbum.isActive(elements)) continue;
                    log.println(threadEntry.getKey());
                    for (StackTraceElement el : elements) {
                        log.println(el);
                    }
                    log.println("");
                }
            }
            MyDesktop.getDesktop().browseFileDirectory(logFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setFontSize(int fontSize) {
        if (fontSize == 11) {
            return;
        }
        UIManager.getLookAndFeelDefaults().put("defaultFont", new Font("SansSerif", 0, fontSize));
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Object key = entry.getKey();
            try {
                Object value = UIManager.get(key);
                if (value == null || !(value instanceof FontUIResource)) continue;
                FontUIResource fr = (FontUIResource)value;
                FontUIResource f = new FontUIResource(fr.deriveFont(fr.getSize2D() - 11.0f + (float)fontSize));
                UIManager.put(key, f);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAlbum(String[] args) {
        splash = new SplashScreen();
        splash.setVisible(true);
        splash.toFront();
        Object object = initializedOkMonitor;
        synchronized (object) {
            File projectFile = null;
            if (args.length > 0) {
                projectFile = new File(args[0]);
            }
            PluginManager.loadPlugins();
            JavaFXInit.ensureInitialzed();
            if (Config.getConfig().isUseWatchdog()) {
                Watchdog.getInstance().run();
            }
            if (System.getProperty("java.version").compareTo("10") < 0) {
                JOptionPane.showMessageDialog(null, Msg.get("ui.javaVersionError", "10"), "jAlbum", 0);
                System.exit(20);
            }
            mainFrame = new JAlbumFrame(projectFile);
            PluginManager.initPlugins();
            File onStart = new File(Config.getConfig().progDir, "system/onstart.bsh");
            splash.setVisible(false);
            SwingUtilities.invokeLater(() -> {
                mainFrame.setResizable(true);
                mainFrame.packThis();
                if (Config.getConfig().getWindowState() != 1) {
                    mainFrame.setVisible(true);
                    mainFrame.setFullscreenForMac();
                    mainFrame.toFront();
                }
                initialized = true;
                if (onStart.exists()) {
                    mainFrame.executeScript(onStart, null);
                }
                this.launchOnStartCode();
                System.out.println("\nStartup: " + String.valueOf(stopwatch));
                if (Config.getConfig().getPreviewMode() != Config.PreviewMode.external) {
                    JAlbumUtilities.schedule(() -> JxBrowser.initEngine(), 1000L, TimeUnit.MILLISECONDS);
                }
            });
        }
    }

    public static Object getGlobal(Object key) {
        return globals.get(key);
    }

    public static Object setGlobal(Object key, Object value) {
        return globals.put(key, value);
    }

    public static long getGUID() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
            return Long.valueOf(prefs.get("guid", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static long getTSD(long now) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
            long sd = Long.valueOf(prefs.get(baseline, "-1"));
            if (sd == -1L) {
                sd = now;
                prefs.put(baseline, String.valueOf(sd));
            }
            return sd;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static long getTSD() {
        return JAlbum.getTSD(0L);
    }

    public static boolean isUsingAlloyLAF() {
        return UIManager.getLookAndFeel().getClass().getName().contains("Alloy");
    }

    public static boolean isUsingSystemLAF() {
        return UIManager.getLookAndFeel().getClass().getName().equals(UIManager.getSystemLookAndFeelClassName());
    }

    public static void main(String[] args) {
        JAlbum.setGlobal("free", true);
        File defaultProjectFile = Config.getConfigFile("defaults.jap", ".jalbum-defaults.jap");
        try {
            logger.setUseParentHandlers(false);
            try {
                Preferences prefs = Preferences.userNodeForPackage(JAlbum.class);
                long now = System.currentTimeMillis();
                String guid = prefs.get("guid", null);
                if (guid == null) {
                    guid = String.valueOf(now);
                    prefs.put("guid", guid);
                }
                System.setProperty("jalbum.session", String.valueOf(now));
                JAlbum.getTSD(now);
                ImageIOSupport.registerReader((ImageIOSupport.InputFormat)ImageIOSupport.InputFormat.WEBP);
                ImageIOSupport.registerWriter((OutputFormat)OutputFormat.WEBP);
                ImageIOSupport.registerReader((ImageIOSupport.InputFormat)ImageIOSupport.InputFormat.HEIC);
            }
            catch (Throwable prefs) {
                // empty catch block
            }
            if ("Windows NT (unknown)".equals(System.getProperty("os.name")) && System.getProperty("os.version").startsWith("6")) {
                System.setProperty("os.name", "Windows 8");
            }
            System.setProperty("apple.awt.application.appearance", "system");
            Config config = Config.getConfig();
            if (defaultProjectFile.exists()) {
                Properties props = IO.readPropertyFile(defaultProjectFile);
                try {
                    BeanBinderBase.setProperties(config, props);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
            try {
                File signupFile = new File(config.progDir, "system/signup.properties");
                if (signupFile.exists()) {
                    Properties extra = IO.readPropertyFile(signupFile);
                    System.getProperties().putAll((Map<?, ?>)extra);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            if (Platform.isMac() || Platform.isLinux()) {
                File desktopDir;
                File myMusicDir;
                File userHomeDir = new File(System.getProperty("user.home"));
                File myPicturesDir = new File(userHomeDir, "Pictures");
                if (myPicturesDir.exists()) {
                    System.setProperty("my.pictures.path", myPicturesDir.getAbsolutePath());
                }
                if ((myMusicDir = new File(userHomeDir, "Music")).exists()) {
                    System.setProperty("my.music.path", myMusicDir.getAbsolutePath());
                }
                if ((desktopDir = new File(userHomeDir, "Desktop")).exists()) {
                    System.setProperty("desktop.path", desktopDir.getAbsolutePath());
                }
            }
            if (Platform.isMac()) {
                try {
                    Beans.instantiate(JAlbum.class.getClassLoader(), "se.datadosen.jalbum.SpecialMacHandler");
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    err.println("Error: Failed to load extended Mac support.Needs Java 9+ for that.");
                }
            } else if (Platform.isWindows()) {
                try {
                    System.setProperty("my.pictures.path", Shell32Util.getMyPicturesPath());
                    System.setProperty("my.music.path", Shell32Util.getMyMusicPath());
                    System.setProperty("desktop.path", Shell32Util.getDesktopPath());
                }
                catch (Throwable ex) {
                    ex.printStackTrace(err);
                }
            } else if (Platform.isLinux()) {
                FlatLaf.setUseNativeWindowDecorations((boolean)false);
                UIManager.put("TitlePane.unifiedBackground", true);
                UIManager.put("TitlePane.height", 28);
                if (config.isCustomTitleBar()) {
                    JFrame.setDefaultLookAndFeelDecorated(true);
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
            }
            UIManager.installLookAndFeel("FlatDark", "com.formdev.flatlaf.FlatDarkLaf");
            UIManager.installLookAndFeel("FlatLight", "com.formdev.flatlaf.FlatLightLaf");
            UIManager.installLookAndFeel("FlatDarcula", "com.formdev.flatlaf.FlatDarculaLaf");
            UIManager.installLookAndFeel("FlatLaf macOS Light", "com.formdev.flatlaf.themes.FlatMacLightLaf");
            UIManager.installLookAndFeel("FlatLaf macOS Dark", "com.formdev.flatlaf.themes.FlatMacDarkLaf");
            for (Map.Entry<String, IntelliJTheme> e : LaF.getThemes().entrySet()) {
                UIManager.installLookAndFeel(e.getKey(), "com.formdev.flatlaf.FlatIntelliJLaf");
            }
            Properties commandLineProperties = BeanBinderBase.parseArgsOptions(args);
            BeanBinderBase.setProperties(Config.getConfig(), commandLineProperties);
            SmartResourceBundle.getBundle(config.progDir, "texts/texts");
            if (commandLineProperties.size() > 0 && !commandLineProperties.containsKey("ui")) {
                Stopwatch timer = new Stopwatch();
                timer.start();
                new JAlbumConsole(commandLineProperties);
                System.out.println("Elapsed time: " + String.valueOf(timer));
                System.exit(0);
            } else {
                IntelliJTheme theme = LaF.getThemes().get(config.getLookAndFeelName());
                try {
                    if (theme != null) {
                        UIManager.setLookAndFeel((LookAndFeel)IntelliJTheme.createLaf((IntelliJTheme)theme));
                    } else {
                        UIManager.setLookAndFeel(LaF.getClassNameFromName(config.getLookAndFeelName()));
                    }
                }
                catch (Exception ex) {
                    System.err.println("Could not load look&feel " + config.getLookAndFeelName());
                }
                UIDefaults defaults = UIManager.getDefaults();
                if (defaults.getColor("textSublimeText") == null) {
                    defaults.put("textSublimeText", new ColorUIResource(64, 64, 64));
                }
                if (defaults.getColor("imageBorder") == null) {
                    defaults.put("imageBorder", new ColorUIResource(220, 220, 220));
                }
                if (LaF.isDark()) {
                    defaults.put("textHighlight", new ColorUIResource(164, 205, 255));
                    defaults.put("text", new ColorUIResource(Color.decode("#2c2f31")));
                    defaults.put("textInactiveText", new ColorUIResource(Color.decode("#999999")));
                    defaults.put("textSublimeText", new ColorUIResource(Color.decode("#dddddd")));
                    defaults.put("imageBorder", new ColorUIResource(Color.decode("#505050")));
                    defaults.put("link.foreground", new ColorUIResource(Color.decode("#589df6")));
                    defaults.put("OptionPane.questionIcon", new IconUIResource(Icons.get("help-24", 48)));
                    defaults.put("OptionPane.informationIcon", new IconUIResource(Icons.get("info-24", 48)));
                    defaults.put("OptionPane.warningIcon", new IconUIResource(Icons.get("warning-24", 48)));
                    defaults.put("OptionPane.errorIcon", new IconUIResource(Icons.get("error-24", 48)));
                }
                JAlbum.setFontSize(config.getFontSize());
                if (args.length > 0 && args[0].endsWith(".jaskin")) {
                    SkinManager sm = new SkinManager();
                    sm.setExitOnClose(true);
                    sm.installSkin(new File(args[0]));
                } else if (args.length > 0 && args[0].endsWith(".jaext")) {
                    PluginManager.installPlugin(new File(args[0]));
                } else {
                    new JAlbum(args);
                }
            }
            return;
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace(System.out);
            err.println("JAlbum: Cannot locate resources. Either set -programDirectory to JAlbum install directory or run JAlbum from its install directory.");
        }
        catch (Throwable e) {
            if ("javafx/beans/binding/BooleanExpression".equals(e.getMessage())) {
                System.err.println("Missing JavaFX runtime. Needed arguments: --module-path=$JAVAFX_HOME/lib --add-modules javafx.graphics,javafx.swing,javafx.web");
            }
            e.printStackTrace(err);
            if (splash != null) {
                splash.onError(e);
            }
            System.exit(e.getClass().getName().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secondaryMain(String[] args) {
        JAlbum.ensureGuiStarted();
        Object object = initializedOkMonitor;
        synchronized (object) {
            SwingUtilities.invokeLater(() -> {
                if (mainFrame.getExtendedState() == 1) {
                    mainFrame.setExtendedState(0);
                }
                mainFrame.toFront();
                if (args[0].length() > 0) {
                    if (args[0].endsWith(".jaskin")) {
                        new SkinManager().installSkin(new File(args[0]));
                    } else if (args[0].endsWith(".jaext")) {
                        PluginManager.installPlugin(new File(args[0]));
                    } else {
                        ArrayList<File> files = new ArrayList<File>();
                        for (String s : args) {
                            files.add(new File(s));
                        }
                        JAlbumContext.getInstance().getFrame().addFiles(files);
                    }
                }
            });
        }
    }

    private static void ensureGuiStarted() {
        while (!initialized) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void launchOnStartCode() {
        final String onStartCodeUrl = JAlbumSite.getInstance().getOnStartCodeUrl();
        final String onStartCodeClass = JAlbumSite.getInstance().getOnStartCodeClassName();
        if (onStartCodeUrl != null && onStartCodeClass != null) {
            new Thread(this, "onStartCodeThread"){
                final /* synthetic */ JAlbum this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            URLClassLoader cl = new URLClassLoader(new URL[]{new URL(onStartCodeUrl)}, this.getClass().getClassLoader());
                            Class<?> clazz = cl.loadClass(onStartCodeClass);
                            JAlbumPlugin onStartPlugin = (JAlbumPlugin)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                            onStartPlugin.init(JAlbumContext.getInstance().getPluginContext());
                            PluginManager.registerPlugin(onStartPlugin);
                        }
                        catch (ReflectiveOperationException | MalformedURLException ex) {
                            if (!Config.getConfig().isDebugMode()) break block2;
                            ex.printStackTrace(err);
                        }
                    }
                }
            }.start();
        }
    }

    private static boolean isAtleastJava9() {
        return Double.parseDouble(System.getProperty("java.specification.version")) >= 9.0;
    }
}

