/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.InvalidLicenseException;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.Debug;

class InvalidLicenseVersionException
extends InvalidLicenseException {
    private final int licenseVersion;
    private final double currentVersion;

    public InvalidLicenseVersionException(String msg, int licenseVersion, double currentVersion) {
        super(msg);
        this.licenseVersion = licenseVersion;
        this.currentVersion = currentVersion;
    }

    @Override
    public void showDialog(JFrame parent) {
        JInvalidLicenseVersionDialog d = new JInvalidLicenseVersionDialog(parent);
        d.setLocationRelativeTo(parent);
        ((Dialog)d).setVisible(true);
    }

    private class JInvalidLicenseVersionDialog
    extends JSmartDialog {
        JLabel logo;
        private final JFrame parent;
        Action cancelAction;
        Action upgradeAction;

        public JInvalidLicenseVersionDialog(JFrame parent) throws HeadlessException {
            super(parent, Msg.get("ui.invalidLicenseVersionTitle"), true);
            this.logo = new JLabel(Icons.get("share-jalbum", 64));
            this.cancelAction = new AbstractAction(Msg.get("cancel")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JInvalidLicenseVersionDialog.this.setVisible(false);
                }
            };
            this.upgradeAction = new AbstractAction(Msg.get("ui.upgrade")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        String cid = null;
                        SignInManager sim = SignInManager.getInstance();
                        if (sim.isSignedIn()) {
                            cid = AccountManager.getCid(sim.getUserName(), sim.getPassword());
                        } else {
                            AccountProfile profile = AccountManager.getInstance().getFirstMyjalbumAccount();
                            if (profile != null) {
                                cid = AccountManager.getCid(profile);
                            }
                        }
                        BrowserLauncher.openURL("http://jalbum.net/purchase?referrer=invalidLicenseVersionDialog&utm_source=client&utm_medium=upgradeAction&utm_campaign=invalidLicenseVersion" + (String)(cid != null ? "&cid=" + cid : ""));
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JInvalidLicenseVersionDialog.this.parent, ex);
                    }
                }
            };
            this.parent = parent;
            this.init();
        }

        private void init() {
            this.setResizable(false);
            JPanel logoPanel = new JPanel();
            logoPanel.setBorder(BorderFactory.createEmptyBorder(18, 18, 0, 8));
            logoPanel.add(this.logo);
            this.add((Component)logoPanel, "West");
            ControlPanel main = new ControlPanel();
            main.add("p", new JLabel("<html>" + Msg.get("ui.invalidLicenseVersionInfo", InvalidLicenseVersionException.this.licenseVersion) + "</html>"));
            this.add((Component)main, "East");
            this.registerActions(this.upgradeAction, this.cancelAction);
            this.pack();
        }
    }
}

