/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import se.datadosen.component.DeferredJSVGIcon;
import se.datadosen.component.DeferredRemoteSVGIcon;

public class Icons {
    private static final String ICON_PROPERTIES_FILE = "icons.properties";
    private static String iconPackName = "standard";
    private static Properties properties;
    private static Icon emptyIcon;

    public static ImageIcon getIcon(String key) {
        return new ImageIcon(Icons.getIconResource(key));
    }

    public static Icon small(String baseName) {
        return Icons.get(baseName, 16);
    }

    public static Icon smaller(String baseName) {
        return Icons.get(baseName, 14);
    }

    public static Icon tiny(String baseName) {
        return Icons.get(baseName, 8);
    }

    public static Icon toolbar(String baseName) {
        return Icons.get(baseName, 20);
    }

    public static Icon big(String baseName) {
        return Icons.get(baseName, 24);
    }

    public static Icon empty() {
        return emptyIcon;
    }

    public static Icon get(String baseName) {
        return Icons.get(Icons.class, "icons/" + baseName + ".svg", -1);
    }

    public static Icon get(URL svgIconURL) {
        return new DeferredRemoteSVGIcon(svgIconURL);
    }

    public static Icon get(String baseName, int pointSize) {
        return Icons.get(Icons.class, "icons/" + baseName + ".svg", pointSize);
    }

    public static Icon get(Class resourceLoader, String path, int pointSize) {
        DeferredJSVGIcon icon = new DeferredJSVGIcon(resourceLoader, path);
        if (pointSize > 0) {
            icon.setIconSize(pointSize, pointSize);
        }
        return icon;
    }

    public static boolean exists(String baseName) {
        return Icons.class.getResource("icons/" + baseName + ".svg") != null;
    }

    public static URL getIconResource(String key) {
        Object path = Icons.getProperties().getProperty(key);
        if (path == null) {
            throw new RuntimeException("No icon set in properties file for key=" + key);
        }
        path = "/icons/" + iconPackName + "/" + (String)path;
        try {
            return Icons.class.getResource((String)path);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Icon not found for path=" + (String)path, e);
        }
    }

    public static Image getImage(String key) {
        return Icons.getIcon(key).getImage();
    }

    public static void setIconPack(String name) {
        try {
            iconPackName = name;
            properties = null;
            Icons.getProperties();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set iconpack=" + name, e);
        }
    }

    private static Properties getProperties() {
        if (properties == null) {
            try {
                properties = new Properties();
                String fileName = "/icons/" + iconPackName + "/icons.properties";
                InputStream in = Icons.class.getResourceAsStream(fileName);
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("Property file for icons not found", e);
            }
        }
        return properties;
    }

    static {
        emptyIcon = Icons.small("empty");
    }
}

