/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.ChainedObjects;
import se.datadosen.util.IO;

public class FullTreeChainedObjects
extends ChainedObjects {
    public FullTreeChainedObjects(AlbumObject root, AlbumBean engine) {
        super(engine);
        this.buildLinks(root);
    }

    private void buildLinks(AlbumObject folder) {
        this.add(folder);
        AlbumObject first = null;
        AlbumObject last = null;
        int childCount = 0;
        for (AlbumObject ao : folder.getChildren()) {
            if (!FullTreeChainedObjects.qualifies(ao)) continue;
            if (ao.isFolder()) {
                if (last != null) {
                    if (childCount > 2) {
                        this.add(null);
                    }
                    this.add(last);
                    last = null;
                }
                this.buildLinks(ao);
                childCount = 0;
                first = null;
                continue;
            }
            ++childCount;
            if (first == null) {
                first = ao;
                this.add(ao);
                continue;
            }
            last = ao;
        }
        if (last != null) {
            if (childCount > 2) {
                this.add(null);
            }
            this.add(last);
        }
    }

    private void add(AlbumObject ao) {
        this.list.add(ao);
        if (ao != null) {
            this.indexMap.put(ao.getFile(), this.list.size() - 1);
        }
    }

    private int indexOf(AlbumObject ao) {
        Integer index = (Integer)this.indexMap.get(ao.getFile());
        if (index != null) {
            return index;
        }
        return -1;
    }

    public AlbumObject getPrevious(AlbumObject ao) {
        int index = this.indexOf(ao);
        if (index != -1 && --index >= 0) {
            return (AlbumObject)this.list.get(index);
        }
        return null;
    }

    public AlbumObject getNext(AlbumObject ao) {
        int index = this.indexOf(ao);
        if (index != -1 && ++index < this.list.size()) {
            return (AlbumObject)this.list.get(index);
        }
        return null;
    }

    @Override
    public AlbumObject getPrevious(AlbumObject ao, boolean folder) {
        int index = this.indexOf(ao);
        if (index != -1) {
            while (--index >= 0) {
                AlbumObject closest = (AlbumObject)this.list.get(index);
                if (!folder && closest == null) {
                    return null;
                }
                if (closest == null || closest.isFolder() != folder) continue;
                return closest;
            }
        }
        return null;
    }

    @Override
    public AlbumObject getNext(AlbumObject ao, boolean folder) {
        int index = this.indexOf(ao);
        if (index != -1) {
            while (++index < this.list.size()) {
                AlbumObject closest = (AlbumObject)this.list.get(index);
                if (!folder && closest == null) {
                    return null;
                }
                if (closest == null || closest.isFolder() != folder) continue;
                return closest;
            }
        }
        return null;
    }

    @Override
    public String getPreviousPath(AlbumObject ao, boolean folder) {
        return this.relativePath(this.getPrevious(ao, folder), ao);
    }

    @Override
    public String getNextPath(AlbumObject ao, boolean folder) {
        return this.relativePath(this.getNext(ao, folder), ao);
    }

    public String getPreviousPart(AlbumObject ao) {
        String rel;
        AlbumObject prev = this.getPrevious(ao, false);
        if (!prev.isFolder()) {
            prev = prev.getParent();
        }
        if (!ao.isFolder()) {
            ao = ao.getParent();
        }
        return (rel = IO.relativePath("/" + prev.getPathFromRoot(), "/" + ao.getPathFromRoot())).length() == 0 ? "" : rel + "/";
    }

    public String getNextPart(AlbumObject ao) {
        String rel;
        AlbumObject next = this.getNext(ao, false);
        if (!next.isFolder()) {
            next = next.getParent();
        }
        if (!ao.isFolder()) {
            ao = ao.getParent();
        }
        return (rel = IO.relativePath("/" + next.getPathFromRoot(), "/" + ao.getPathFromRoot())).length() == 0 ? "" : rel + "/";
    }
}

