/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.jalbum.component.Dialogs;
import se.datadosen.jalbum.AccountManager;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.LicenseManagerImpl;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.SignInManager;
import se.datadosen.util.Debug;

public class FreeVersionDialogs {
    public static final int OBJECT_LIMIT = 24;
    private static final CurrentVersionDismisser onStartDismisser = new CurrentVersionDismisser("onStart");
    private static final CurrentVersionDismisser onSettingsDismisser = new CurrentVersionDismisser("onSettingsDismisser");
    private static final CurrentVersionDismisser onMakeAlbum = new CurrentVersionDismisser("onMakeAlbum");
    JAlbumContext context;
    String activateLicenseOption = Msg.get("ui.activateLicense");
    String pricingOption = Msg.get("ui.pricing");
    String cancelOption = Msg.get("cancel");
    String laterOption = Msg.get("ui.later");
    String okOption = Msg.get("ok");
    static final Preferences prefs;
    static final Preferences dontShowDialogsNode;

    public static void forgetAllDismissed() {
        onStartDismisser.forget();
        onSettingsDismisser.forget();
        onMakeAlbum.forget();
    }

    public FreeVersionDialogs(JAlbumContext context) {
        this.context = context;
    }

    public void showOnStart() {
        if (onStartDismisser.isDismissed()) {
            return;
        }
        JCheckBox dontShowAgain = new JCheckBox(Msg.get("ui.dontShowAgainForThisVersion"));
        Object result = Dialogs.showOptionDialog(this.context.getFrame(), new Object[]{new JLabel("<html>" + Msg.get("ui.aboutFreeInfo", AlbumBean.getDisplayVersion()) + "<br>" + Msg.get("ui.licenseBenefits", 24) + "</html>"), new JLabel(" "), dontShowAgain}, Msg.get("ui.aboutFreeTitle"), 1, new Object[]{this.okOption, this.pricingOption, this.activateLicenseOption}, this.okOption);
        if (dontShowAgain.isSelected()) {
            onStartDismisser.dismiss();
        }
        if (result == this.pricingOption) {
            this.pricingAction();
        } else if (result == this.activateLicenseOption) {
            this.activatLicenceAction();
        }
    }

    public void showOnSettings() {
        if (onSettingsDismisser.isDismissed()) {
            return;
        }
        JCheckBox dontShowAgain = new JCheckBox(Msg.get("ui.dontShowAgainForThisVersion"));
        Object result = Dialogs.showOptionDialog(this.context.getFrame(), new Object[]{new JLabel("<html>" + Msg.get("ui.onlyForLicensedUseInfo") + "<br>" + Msg.get("ui.licenseBenefits", 24) + "</html>"), new JLabel(" "), dontShowAgain}, Msg.get("ui.onlyForLicensedUse"), 1, new Object[]{this.okOption, this.pricingOption, this.activateLicenseOption}, this.okOption);
        if (dontShowAgain.isSelected()) {
            onSettingsDismisser.dismiss();
        }
        if (result == this.pricingOption) {
            this.pricingAction();
        } else if (result == this.activateLicenseOption) {
            this.activatLicenceAction();
        }
    }

    public void showOnMake() {
        Object result = Dialogs.showOptionDialog(this.context.getFrame(), new JLabel("<html>" + Msg.get("ui.sizeLimitExceededInfo", 24) + "<br>" + Msg.get("ui.licenseBenefits", 24) + "</html>"), Msg.get("ui.sizeLimitExceeded"), 2, new Object[]{this.okOption, this.cancelOption, this.pricingOption, this.activateLicenseOption}, this.okOption);
        if (result == this.pricingOption) {
            this.pricingAction();
            throw new OperationAbortedException();
        }
        if (result == this.activateLicenseOption) {
            this.activatLicenceAction();
            throw new OperationAbortedException();
        }
        if (result != this.okOption) {
            throw new OperationAbortedException();
        }
    }

    private void pricingAction() {
        try {
            String cid = null;
            SignInManager sim = SignInManager.getInstance();
            if (sim.isSignedIn()) {
                cid = AccountManager.getCid(sim.getUserName(), sim.getPassword());
            } else {
                AccountProfile profile = AccountManager.getInstance().getFirstMyjalbumAccount();
                if (profile != null) {
                    cid = AccountManager.getCid(profile);
                }
            }
            BrowserLauncher.openURL("http://jalbum.net/purchase?referrer=freeVersionDialog&utm_source=client&utm_medium=upgradeAction&utm_campaign=freeVersionDialog" + (String)(cid != null ? "&cid=" + cid : ""));
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this.context.getFrame(), ex);
        }
    }

    private void activatLicenceAction() {
        LicenseManagerImpl mgr = (LicenseManagerImpl)this.context.getLicenseManager();
        mgr.activateLicense();
    }

    static {
        JAlbumContext.getInstance().getLicenseManager().addPropertyChangeListener("licenseValid", pce -> {
            if (Boolean.FALSE.equals(pce.getNewValue())) {
                FreeVersionDialogs.forgetAllDismissed();
            }
        });
        prefs = Preferences.userNodeForPackage(FreeVersionDialogs.class);
        dontShowDialogsNode = prefs.node("dontShowDialogs");
    }

    private static class CurrentVersionDismisser {
        private String key;

        public CurrentVersionDismisser(String key) {
            this.key = key;
        }

        public boolean isDismissed() {
            return "39".equals(dontShowDialogsNode.get(this.key, null));
        }

        public void forget() {
            dontShowDialogsNode.remove(this.key);
        }

        public void dismiss() {
            dontShowDialogsNode.put(this.key, "39");
        }
    }
}

