/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.Msg;

public enum Flag {
    NoFlag("small.flag.empty", JAlbumColor.textText),
    Select("small.flag.red", new Color(232, 49, 46)),
    Second("small.flag.yellow", new Color(236, 187, 79)),
    Review("small.flag.blue", new Color(72, 171, 233)),
    Approved("small.flag.green", new Color(80, 177, 70));

    private Icon icon;
    private Icon selectedIcon;
    private final Color color;
    public static final int DEFAULT_ICON_SIZE = 16;

    private Flag(String iconName, Color color) {
        this.color = color;
    }

    public String toString() {
        return Msg.get("flag." + this.name().toLowerCase());
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.getIcon(16, false, JAlbumColor.textText);
        }
        return this.icon;
    }

    public Icon getSelectedIcon() {
        if (this.selectedIcon == null) {
            this.selectedIcon = this.getIcon(16, true, SystemColor.black);
        }
        return this.selectedIcon;
    }

    public Icon getIcon(int size, boolean selected, Color frameColor) {
        return new FlagIcon(size, selected, frameColor);
    }

    private class FlagIcon
    implements Icon {
        private final int size;
        private final Color frameColor;
        private final boolean selected;

        public FlagIcon(int size, boolean selected, Color frameColor) {
            this.size = size;
            this.selected = selected;
            this.frameColor = frameColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g2d, int x, int y) {
            Graphics2D g = (Graphics2D)g2d;
            AffineTransform at = g.getTransform();
            g.translate(x, y);
            Composite comp = g.getComposite();
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int side = (int)((double)this.size * 0.75);
            int margin = (this.size - side) / 2;
            int radius = side / 2;
            if (!this.selected) {
                g.setComposite(AlphaComposite.getInstance(3, 0.3f));
            }
            if (Flag.this != NoFlag) {
                g.setColor(Flag.this.color);
                g.fillRoundRect(margin, margin, side, side, radius, radius);
            }
            g.setColor(this.frameColor);
            g.setStroke(new BasicStroke((float)this.size / 16.0f));
            g.drawRoundRect(margin, margin, side, side, radius, radius);
            g.setComposite(comp);
            g.setTransform(at);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

