/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.ControlFiles;
import se.datadosen.jalbum.DeleteOption;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.io.FileTreeProcessor;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.Platform;
import se.datadosen.util.Stopwatch;

public class FileCopier {
    private JAlbumFileFilter fileFilter = new JAlbumFileFilter();
    private JFrame parentWindow;
    private JCopyDialog dialog;
    private boolean aborted;
    private boolean done;
    private boolean allowDuplicates = false;
    private boolean deleteExisting = true;
    private List<File> copiedFiles = new ArrayList<File>();
    private AtomicInteger items = new AtomicInteger(0);
    private long processedBytes;
    private long totalBytes;
    private Stopwatch timer = new Stopwatch();
    private Recorder recorder;
    private CopyDecision copyDecision = CopyDecision.UNDECIDED;
    private Thread copierThread;
    private long lastUpdateMillis = 0L;
    private static final long UPDATE_INTERVAL = 250L;
    private int millisToPopup = 1500;
    private ProgressMonitor monitor = new ProgressMonitor(){

        @Override
        public void progress(long count) throws OperationAbortedException {
            FileCopier.this.processedBytes += count;
            if (FileCopier.this.aborted) {
                throw new OperationAbortedException();
            }
            if (System.currentTimeMillis() - FileCopier.this.lastUpdateMillis > 250L) {
                SwingUtilities.invokeLater(FileCopier.this::updateProgress);
            }
        }
    };
    private byte[] buffer = new byte[262144];

    public FileCopier(JFrame window) {
        this.parentWindow = window;
        this.dialog = new JCopyDialog(window, Msg.get("ui.copy"));
    }

    public CopyDecision getCopyDecision() {
        return this.copyDecision;
    }

    public void setCopyDecision(CopyDecision copyDecision) {
        this.copyDecision = copyDecision;
    }

    public void setTitle(String title) {
        this.dialog.setTitle(title);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public JAlbumFileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(JAlbumFileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> copyFiles(final List<File> files, final AlbumObject dest) {
        this.copiedFiles = new ArrayList<File>();
        this.aborted = false;
        this.items = new AtomicInteger(0);
        this.processedBytes = 0L;
        this.totalBytes = 0L;
        this.timer.reset();
        this.done = false;
        if (!files.isEmpty()) {
            this.copierThread = new Thread(this, "copier"){
                final /* synthetic */ FileCopier this$0;
                {
                    this.this$0 = this$0;
                    super(arg0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    this.this$0.recorder = Config.getConfig().isRememberCopiedFiles() ? this.this$0.new RealRecorder((File)files.get(0)) : this.this$0.new DummyRecorder();
                    try {
                        this.this$0.doCopyFiles(files, dest);
                    }
                    catch (OperationAbortedException ex) {
                    }
                    catch (IOException ex) {
                        SwingUtilities.invokeLater(() -> Debug.showFriendlyErrorDialog(this.this$0.parentWindow, ex));
                    }
                    finally {
                        this.this$0.done = true;
                        try {
                            2.sleep(100L);
                            this.this$0.recorder.close();
                        }
                        catch (IOException ex) {
                            System.err.println(ex);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.this$0.recorder = null;
                    }
                    FileCopier fileCopier = this.this$0;
                    synchronized (fileCopier) {
                        SwingUtilities.invokeLater(() -> this.this$0.dialog.setVisible(false));
                        this.this$0.notify();
                    }
                }
            };
            this.copierThread.setDaemon(true);
            this.copierThread.start();
            if (this.millisToPopup > 0) {
                FileCopier fileCopier = this;
                synchronized (fileCopier) {
                    try {
                        this.wait(this.millisToPopup);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.done) {
                this.dialog.pack();
                this.dialog.setLocationRelativeTo(this.parentWindow);
                this.dialog.setVisible(true);
            }
        }
        return this.copiedFiles;
    }

    private String getDuplicateName(AlbumObject targetFolder, String originalName) {
        String name;
        String base = IO.baseName(originalName);
        Object ext = IO.extensionOf(originalName);
        if (((String)ext).length() > 0) {
            ext = "." + (String)ext;
        }
        if (!targetFolder.containsName(name = base + " - " + Msg.get("ui.copyOfSomething") + (String)ext)) {
            return name;
        }
        int i = 2;
        do {
            name = base + " - " + Msg.get("ui.copyOfSomething") + " (" + i + ")" + (String)ext;
            ++i;
        } while (targetFolder.containsName(name));
        return name;
    }

    private void doCopyFiles(List<File> files, AlbumObject targetFolder) throws IOException, OperationAbortedException {
        File destDir = targetFolder.getFile();
        this.dialog.setHeader(Msg.get("ui.calculatingSize") + "...");
        this.totalBytes = this.calculateTotalSize(files);
        this.dialog.setHeader(Msg.get("ui.copyingItems", this.items, destDir.getName()));
        this.timer.start();
        for (File f : files) {
            if (this.okToCopy(f)) {
                String newName = f.getName();
                if (this.allowDuplicates && f.getParentFile().equals(destDir)) {
                    newName = this.getDuplicateName(targetFolder, newName);
                }
                File dest = f instanceof LinkFile && !(f instanceof RenamedFile) ? new LinkFile(destDir, newName, f) : new File(destDir, newName);
                AlbumObject existingChild = targetFolder.getChild(newName);
                if (existingChild != null) {
                    if (!this.allowDuplicates) {
                        throw new IOException(Msg.get("edit.objectAlreadyExists", f.getName()));
                    }
                    if (!existingChild.isFolder() && this.deleteExisting) {
                        try {
                            existingChild.delete(DeleteOption.KEEP_COMMENT, DeleteOption.KEEP_META, DeleteOption.KEEP_INCLUDED);
                        }
                        catch (PermissionException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
                if (f instanceof LinkFile && !(f instanceof RenamedFile)) {
                    this.copiedFiles.add(dest);
                    continue;
                }
                if (f.isDirectory()) {
                    if (f.equals(destDir) || IO.isSubdirectoryOf(destDir, f)) {
                        throw new IOException(Msg.get("ui.invalidFolderCopyError", f.getName()));
                    }
                    this.copiedFiles.add(dest);
                    this.copyDir(f, dest);
                    continue;
                }
                this.doCopyPlainFile(f, dest);
                this.copyAdditionalFiles(f, newName, targetFolder);
                this.copiedFiles.add(dest);
                continue;
            }
            this.processedBytes += f.length();
        }
    }

    private void copyAdditionalFiles(File f, String newName, AlbumObject targetFolder) throws IOException {
        File attachmentsSrcDir;
        File commentsFile;
        File infoFile;
        File srcjAlbumFolder = AlbumObjectImpl.getJalbumFolder(f);
        File destjAlbumFolder = ControlFiles.jalbum(targetFolder.getFile());
        if (!destjAlbumFolder.exists()) {
            destjAlbumFolder.mkdir();
        }
        if ((infoFile = new File(srcjAlbumFolder, f.getName() + ".info")).exists()) {
            IO.copyFile(infoFile, new File(destjAlbumFolder, newName + ".info"));
        }
        if ((commentsFile = ControlFiles.comments(AlbumObjectImpl.getAlbumParentFile(f))).exists()) {
            Map commentsMap = IO.readMapFile(commentsFile);
            AlbumObjectImpl.setTextFileComment((String)commentsMap.get(f.getName()), (AlbumObjectImpl)targetFolder, newName);
        }
        if ((attachmentsSrcDir = Attachments.getAttachmentsDir(f)).exists()) {
            File destFile = new File(targetFolder.getFile(), newName);
            File attachmentsDestDir = Attachments.getAttachmentsDir(destFile);
            attachmentsDestDir.mkdirs();
            IO.copyDirectoryContent(attachmentsSrcDir, attachmentsDestDir, true);
        }
    }

    private void copyDir(File src, File dir) throws IOException {
        dir.mkdir();
        CachedFile[] files = CachedFile.listFiles(src);
        if (files != null) {
            for (CachedFile f : files) {
                if (((File)f).isDirectory()) {
                    this.copyDir(f, new File(dir, f.getName()));
                    continue;
                }
                try {
                    this.copyPlainFile(f, dir);
                }
                catch (IOException ex) {
                    throw new IOException("Error copying " + String.valueOf(f) + ": " + ex.getMessage(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToCopy(File src) {
        if (this.recorder.isAlreadyCopied(src)) {
            CopyDecision decision = this.copyDecision;
            if (this.copyDecision == CopyDecision.UNDECIDED) {
                FileCopier fileCopier = this;
                synchronized (fileCopier) {
                    this.notify();
                }
                JReCopyConfirmationDialog confirmDialog = new JReCopyConfirmationDialog(this.dialog, Msg.get("ui.copy"), src);
                confirmDialog.setVisible(true);
                if (confirmDialog.buttonPressed == confirmDialog.copyButton) {
                    decision = CopyDecision.COPY;
                } else if (confirmDialog.buttonPressed == confirmDialog.dontCopyButton) {
                    decision = CopyDecision.SKIP;
                } else {
                    throw new OperationAbortedException();
                }
                if (confirmDialog.applyToAll.isSelected()) {
                    this.copyDecision = decision;
                }
            }
            return decision == CopyDecision.COPY;
        }
        return true;
    }

    private boolean copyPlainFile(File src, File dest) throws IOException {
        if (this.okToCopy(src)) {
            this.doCopyPlainFile(src, dest);
            return true;
        }
        this.processedBytes += src.length();
        return false;
    }

    private void doCopyPlainFile(File src, File dest) throws IOException {
        this.classicCopyFile(src, dest, this.monitor);
        SwingUtilities.invokeLater(this::updateProgress);
        this.recorder.copiedOk(src);
    }

    public void abort() {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean isDeleleteExisting() {
        return this.deleteExisting;
    }

    public void setDeleteExisting(boolean b) {
        this.deleteExisting = b;
    }

    private long calculateTotalSize(List<File> files) {
        FileTreeProcessor p = new FileTreeProcessor((File[])files.toArray(File[]::new), this.fileFilter);
        try {
            long l = p.process(str -> str.peek(f -> {
                this.items.incrementAndGet();
                if (this.aborted) {
                    throw new OperationAbortedException();
                }
            }).filter(f -> !f.isDirectory()).mapToLong(File::length).sum());
            p.close();
            return l;
        }
        catch (Throwable throwable) {
            try {
                try {
                    p.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                Debug.showErrorDialog(this.parentWindow, ex);
                throw new OperationAbortedException();
            }
        }
    }

    public void updateProgress() {
        if (this.totalBytes > 0L) {
            this.dialog.setPercentDone((int)(100L * this.processedBytes / this.totalBytes));
        }
        Object timeLeftString = "";
        long elapsed = this.timer.getMillis();
        if (elapsed > 3000L) {
            long totalMillis = this.totalBytes * elapsed / this.processedBytes;
            int secsLeft = (int)(totalMillis - elapsed) / 1000;
            if (secsLeft < 1) {
                secsLeft = 1;
            }
            timeLeftString = " - " + FileCopier.formatTimeLeft(secsLeft);
        }
        this.dialog.lowerLabel.setText(Msg.get("progress.processingInfo2", DataSizeFormatter.formatBytes(this.processedBytes), DataSizeFormatter.formatBytes(this.totalBytes)) + (String)timeLeftString);
        this.lastUpdateMillis = System.currentTimeMillis();
    }

    private static String formatTimeLeft(int secsLeft) {
        int value;
        String unit = secsLeft > 3600 ? ((value = secsLeft / 3600) > 1 ? "ui.hours" : "ui.hour") : (secsLeft > 60 ? ((value = secsLeft / 60) > 1 ? "ui.minutes" : "ui.minute") : ((value = secsLeft) > 1 ? "ui.seconds" : "ui.second"));
        return Msg.get("ui.timeEstimate", value, Msg.get(unit));
    }

    private void classicCopyFile(File src, File dest, ProgressMonitor monitor) throws IOException, OperationAbortedException {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (dest.equals(src)) {
            throw new IOException("Cannot copy file " + String.valueOf(src) + " onto itself");
        }
        long length = src.length();
        if (src.lastModified() == dest.lastModified() && length == dest.length()) {
            monitor.progress(length);
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        long lastModified = src.lastModified();
        try {
            int bytesRead;
            while ((bytesRead = in.read(this.buffer)) != -1) {
                out.write(this.buffer, 0, bytesRead);
                monitor.progress(bytesRead);
            }
            IO.close(out);
            if (lastModified > 0L) {
                dest.setLastModified(lastModified);
            }
        }
        catch (IOException | OperationAbortedException ex) {
            IO.close(out);
            dest.delete();
            throw ex;
        }
        finally {
            IO.close(in);
            IO.close(out);
        }
    }

    private static class JAlbumFileFilter
    implements FileFilter {
        private JAlbumFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || FileFilters.isFileSupported(f) || FileFilters.hasIcon(f) || IO.isThumbFile(f);
        }
    }

    public static enum CopyDecision {
        UNDECIDED,
        COPY,
        SKIP;

    }

    public static interface ProgressMonitor {
        public void progress(long var1) throws OperationAbortedException;
    }

    private class JCopyDialog
    extends JDialog {
        JLabel upperLabel;
        JLabel icon;
        JProgressBar progressBar;
        JButton abortButton;
        JLabel lowerLabel;

        public JCopyDialog(JFrame owner, String title) {
            super((Window)owner, title, Dialog.ModalityType.DOCUMENT_MODAL);
            this.upperLabel = new JLabel();
            this.icon = new JLabel(Icons.get("copy-files", 32));
            this.progressBar = new JProgressBar(0, 100);
            this.abortButton = new JPlainButton(Icons.small("abort"), Icons.small("abort-1"));
            this.lowerLabel = new JLabel(" ");
            this.init();
        }

        private void init() {
            this.setResizable(false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    FileCopier.this.abort();
                }
            });
            this.abortButton.addActionListener(e -> {
                this.setVisible(false);
                FileCopier.this.abort();
            });
            if (Platform.isMac()) {
                this.setSmallerFont(this.upperLabel);
                this.setSmallerFont(this.lowerLabel);
            }
            JPanel outer = new JPanel(new BorderLayout(8, 0));
            outer.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 2));
            this.setContentPane(outer);
            outer.add((Component)this.icon, "West");
            JPanel content = new JPanel(new RiverLayout());
            outer.add((Component)content, "Center");
            content.add("hfill", this.upperLabel);
            content.add("br hfill", this.progressBar);
            content.add("", this.abortButton);
            content.add("br hfill", this.lowerLabel);
            this.setMinimumSize(new Dimension(400, 1));
        }

        public void setHeader(String s) {
            this.upperLabel.setText(s);
        }

        public void setPercentDone(int percent) {
            this.progressBar.setValue(percent);
        }

        private void setSmallerFont(JComponent comp) {
            Font f = comp.getFont();
            comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }
    }

    static interface Recorder {
        public boolean isAlreadyCopied(File var1);

        public void copiedOk(File var1);

        public void close() throws IOException;
    }

    public static class JReCopyConfirmationDialog
    extends JDialog
    implements ActionListener {
        JLabel upperLabel = new JLabel();
        JLabel icon = new JLabel(Icons.get("warning-24", 48));
        WrappableJLabel message;
        JCheckBox applyToAll = new JCheckBox(Msg.get("ui.applyToAll"));
        JButton dontCopyButton = new JButton(Msg.get("ui.dontCopy"));
        JButton stopButton = new JButton(Msg.get("ui.stop"));
        JButton copyButton = new JButton(Msg.get("ui.copy"));
        File file;
        JButton buttonPressed = this.stopButton;

        public JReCopyConfirmationDialog(JDialog owner, String title, File file) {
            super(owner, title, true);
            this.file = file;
            this.init();
        }

        private void init() {
            this.setResizable(false);
            this.message = new WrappableJLabel(Msg.get("ui.fileAlreadyCopiedWarning", this.file.getName()));
            this.message.setPreferredWidth(340);
            if (Platform.isMac()) {
                this.setSmallerFont(this.message);
                this.setSmallerFont(this.applyToAll);
                this.setSmallerFont(this.applyToAll);
                this.setSmallerFont(this.dontCopyButton);
                this.setSmallerFont(this.stopButton);
                this.setSmallerFont(this.copyButton);
            }
            this.dontCopyButton.addActionListener(this);
            this.stopButton.addActionListener(this);
            this.copyButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.dontCopyButton);
            JPanel outer = new JPanel(new BorderLayout(8, 0));
            outer.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 2));
            this.setContentPane(outer);
            outer.add((Component)this.icon, "West");
            JPanel messagePanel = new JPanel(new BorderLayout());
            messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
            messagePanel.add((Component)this.message, "Center");
            outer.add((Component)messagePanel, "Center");
            JPanel buttonBar = new JPanel(new FlowLayout(1, 4, 4));
            outer.add((Component)buttonBar, "South");
            buttonBar.add(this.applyToAll);
            buttonBar.add(Box.createHorizontalGlue());
            buttonBar.add(this.dontCopyButton);
            buttonBar.add(this.stopButton);
            buttonBar.add(this.copyButton);
            this.setMinimumSize(new Dimension(420, 1));
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        private void setSmallerFont(JComponent comp) {
            Font f = comp.getFont();
            comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.buttonPressed = (JButton)e.getSource();
            this.setVisible(false);
        }
    }

    class RealRecorder
    implements Recorder {
        private Set<String> db;
        private File dbFile;
        private static final String DB_FILE_NAME = "jalbum-copied-files.db";

        public RealRecorder(File initialFile) {
            File dcimFolder = this.getDCIMParent(initialFile);
            if (dcimFolder != null) {
                this.init(dcimFolder);
            }
        }

        @Override
        public boolean isAlreadyCopied(File f) {
            return this.db != null && this.db.contains(this.keyOf(f));
        }

        @Override
        public void copiedOk(File f) {
            if (this.db != null) {
                this.db.add(this.keyOf(f));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.db != null && this.dbFile != null) {
                try (ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dbFile)));){
                    oos.writeObject(this.db);
                }
            }
        }

        private void init(File dcimFolder) {
            block9: {
                try {
                    this.dbFile = new File(dcimFolder.getParentFile(), DB_FILE_NAME);
                    if (this.dbFile.exists()) {
                        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.dbFile));){
                            this.db = (Set)ois.readObject();
                            break block9;
                        }
                    }
                    this.db = new HashSet<String>();
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            }
        }

        private String keyOf(File f) {
            return f.getParentFile().getName() + "/" + f.getName();
        }

        private File getDCIMParent(File f) {
            for (f = f.getParentFile(); f != null && !"DCIM".equals(f.getName()); f = f.getParentFile()) {
            }
            return f;
        }
    }

    class DummyRecorder
    implements Recorder {
        DummyRecorder() {
        }

        @Override
        public boolean isAlreadyCopied(File f) {
            return false;
        }

        @Override
        public void copiedOk(File f) {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

