/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import net.jalbum.remotefs.RemoteFSBean;
import net.jalbum.remotefs.RemoteFSDelegate;
import net.jalbum.remotefs.RemoteFSException;
import net.jalbum.remotefs.RemoteFSProgressMonitor;
import net.jalbum.remotefs.RemoteFile;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.event.ByteProgressEvent;
import se.datadosen.util.IO;

public class DownloadWorkers {
    UploadBean uploadBean;
    final Worker[] workers;
    final Queue<RemoteFile> downloadQueue;
    final String remotePath;
    ByteProgressEvent progressEvent;
    File destDir;

    public DownloadWorkers(UploadBean uploadBean, ByteProgressEvent progressEvent, Set<RemoteFile> remoteFiles, String remotePath, int maxTransfers, File destDir) {
        this.uploadBean = uploadBean;
        this.progressEvent = progressEvent;
        this.downloadQueue = new LinkedBlockingQueue<RemoteFile>(remoteFiles);
        this.remotePath = remotePath;
        this.destDir = destDir;
        this.workers = new Worker[maxTransfers];
        this.workers[0] = new Worker(uploadBean.getRemoteFS());
    }

    void downloadFiles() throws RemoteFSException, IOException, OperationAbortedException, InterruptedException {
        this.destDir.mkdir();
        for (int i = 1; i < this.workers.length; ++i) {
            this.workers[i] = new Worker(i);
        }
        for (Worker worker : this.workers) {
            worker.start();
        }
        for (Worker worker : this.workers) {
            worker.join();
        }
        Throwable t = null;
        for (Worker worker : this.workers) {
            if (worker.throwable == null) {
                return;
            }
            t = worker.throwable;
        }
        if (t != null) {
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RemoteFSException) {
                throw (RemoteFSException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            t.printStackTrace(System.err);
        }
    }

    void fireFileProcessingProgress() {
        this.progressEvent.processed = this.uploadBean.processedBytes.get() + this.getBytesInProgress();
        this.uploadBean.fireFileProcessingProgress(this.progressEvent);
    }

    private long getBytesInProgress() {
        long totalBytesInProgress = 0L;
        for (Worker worker : this.workers) {
            if (!worker.isAlive()) continue;
            totalBytesInProgress += worker.currentFileByteProgress;
        }
        return totalBytesInProgress;
    }

    private class Worker
    extends Thread
    implements RemoteFSProgressMonitor {
        RemoteFSDelegate channel;
        boolean disconnectOnDone;
        Throwable throwable;
        long currentFileByteProgress;
        String currentPath;

        public Worker(int i) {
            super("Download worker " + (i + 1));
            this.disconnectOnDone = true;
            this.currentPath = "";
            this.setDaemon(true);
        }

        public Worker(RemoteFSDelegate connectedDelegate) {
            super("Main download worker");
            this.disconnectOnDone = true;
            this.currentPath = "";
            this.channel = connectedDelegate;
            this.disconnectOnDone = false;
            connectedDelegate.setProgressMonitor(this);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                if (this.channel == null) {
                    this.prepareConnection();
                }
                this.downloadFiles();
            }
            catch (IOException | RemoteFSException | OperationAbortedException t) {
                this.throwable = t;
            }
            if (this.disconnectOnDone) {
                try {
                    this.channel.disconnect();
                }
                catch (IOException | RemoteFSException ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void bytesTransferred(long bytes) {
            this.currentFileByteProgress = bytes;
            DownloadWorkers.this.fireFileProcessingProgress();
        }

        private String getParentPath(RemoteFile rf) {
            String fullPath = rf.getFullPath();
            int slashIndex = fullPath.lastIndexOf(47);
            return slashIndex != -1 ? fullPath.substring(0, slashIndex + 1) : "";
        }

        private void downloadFiles() throws RemoteFSException, IOException, OperationAbortedException {
            RemoteFile rf;
            File curDir = DownloadWorkers.this.destDir;
            while ((rf = DownloadWorkers.this.downloadQueue.poll()) != null) {
                String path = rf.getFullPath();
                String parentPath = this.getParentPath(rf);
                if (!this.currentPath.equals(parentPath)) {
                    curDir = new File(DownloadWorkers.this.destDir, parentPath);
                    curDir.mkdirs();
                    this.currentPath = parentPath;
                }
                File f = new File(DownloadWorkers.this.destDir, path);
                DownloadWorkers.this.progressEvent.update(f.getParentFile().getName(), f.getName(), DownloadWorkers.this.uploadBean.processedBytes.get() + DownloadWorkers.this.getBytesInProgress());
                DownloadWorkers.this.uploadBean.fireFileProcessingStarted(DownloadWorkers.this.progressEvent);
                if (DownloadWorkers.this.progressEvent.isAborted()) {
                    throw new OperationAbortedException();
                }
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(f));){
                    this.channel.get(IO.combinePaths(DownloadWorkers.this.remotePath, path), os);
                }
                this.currentFileByteProgress = 0L;
                DownloadWorkers.this.uploadBean.processedBytes.addAndGet(rf.size());
                DownloadWorkers.this.uploadBean.fireFileProcessingFinished(DownloadWorkers.this.progressEvent);
                if (!DownloadWorkers.this.progressEvent.isAborted()) continue;
                throw new OperationAbortedException();
            }
        }

        private void prepareConnection() throws RemoteFSException, IOException {
            this.channel = RemoteFSBean.createInstance();
            this.channel.setProgressMonitor(this);
            this.connect();
        }

        private void connect() throws RemoteFSException, IOException {
            UploadBean ub = DownloadWorkers.this.uploadBean;
            this.channel.setProtocol(ub.getProtocol());
            this.channel.setForceUTF8(ub.isFtpForceUTF8());
            this.channel.setPassiveMode(ub.isPassiveMode());
            this.channel.setPort(ub.getFtpPort());
            this.channel.setTrackDiskSpaceUsage(ub.isMyjalbum());
            this.channel.connect(ub.getFtpServer(), ub.getFtpUser(), ub.getFtpPassword());
        }
    }
}

