/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import se.datadosen.component.DirectoryChooser;
import se.datadosen.component.FileChooser;

public class DeferredChooser
implements FileChooser,
DirectoryChooser {
    private Class chooserClass;
    private JFileChooser chooser;
    private int fileSelectionMode = -1;
    private String title;
    private File selectedFile;
    private File currentDirectory;
    private FileFilter fileFilter;
    private LinkedList listenerList = new LinkedList();

    public DeferredChooser(Class chooserClass) {
        this.chooserClass = chooserClass;
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (this.chooser == null) {
            this.listenerList.add(l);
        } else {
            this.chooser.addActionListener(l);
        }
    }

    @Override
    public void setDialogTitle(String title) {
        if (this.chooser == null) {
            this.title = title;
        } else {
            this.chooser.setDialogTitle(title);
        }
    }

    @Override
    public void setSelectedFile(File file) {
        if (this.chooser == null) {
            this.selectedFile = file;
        } else {
            this.chooser.setSelectedFile(file);
        }
    }

    @Override
    public File getSelectedFile() {
        if (this.chooser == null) {
            return this.selectedFile;
        }
        return this.chooser.getSelectedFile();
    }

    @Override
    public void setFileSelectionMode(int mode) {
        if (this.chooser == null) {
            this.fileSelectionMode = mode;
        } else {
            this.chooser.setFileSelectionMode(mode);
        }
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        if (this.chooser == null) {
            this.fileFilter = filter;
        } else {
            this.chooser.setFileFilter(filter);
        }
    }

    @Override
    public void setCurrentDirectory(File dir) {
        if (this.chooser == null) {
            this.currentDirectory = dir;
        } else {
            this.chooser.setCurrentDirectory(dir);
        }
    }

    @Override
    public File getCurrentDirectory() {
        if (this.chooser == null) {
            return this.currentDirectory;
        }
        return this.chooser.getCurrentDirectory();
    }

    @Override
    public int showOpenDialog(Component parent) {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.chooser.showOpenDialog(parent);
    }

    @Override
    public int showSaveDialog(Component parent) {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.chooser.showSaveDialog(parent);
    }

    private void instantiate() {
        try {
            this.chooser = (JFileChooser)this.chooserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Iterator it = this.listenerList.iterator();
            while (it.hasNext()) {
                this.chooser.addActionListener((ActionListener)it.next());
            }
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            if (this.fileSelectionMode != -1) {
                this.chooser.setFileSelectionMode(this.fileSelectionMode);
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            }
            if (this.selectedFile != null) {
                this.chooser.setSelectedFile(this.selectedFile);
            }
            if (this.title != null) {
                this.chooser.setDialogTitle(this.title);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void setDialogType(int dialogType) {
        if (this.chooser == null) {
            this.instantiate();
        }
        this.chooser.setDialogType(dialogType);
    }

    @Override
    public void setMultiSelectionEnabled(boolean b) {
        if (this.chooser == null) {
            this.instantiate();
        }
        this.chooser.setMultiSelectionEnabled(b);
    }

    @Override
    public void setFileView(FileView fileView) {
        if (this.chooser == null) {
            this.instantiate();
        }
        this.chooser.setFileView(fileView);
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.showOpenDialog(parent);
    }

    @Override
    public File[] getSelectedFiles() {
        if (this.chooser == null) {
            this.instantiate();
        }
        return this.chooser.getSelectedFiles();
    }
}

