/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.text.DecimalFormat;
import java.util.LinkedList;

public class DataRate {
    private String kiloUnit = "KB";
    private String megaUnit = "MB";
    private DecimalFormat twoDec = new DecimalFormat("0.00");
    private Sample initial;
    private LinkedList<Sample> buffer = new LinkedList();
    private int bufSizeSecs = 6;
    double lastValue;
    long timeThreshold;

    public DataRate() {
    }

    public DataRate(int bufSizeSecs) {
        this.bufSizeSecs = bufSizeSecs;
    }

    public DataRate(String kiloUnit, String MegaUnit) {
        this.kiloUnit = kiloUnit;
        this.megaUnit = this.megaUnit;
    }

    private int getBufferSpanSecs() {
        if (this.buffer.size() < 2) {
            return 0;
        }
        return (int)((this.buffer.getLast().time - this.buffer.getFirst().time) / 1000000000L);
    }

    public synchronized void update(long value) {
        Sample sample = new Sample(value);
        if (this.initial == null) {
            this.initial = sample;
        }
        if (!this.buffer.isEmpty() && value < this.buffer.getFirst().value) {
            this.buffer.clear();
        }
        this.buffer.add(sample);
        Sample old = this.buffer.getFirst();
        while (old.time < sample.time - (long)this.bufSizeSecs * 1000000000L && this.buffer.size() > 2) {
            this.buffer.removeFirst();
            old = this.buffer.getFirst();
        }
    }

    public synchronized double current() {
        long now = System.nanoTime();
        if (now - this.timeThreshold > 1000000000L) {
            this.lastValue = this.doGetCurrent();
            this.timeThreshold = now;
        }
        return this.lastValue;
    }

    private double doGetCurrent() {
        if (this.buffer.size() > 1) {
            Sample first = this.buffer.getFirst();
            Sample last = this.buffer.getLast();
            return (double)(last.value - first.value) / (double)(last.time - first.time) * 1.0E9;
        }
        return 0.0;
    }

    public String toString() {
        double rate = this.current();
        if (rate > 1048576.0) {
            return this.formatAsMega(rate) + " " + this.megaUnit + "/s";
        }
        return this.formatAsKilo(rate) + " " + this.kiloUnit + "/s";
    }

    public String estTimeLeft(long bytesLeft) {
        if (this.getBufferSpanSecs() >= 3) {
            return DataRate.timerFormat((int)((double)bytesLeft / this.current()));
        }
        return "";
    }

    protected String formatAsMega(double value) {
        return this.twoDec.format(value / 1024.0 / 1024.0);
    }

    protected String formatAsKilo(double value) {
        return this.twoDec.format(value / 1024.0);
    }

    private static String twoDigits(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    public static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return hours + ":" + DataRate.twoDigits(minutes) + ":" + DataRate.twoDigits(seconds);
    }

    private static class Sample {
        long time = System.nanoTime();
        long value;

        public Sample(long value) {
            this.value = value;
        }
    }
}

