/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.ScriptEnginePool;
import se.datadosen.util.Scope;
import se.datadosen.util.SmartResourceBundle;

public class CompiledBase {
    public final String generator;
    public final String generatorUrl;
    public final String internalVersion;
    public final String styleFile;
    public final String skin;
    public final String style;
    public final int maxImageWidth;
    public final int maxImageHeight;
    public final int maxThumbWidth;
    public final int maxThumbHeight;
    public final int rows;
    public final int cols;
    public final Map application;
    public final Map album;
    public final AlbumBean engine;
    public final JAlbumFrame window;
    public final JAlbumContext context;
    public final LicenseManager licenseManager;
    public final File programDirectory;
    public final File skinDirectory;
    public final File resDirectory;
    public final File skinResDirectory;
    public final File rootImageDirectory;
    public final File rootOutputDirectory;
    public final String currentDate;
    public final int totalAlbumImages;
    public final String textEncoding;
    public final SmartResourceBundle texts;
    public final AlbumObject rootFolder;
    public final DelegatingPrintWriter out = new DelegatingPrintWriter();
    public final String language = Config.getConfig().getInterpretedLanguage();

    protected CompiledBase(AlbumBean engine) {
        this.engine = engine;
        Scope c = engine.globalVariables;
        this.generator = (String)c.get("generator");
        this.generatorUrl = (String)c.get("generatorUrl");
        this.internalVersion = (String)c.get("internalVersion");
        this.styleFile = (String)c.get("styleFile");
        this.skin = (String)c.get("skin");
        this.style = (String)c.get("style");
        this.maxImageWidth = this.getInt((Integer)c.get("maxImageWidth"));
        this.maxImageHeight = this.getInt((Integer)c.get("maxImageHeight"));
        this.maxThumbWidth = this.getInt((Integer)c.get("maxThumbWidth"));
        this.maxThumbHeight = this.getInt((Integer)c.get("maxThumbHeight"));
        this.rows = this.getInt((Integer)c.get("rows"));
        this.cols = this.getInt((Integer)c.get("cols"));
        this.window = (JAlbumFrame)c.get("window");
        this.context = (JAlbumContext)c.get("context");
        this.licenseManager = (LicenseManager)c.get("licenseManager");
        this.album = (Map)c.get("album");
        this.application = (Map)c.get("application");
        this.programDirectory = (File)c.get("programDirectory");
        this.skinDirectory = (File)c.get("skinDirectory");
        this.rootImageDirectory = (File)c.get("rootImageDirectory");
        this.rootOutputDirectory = (File)c.get("rootOutputDirectory");
        this.resDirectory = (File)c.get("resDirectory");
        this.skinResDirectory = (File)c.get("skinResDirectory");
        this.currentDate = (String)c.get("currentDate");
        this.totalAlbumImages = this.getInt((Integer)c.get("totalAlbumImages"));
        this.textEncoding = (String)c.get("textEncoding");
        this.texts = (SmartResourceBundle)c.get("texts");
        this.rootFolder = (AlbumObject)c.get("rootFolder");
    }

    public final Object get(String variable) {
        return this.getVariable(variable);
    }

    private Object getVariable(String variable) {
        return ScriptEnginePool.getVar(variable, this.engine.scriptEnginePool.get(this.engine.getScriptLanguage()));
    }

    private int getInt(Integer i) {
        return this.getInt(i, 0);
    }

    private int getInt(Integer i, int def) {
        return i != null ? i : def;
    }

    public class DelegatingPrintWriter {
        public void println(Object x) {
            this.getOut().println(x);
        }

        public void println(String x) {
            this.getOut().println(x);
        }

        public void println(char[] x) {
            this.getOut().println(x);
        }

        public void println(double x) {
            this.getOut().println(x);
        }

        public void println(float x) {
            this.getOut().println(x);
        }

        public void println(long x) {
            this.getOut().println(x);
        }

        public void println(int x) {
            this.getOut().println(x);
        }

        public void println(char x) {
            this.getOut().println(x);
        }

        public void println(boolean x) {
            this.getOut().println(x);
        }

        public void println() {
            this.getOut().println();
        }

        public PrintWriter printf(Locale l, String format, Object ... args) {
            return this.getOut().printf(l, format, args);
        }

        public PrintWriter printf(String format, Object ... args) {
            return this.getOut().printf(format, args);
        }

        public void print(Object obj) {
            this.getOut().print(obj);
        }

        public void print(String s) {
            this.getOut().print(s);
        }

        public void print(char[] s) {
            this.getOut().print(s);
        }

        public void print(double d) {
            this.getOut().print(d);
        }

        public void print(float f) {
            this.getOut().print(f);
        }

        public void print(long l) {
            this.getOut().print(l);
        }

        public void print(int i) {
            this.getOut().print(i);
        }

        public void print(char c) {
            this.getOut().print(c);
        }

        public void print(boolean b) {
            this.getOut().print(b);
        }

        private PrintWriter getOut() {
            return (PrintWriter)CompiledBase.this.get("out");
        }
    }
}

