/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import se.datadosen.jalbum.AbstractAlbumObjectFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.util.IO;

public class CategoryFilter
extends AbstractAlbumObjectFilter {
    protected Set<Category> includes = new HashSet<Category>();
    protected Set<Category> excludes = new HashSet<Category>();
    protected Set<String> includeTypes = new HashSet<String>();
    protected Set<String> excludeTypes = new HashSet<String>();

    public CategoryFilter() {
    }

    public CategoryFilter(CategoryFilter original) {
        this.includes = new HashSet<Category>(original.includes);
        this.excludes = new HashSet<Category>(original.excludes);
        this.includeTypes = new HashSet<String>(original.includeTypes);
        this.excludeTypes = new HashSet<String>(original.excludeTypes);
    }

    public CategoryFilter(AbstractAlbumObjectFilter next) {
        super(next);
    }

    public CategoryFilter include(Category ... cats) {
        this.includes.addAll(Arrays.asList(cats));
        return this;
    }

    public CategoryFilter exclude(Category ... cats) {
        this.excludes.addAll(Arrays.asList(cats));
        return this;
    }

    public CategoryFilter include(String ... types) {
        for (String type : types) {
            this.includeTypes.add(type.toLowerCase());
        }
        return this;
    }

    public CategoryFilter exclude(String ... types) {
        for (String type : types) {
            this.excludeTypes.add(type.toLowerCase());
        }
        return this;
    }

    public CategoryFilter dirs() {
        return this.include(Category.folder);
    }

    public CategoryFilter nodirs() {
        return this.exclude(Category.folder);
    }

    public CategoryFilter thumbnails() {
        return this.exclude(Category.folder, Category.webPage, Category.webLocation);
    }

    public CategoryFilter reset() {
        this.includes = new HashSet<Category>();
        this.excludes = new HashSet<Category>();
        this.includeTypes = new HashSet<String>();
        this.excludeTypes = new HashSet<String>();
        return this;
    }

    @Override
    public boolean doTest(AlbumObject ao) {
        String ext = IO.extensionOf(ao.getFile()).toLowerCase();
        Category cat = ao.getCategory();
        Boolean ret = null;
        if (!this.includes.isEmpty()) {
            ret = this.includes.contains((Object)cat);
        }
        if (this.excludes.contains((Object)cat)) {
            ret = false;
        }
        if (!this.includeTypes.isEmpty()) {
            ret = this.includeTypes.contains(ext) || CategoryFilter.isTrue(ret);
        }
        if (this.excludeTypes.contains(ext)) {
            ret = false;
        }
        if (ret != null) {
            return ret;
        }
        return true;
    }

    private static boolean isTrue(Boolean ret) {
        return ret != null && ret != false;
    }
}

