/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Descriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDescriptor;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import java.awt.Dimension;
import java.io.IOException;
import java.text.DecimalFormat;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.util.FileFilters;

public class CameraMetadataPrinter {
    private static DecimalFormat twoDec = new DecimalFormat("0.##");
    private ImageInfoFormatter formatter = new ImageInfoFormatter();

    private static ExifSubIFDDirectory getMainSubIFDDirectory(Metadata meta) {
        for (ExifSubIFDDirectory dir : meta.getDirectoriesOfType(ExifSubIFDDirectory.class)) {
            if (dir.containsTag(254)) continue;
            return dir;
        }
        return null;
    }

    private static Dimension getImageDim(Metadata meta) throws MetadataException {
        for (ExifSubIFDDirectory dir : meta.getDirectoriesOfType(ExifSubIFDDirectory.class)) {
            if (dir.containsTag(40962)) {
                return new Dimension(dir.getInt(40962), dir.getInt(40963));
            }
            if (!dir.containsTag(256)) continue;
            return new Dimension(dir.getInt(256), dir.getInt(257));
        }
        return null;
    }

    public String printMetadata(AlbumObject ao, String delim) {
        if (ao == null) {
            return "";
        }
        FileFilters.BasicImageInfo ii = null;
        try {
            ii = ao.getImageInfo();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Metadata meta = ao.getMetadata().getMetadata();
        this.formatter.setMetadata(meta);
        StringBuilder buf = new StringBuilder();
        buf.append(ao.getName());
        buf.append(delim);
        buf.append(Config.getConfig().getDateFormatter().format(ao.getMetadata().getCameraDate()) + delim);
        buf.append("(").append(ii.width).append(" x ").append(ii.height).append(") - ").append(twoDec.format((float)ao.getFile().length() / 1024.0f / 1024.0f)).append(" MB").append(delim);
        ExifIFD0Directory ifd0Dir = null;
        if (meta != null) {
            if (meta.containsDirectoryOfType(ExifIFD0Directory.class) && !(ifd0Dir = (ExifIFD0Directory)meta.getFirstDirectoryOfType(ExifIFD0Directory.class)).containsTag(272)) {
                return buf.toString();
            }
            ExifSubIFDDirectory dir = CameraMetadataPrinter.getMainSubIFDDirectory(meta);
            if (dir != null) {
                ExifSubIFDDescriptor desc = new ExifSubIFDDescriptor(dir);
                ExifIFD0Descriptor ifd0Desc = new ExifIFD0Descriptor(ifd0Dir);
                try {
                    buf.append(ifd0Desc.getDescription(271)).append(" - ").append(ifd0Desc.getDescription(272)).append(delim);
                    Directory nikon = null;
                    if (meta.containsDirectoryOfType(NikonType2MakernoteDirectory.class)) {
                        nikon = meta.getFirstDirectoryOfType(NikonType2MakernoteDirectory.class);
                    }
                    if (nikon != null) {
                        buf.append(nikon.getDescription(132)).append(delim);
                    }
                    buf.append(desc.getFocalLengthDescription());
                    String focalLength35mm = this.formatter.format35mmEq(ifd0Dir, dir);
                    if (focalLength35mm != null) {
                        buf.append(" (\u223c").append(focalLength35mm).append(")");
                    }
                    buf.append(delim);
                    buf.append(CameraMetadataPrinter.optional(desc.getExposureModeDescription())).append(" (ISO ").append(desc.getIsoEquivalentDescription()).append(")").append(CameraMetadataPrinter.optional(desc.getExposureBiasDescription(), " - ")).append(delim);
                    buf.append(desc.getExposureTimeDescription()).append(" - ").append(desc.getFNumberDescription()).append(delim);
                    buf.append(dir.getDescription(41987));
                    if (nikon != null) {
                        buf.append(" (").append(nikon.getDescription(5).strip()).append(")");
                    }
                }
                catch (MetadataException ex) {
                    System.err.println((Object)ex);
                    return "Error extracting metadata";
                }
            }
        }
        return buf.toString();
    }

    private static String optional(String s) {
        return s == null ? "" : s;
    }

    private static String optional(String s, String delim) {
        return s == null ? "" : delim + s;
    }
}

