/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.util.Duration;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.util.IO;
import se.datadosen.util.MediaUtil;

public class Attachments {
    private static HashMap<String, String> audioMimeTypeMap = new HashMap();
    private static final String AUDIO_CLIPS_FOLDER = "audioClips";
    public static final String ATTACHMENTS_FOLDER = "attachments";
    private AlbumObject ao;
    private File parentDir;
    private File attDir;

    Attachments(AlbumObject ao) {
        this.ao = ao;
        this.attDir = Attachments.getAttachmentsDir(ao.getFile());
        this.parentDir = this.attDir.getParentFile();
    }

    public static File getAttachmentsDir(File f) {
        File parent = new File(AlbumObjectImpl.getJalbumFolder(f), ATTACHMENTS_FOLDER);
        return new File(parent, f.getName());
    }

    void delete() {
        IO.deleteDir(this.attDir);
        this.cleanupDirs();
    }

    void renameTo(File renamedFile) {
        File newParentDir = new File(AlbumObjectImpl.getJalbumFolder(renamedFile), ATTACHMENTS_FOLDER);
        File newAttDir = new File(newParentDir, renamedFile.getName());
        if (this.attDir.exists()) {
            newParentDir.mkdirs();
            this.attDir.renameTo(newAttDir);
        }
        this.cleanupDirs();
        this.parentDir = newParentDir;
        this.attDir = newAttDir;
    }

    private void cleanupDirs() {
        IO.deleteIfEmpty(this.attDir);
        IO.deleteIfEmpty(this.parentDir);
    }

    public boolean isPresent(Type type) {
        return this.ao.getProperties().get(type.keyName) != null;
    }

    public File get(Type type) {
        String path = (String)this.ao.getProperties().get(type.keyName);
        File f = null;
        if (path != null) {
            f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(this.attDir, path);
            }
            return f;
        }
        return null;
    }

    public void set(File file, Type type) {
        AlbumObject oldRep = null;
        if (type == Type.IMAGE) {
            oldRep = this.ao.getRepresentingAlbumObject();
        }
        AlbumObjectProperties props = this.ao.getProperties();
        AlbumSynchronizer albumSynchronizer = new AlbumSynchronizer(this.ao.getEngine());
        File translated = albumSynchronizer.translate(this.ao);
        if (type == Type.AUDIO) {
            File destFile = albumSynchronizer.getAudioClipFile(this.ao, translated);
            if (destFile != null) {
                destFile.delete();
            }
            props.remove("audioClipDuration");
            props.remove("audioClipType");
        } else if (type == Type.IMAGE) {
            albumSynchronizer.getAttachedThumb(this.ao, translated).delete();
            albumSynchronizer.getAttachedCloseup(this.ao, translated).delete();
        }
        File oldFile = this.get(type);
        if (oldFile != null && oldFile.getParentFile().equals(this.attDir)) {
            oldFile.delete();
        }
        props.remove(type.keyName);
        if (file != null) {
            String path = file.getParentFile().equals(this.attDir) ? file.getName() : file.getAbsolutePath();
            props.put(type.keyName, path);
            if (type == Type.AUDIO) {
                String ext = IO.extensionOf(path).toLowerCase();
                String mimeType = audioMimeTypeMap.getOrDefault(ext, "audio/" + ext);
                props.put("audioClipType", mimeType);
                try {
                    Media media = MediaUtil.loadMedia(file);
                    Duration d = media.getDuration();
                    if (d != Duration.UNKNOWN) {
                        props.put("audioClipDuration", new TimeCode(d.toMillis()));
                    }
                }
                catch (IOException | MediaException ex) {
                    System.err.println("Couldn't read duration for file " + String.valueOf(file) + ": " + ex.getMessage());
                }
            }
        } else {
            this.cleanupDirs();
        }
        props.save(false);
        if (type == Type.IMAGE) {
            ((AlbumObjectImpl)this.ao).setRep(null);
            ((AlbumObjectImpl)this.ao).updateRepresentingIcon();
            ((AlbumObjectImpl)this.ao).firePropertyChange("representingAlbumObject", oldRep, null);
        }
    }

    public File getAttachmentsDir() {
        return this.attDir;
    }

    public File getAttachmentsDir(boolean create) {
        if (create) {
            this.attDir.mkdirs();
        }
        return this.attDir;
    }

    private void importAudioClips() {
        AlbumObjectProperties props = this.ao.getProperties();
        if (!props.containsKey("attachmentsVersion")) {
            String path = (String)this.ao.getProperties().get("audioClipPath");
            if (path != null) {
                File clipsFolder = new File(AlbumObjectImpl.getJalbumFolder(this.ao.getFile()), AUDIO_CLIPS_FOLDER);
                File clipFile = new File(path);
                if (!clipFile.isAbsolute() && (clipFile = new File(clipsFolder, clipFile.getName())).exists()) {
                    this.attDir.mkdirs();
                    clipFile.renameTo(new File(this.attDir, clipFile.getName()));
                    System.out.println("Imported audio clip for " + String.valueOf(this.ao));
                    IO.deleteIfEmpty(clipsFolder);
                }
            }
            props.put("attachmentsVersion", "1.0");
            props.save();
        }
    }

    static {
        audioMimeTypeMap.put("mp3", "audio/mpeg");
        audioMimeTypeMap.put("m4a", "audio/mp4");
    }

    public static enum Type {
        AUDIO("audioClipPath"),
        IMAGE("imageAttachmentPath");

        private String keyName;

        private Type(String keyName) {
            this.keyName = keyName;
        }
    }
}

