/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import se.datadosen.io.CachedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.jalbum.Targets;
import se.datadosen.util.IO;

public class AlbumSynchronizer {
    protected AlbumBean engine;
    public static boolean debugMode = false;

    public AlbumSynchronizer(AlbumBean engine) {
        this.engine = engine;
    }

    public File translate(AlbumObject ao) {
        File rootOutputDirectory = this.engine.getOutputDir();
        return new File(rootOutputDirectory, ao.getPathFromRoot());
    }

    public void moveTo(AlbumObject ao, File from, File to) {
        File rootOutputDir;
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        if (!rootImageDir.equals(rootOutputDir = this.engine.getOutputDir())) {
            AlbumSynchronizer.moveFile(from, to);
        }
        if (ao.getCategory() == Category.video) {
            AlbumSynchronizer.moveFile(this.getVideoFile(from), this.getVideoFile(to));
        }
        if (ao.getCategory() == Category.webPage) {
            AlbumSynchronizer.moveFile(this.getWebPage(from), this.getWebPage(to));
        } else if (!from.isDirectory()) {
            File newFile;
            String newName;
            AlbumSynchronizer.moveFile(this.getThumbnailFile(from), this.getThumbnailFile(to));
            AlbumSynchronizer.moveFile(this.getCloseupFile(from), this.getCloseupFile(to));
            AlbumSynchronizer.moveFile(this.getCloseupPage(from), this.getCloseupPage(to));
            for (File f : ImageRenderer.listVariantsFor(this.getThumbnailFile(from))) {
                newName = IO.baseName(to) + ImageRenderer.nameSuffix(f.getName());
                newFile = new File(this.getThumbnailFile(to).getParentFile(), newName);
                AlbumSynchronizer.moveFile(f, newFile);
            }
            for (File f : ImageRenderer.listVariantsFor(this.getCloseupFile(from))) {
                newName = IO.baseName(to) + ImageRenderer.nameSuffix(f.getName());
                newFile = new File(this.getCloseupFile(to).getParentFile(), newName);
                AlbumSynchronizer.moveFile(f, newFile);
            }
            if (ao.getAttachments().isPresent(Attachments.Type.AUDIO)) {
                AlbumSynchronizer.moveFile(this.getAudioClipFile(ao, from), this.getAudioClipFile(ao, to));
            }
        }
    }

    public void delete(AlbumObject ao) {
        File file = this.translate(ao);
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        File rootOutputDir = this.engine.getOutputDir();
        if (ao.getCategory() == Category.webPage) {
            this.getWebPage(file).delete();
        } else {
            if (!file.isDirectory() && !rootImageDir.equals(rootOutputDir)) {
                AlbumSynchronizer.deleteFile(file);
                if (ao.getCategory() == Category.video) {
                    AlbumSynchronizer.deleteFile(this.getVideoFile(file));
                }
            }
            AlbumSynchronizer.deleteFile(this.getThumbnailFile(file));
            for (File f : ImageRenderer.listVariantsFor(this.getThumbnailFile(file))) {
                AlbumSynchronizer.deleteFile(f);
            }
            AlbumSynchronizer.deleteFile(this.getCloseupFile(file));
            for (File f : ImageRenderer.listVariantsFor(this.getCloseupFile(file))) {
                AlbumSynchronizer.deleteFile(f);
            }
            AlbumSynchronizer.deleteFile(this.getCloseupPage(file));
            AlbumSynchronizer.deleteFile(this.getAudioClipFile(ao, file));
        }
        if (file.isDirectory() && !rootImageDir.equals(rootOutputDir)) {
            AlbumSynchronizer.deleteDirRecursively(file);
            AlbumSynchronizer.log("Deleted directory " + String.valueOf(file));
        }
    }

    @Deprecated
    public void delete(File file) {
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        File rootOutputDir = this.engine.getOutputDir();
        if (file.isDirectory()) {
            if (!rootImageDir.equals(rootOutputDir)) {
                AlbumSynchronizer.deleteDirRecursively(file);
                AlbumSynchronizer.log("Deleted directory " + String.valueOf(file));
            }
        } else {
            if (!rootImageDir.equals(rootOutputDir)) {
                AlbumSynchronizer.deleteFile(file);
                AlbumSynchronizer.deleteFile(this.getVideoFile(file));
            }
            AlbumSynchronizer.deleteFile(this.getThumbnailFile(file));
            for (File f : ImageRenderer.listVariantsFor(this.getThumbnailFile(file))) {
                AlbumSynchronizer.deleteFile(f);
            }
            AlbumSynchronizer.deleteFile(this.getCloseupFile(file));
            for (File f : ImageRenderer.listVariantsFor(this.getCloseupFile(file))) {
                AlbumSynchronizer.deleteFile(f);
            }
            AlbumSynchronizer.deleteFile(this.getCloseupPage(file));
        }
    }

    public void deleteOriginal(AlbumObject ao) {
        File rootOutputDir;
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        if (!rootImageDir.equals(rootOutputDir = this.engine.getOutputDir())) {
            AlbumSynchronizer.deleteFile(this.translate(ao));
        }
    }

    private static void deleteDirRecursively(File dir) {
        for (CachedFile f : CachedFile.listFiles(dir)) {
            if (((File)f).isDirectory()) {
                AlbumSynchronizer.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private static void deleteFile(File f) {
        if (f != null && f.delete()) {
            AlbumSynchronizer.log("Deleted " + String.valueOf(f));
        }
    }

    private static void moveFile(File from, File to) {
        to.getParentFile().mkdirs();
        if (from.renameTo(to)) {
            AlbumSynchronizer.log("Moved " + String.valueOf(from) + " to " + String.valueOf(to));
        }
    }

    private File getVideoFile(File translatedFile) {
        return this.engine.getVideoProcessor().getOutputVideoFile(translatedFile, translatedFile.getParentFile());
    }

    private File getThumbnailFile(File translatedFile) {
        File thumbDir = new File(translatedFile.getParentFile(), this.engine.getThumbnailDirectory());
        return new File(thumbDir, this.engine.getTargetThumbName(translatedFile));
    }

    private File getCloseupFile(File translatedFile) {
        File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
        return new File(slidesDir, this.engine.getTargetName(translatedFile));
    }

    private File getCloseupPage(File translatedFile) {
        File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
        return new File(slidesDir, IO.baseName(translatedFile.getName()) + this.engine.getPageExtension());
    }

    private File getWebPage(File translatedFile) {
        return new File(translatedFile.getParentFile(), IO.baseName(translatedFile.getName()) + this.engine.getPageExtension());
    }

    public File getAudioClipFile(AlbumObject ao, File translatedFile) {
        return this.getAudioClipFile(ao.getAttachments().get(Attachments.Type.AUDIO), translatedFile);
    }

    private File getAudioClipFile(File audioClip, File translatedFile) {
        if (audioClip != null) {
            File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
            return new File(slidesDir, audioClip.getName());
        }
        return null;
    }

    public File getAttachedThumb(AlbumObject ao, File translatedFile) {
        File thumbsDir = new File(translatedFile.getParentFile(), this.engine.getThumbnailDirectory());
        return new File(thumbsDir, Targets.of((AlbumObject)ao).thumb);
    }

    public File getAttachedCloseup(AlbumObject ao, File translatedFile) {
        File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
        return new File(slidesDir, Targets.of((AlbumObject)ao).closeup);
    }

    private static void log(String s) {
        if (debugMode) {
            System.out.println(s);
        }
    }
}

