/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.BiConsumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.jalbum.undo.UndoHandler;
import se.datadosen.component.RetinaIcon;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.RecentProjectFiles;
import se.datadosen.util.IO;

public class AlbumProject
implements Transferable {
    public static final String PROJECT_EXTENSION = ".jap";
    public static final String PROJECT_FILE_NAME = "jalbum-settings.jap";
    static final File defaultProjectFile = Config.getConfigFile("defaults.jap", ".jalbum-defaults.jap");
    public static final DataFlavor ALBUM_PROJECT_FLAVOR = new DataFlavor(AlbumProject.class, "Album Project");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{ALBUM_PROJECT_FLAVOR};
    static final Dimension iconSize = new Dimension(28, 28);
    private File projectFile;
    private boolean hintsIncluded;
    private Properties props;
    private long lastRead;
    private AlbumObject root;
    private int addedCount;
    private final IntegerProperty workersProperty = new SimpleIntegerProperty(0);
    public final BooleanProperty workingProperty = new SimpleBooleanProperty();
    public final BooleanProperty newObjectsProperty = new SimpleBooleanProperty(false);
    public final ObjectProperty<Throwable> lastExceptionProperty = new SimpleObjectProperty();
    public static final ImageIcon newAlbumProjectIcon = Icons.getIcon("big.newAlbumProject");
    Icon icon;
    AlbumObjectProperties cachedProperties;
    private static int addedCounter = 0;

    public static List<AlbumProject> getRecentProjects() {
        ArrayList<AlbumProject> projects = new ArrayList<AlbumProject>();
        AlbumObjectFactory factory = new AlbumObjectFactory(new AlbumBean());
        factory.setUndoNotifier(UndoHandler.getInstance());
        for (File f : RecentProjectFiles.getInstance().getFiles()) {
            try {
                projects.add(new AlbumProject(f, factory));
            }
            catch (IOException ex) {
                if (!Config.getConfig().isDebugMode()) continue;
                System.err.println("Can't list project " + String.valueOf(f));
            }
        }
        return projects;
    }

    public AlbumProject(File projectFile) throws IOException {
        this(projectFile, JAlbumContext.getInstance().getAlbumObjectfactory());
    }

    public AlbumProject(File projectFile, AlbumObjectFactory factory) throws IOException {
        File f;
        if (projectFile.isDirectory() && (f = new File(projectFile, PROJECT_FILE_NAME)).exists()) {
            projectFile = f;
        }
        this.projectFile = projectFile;
        this.workingProperty.bind((ObservableValue)this.workersProperty.greaterThan(0));
        String directory = this.getProperties(false).getProperty("directory");
        if (directory == null) {
            throw new IOException("Project file " + String.valueOf(projectFile) + " doesn't point to a valid jAlbum project");
        }
        File imageDir = new File(directory);
        if (!imageDir.exists()) {
            imageDir = projectFile.getParentFile();
        }
        this.root = factory.createInstance(imageDir);
        this.addedCount = addedCounter++;
    }

    public AlbumProject(File projectFile, AlbumObject root) {
        if (projectFile == null) {
            projectFile = defaultProjectFile;
        }
        this.projectFile = projectFile;
        this.workingProperty.bind((ObservableValue)this.workersProperty.greaterThan(0));
        this.root = projectFile != null ? root : null;
    }

    public Properties getProperties() throws IOException {
        return this.getProperties(true);
    }

    public Properties getProperties(boolean includeHints) throws IOException {
        if (this.props == null || this.projectFile.lastModified() > this.lastRead || includeHints && !this.hintsIncluded) {
            this.props = JAlbumUtilities.importProject(this.projectFile, includeHints);
            this.lastRead = System.currentTimeMillis();
            if (includeHints) {
                this.hintsIncluded = true;
            }
        }
        return this.props;
    }

    public AlbumObject getRootFolder() {
        return this.root;
    }

    private Icon getRetinaIcon(AlbumObject ao, Dimension pointBounds) throws IOException {
        Dimension bounds = new Dimension(pointBounds.width * 2, pointBounds.height * 2);
        ImageIcon icon = ao.getRepresentingIcon(bounds, true, false);
        return new RetinaIcon(icon.getImage());
    }

    public void invalidateIcon() {
        this.icon = null;
    }

    public void forIcon(BiConsumer<Icon, Boolean> consumer) {
        if (this.icon != null) {
            consumer.accept(this.icon, true);
        } else {
            consumer.accept(newAlbumProjectIcon, true);
            AlbumObject.iconLoaderPool.submit(() -> {
                if (this.icon == null) {
                    this.icon = this.loadIcon();
                }
                if (this.icon != null) {
                    SwingUtilities.invokeLater(() -> consumer.accept(this.icon, false));
                }
            });
        }
    }

    private Icon loadIcon() {
        AlbumObject ao;
        if (this.icon == null && (ao = this.getRootFolder()) != null) {
            AlbumObjectProperties props;
            this.cachedProperties = props = ao.getProperties();
            AlbumObject rep = ao.getRepresentingAlbumObject(true);
            if (rep != null) {
                try {
                    this.icon = this.getRetinaIcon(rep, iconSize);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.icon;
    }

    public void forRootProperties(BiConsumer<AlbumObjectProperties, Boolean> consumer) {
        if (this.root != null) {
            if (((AlbumObjectImpl)this.root).peekProperties() != null) {
                consumer.accept(this.root.getProperties(), true);
            } else {
                AlbumObject.iconLoaderPool.submit(() -> {
                    AlbumObjectProperties rootProps = this.root.getProperties();
                    SwingUtilities.invokeLater(() -> consumer.accept(rootProps, false));
                });
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlbumProject other = (AlbumProject)obj;
        return this.projectFile == other.projectFile || this.projectFile != null && this.projectFile.equals(other.projectFile);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this.projectFile != null ? this.projectFile.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return AlbumProject.getName(this.projectFile);
    }

    public static String getName(File projectFile) {
        if (projectFile == null) {
            return Msg.get("newproject.defaultName");
        }
        if (!projectFile.getName().equals(PROJECT_FILE_NAME)) {
            return IO.baseName(projectFile);
        }
        File parent = projectFile.getParentFile();
        if (parent == null) {
            try {
                parent = projectFile.getCanonicalFile().getParentFile();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return parent.getName();
    }

    public int getAddedCount() {
        return this.addedCount;
    }

    public long getLastModified() {
        long last = 0L;
        last = Math.max(last, this.getProjectFile().lastModified());
        return last;
    }

    public String getLongName() {
        if (this.projectFile == null) {
            return Msg.get("newproject.defaultName");
        }
        File parent = this.projectFile.getParentFile();
        Object longName = "";
        Object projectFileName = "";
        if (!this.projectFile.getName().equals(PROJECT_FILE_NAME)) {
            projectFileName = File.separatorChar + this.projectFile.getName();
        }
        longName = parent.getParentFile() == null ? (String)longName + parent.getName() + (String)projectFileName : (String)longName + parent.getParentFile().getName() + File.separatorChar + parent.getName() + (String)projectFileName;
        return longName;
    }

    public File getProjectFile() {
        return this.projectFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setRootFolder(AlbumObject root) {
        this.root = root;
    }

    public File getIndexFile() throws IOException {
        this.getProperties();
        String outputDirectory = this.props.getProperty("outputDirectory");
        if (outputDirectory == null) {
            return null;
        }
        File dir = new File(outputDirectory);
        if (!dir.isAbsolute()) {
            dir = new File(this.root.getFile(), outputDirectory);
        }
        return new File(dir, (String)this.props.getOrDefault((Object)"indexPageName", "index") + String.valueOf(this.props.getOrDefault((Object)"pageExtension", ".index.html")));
    }

    public String toString() {
        return "Project {" + this.projectFile.getAbsolutePath() + "}";
    }

    public synchronized void workStarted() {
        this.workersProperty.set(this.workersProperty.get() + 1);
    }

    public synchronized void workDone() {
        if (this.workersProperty.get() > 0) {
            this.workersProperty.set(this.workersProperty.get() - 1);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(FLAVORS).contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(ALBUM_PROJECT_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

