/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import net.jalbum.util.Profiler;
import org.netbeans.editor.WeakPropertyChangeSupport;
import se.datadosen.io.RenamedFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.io.VirtualDirectory;
import se.datadosen.util.Debug;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.MapBinder;

public class AlbumObjectProperties {
    public static final String TITLE = "title";
    public static final String TAGS = "tags";
    public static final String RATING = "rating";
    public static final String FLAG = "flag";
    public static final String KEYWORDS = "keywords";
    public static final String FILTER_LIST = "filterList";
    public static final String INCLUDE_ORIGINAL = "includeOriginal";
    public static final String USE_ORIGINAL = "useOriginal";
    public static final String HIDDEN = "hidden";
    public static final String ORIGINAL_PATH = "originalPath";
    public static final String ORIGINAL_HASH = "originalHash";
    public static final String IMAGE_SETTINGS_HASH = "imageSettingsHash";
    public static final String VIDEO_SETTINGS_HASH = "videoSettingsHash";
    public static final String FOLDER_THUMB_SETTINGS_HASH = "folderThumbSettingsHash";
    public static final String SETTINGS_HASH = "settingsHash";
    public static final String PROJECT_SETTINGS = "projectSettings";
    public static final String CREATED_DATE = "createdDate";
    public static final String LAST_MADE_DATE = "lastMadeDate";
    public static final String FIRST_PUBLISHED_DATE = "firstPublishedDate";
    public static final String LAST_PUBLISHED_DATE = "lastPublishedDate";
    public static final String LAST_BACKUP_DATE = "lastBackupDate";
    public static final String REMOTE_PATH = "remotePath";
    public static final String ACCOUNT_PROFILE_NAME = "accountProfileName";
    public static final String ALBUM_URL = "albumURL";
    public static final String WIDGETS = "widgets";
    public static final String WIDGETS_LOCAL_CHANGE = "widgetsLocalChange";
    public static final String ALBUM_ID = "albumId";
    public static final String ORIENTATION = "orientation";
    public static final String VIDEO_DURATION = "videoDuration";
    public static final String VIDEO_POSITION = "videoPosition";
    public static final String VIDEO_FPS = "videoFPS";
    public static final String VIDEO_WIDTH = "videoWidth";
    public static final String VIDEO_HEIGHT = "videoHeight";
    public static final String VIDEO_CLIP_START = "videoClipStart";
    public static final String VIDEO_CLIP_LENGTH = "videoClipLength";
    public static final String USES_FFMPEG_VIDEO = "ffmpegVideo";
    public static final String IMAGE_LINKING = "imageLinking";
    public static final String FILE_EXTENSION = ".info";
    public static final String TRANSFORMER = "transformer";
    public static final String LAST_TRANSFORMER = "lastTransformer";
    public static final String INBOX_USER_NAME = "inboxUserName";
    public static final String COLLABORATIVE_FROM = "from";
    public static final String CONTRIBUTORS = "contributors";
    public static final String LAST_FETCHED_DATE = "lastFetchedDate";
    public static final String LAST_OPENED_DATE = "lastOpenedDate";
    public static final String IMAGE_READ_PARAM = "imageReadParam";
    public static final String IMAGE_URI = "imageURI";
    public static final String FIRST_CAMERA_DATE = "firstCameraDate";
    public static final String LAST_CAMERA_DATE = "lastCameraDate";
    public static final String CAMERA_DATES_UPDATED_DATE = "cameraDatesUpdatedDate";
    public static final String THEME_IMAGE_PATH = "themeImagePath";
    public static final String HAS_THEME_IMAGE = "hasThemeImage";
    public static final String USER_VARIABLES = "userVariables";
    public static final String DESCRIPTION = "description";
    public static final String SELECTED = "selected";
    public static final String MONITORED = "monitored";
    public static final String MAKE_ON_CHANGE = "makeOnChange";
    public static final String UPLOAD_ON_CHANGE = "uploadOnChange";
    public static final String AUDIO_CLIP_PATH = "audioClipPath";
    public static final String AUDIO_CLIP_DURATION = "audioClipDuration";
    public static final String AUDIO_CLIP_TYPE = "audioClipType";
    public static final String IMAGE_ATTACHMENT_PATH = "imageAttachmentPath";
    public static final String ATTACHMENTS_VERSION = "attachmentsVersion";
    public static final String VIEW = "view";
    public static final String VIEW_SOURCE = "viewSource";
    public static final String LAST_REP_OBJECT = "lastRepresentingObject";
    public static final String FOLDER_IMAGES = "folderImages";
    private File file;
    private AlbumObject ao;
    private Map<String, Object> props = new HashMap<String, Object>();
    private WeakPropertyChangeSupport changeSupport;
    private String lastSkin;
    private static WeakHashMap<File, AlbumObjectProperties> instances = new WeakHashMap();
    private Map<String, Property> boundProperties = new HashMap<String, Property>();

    private static Map<String, Object> stripDefaults(Map<String, Object> map, Map<String, Object> defaults) {
        HashMap<String, Object> stripped = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Object val = e.getValue();
            if (val != null ? val.equals(defaults.get(e.getKey())) : defaults.containsKey(e.getKey()) && defaults.get(e.getKey()) == null) continue;
            stripped.put(e.getKey(), val);
        }
        return stripped;
    }

    public static AlbumObjectProperties getInstance(AlbumObject ao) {
        return new AlbumObjectProperties(ao);
    }

    private AlbumObjectProperties(AlbumObject ao) {
        this.ao = ao;
        this.init();
    }

    public AlbumObjectProperties(File f) {
        this.file = f;
        this.init();
    }

    public String toString() {
        return this.props.toString();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new WeakPropertyChangeSupport();
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(this, propertyName, oldValue, newValue);
    }

    public void reload() {
        this.init();
    }

    private void ensureClean() {
        String currentSkin = this.ao.getEngine().getSkin();
        if (this.lastSkin != null && !currentSkin.equals(this.lastSkin)) {
            this.load();
            this.lastSkin = currentSkin;
        }
    }

    private void init() {
        if (!this.load() && this.getAOFile().isDirectory()) {
            try {
                Map fp = ((AlbumObjectImpl)this.ao).getFolderProperties();
                Object title = fp.get(TITLE);
                if (title != null) {
                    this.props.put(TITLE, title);
                    this.save(false);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object get(String key) {
        this.ensureClean();
        Object property = this.props.get(key);
        if (property != null && property instanceof HiddenProperty) {
            property = ((HiddenProperty)property).getProperty();
        }
        return property;
    }

    public <T> T get(String key, T def) {
        Object res = this.get(key);
        if (res == null) {
            res = def;
        }
        return (T)res;
    }

    public <T> T computeIfAbsent(String key, Function<? super String, ? extends T> mappingFunction) {
        return (T)this.props.computeIfAbsent(key, (? super K k) -> mappingFunction.apply((String)k));
    }

    public ReadOnlyStringProperty getStringProperty(String name) {
        StringProperty prop = (StringProperty)this.boundProperties.get(name);
        if (prop == null) {
            prop = new SimpleStringProperty();
            prop.setValue((String)this.get(name));
            this.boundProperties.put(name, (Property)prop);
        }
        return prop;
    }

    public ReadOnlyBooleanProperty getBooleanProperty(String name) {
        BooleanProperty prop = (BooleanProperty)this.boundProperties.get(name);
        if (prop == null) {
            prop = new SimpleBooleanProperty();
            prop.setValue((Boolean)this.get(name));
            this.boundProperties.put(name, (Property)prop);
        }
        return prop;
    }

    public Object put(String key, Object value) {
        Object ret = Boolean.FALSE.equals(value) ? this.props.remove(key) : this.props.put(key, value);
        Property prop = this.boundProperties.get(key);
        if (prop != null) {
            prop.setValue(value);
        }
        return ret;
    }

    public Object putHidden(String key, Object value) {
        return this.put(key, new HiddenProperty(value));
    }

    public Object remove(String key) {
        return this.props.remove(key);
    }

    public boolean containsKey(String key) {
        this.ensureClean();
        return this.props.containsKey(key);
    }

    public Set<String> keySet() {
        this.ensureClean();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, Object> e : this.props.entrySet()) {
            if (e.getValue() instanceof HiddenProperty) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    /*
     * Loose catch block
     */
    public boolean save(boolean preserveLastModified) {
        boolean retrying = false;
        while (true) {
            try {
                if (retrying) {
                    Files.setAttribute(this.getFile().toPath(), "dos:hidden", false, new LinkOption[0]);
                }
                this.store(preserveLastModified);
                return true;
            }
            catch (FileNotFoundException ex) {
                if (retrying) {
                    return false;
                }
                retrying = true;
                continue;
            }
            break;
        }
        catch (IOException | UnsupportedOperationException ex) {
            return false;
        }
    }

    public void store(boolean preserveLastModified) throws IOException {
        if (this.ao != null && this.ao.getFile() instanceof VirtualDirectory) {
            return;
        }
        File f = this.getFile();
        f.getParentFile().mkdirs();
        if (this.ao != null && this.ao.getParent() != null) {
            ((AlbumObjectImpl)this.ao.getParent()).markAsClean();
        }
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        AlbumBean engine = this.ao.getEngine();
        engine.setDataTypes(defaults, engine.getSkinProperties().getProperty("slideModel", "SlideModel"));
        Map<String, Object> toSave = AlbumObjectProperties.stripDefaults(this.props, defaults);
        if (toSave.isEmpty()) {
            f.delete();
            this.getAOFile().setLastModified(new Date().getTime());
        } else {
            long lastModified = preserveLastModified ? f.lastModified() : 0L;
            try (XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));){
                e.setExceptionListener(Debug::logErr);
                e.writeObject(toSave);
            }
            if (preserveLastModified && lastModified > 0L) {
                f.setLastModified(lastModified);
            }
        }
        this.firePropertyChange("properties", null, null);
    }

    public void store() throws IOException {
        this.store(true);
    }

    public boolean save() {
        return this.save(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load() {
        block22: {
            File f = this.getFile();
            Profiler.Sample _s2 = Profiler.profile();
            try {
                try (Object d2 = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)), null, e -> {
                    if (JAlbum.logger.isLoggable(Level.FINER)) {
                        System.err.println("Error reading " + f.getAbsolutePath() + ": " + e.toString());
                    }
                }, this.getClass().getClassLoader());){
                    this.props = (Map)((XMLDecoder)d2).readObject();
                }
                d2 = this.props;
                synchronized (d2) {
                    AlbumBean engine = this.ao.getEngine();
                    engine.setDataTypes(this.props, engine.getSkinProperties().getProperty("slideModel", "SlideModel"));
                }
                this.lastSkin = this.ao.getEngine().getSkin();
                boolean d2 = true;
                if (_s2 != null) {
                    _s2.close();
                }
                return d2;
            }
            catch (Throwable d2) {
                try {
                    if (_s2 != null) {
                        try {
                            _s2.close();
                        }
                        catch (Throwable throwable) {
                            d2.addSuppressed(throwable);
                        }
                    }
                    throw d2;
                }
                catch (FileNotFoundException _s2) {
                }
                catch (RuntimeException ex) {
                    if (!JAlbum.logger.isLoggable(Level.FINER)) break block22;
                    System.err.println("Error reading xml metadata from " + String.valueOf(f) + ": " + String.valueOf(ex));
                    ex.printStackTrace(System.err);
                }
            }
        }
        Map<String, Object> map = this.props;
        synchronized (map) {
            AlbumBean engine = this.ao.getEngine();
            engine.setDataTypes(this.props, engine.getSkinProperties().getProperty("slideModel", "SlideModel"));
        }
        return false;
    }

    public File getFile() {
        return AlbumObjectProperties.getPropertyFile(this.getAOFile());
    }

    private File getAOFile() {
        if (this.ao != null) {
            return this.ao.getFile();
        }
        return this.file;
    }

    public static File getPropertyFile(File f) {
        if (f instanceof RenamedFile) {
            f = ((RenamedFile)f).getTarget();
        }
        if (f.isDirectory()) {
            File dir = new File(f, ".jalbum");
            return new File(dir, FILE_EXTENSION);
        }
        return new File(AlbumObjectImpl.getJalbumFolder(f), f.getName() + FILE_EXTENSION);
    }

    public void loadUI(JComponentHolder ui) {
        this.ensureClean();
        MapBinder.syncUI(this.props, ui);
    }

    public void saveUI(JComponentHolder ui) throws FileNotFoundException {
        HashMap<String, Object> oldProps = new HashMap<String, Object>();
        oldProps.putAll(this.props);
        Map<String, Object> newProps = MapBinder.getMap(ui);
        this.props.putAll(newProps);
        if (!this.props.equals(oldProps)) {
            this.save(false);
        }
    }

    public static class HiddenProperty {
        private Object property;

        public HiddenProperty() {
        }

        public HiddenProperty(Object property) {
            this.property = property;
        }

        public Object getProperty() {
            return this.property;
        }

        public void setProperty(Object property) {
            this.property = property;
        }
    }
}

