/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import net.jalbum.views.View;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectOrderer;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.DeleteOption;
import se.datadosen.jalbum.ElementFactory;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.FileFilters;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.Orientation;
import se.datadosen.util.PermissionDeniedException;
import se.datadosen.util.Scope;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.NoLinkForward;

public interface AlbumObject
extends Transferable,
Comparable<AlbumObject> {
    public static final ExecutorService iconLoaderPool = Executors.newFixedThreadPool(8, new NamedThreadFactory("Icon loader"));
    public static final DataFlavor albumObjectFlavor = new DataFlavor(AlbumObject.class, "Album object");

    public AlbumObject getParent();

    public File getFile();

    public AlbumObjectFactory getFactory();

    public AlbumBean getEngine();

    public long getLastModified();

    public long getMetaLastModified();

    public void setLastModified(long var1) throws IOException;

    public long getWhenAdded();

    public long getCameraDate();

    public void setCameraDate(long var1);

    public void setWhenAdded(long var1) throws IOException;

    public Image loadImage(boolean var1, Dimension var2) throws IOException;

    public Image loadImage(boolean var1, Dimension var2, boolean var3) throws IOException;

    public Image loadImage() throws IOException;

    public String getName();

    public String getKey();

    public String getWebName();

    public boolean setName(String var1);

    public String getComment();

    public void setComment(String var1) throws IOException;

    public String getTitle();

    public boolean setTitle(String var1) throws IOException;

    public int getRating();

    public void setRating(int var1) throws IOException;

    public Flag getFlag();

    public void setFlag(Flag var1) throws IOException;

    public String getKeywords();

    public Set<String> getKeywordSet();

    public void setKeywords(String var1) throws IOException;

    default public void setKeywords(Set<String> keywords) throws IOException {
        this.setKeywords(keywords != null ? StringUtil.setToString(keywords) : null);
    }

    public AlbumObjectMetadata getMetadata();

    public AlbumObjectProperties getProperties();

    public Attachments getAttachments();

    public XmpManager getXmpManager();

    public void rotateLeft() throws IOException;

    public void rotateRight() throws IOException;

    public Orientation getOrientation();

    public void setOrientation(Orientation var1) throws IOException;

    public boolean isIncludeOriginal();

    public void setIncludeOriginal(boolean var1) throws IOException;

    public boolean isUseOriginal();

    public void setUseOriginal(boolean var1) throws IOException;

    public void delete() throws IOException, PermissionDeniedException;

    public void delete(DeleteOption var1, DeleteOption ... var2) throws IOException, PermissionException;

    public AlbumObject createFolder(String var1) throws IOException;

    public AlbumObject createFolder(int var1, String var2) throws IOException;

    public AlbumObject createView(View var1, int var2, String var3) throws IOException;

    public AlbumObject createPage(int var1, String var2) throws IOException;

    public AlbumObject createPage(int var1, String var2, File var3) throws IOException;

    public boolean isDisplayableImage();

    public boolean hasDisplayableImage();

    @NoLinkForward
    default public boolean isLink() {
        return false;
    }

    @NoLinkForward
    default public boolean isInternalLink() {
        return false;
    }

    public boolean isFolder();

    public Category getCategory();

    public boolean isIncluded();

    public void setIncluded(boolean var1) throws IOException;

    public boolean isHidden();

    default public boolean isView() {
        return this.getProperties().containsKey("view");
    }

    @NoLinkForward
    public boolean isWithin(AlbumObject var1);

    public void setHidden(boolean var1) throws IOException;

    public List<AlbumObject> getChildren();

    default public List<AlbumObject> getChildren(boolean ordered) {
        return this.getChildren();
    }

    default public List<AlbumObject> getChildren(Category ofCategory) {
        try {
            return this.getChildren().stream().filter(ao -> ao.getCategory() == ofCategory).collect(Collectors.toList());
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("For " + String.valueOf(this.getFile()));
        }
    }

    default public List<AlbumObject> getChildren(Predicate<AlbumObject> filter) {
        try {
            return this.getChildren().stream().filter(filter).collect(Collectors.toList());
        }
        catch (NullPointerException ex) {
            throw new NullPointerException("For " + String.valueOf(this.getFile()));
        }
    }

    public TreeCollection getDescendants();

    public TreeCollection getDescendants(IncludeOption var1, IncludeOption ... var2);

    public AlbumObject getChild(String var1);

    public void setChildren(List<AlbumObject> var1) throws IOException;

    public boolean containsName(String var1);

    public void moveTo(AlbumObject var1) throws IOException;

    public void moveTo(AlbumObject var1, int var2) throws IOException;

    public void moveTo(AlbumObject var1, String var2) throws IOException;

    public void moveTo(AlbumObject var1, String var2, int var3) throws IOException;

    public String getUniqueName(String var1);

    public boolean repairLink(File var1) throws IOException;

    public void add(List<File> var1) throws IOException;

    public void add(int var1, Set<AlbumObject> var2) throws IOException;

    public void add(int var1, AlbumObject var2) throws IOException;

    public void add(Set<AlbumObject> var1) throws IOException;

    public void add(AlbumObject var1) throws IOException;

    public Ordering getOrdering();

    public void setOrdering(Ordering var1) throws IOException;

    public Ordering getFolderOrdering();

    public void setFolderOrdering(Ordering var1) throws IOException;

    public boolean isFoldersFirst();

    public void setFoldersFirst(boolean var1) throws IOException;

    public boolean isReverseOrdering();

    public void setReverseOrdering(boolean var1) throws IOException;

    public boolean isReverseFolderOrdering();

    public void setReverseFolderOrdering(boolean var1) throws IOException;

    public void setRepresentingIcon(BufferedImage var1, boolean var2) throws IOException;

    public AlbumObject getRepresentingAlbumObject();

    public ImageRenderer getRenderer();

    public AlbumObject getRepresentingAlbumObject(boolean var1);

    public void setRepresentingAlbumObject(AlbumObject var1);

    public void updateRepresentingIcon();

    public void invalidate();

    public ImageIcon getRepresentingIcon(Dimension var1, boolean var2) throws IOException;

    public ImageIcon getRepresentingIcon(Dimension var1, boolean var2, boolean var3) throws IOException;

    public FileFilters.BasicImageInfo getImageInfo() throws IOException;

    public Dimension getSize() throws IOException;

    public Dimension getSize(boolean var1) throws IOException;

    public File getRepresentingImageFile();

    public String getThumbnailPath();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public String getPathFromRoot();

    public String getPathFrom(AlbumObject var1);

    public Path getPath();

    public AlbumObject getRoot();

    public AlbumObject getViewRoot();

    default public boolean isUnderView() {
        AlbumObject viewRoot = this.getViewRoot();
        return viewRoot != null && viewRoot != this;
    }

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public Scope getVars();

    public void setVars(Scope var1);

    public Scope getPathVars(AlbumObject var1);

    public void fireModelChanged();

    public static Stream<AlbumObject> folderTreeOf(AlbumObject folder) {
        return TreeCollection.of(new AlbumObject[]{folder}).stream().filter(fld -> fld.isFolder());
    }

    public static Stream<AlbumObject> treeOf(AlbumObject folder) {
        return TreeCollection.of(new AlbumObject[]{folder}).stream();
    }

    default public ElementFactory elements() {
        return new ElementFactory(this);
    }

    public static enum Ordering {
        name("ui.nameOrdering"),
        simpleName("ui.nameOrdering"),
        cameraDate("edit.cameraDateOrdering"),
        date("ui.dateOrdering"),
        addedDate("edit.addedDateOrdering"),
        rating("edit.ratingOrdering"),
        title("edit.titleLabel"),
        comment("ui.caption"),
        category("info.category"),
        extension("info.type"),
        custom("edit.customOrdering"),
        jalbum("edit.jalbumOrdering"),
        foldersFirst("edit.foldersFirst");

        private String key;

        private Ordering(String key) {
            this.key = key;
        }

        public String toString() {
            return Msg.get(this.key);
        }

        public Comparator<AlbumObject> getComparator() {
            return this.getComparator(false);
        }

        public Comparator<AlbumObject> getComparator(boolean reverse) {
            return AlbumObjectOrderer.getComparator(this, reverse);
        }
    }
}

