/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.BshScriptEngine;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.StringValue;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Descriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDescriptor;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.xmp.XmpDirectory;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.Year;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.util.Pair;
import javax.imageio.ImageReadParam;
import javax.imageio.metadata.IIOMetadata;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import marcoschmidt.ImageInfo;
import net.jalbum.ObjectException;
import net.jalbum.OutputFormat;
import net.jalbum.Variant;
import net.jalbum.avif.AVIFMetadata;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterPipeline;
import net.jalbum.filters.ColorProfileFilter;
import net.jalbum.imaging.Imaging2;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.metadata.exif.ExtendedExifDescriptor;
import net.jalbum.metadata.exif.ExtendedGpsDescriptor;
import net.jalbum.util.Parameters;
import net.jalbum.util.Profiler;
import net.jalbum.util.Work;
import net.jalbum.util.WorkerPool;
import net.jalbum.views.View;
import net.jalbum.views.ViewSupport;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AST;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumEngine;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.AlbumProject;
import se.datadosen.jalbum.AlbumSynchronizer;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.ChainedObjects;
import se.datadosen.jalbum.CircularFolderReferenceException;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.ControlFiles;
import se.datadosen.jalbum.DirectoryChaining;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.EditListener2;
import se.datadosen.jalbum.EvaluationException;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.FileNamer;
import se.datadosen.jalbum.FolderVisitResult;
import se.datadosen.jalbum.FreeVersionDialogs;
import se.datadosen.jalbum.FullTreeChainedObjects;
import se.datadosen.jalbum.ImageRenderer;
import se.datadosen.jalbum.IncludeOption;
import se.datadosen.jalbum.Includes;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAFilterNode;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.JSONEncoder;
import se.datadosen.jalbum.JSONMaker;
import se.datadosen.jalbum.LicenseManager;
import se.datadosen.jalbum.LinkAlbumObject;
import se.datadosen.jalbum.Main;
import se.datadosen.jalbum.MakeResult;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.NoDiacriticsAlbumObjectFactory;
import se.datadosen.jalbum.NotADirectoryException;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.OperationRestartedException;
import se.datadosen.jalbum.PageNamer;
import se.datadosen.jalbum.Paginator;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.PhotoSphere;
import se.datadosen.jalbum.ProjectSettings;
import se.datadosen.jalbum.RecoveryTool;
import se.datadosen.jalbum.ScriptEnginePool;
import se.datadosen.jalbum.ScriptEnvironment;
import se.datadosen.jalbum.ScriptLanguage;
import se.datadosen.jalbum.SiblingChainedObjects;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.jalbum.StandardFileNamer;
import se.datadosen.jalbum.StandardPageNamer;
import se.datadosen.jalbum.Targets;
import se.datadosen.jalbum.ThemeImageProcessor;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.TitleSource;
import se.datadosen.jalbum.Tracer;
import se.datadosen.jalbum.TreeCollection;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.VideoResolution;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.jalbum.XMPConsumer;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.jalbum.io.FileTreeCollection;
import se.datadosen.jalbum.io.VirtualFile;
import se.datadosen.jalbum.scaling.CustomScaler;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.jalbum.structure.LimitTransformer;
import se.datadosen.jalbum.structure.MirrorTransformer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.Section;
import se.datadosen.tags.Template;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.DigestUtil;
import se.datadosen.util.FileFilters;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.GraphicsUtilities;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.Orientation;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.Replacer;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.SafeSimpleDateFormat;
import se.datadosen.util.Scope;
import se.datadosen.util.ScriptException;
import se.datadosen.util.ScriptExceptions;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.TargetPage;
import se.datadosen.util.VersionNumber;
import se.datadosen.util.annotations.Bean;
import se.datadosen.util.annotations.CallOrder;
import se.datadosen.util.annotations.Unbound;

public class AlbumBean
implements ImageObserver,
AlbumEngine,
Cloneable {
    public boolean compile = true;
    public static final String PRODUCT_DISPLAY_VERSION = "39";
    public static final String PRODUCT_INTERNAL_VERSION = "39";
    public static final String HEADLESS_SETTINGS_NAME = "headless-settings.jap";
    public static final String ORDER_BY_DATE = "OrderByDate";
    public static final String ORDER_BY_ADDED_DATE = "OrderByAddedDate";
    public static final String ORDER_BY_CAMERA_DATE = "OrderByCameraDate";
    public static final String ORDER_BY_NAME = "OrderByName";
    public static final String ORDER_BY_SIMPLE_NAME = "OrderBySimpleName";
    public static final String LINK_ORIGINALS = "LinkOriginals";
    public static final String LINK_ORIGINALS_VIA_SCALED = "LinkOriginalsViaScaled";
    public static final String LINK_SCALED = "LinkScaled";
    public static final String SCALE_SMOOTH = "ScaleSmooth";
    public static final String SCALE_MEDIUM = "ScaleMedium";
    public static final String SCALE_FAST = "ScaleFast";
    static final String GIFS_DIR = "gifs";
    private static final String STYLES_FILE = "styles.css";
    private boolean smartMake;
    private static final String DEFAULT_INDEX_PAGE_NAME = "index";
    public static final int MAX_ROWS = 999;
    protected static final Map application = new PrintSafeHashMap();
    public HashMap evalStats = new HashMap();
    private final ImageInfoFormatter formatter = new ImageInfoFormatter();
    private final Config cfg = Config.getConfig();
    Object using;
    private Map album;
    Scope globalVariables;
    Map<File, Scope> fileVariables;
    Template indexTemplate;
    Template slideTemplate;
    public AST indexAST;
    public AST slideAST;
    private ASTCache astCache = new ASTCache();
    private boolean mediaRSS = true;
    private boolean generateJSON = false;
    private String notes = "";
    private boolean notifyNotes = true;
    private boolean widgetInjection = true;
    private boolean excludeBacklinks = false;
    private String userName = "";
    static final String mediaRSSPath = "album.rss";
    private AtomicInteger processedFiles = new AtomicInteger(0);
    private int totalFiles;
    private String directory = "";
    private String thumbSize = "124x124";
    private String folderThumbSize = "";
    private String imageSize = "640x480";
    private boolean processFolderThumbs = false;
    private List<Variant> imageVariants = new ArrayList<Variant>();
    private List<Variant> thumbVariants = new ArrayList<Variant>();
    private Color imageBackgroundColor = Color.white;
    Dimension thumbDim = new Dimension(124, 124);
    Dimension folderThumbDim = null;
    Dimension imageDim = new Dimension(640, 480);
    private Dimension themeImageDim = null;
    private int cols = 6;
    private int rows = 4;
    private int limit = 0;
    private int qualityPercent = 85;
    private int qualityPercentWebP = 80;
    private int qualityPercentAVIF = 60;
    private int speedAVIF = 6;
    private int imageScale = 1;
    private int thumbScale = 1;
    private boolean highThumbnailCompressionQuality = false;
    private int sharpenPercent = 25;
    private boolean progressiveMode = false;
    private boolean disableColorSubsampling = false;
    private boolean classicReaders = false;
    private boolean useThumbForFolderIcon = true;
    private int cpuCores = this.calculateDefaultThreads();
    private boolean slides = true;
    private boolean makeThumbs = true;
    private boolean makeImages = true;
    private boolean includeOriginals;
    private boolean useInternalLinking = true;
    private boolean includeHiddenObjectsInViews = false;
    private ThemeImageProcessor themeImageProcessor = null;
    private int albumWidth = 560;
    private int albumHeight = 420;
    private Set<String> contributors = new HashSet<String>();
    private RAWImageReadParam rawParam = new RAWImageReadParam();
    private Runnable onMakeStarted;
    private AlbumProject currentProject;
    private final Stopwatch stopwatch = new Stopwatch();
    private boolean imagesProcessed = false;
    private JAlbumContext context;
    private transient ArrayList albumBeanListeners;
    private PropertyChangeSupport changeSupport;
    private String dateFormat = "";
    private String scalingMethod = "ScaleSmooth";
    private CustomScaler.Type smoothScalingType = CustomScaler.Type.STANDARD;
    private boolean acceleratedScaling = true;
    private boolean subdirs = true;
    private boolean appendImages = false;
    private boolean forceImage = false;
    private boolean forceVideo = false;
    private boolean updatedDirsOnly = false;
    private boolean excludeByDefault = false;
    private boolean keepMetaData = false;
    private boolean keepXmpData = true;
    private String homepageAddress = "";
    private String homepageLinkText = "";
    private String indexPageName = "index";
    private String framesetPageName;
    private String imageOrdering = "OrderByDate";
    private Comparator customImageOrdering;
    private boolean metaData = true;
    private String outputDirectory = "album";
    private String albumAddress = "";
    private boolean copyOriginals = true;
    private String skin = "Plain";
    private String lastSkin = "";
    private String style = "Dark.css";
    private String resourceDirectory = "res";
    private String thumbDirectory = "thumbs";
    private String closeupDirectory = "slides";
    private String slideDirectory = "slides";
    private String thumbnailPrefix = "";
    private String closeupPrefix = "";
    private String pageExtension = ".html";
    private boolean includeDirectories = true;
    private Map userVariables = new PrintSafeHashMap();
    private Map skinVariables = new PrintSafeHashMap();
    private VideoProcessor videoProcessor;
    private boolean useCustomVideoSettings = false;
    private boolean frames;
    private String accountProfileName = "";
    private String remoteDirectory = "VALUE_UNSET";
    private boolean reverseOrder;
    private LinkedList<JAFilterNode> filters = new LinkedList();
    private String textEncoding;
    private boolean writeUTF8 = true;
    private boolean removeDiacritics = false;
    boolean _useScaledImagesAsOriginals = false;
    private boolean directoriesFirst = true;
    private String ignorePattern = "\\..*";
    private String includePattern = "";
    boolean readXmp = true;
    boolean readJAlbumMetaData = true;
    boolean jpegComment = false;
    boolean iptcCaption = true;
    boolean exifUserComment = false;
    TitleSource titleSource = TitleSource.IPTCObjectName;
    boolean highQualityThumbs = true;
    boolean forceJPEGThumbs = false;
    boolean forceJPEGImages = false;
    OutputFormat outputFormat = OutputFormat.JPEG;
    boolean forceProcessing = false;
    private boolean superimposeFilmIcon = true;
    boolean exifImageDescription = false;
    private DateFormat df = new SafeSimpleDateFormat();
    private DateFormat mediaRssDf = new SafeSimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public File skinDir;
    private File slidesDir;
    private File thumbsDir;
    private File resDir;
    public File srcResDir;
    private File rootImageDir;
    private AlbumObjectFactory factory;
    transient AlbumObject root;
    File rootOutputDir;
    private PageNamer pageNamer;
    private FileNamer fileNamer;
    private boolean visibleOnProfilePage;
    private String webPassword;
    private LicenseManager licenseManager;
    private DirectoryChaining directoryChaining;
    private ChainedObjects chainedObjects;
    private SkinProperties skinProperties;
    private Object slideModel;
    private String creator;
    private String rights;
    private String rightsURL;
    private boolean overrideExistingCopyright;
    private JSONMaker jsonMaker;
    private boolean forceVideoProcessing;
    ExecutorService threadPool;
    private static final WorkerPool bigPool = new WorkerPool(Integer.parseInt(System.getProperty("ioThreads", "24")));
    private CreditText creditText;
    int currentRows;
    int indexNum;
    int imagesPerIndex;
    int indexImageCount;
    Scope indexVariables;
    private Interpreter interpreter;
    ScriptEnginePool scriptEnginePool;
    private ScriptLanguage scriptLanguage;
    ASTEvaluator evaluator;
    private URLClassLoader classLoader;
    private boolean createHardLinks;
    private Map<File, Pair<Long, CompiledScript>> compiledScriptCache;
    private long lastMadeDate;
    private String imageSettingsHash;
    private String lastImageSettingsHash;
    private String videoSettingsHash;
    private String lastVideoSettingsHash;
    private String folderThumbSettingsHash;
    AlbumObject[] currentObjects;
    AlbumObject[] reallyAllObjects;
    private static final Set<String> ignoredVars = new HashSet<String>();

    static File resolveScriptFile(File dir, String baseName) {
        boolean found = false;
        File file = null;
        for (String ext : ScriptLanguage.getSupportedExtensions()) {
            File f = new File(dir, baseName + "." + ext);
            if (file == null) {
                file = f;
            }
            if (!f.exists()) continue;
            if (found) {
                System.err.println("Multiple " + baseName + " files found in skin. Ignoring " + f.getName());
                continue;
            }
            found = true;
            file = f;
        }
        return file;
    }

    private static File[] resolveScriptFiles(File dir) {
        File[] files = dir.listFiles((d, name) -> {
            String ext = IO.extensionOf(name);
            for (ScriptLanguage sl : ScriptLanguage.values()) {
                if (!ext.equals(sl.getExtension())) continue;
                return true;
            }
            return false;
        });
        return files != null ? files : new File[]{};
    }

    private ScriptLanguage resolveScriptLanguage(File scriptFile) {
        if (scriptFile.exists()) {
            String ext = IO.extensionOf(scriptFile);
            for (ScriptLanguage sl : ScriptLanguage.values()) {
                if (!sl.getExtension().equals(ext)) continue;
                return sl;
            }
        }
        if (this.skinProperties != null) {
            return ScriptLanguage.valueOf(this.skinProperties.getProperty("scriptLanguage", ScriptLanguage.BEANSHELL.getLookupName()));
        }
        return ScriptLanguage.BEANSHELL;
    }

    private void copyAlbumFolder(File srcDir, File destDir, AlbumFileFilter filter) throws IOException {
        IO.createDirectories(destDir.toPath(), new FileAttribute[0]);
        FileCollection fc = new FileCollection(this, srcDir);
        for (File f : fc.listFiles(filter)) {
            File dst = new File(destDir, f.getName());
            if (f.isDirectory()) {
                this.copyAlbumFolder(f, dst, filter);
                continue;
            }
            IO.copyFile(f, dst);
        }
    }

    private Object getSlideModel() {
        String modelClassName = this.getSkinProperties().getProperty("slideModel", "SlideModel");
        try {
            Class modelClass = this.smartLoadClass(modelClassName);
            return modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException modelClass) {
        }
        catch (ReflectiveOperationException ex) {
            Logger.getLogger(AlbumBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private static String getSkinFrom(String path) {
        String[] parts = path.split("/|\\\\");
        for (int i = parts.length - 2; i > 0; --i) {
            if (!"skins".equals(parts[i - 1])) continue;
            return parts[i];
        }
        return null;
    }

    private static String getNameFrom(String path) {
        String[] parts = path.split("/|\\\\");
        return parts[parts.length - 1];
    }

    private void assertPageUpdated(AlbumObject ao) throws IOException {
        if (ao.getFile() instanceof LinkFile) {
            return;
        }
        AlbumObjectProperties props = ao.getProperties();
        if (props.containsKey("originalPath")) {
            String originalPath = (String)props.get("originalPath");
            File originalFile = new File(originalPath);
            String pageSkin = AlbumBean.getSkinFrom(originalPath);
            if (pageSkin != null) {
                originalFile = new File(this.skinDir, "templates/" + AlbumBean.getNameFrom(originalPath));
            }
            if (originalFile.exists() && !originalFile.getName().equals("empty-page.htt") && !DigestUtil.md5(originalFile).equals(props.get("originalHash"))) {
                String currentFileHash = DigestUtil.md5(ao.getFile());
                if (currentFileHash.equals(props.get("originalHash", currentFileHash))) {
                    ao.getFile().renameTo(IO.ensureUnique(ao.getFile().getParentFile(), ao.getFile().getName() + ".bak"));
                    IO.copyFile(originalFile, ao.getFile());
                    props.put("originalPath", originalFile.getAbsolutePath());
                    props.put("originalHash", DigestUtil.md5(originalFile));
                    props.save();
                    System.out.println("Updated page " + ao.getName() + " from " + String.valueOf(originalFile));
                } else {
                    System.err.println("Warning. New version of page " + ao.getName() + " exists but can't be updated (user modified). Consider removing and re-adding page");
                }
            }
        }
    }

    @Unbound
    int getProcessedFiles() {
        return this.processedFiles.get();
    }

    @Unbound
    int getTotalFiles() {
        return this.totalFiles;
    }

    @Unbound
    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public void setOnMakeStarted(Runnable onMakeStarted) {
        this.onMakeStarted = onMakeStarted;
    }

    private int calculateDefaultThreads() {
        int nThreads = Runtime.getRuntime().availableProcessors();
        if (nThreads > 8) {
            nThreads = 8;
        }
        return nThreads;
    }

    public int getAlbumHeight() {
        return this.albumHeight;
    }

    public void setAlbumHeight(int albumHeight) {
        this.albumHeight = albumHeight;
    }

    public int getAlbumWidth() {
        return this.albumWidth;
    }

    public void setAlbumWidth(int albumWidth) {
        this.albumWidth = albumWidth;
    }

    public boolean isMakeThumbs() {
        return this.makeThumbs;
    }

    public void setMakeThumbs(boolean makeThumbs) {
        this.makeThumbs = makeThumbs;
    }

    public boolean isMakeImages() {
        return this.makeImages;
    }

    public void setMakeImages(boolean makeImages) {
        this.makeImages = makeImages;
    }

    public boolean isIncludeOriginals() {
        return this.includeOriginals;
    }

    public void setIncludeOriginals(boolean includeOriginals) {
        this.includeOriginals = includeOriginals;
    }

    public boolean isUseInternalLinking() {
        return this.useInternalLinking;
    }

    public void setUseInternalLinking(boolean useInternalLinking) {
        this.useInternalLinking = useInternalLinking;
    }

    public boolean isIncludeHiddenObjectsInViews() {
        return this.includeHiddenObjectsInViews;
    }

    public void setIncludeHiddenObjectsInViews(boolean includeHiddenObjectsInViews) {
        this.includeHiddenObjectsInViews = includeHiddenObjectsInViews;
    }

    public ThemeImageProcessor getThemeImageProcessor() {
        return this.themeImageProcessor;
    }

    public void setThemeImageProcessor(ThemeImageProcessor themeImageProcessor) {
        this.themeImageProcessor = themeImageProcessor;
        if (themeImageProcessor != null) {
            themeImageProcessor.setEngine(this);
        }
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public JSONMaker getJSONMaker() {
        if (this.jsonMaker == null) {
            File dataConfigFile = new File(this.skinDir, "data-config.json");
            if (dataConfigFile.exists()) {
                try {
                    this.jsonMaker = new JSONMaker(this, dataConfigFile);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else if (this.generateJSON) {
                this.jsonMaker = new JSONMaker(this);
            }
        }
        return this.jsonMaker;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getRightsURL() {
        return this.rightsURL;
    }

    public void setRightsURL(String rightsURL) {
        this.rightsURL = rightsURL;
    }

    public boolean isOverrideExistingCopyright() {
        return this.overrideExistingCopyright;
    }

    public void setOverrideExistingCopyright(boolean overrideExistingCopyright) {
        this.overrideExistingCopyright = overrideExistingCopyright;
    }

    public LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = JAlbumContext.getInstance().getLicenseManager();
        }
        return this.licenseManager;
    }

    void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public PageNamer getPageNamer() {
        return this.pageNamer;
    }

    public void setPageNamer(PageNamer pageNamer) {
        this.pageNamer = pageNamer;
    }

    public FileNamer getFileNamer() {
        return this.fileNamer;
    }

    public void setFileNamer(FileNamer fileNamer) {
        this.fileNamer = fileNamer;
    }

    public static String getDisplayVersion() {
        return "39";
    }

    private static int getMajorVersion() {
        String ver = "39";
        int dotIndex = ver.indexOf(46);
        return Integer.parseInt(dotIndex != -1 ? ver.substring(0, dotIndex) : ver);
    }

    public static String getInternalVersion() {
        return "39";
    }

    public AlbumBean() {
        this(JAlbumContext.getInstance());
    }

    public AlbumBean(JAlbumContext context) {
        File systemDir;
        File headlessSettingsFile;
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.visibleOnProfilePage = true;
        this.webPassword = "";
        this.directoryChaining = DirectoryChaining.NO_CHAINING;
        this.chainedObjects = null;
        this.skinProperties = new SkinProperties(this.skinDir);
        this.creator = "";
        this.rights = "";
        this.rightsURL = "";
        this.overrideExistingCopyright = false;
        this.forceVideoProcessing = false;
        this.threadPool = null;
        this.scriptLanguage = ScriptLanguage.BEANSHELL;
        this.compiledScriptCache = new HashMap<File, Pair<Long, CompiledScript>>();
        this.context = context;
        if (context.getAlbumObjectfactory() == null) {
            context.setEngine(this);
            AlbumObjectFactory factory = new AlbumObjectFactory(this);
            context.setAlbumObjectfactory(factory);
        }
        this.textEncoding = System.getProperty("jalbum.file.encoding");
        if (this.textEncoding.equals("MacRoman") || this.textEncoding.equals("Cp1252")) {
            this.setTextEncoding("ISO-8859-1");
        }
        this.setDirectory(this.directory);
        this.initInterpreter();
        if (context.getFrame() == null && (headlessSettingsFile = new File(systemDir = new File(Config.getConfig().progDir, "system"), HEADLESS_SETTINGS_NAME)).exists()) {
            Properties props = new Properties();
            try {
                FileInputStream fis = new FileInputStream(headlessSettingsFile);
                props.load(fis);
                fis.close();
                this.setProperties(props);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public SkinProperties getSkinProperties() {
        return this.skinProperties;
    }

    @Unbound
    public ChainedObjects getChainedObjects() {
        if (this.chainedObjects == null) {
            switch (this.directoryChaining) {
                case FULL_TREE: {
                    this.chainedObjects = new FullTreeChainedObjects(this.root, this);
                    break;
                }
                case SIBLINGS: {
                    this.chainedObjects = new SiblingChainedObjects(this.root, this);
                }
            }
        }
        return this.chainedObjects;
    }

    @Bean
    public RAWImageReadParam getRawParam() {
        return this.rawParam;
    }

    @Bean
    public void setRawParam(RAWImageReadParam rawParam) {
        this.rawParam = rawParam;
    }

    void initInterpreter() {
        if (this.classLoader == null) {
            this.setClassLoader();
        }
        this.interpreter = new Interpreter();
        this.interpreter.setClassLoader((ClassLoader)this.classLoader);
        if (this.scriptEnginePool == null) {
            this.scriptEnginePool = new ScriptEnginePool(this.classLoader);
        } else {
            this.scriptEnginePool.resetBshEngine();
            this.scriptEnginePool.clearEngineVariables();
        }
    }

    private void setClassLoader() {
        File skinPluginsDir = new File(this.skinDir, "plugins");
        File skinLibDir = new File(this.skinDir, "lib");
        try {
            LinkedList<URL> all = new LinkedList<URL>();
            if (skinPluginsDir.exists()) {
                all.add(skinPluginsDir.toURI().toURL());
            }
            if (skinLibDir.exists()) {
                all.addAll(Main.buildURLList(skinLibDir));
            }
            all.add(this.cfg.pluginsDir.toURI().toURL());
            URL[] allURLs = all.toArray(new URL[all.size()]);
            URLClassLoader oldClassLoader = this.classLoader;
            this.classLoader = new URLClassLoader(allURLs, this.getClass().getClassLoader());
            if (this.interpreter != null) {
                this.interpreter.setClassLoader((ClassLoader)this.classLoader);
                this.interpreter.getClassManager().setClassLoader((ClassLoader)this.classLoader);
            }
            this.closeClassLoader(oldClassLoader);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void closeClassLoader(URLClassLoader cl) {
        if (cl instanceof Closeable) {
            try {
                cl.close();
                for (URL u : cl.getURLs()) {
                    if (!u.getProtocol().equals("jar")) continue;
                    ((JarURLConnection)u.openConnection()).getJarFile().close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public void unloadCurrentSkin() throws IOException {
        System.out.println("Unloading " + this.getSkin());
        this.closeClassLoader(this.classLoader);
        this.classLoader = null;
        this.scriptEnginePool = null;
        this.compiledScriptCache = new HashMap<File, Pair<Long, CompiledScript>>();
    }

    public ScriptEnvironment getScriptEnvironment() {
        if (this.classLoader == null) {
            this.setClassLoader();
        }
        if (this.scriptEnginePool == null) {
            this.scriptEnginePool = new ScriptEnginePool(this.classLoader);
        }
        return new ScriptEnvironment(this.skin, this.classLoader, this.scriptEnginePool, this.compiledScriptCache, this.interpreter);
    }

    void setScriptEnvironment(ScriptEnvironment se) {
        if (se != null && this.skin.equals(se.skin)) {
            if (JAlbum.logger.isLoggable(Level.CONFIG)) {
                System.out.println("Using cached scriptEnvironment");
            }
            this.classLoader = se.classLoader;
            this.scriptEnginePool = se.scriptEnginePool;
            this.compiledScriptCache = se.compiledScriptCache;
            this.interpreter = se.interpreter;
        }
    }

    public AlbumBean clone() {
        try {
            return (AlbumBean)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isGeneratesFormat(OutputFormat format) {
        if (this.outputFormat == format) {
            return true;
        }
        if (this.skinProperties.isSupportsVariants()) {
            for (Variant v : this.thumbVariants) {
                if (v.getFormat() != format) continue;
                return true;
            }
            for (Variant v : this.imageVariants) {
                if (v.getFormat() != format) continue;
                return true;
            }
        }
        return false;
    }

    private String getImageSettingsHash(EnumSet<ImageCategory> categories) {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        if (categories.contains((Object)ImageCategory.CLOSEUP)) {
            props.put("imageSize", this.getImageSize());
        }
        if (categories.contains((Object)ImageCategory.THUMBNAIL)) {
            props.put("thumbSize", this.getThumbSize());
        }
        if (this.folderThumbDim != null && categories.contains((Object)ImageCategory.FOLDER_THUMB)) {
            props.put("folderThumbSize", this.getFolderThumbSize());
        }
        props.put("scalingMethod", this.getScalingMethod());
        props.put("sharpenPercent", this.getSharpenPercent());
        props.put("qualityPercent", this.getQualityPercent());
        if (this.highThumbnailCompressionQuality) {
            props.put("highThumbnailCompressionQuality", this.highThumbnailCompressionQuality);
        }
        props.put("progressiveMode", this.progressiveMode);
        props.put("keepMetaData", this.isKeepMetaData());
        props.put("filterStack", this.filters.stream().filter(fn -> {
            for (ImageCategory cat : categories) {
                if (!cat.getStages().contains(fn.getStage())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList()));
        if (this.thumbScale > 1) {
            props.put("thumbScale", this.thumbScale);
        }
        if (this.imageScale > 1) {
            props.put("imageScale", this.imageScale);
        }
        if (this.isGeneratesFormat(OutputFormat.WEBP)) {
            props.put("qualityPercentWebP", this.getQualityPercentWebP());
        }
        if (this.isGeneratesFormat(OutputFormat.AVIF)) {
            props.put("qualityPercentAVIF", this.getQualityPercentAVIF());
            props.put("speedAVIF", this.getSpeedAVIF());
        }
        if (this.getScalingMethod().equals(SCALE_SMOOTH) && this.getSmoothScalingType() != CustomScaler.Type.STANDARD) {
            props.put("smoothScaingType", this.getSmoothScalingType().name());
        }
        if (!"".equals(this.getCreator())) {
            props.put("creator", this.getCreator());
        }
        if (!"".equals(this.getRights())) {
            props.put("rights", this.getRights());
        }
        if (!"".equals(this.getRightsURL())) {
            props.put("rightsURL", this.getRightsURL());
        }
        try {
            JSONEncoder jsonEnc = new JSONEncoder();
            if (JAlbum.logger.isLoggable(Level.FINEST)) {
                System.out.println("--- Image settings ---");
                System.out.println(jsonEnc.serialize(props));
                System.out.println("--- End of image settings ---");
            }
            return DigestUtil.md5(jsonEnc.serialize(props));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setDirectory(String newDirectory) {
        String oldDirectory = this.directory;
        this.directory = newDirectory;
        this.rootImageDir = new File(this.directory);
        this.firePropertyChange("directory", oldDirectory, newDirectory);
    }

    File getRootImageDir() {
        return this.rootImageDir;
    }

    @Override
    public String getDirectory() {
        return this.directory;
    }

    public AlbumProject getCurrentProject() {
        return this.currentProject;
    }

    public void setCurrentProject(AlbumProject currentProject) {
        this.currentProject = currentProject;
    }

    public void setThumbSize(String newThumbSize) throws ParameterException {
        String oldThumbSize = this.thumbSize;
        this.thumbDim = AlbumBean.parseSize(newThumbSize);
        this.thumbSize = this.thumbDim.width + "x" + this.thumbDim.height;
        this.firePropertyChange("thumbSize", oldThumbSize, newThumbSize);
    }

    public String getThumbSize() {
        return this.thumbSize;
    }

    public boolean isProcessFolderThumbs() {
        return this.processFolderThumbs;
    }

    public void setProcessFolderThumbs(boolean processFolderThumbs) {
        this.processFolderThumbs = processFolderThumbs;
        this.folderThumbDim = null;
        if (this.isProcessFolderThumbs() && "true".equals(this.skinProperties.getProperty("supportsFolderThumbs"))) {
            try {
                this.folderThumbDim = AlbumBean.parseSize(this.folderThumbSize);
            }
            catch (IllegalArgumentException ex) {
                this.folderThumbDim = this.thumbDim;
            }
            if (this.globalVariables != null) {
                this.globalVariables.put("processFolderThumbs", (Object)processFolderThumbs);
            }
        }
    }

    public void setFolderThumbSize(String folderThumbSize) throws ParameterException {
        String oldFolderThumbSize = folderThumbSize;
        this.folderThumbSize = folderThumbSize;
        this.firePropertyChange("folderThumbSize", oldFolderThumbSize, folderThumbSize);
    }

    public String getFolderThumbSize() {
        return this.folderThumbSize;
    }

    public void setImageSize(String newImageSize) throws ParameterException {
        Dimension oldImageDim = this.imageDim;
        this.imageDim = AlbumBean.parseSize(newImageSize);
        this.imageSize = this.imageDim.width + "x" + this.imageDim.height;
        this.firePropertyChange("imageDim", oldImageDim, this.imageDim);
    }

    public String getImageSize() {
        return this.imageSize;
    }

    public String getImageVariants() {
        return Jsoner.serialize(this.imageVariants);
    }

    @Unbound
    List<Variant> getImageVariantList() {
        return this.imageVariants;
    }

    public void setImageVariants(String imageVariants) {
        this.imageVariants = Variant.deserialize(imageVariants);
    }

    public String getThumbVariants() {
        return Jsoner.serialize(this.thumbVariants);
    }

    @Unbound
    List<Variant> getThumbVariantList() {
        return this.thumbVariants;
    }

    public void setThumbVariants(String thumbVariants) {
        this.thumbVariants = Variant.deserialize(thumbVariants);
    }

    @Unbound
    public Dimension getThemeImageDim() {
        return this.themeImageDim;
    }

    public void setThemeImageDim(Dimension themeImageDim) {
        Dimension oldDim = this.themeImageDim;
        this.themeImageDim = themeImageDim;
        this.firePropertyChange("themeImageDim", oldDim, themeImageDim);
    }

    public void setThemeImageSize(String themeImageSize) {
        if (themeImageSize != null) {
            try {
                this.setThemeImageDim(AlbumBean.parseSize(themeImageSize));
            }
            catch (IllegalArgumentException ex) {
                this.setThemeImageDim(null);
            }
        } else {
            this.setThemeImageDim(null);
        }
    }

    public String getThemeImageSize() {
        Dimension dim = this.getThemeImageDim();
        if (dim != null) {
            return dim.width + "x" + dim.height;
        }
        return "";
    }

    @Unbound
    public Dimension getImageDim() {
        return new Dimension(this.imageDim);
    }

    @Unbound
    public Dimension getThumbDim() {
        return new Dimension(this.thumbDim);
    }

    public void setCols(int newCols) {
        int oldCols = this.cols;
        if (newCols == 0) {
            return;
        }
        this.cols = newCols;
        this.firePropertyChange("cols", oldCols, newCols);
    }

    public int getCols() {
        return this.cols;
    }

    public void setQualityPercent(int newQualityPercent) {
        this.qualityPercent = newQualityPercent;
    }

    public int getQualityPercent() {
        return this.qualityPercent;
    }

    public int getQualityPercentWebP() {
        return this.qualityPercentWebP;
    }

    public void setQualityPercentWebP(int qualityPercentWebP) {
        this.qualityPercentWebP = qualityPercentWebP;
    }

    public int getQualityPercentAVIF() {
        return this.qualityPercentAVIF;
    }

    public void setQualityPercentAVIF(int qualityPercentAVIF) {
        this.qualityPercentAVIF = qualityPercentAVIF;
    }

    public int getSpeedAVIF() {
        return this.speedAVIF;
    }

    public void setSpeedAVIF(int speedAVIF) {
        this.speedAVIF = speedAVIF;
    }

    public boolean isHiDPIThumbs() {
        return this.thumbScale > 1;
    }

    public void setHiDPIThumbs(boolean hiDPI) {
        this.thumbScale = hiDPI ? 2 : 1;
    }

    @Unbound
    public int getImageScale() {
        return this.imageScale;
    }

    @Unbound
    public int getScaleForStage(int stage) {
        switch (stage) {
            case 1: 
            case 2: 
            case 3: {
                return this.getImageScale();
            }
        }
        return this.getThumbScale();
    }

    @Unbound
    public Dimension getSizeForStage(int stage) {
        switch (stage) {
            case 1: 
            case 2: 
            case 3: {
                return this.imageDim;
            }
            case 4: 
            case 5: {
                return this.thumbDim;
            }
        }
        return this.folderThumbDim;
    }

    @Unbound
    public int getThumbScale() {
        return this.thumbScale;
    }

    public void setSharpenPercent(int newSharpenPercent) {
        this.sharpenPercent = newSharpenPercent;
    }

    public int getSharpenPercent() {
        return this.sharpenPercent;
    }

    public boolean isDisableColorSubsampling() {
        return this.disableColorSubsampling;
    }

    public void setDisableColorSubsampling(boolean disableColorSubsampling) {
        this.disableColorSubsampling = disableColorSubsampling;
    }

    public boolean isHiDPIImages() {
        return this.imageScale > 1;
    }

    public void setHiDPIImages(boolean hiDPI) {
        int oldImageScale = this.imageScale;
        this.imageScale = hiDPI ? 2 : 1;
        this.firePropertyChange("imageScale", oldImageScale, this.imageScale);
    }

    public void useScaledImagesAsOriginals(boolean use) {
        this._useScaledImagesAsOriginals = use;
    }

    public void setClassicReaders(boolean newClassicReaders) {
        this.classicReaders = newClassicReaders;
    }

    public boolean isClassicReaders() {
        return this.classicReaders;
    }

    public void setUseThumbForFolderIcon(boolean newUseThumbForFolderIcon) {
        this.useThumbForFolderIcon = newUseThumbForFolderIcon;
    }

    public boolean isUseThumbForFolderIcon() {
        return this.useThumbForFolderIcon;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public void setSlides(boolean newSlides) {
        this.slides = newSlides;
        if (!newSlides) {
            this.slideTemplate = null;
        }
    }

    public boolean isSlides() {
        return this.slides;
    }

    public void setDateFormat(String newDateFormat) {
        this.dateFormat = newDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    @Unbound
    public DateFormat getDateFormatAsObject() {
        return this.df;
    }

    public ImageInfoFormatter getImageInfoFormatter() {
        return this.formatter;
    }

    public Color getImageBackgroundColor() {
        return this.imageBackgroundColor;
    }

    public void setImageBackgroundColor(Color backgroundColor) {
        this.imageBackgroundColor = backgroundColor;
    }

    public void processTemplateFile(File source, File dest) throws IOException, ElementException, javax.script.ScriptException {
        TargetPage page = new TargetPage(dest);
        String data = this.astCache.get(source).eval(this.evaluator);
        page.writeChangesBg(data, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    public void processTemplateFile(File source, Writer writer) throws IOException, ElementException, javax.script.ScriptException {
        String data = this.astCache.get(source).eval(this.evaluator);
        writer.write(data);
    }

    @Unbound
    public ASTCache getASTCache() {
        return this.astCache;
    }

    public String processTemplate(String s) throws ElementException, javax.script.ScriptException {
        return new AST(this, new Section(s)).eval(this.evaluator);
    }

    public String processSection(Section sec, Scope vars) throws ElementException, javax.script.ScriptException {
        return new AST(this, sec).eval(this.evaluator, vars);
    }

    public String processSection(Section sec, Map<String, Object> vars) throws ElementException, javax.script.ScriptException {
        return new AST(this, sec).eval(this.evaluator, new Scope(vars));
    }

    public void processTemplateFile(File source, File dest, Map vars) throws IOException, ElementException, javax.script.ScriptException {
        this.processTemplateFile(source, dest, vars, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    private void processTemplateFile(File source, File dest, Map vars, String encoding) throws IOException, ElementException, javax.script.ScriptException {
        TargetPage page = new TargetPage(dest);
        String data = this.astCache.get(source).eval(this.evaluator, new Scope(vars));
        page.writeChangesBg(data, encoding);
    }

    @Deprecated
    public File[] listFiles(File dir, boolean includeDirs, File outputDir) throws IOException {
        FileCollection fc = new FileCollection(this, dir);
        AlbumFileFilter filter = includeDirs ? new AlbumFileFilter(this) : new AlbumFileFilter(this, null, this.ignorePattern);
        return (File[])fc.listFiles(filter).toArray(File[]::new);
    }

    private void cleanIfRequested(File dir) throws IOException {
        IO.createDirectories(dir.toPath(), new FileAttribute[0]);
        if (this.cfg.isCleanOutputFiles() && !this.appendImages) {
            IO.emptyDir(dir);
        }
    }

    private AlbumObject[] limitTo(AlbumObject[] arr, int max) {
        if (max > 0 && max < arr.length) {
            AlbumObject[] limited = new AlbumObject[max];
            System.arraycopy(arr, 0, limited, 0, max);
            return limited;
        }
        return arr;
    }

    private static List<AlbumObject> excludePages(List<AlbumObject> all) {
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (ao.getCategory() == Category.webPage) continue;
            filtered.add(ao);
        }
        return filtered;
    }

    private static AlbumObject[] excludeCategory(AlbumObject[] all, Category excludeCat) {
        boolean anyExcluded = false;
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (ao.getCategory() != excludeCat) {
                filtered.add(ao);
                continue;
            }
            anyExcluded = true;
        }
        return anyExcluded ? filtered.toArray(new AlbumObject[filtered.size()]) : all;
    }

    private static AlbumObject[] excludeHidden(AlbumObject[] all) {
        boolean foundHidden = false;
        ArrayList<AlbumObject> filtered = new ArrayList<AlbumObject>();
        for (AlbumObject ao : all) {
            if (!ao.isHidden()) {
                filtered.add(ao);
                continue;
            }
            foundHidden = true;
        }
        return foundHidden ? filtered.toArray(new AlbumObject[filtered.size()]) : all;
    }

    private static AlbumObject[] toArray(List<AlbumObject> all) {
        int nIncluded = 0;
        for (AlbumObject ao : all) {
            if (!ao.isIncluded()) continue;
            ++nIncluded;
        }
        AlbumObject[] included = new AlbumObject[nIncluded];
        int i = 0;
        for (AlbumObject ao : all) {
            if (!ao.isIncluded()) continue;
            included[i++] = ao;
        }
        return included;
    }

    private void makeAlbumForFolder(AlbumObject folder, File outputDir, int level) throws IllegalArgumentException, IOException, OperationAbortedException, ElementException, javax.script.ScriptException {
        File gifsDir;
        this.fireFolderProcessingStarted(folder);
        if (!folder.isFolder()) {
            throw new IllegalArgumentException(Msg.get("engine.invalidDirectoryError"));
        }
        List<AlbumObject> children = folder.getChildren();
        AlbumObject[] reallyAllObjects = AlbumBean.toArray(children);
        AlbumObject[] allObjects = AlbumBean.toArray(AlbumBean.excludePages(children));
        AlbumObject[] objects = AlbumBean.excludeCategory(allObjects, Category.folder);
        if (!this.subdirs && !this.includeDirectories) {
            allObjects = AlbumBean.excludeCategory(allObjects, Category.folder);
        }
        objects = this.limitTo(objects, this.limit);
        allObjects = this.limitTo(allObjects, this.limit);
        IO.createDirectories(outputDir.toPath(), new FileAttribute[0]);
        if (level == 0) {
            File projectResDir;
            if (this.resDir != null) {
                File stylesResDir = new File(this.skinDir, "styles/" + IO.baseName(this.style));
                try (Profiler.Sample _s = Profiler.profile("Copy res files");){
                    IO.copyDirectoryContent(this.srcResDir, this.resDir, false, null, Config.getConfig().isUseHardLinks());
                    if (stylesResDir.exists()) {
                        IO.copyDirectoryContent(stylesResDir, this.resDir, false, null, Config.getConfig().isUseHardLinks());
                    }
                }
                File commonStyleFile = new File(this.skinDir, "common.css");
                if (commonStyleFile.exists()) {
                    File baseStyleFile = new File(this.skinDir, "base.css");
                    if (!baseStyleFile.exists()) {
                        baseStyleFile = new File(this.cfg.progDir, "system/base.css");
                    }
                    if (baseStyleFile.exists()) {
                        TargetPage commonStylePage = new TargetPage(new File(this.resDir, "common.css"));
                        StringWriter sw = new StringWriter();
                        this.processTemplateFile(baseStyleFile, sw);
                        this.processTemplateFile(commonStyleFile, sw);
                        commonStylePage.writeChangesBg(sw.toString(), this.writeUTF8 ? "UTF-8" : this.textEncoding);
                    } else {
                        this.processTemplateFile(commonStyleFile, new File(this.resDir, "common.css"));
                    }
                }
                File styleFile = new File(this.skinDir, "styles/" + this.style);
                File destFile = new File(this.resDir, STYLES_FILE);
                if (this.style != null && styleFile.exists() && styleFile.length() > 0L) {
                    this.processTemplateFile(styleFile, destFile);
                } else {
                    destFile.delete();
                }
            }
            if ((projectResDir = new File(this.rootImageDir, "res")).exists() && !projectResDir.equals(this.resDir) && this.resDir != null) {
                this.copyAlbumFolder(projectResDir, this.resDir, new AlbumFileFilter(this).setResDir(true));
            }
        }
        if ((gifsDir = new File(this.skinDir, GIFS_DIR)).exists()) {
            File outputGifsDir = new File(outputDir, GIFS_DIR);
            this.cleanIfRequested(outputGifsDir);
            IO.copyDirectoryContent(gifsDir, outputGifsDir, true);
        }
        AlbumBeanEvent eventObject = new AlbumBeanEvent(this, folder.getFile(), IO.relativePath(folder.getFile(), this.rootImageDir.getParentFile()), Msg.get("engine.readingMetadataInfo"));
        this.fireImageProcessingStarted(eventObject);
        Collection<AlbumObject> errorObjects = this.registerVariables(reallyAllObjects, outputDir);
        allObjects = this.excludeErrors(allObjects, errorObjects);
        objects = this.excludeErrors(objects, errorObjects);
        reallyAllObjects = this.excludeErrors(reallyAllObjects, errorObjects);
        this.fireStatus(Msg.get("engine.makingIndexPages"));
        AlbumObject[] visibleObjects = (AlbumObject[])((Stream)Arrays.stream(this.includeDirectories ? allObjects : objects).parallel()).filter(ao -> !ao.isHidden()).toArray(AlbumObject[]::new);
        this.reallyAllObjects = reallyAllObjects;
        this.currentObjects = visibleObjects;
        Scope folderVars = this.createFolderVars(folder, outputDir, visibleObjects, objects, level).name("FolderVars");
        Scope currentfolderScope = new Scope(folder.getVars().getMap()).name("Current folder");
        this.evaluator.setCurrentFolderScope(currentfolderScope);
        this.evaluator.enterScope(folderVars);
        try (Profiler.Sample _s = Profiler.profile("predir processing");){
            this.processScript(AlbumBean.resolveScriptFile(this.skinDir, "predir"), folderVars);
            this.processScript(AlbumBean.resolveScriptFile(this.cfg.progDir, "system/predir"), folderVars);
        }
        this.makeIndexPages(folder, outputDir, visibleObjects, folderVars);
        this.slidesDir = new File(outputDir, this.slideDirectory);
        this.thumbsDir = new File(outputDir, this.thumbDirectory);
        this.fireStatus(Msg.get("ui.readingFileAttributes") + "...");
        Future<Set> onf = IO.workerPool.submit(() -> CachedFile.map(outputDir).keySet());
        Future<TreeMap> tdf = IO.workerPool.submit(() -> CachedFile.map(this.thumbsDir));
        Future<TreeMap> sdf = IO.workerPool.submit(() -> CachedFile.map(this.slidesDir));
        try {
            Set outputNames = onf.get();
            TreeMap thumbsContents = tdf.get();
            TreeMap slidesContents = sdf.get();
            if (!outputNames.contains(this.slideDirectory)) {
                IO.createDirectories(this.slidesDir.toPath(), new FileAttribute[0]);
            }
            if (!outputNames.contains(this.thumbDirectory)) {
                IO.createDirectories(this.thumbsDir.toPath(), new FileAttribute[0]);
            }
            if (!this.processFolderThumbs) {
                folder.getChildren().stream().filter(ao -> ao.isFolder()).forEach(ao -> {
                    Map.Entry e;
                    String folderName = ao.getWebName();
                    SortedMap tail = thumbsContents.tailMap(folderName);
                    Iterator it = tail.entrySet().iterator();
                    while (it.hasNext() && (e = it.next()).getKey().startsWith(folderName) && !e.getKey().startsWith(folderName + "_")) {
                        ((CachedFile)e.getValue()).delete();
                        it.remove();
                    }
                });
            }
            this.indexNum = 0;
            for (AlbumObject ao2 : reallyAllObjects) {
                File translated;
                Object synchronizer;
                File destAudioClip;
                File audioClip;
                if (ao2.getCategory() == Category.webPage && this.getSkinProperties().isFullSiteSupport()) {
                    this.assertPageUpdated(ao2);
                    File targetPage = new File(outputDir, IO.baseName(ao2.getFile()) + this.getPageExtension());
                    ao2.getVars().setOuter(folderVars);
                    this.processTemplateFile(ao2.getFile(), targetPage, ao2.getVars());
                }
                if ((audioClip = ao2.getAttachments().get(Attachments.Type.AUDIO)) == null || !audioClip.exists() || !JAlbumUtilities.isDirty(destAudioClip = ((AlbumSynchronizer)(synchronizer = new AlbumSynchronizer(this))).getAudioClipFile(ao2, translated = ((AlbumSynchronizer)synchronizer).translate(ao2)), audioClip)) continue;
                IO.copyFile(audioClip, destAudioClip);
            }
            JSONMaker jm = this.getJSONMaker();
            if (jm != null) {
                jm.makeDataPages(folder, outputDir, reallyAllObjects);
                if (jm.isMakeTree() && level == 0) {
                    jm.makeTree(folder, outputDir);
                }
            }
            this.adjustImageLinks(outputDir, this.getSkinProperties().isMakeWebLocationSlides() ? objects : AlbumBean.excludeCategory(objects, Category.webLocation));
            Collection toProcess = Arrays.asList(allObjects).stream().filter(ao -> !ao.isFolder() || this.folderThumbDim != null || ao.getAttachments().isPresent(Attachments.Type.IMAGE)).collect(Collectors.toList());
            AlbumObject representing = folder.getRepresentingAlbumObject();
            if (representing != null && representing.getParent() == folder && representing.isDisplayableImage() && !representing.isIncluded()) {
                this.registerVariables(representing, outputDir, true);
                toProcess.add(representing);
            }
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
            this.createHardLinks = Config.getConfig().isUseHardLinks();
            String rootPath = IO.relativePath(this.rootOutputDir, this.thumbsDir);
            for (AlbumObject ao3 : toProcess) {
                tasks.add(() -> {
                    if (this.threadPool.isShutdown()) {
                        return null;
                    }
                    if (!ao3.isFolder()) {
                        if (this.slideTemplate != null && (ao3.getCategory() != Category.webLocation || this.getSkinProperties().isMakeWebLocationSlides())) {
                            if (ao3.isIncluded()) {
                                this.makeSlide(ao3, rootPath);
                            }
                        } else {
                            File f = new File(this.slidesDir, this.pageNamer.getSlideName(ao3.getFile()));
                            f.delete();
                        }
                    }
                    AlbumBeanEvent eo = new AlbumBeanEvent(this, outputDir, IO.relativePath(outputDir, this.rootImageDir.getParentFile()), ao3.getName());
                    this.processImage(ao3, outputDir, outputNames, thumbsContents, slidesContents, eo);
                    this.processedFiles.incrementAndGet();
                    if (eo.isAborted()) {
                        this.threadPool.shutdown();
                        throw new OperationAbortedException();
                    }
                    this.fireImageProcessingFinished(eo);
                    if (eventObject.isAborted()) {
                        this.threadPool.shutdown();
                        throw new OperationAbortedException();
                    }
                    return null;
                });
            }
            List results = this.threadPool.invokeAll(tasks);
            for (Future result : results) {
                result.get();
            }
        }
        catch (InterruptedException outputNames) {
        }
        catch (ExecutionException ex) {
            Throwable t = ex.getCause();
            if (!(t instanceof OperationAbortedException)) {
                t.printStackTrace(System.err);
            }
            if (t instanceof ElementException) {
                throw (ElementException)t;
            }
            if (t instanceof javax.script.ScriptException) {
                throw (javax.script.ScriptException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof OperationAbortedException) {
                throw (OperationAbortedException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
        if (this.themeImageProcessor != null) {
            this.themeImageProcessor.processThemeImage(folder, outputDir);
        }
        this.processScript(AlbumBean.resolveScriptFile(this.skinDir, "postdir"), folderVars);
        this.processScript(AlbumBean.resolveScriptFile(this.cfg.progDir, "system/postdir"), folderVars);
        this.fireFolderProcessingFinished(folder);
        AlbumBean.removeIfEmpty(new File(outputDir, this.thumbDirectory));
        AlbumBean.removeIfEmpty(new File(outputDir, this.slideDirectory));
        this.evaluator.exitScope(folderVars);
        if (this.subdirs) {
            for (AlbumObject ao4 : allObjects) {
                File sourceSubDir;
                File outputSubDir;
                if (!ao4.isFolder() || this.isLinkInternally(ao4) || !this.needsToProcessDir(ao4, outputSubDir = new File(outputDir, (sourceSubDir = ao4.getFile()).getName()))) continue;
                this.makeAlbumForFolder(ao4, outputSubDir, level + 1);
            }
        }
    }

    private boolean needsToProcessDir(AlbumObject folder, File outputDir) {
        try {
            return !this.updatedDirsOnly || !outputDir.exists() || JAlbumUtilities.deepLastModified(folder) >= this.lastMadeDate;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void removeIfEmpty(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null && files.length == 0) {
            dir.delete();
        }
    }

    private AlbumObject[] excludeErrors(AlbumObject[] objects, Collection<AlbumObject> errors) {
        if (errors.isEmpty()) {
            return objects;
        }
        LinkedList<AlbumObject> list = new LinkedList<AlbumObject>();
        for (AlbumObject object : objects) {
            list.addLast(object);
        }
        list.removeAll(errors);
        return list.toArray(new AlbumObject[list.size()]);
    }

    private static AlbumObjectProperties propertiesOf(AlbumObject ao) {
        AlbumObject viewRoot = ao.getViewRoot();
        if (viewRoot != null) {
            ao = viewRoot;
        }
        return ao.getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImage(final AlbumObject ao, File outputDir, Set<String> outputNames, Map<String, CachedFile> thumbsContents, Map<String, CachedFile> slidesContents, final AlbumBeanEvent eventObject) {
        block65: {
            try {
                File thumbsDir = new File(outputDir, this.thumbDirectory);
                Scope locals = ao.getVars();
                AlbumObject rep = ao.getRepresentingAlbumObject();
                if (rep == null) {
                    rep = ao;
                }
                Dimension imageDim = AlbumBean.getImageDim(locals);
                boolean isFolderThumb = ao.isFolder() && this.folderThumbDim != null;
                Dimension thumbDim = isFolderThumb ? AlbumBean.getFolderThumbDim(locals) : AlbumBean.getThumbDim(locals);
                ImageRenderer imageRenderer = ao.getRenderer();
                imageRenderer.deleteUnusedVariants(thumbsContents, slidesContents);
                Orientation orientation = ao.getOrientation();
                Includes includes = this.getIncludes(ao);
                final VideoProcessor vp = this.getVideoProcessor();
                if (!this.useCustomVideoSettings) {
                    vp.setVideoParameters(null);
                }
                boolean supportedVideo = vp.isFormatSupported(ao.getFile());
                AlbumBean albumBean = this;
                synchronized (albumBean) {
                    this.fireImageProcessingStarted(eventObject);
                    if (this.isLinkInternally(ao)) {
                        return;
                    }
                    if (supportedVideo && !ao.isIncludeOriginal()) {
                        AlbumObjectProperties props = ao.getProperties();
                        this.root.getProperties().put("ffmpegVideo", true);
                        String lastHash = props.get("videoSettingsHash", this.lastVideoSettingsHash);
                        boolean changed = !this.videoSettingsHash.equals(lastHash);
                        CachedFile oldOutputVideoFile = new CachedFile(vp.getOldOutputVideoFile(ao.getFile(), outputDir));
                        CachedFile outputVideoFile = new CachedFile(vp.getOutputVideoFile(ao.getFile(), outputDir));
                        if (outputVideoFile.lastModified() == 0L && oldOutputVideoFile.lastModified() != 0L) {
                            oldOutputVideoFile.renameTo(outputVideoFile);
                            outputVideoFile = oldOutputVideoFile;
                        }
                        if (this.getMakeMode() == MakeMode.all && this.forceVideoProcessing || changed || JAlbumUtilities.isDirty((File)outputVideoFile, ao.getFile())) {
                            vp.setProgressMonitor(new VideoProcessor.ProgressMonitor(){
                                private DecimalFormat twoDec = new DecimalFormat("0.##");
                                final /* synthetic */ AlbumBean this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void progress(VideoProcessor.ProgressInfo info) {
                                    eventObject.msg = ao.getName() + " (" + this.twoDec.format((double)info.currentMillis / (double)info.durationMillis * 100.0) + "%" + (String)(info.speed != null ? "  " + info.speed : "") + ")";
                                    this.this$0.fireVideoProcessingProgress(eventObject, (float)info.currentMillis / (float)info.durationMillis);
                                    if (eventObject.isAborted()) {
                                        vp.abortProcessing();
                                        throw new OperationAbortedException();
                                    }
                                }
                            });
                            vp.processVideo(ao.getFile(), orientation, (TimeCode)props.get("videoClipStart"), (TimeCode)props.get("videoClipLength"), outputDir);
                            props.put("videoSettingsHash", vp.getVideoSettingsHash());
                            props.save(true);
                        }
                    } else if (!ao.isFolder() && !outputDir.equals(ao.getFile().getParentFile()) && ao.getCategory() != Category.webPage) {
                        if (this.copyOriginals && includes.original || includes.closeup && !ao.isDisplayableImage() && !supportedVideo) {
                            if (!this.appendImages || ao.getFile().lastModified() > new File(ao.getCategory() == Category.video ? this.slidesDir : outputDir, ao.getFile().getName()).lastModified()) {
                                this.createHardLinks = ao.getCategory() == Category.video ? IO.copyFile(ao.getFile(), this.slidesDir, false, this.createHardLinks) : IO.copyFile(ao.getFile(), outputDir, false, this.createHardLinks);
                            }
                        } else if (outputNames.contains(ao.getFile().getName())) {
                            File f = new File(outputDir, ao.getFile().getName());
                            if (IO.isSubdirectoryOf(outputDir, this.root.getFile())) {
                                f.delete();
                            }
                        }
                    }
                }
                File file = ao.getFile();
                File repFile = ao.getRepresentingImageFile();
                if (repFile != null) {
                    file = repFile;
                }
                if (repFile == null && !rep.hasDisplayableImage()) break block65;
                Targets targets = Targets.of(ao);
                CachedFile thumbFile = new CachedFile(thumbsDir, targets.thumb);
                CachedFile scaledFile = new CachedFile(this.slidesDir, targets.closeup);
                BufferedImage original = null;
                ColorModel colorModel = null;
                IIOMetadata meta = null;
                Boolean changed = null;
                FilterList stack = (FilterList)ao.getProperties().get("filterList");
                FilterPipeline filterPipeline = new FilterPipeline(stack);
                if (this.getMakeMode() == MakeMode.all || this.makeThumbs && imageRenderer.isThumbsDirty(thumbFile, thumbsContents) || (includes.closeup || repFile != null) && (!isFolderThumb && imageRenderer.isCloseupsDirty(scaledFile, slidesContents) || (changed = Boolean.valueOf(this.isImageSettingsChanged(scaledFile, changed))).booleanValue())) {
                    boolean writeXmpToFile;
                    this.imagesProcessed = true;
                    int subsampling = 1;
                    boolean isPhotoSphere = PhotoSphere.isPhotoSphere(ao);
                    if (!isPhotoSphere) {
                        Dimension maxImageDim = AlbumBean.getScaledDim(imageRenderer.getMaxCloseupDimension(imageDim), this.imageScale);
                        Dimension maxThumbDim = AlbumBean.getScaledDim(imageRenderer.getMaxThumbDimension(thumbDim), this.thumbScale);
                        Dimension maxBounds = new Dimension(Integer.max(maxImageDim.width, maxThumbDim.width), Integer.max(maxImageDim.height, maxThumbDim.height));
                        if (!this.scalingMethod.equals(SCALE_SMOOTH)) {
                            subsampling = FileFilters.calculateSubsamplingByScale(ao.getImageInfo(), maxBounds);
                        } else if (System.getProperty("maxSubsampling") != null) {
                            int maxSubsampling = Integer.parseInt(System.getProperty("maxSubsampling"));
                            int ss = FileFilters.calculateSubsamplingByScale(ao.getImageInfo(), maxBounds, 0);
                            subsampling = Math.min(maxSubsampling, ss);
                        }
                    }
                    if (this._useScaledImagesAsOriginals && ((File)scaledFile).exists()) {
                        original = FileFilters.loadImage(scaledFile);
                    } else {
                        original = FileFilters.loadImage(file, subsampling, ao.getImageInfo().isRaw() ? (ImageReadParam)ao.getProperties().get("imageReadParam", this.getRawParam()) : null, FileFilters.ReaderFlag.DONT_APPLY_COLOR_PROFILE);
                        colorModel = original.getColorModel();
                        if (colorModel.getColorSpace().isCS_sRGB()) {
                            colorModel = null;
                        }
                    }
                    if (this.threadPool.isShutdown()) {
                        return;
                    }
                    original = RotationSupport.adjustOrientation(original, orientation);
                    boolean bl = writeXmpToFile = this.keepXmpData && ao.getXmpManager() != null;
                    if (writeXmpToFile) {
                        XmpManager mgr = ao.getXmpManager();
                        mgr.setJAlbumProperty("imageSettingsHash", this.imageSettingsHash);
                        mgr.deleteJAlbumProperty("from");
                        this.injectCopyrightProperty(mgr.getCreator(), this.creator, mgr::setCreator);
                        this.injectCopyrightProperty(mgr.getRights(), this.rights, mgr::setRights);
                        this.injectCopyrightProperty(mgr.getRightsURL(), this.rightsURL, mgr::setRightsURL);
                    }
                    if (includes.closeup || ao.getCategory() == Category.video && repFile != null) {
                        String ext = IO.extensionOf(file).toLowerCase();
                        if (!(!"jpeg".equals(ext) && !"jpg".equals(ext) || this.forceProcessing || original.getWidth() > imageDim.width || original.getHeight() > imageDim.height || stack != null && stack.getPosition() != 0 || !this.filters.isEmpty() || !this.imageVariants.isEmpty() && this.skinProperties.isSupportsVariants() || orientation != Orientation.normal)) {
                            IO.copyFile(file, (File)scaledFile);
                        } else {
                            BufferedImage bi = this.processFilters(filterPipeline, original, ao, locals, 1);
                            if (isPhotoSphere) {
                                bi = PhotoSphere.scaleToPowerOfTwo(bi, this);
                                PhotoSphere.addAutoCalculatedFields(ao, bi);
                                if (colorModel != null) {
                                    bi = new ColorProfileFilter().filter(colorModel, bi, null);
                                }
                                bi = this.processFilters(filterPipeline, bi, ao, locals, 2);
                            } else if (!ao.isFolder()) {
                                bi = imageRenderer.processCloseups(bi, colorModel, filterPipeline, this.slidesDir);
                            }
                            if (this.threadPool.isShutdown()) {
                                return;
                            }
                            Dimension realImageDim = imageRenderer.getMaxCloseupDimension(AlbumBean.getScaledDim(imageDim, this.imageScale));
                            Dimension realThumbDim = imageRenderer.getMaxThumbDimension(AlbumBean.getScaledDim(thumbDim, this.thumbScale));
                            if (realImageDim.width >= realThumbDim.width && realImageDim.height >= realThumbDim.height) {
                                original.flush();
                                original = imageRenderer.getAndResetIntermediateImage();
                                colorModel = null;
                            }
                            if (this.keepMetaData) {
                                try {
                                    meta = FileFilters.getMetaData(file);
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    // empty catch block
                                }
                            }
                            if (!scaledFile.equals(file) && !ao.isFolder()) {
                                if (!scaledFile.getParentFile().exists()) {
                                    Files.createDirectory(scaledFile.getParentFile().toPath(), new FileAttribute[0]);
                                }
                                if (writeXmpToFile && FileFilters.isJPEGImage(scaledFile)) {
                                    byte[] bytes = FileFilters.saveImage(bi, (File)new VirtualFile(scaledFile), IO.extensionOf(scaledFile), this, meta);
                                    ao.getXmpManager().save(bytes, scaledFile);
                                } else {
                                    if (FileFilters.isAVIFImage(scaledFile)) {
                                        AVIFMetadata avifMeta = new AVIFMetadata();
                                        if (writeXmpToFile) {
                                            avifMeta.setXmp(ao.getXmpManager().serialize());
                                        }
                                        if (meta != null) {
                                            avifMeta.setEXIF(AVIFMetadata.getEXIFBytes((IIOMetadata)meta));
                                        }
                                        meta = avifMeta;
                                    }
                                    FileFilters.saveImage(bi, (File)scaledFile, IO.extensionOf(scaledFile), this, meta);
                                }
                                bi.flush();
                                if (meta != null && orientation != Orientation.normal) {
                                    try {
                                        RotationSupport.setOrientation(1, scaledFile);
                                    }
                                    catch (IOException avifMeta) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
                boolean folderThumbChanged = false;
                if (isFolderThumb) {
                    AlbumObjectProperties props = AlbumBean.propertiesOf(ao);
                    boolean bl = folderThumbChanged = !this.folderThumbSettingsHash.equals(props.get("folderThumbSettingsHash"));
                }
                if (!this.makeThumbs || thumbFile.equals(file) || this.getMakeMode() != MakeMode.all && !imageRenderer.isThumbsDirty(thumbFile, thumbsContents) && !this.isImageSettingsChanged(scaledFile, changed) && !folderThumbChanged) break block65;
                if (original == null) {
                    int subsampling = 1;
                    if (!this.scalingMethod.equals(SCALE_SMOOTH)) {
                        Dimension maxThumbDim = AlbumBean.getScaledDim(imageRenderer.getMaxThumbDimension(thumbDim), this.thumbScale);
                        subsampling = FileFilters.calculateSubsamplingByScale(ao.getImageInfo(), maxThumbDim);
                    }
                    if (this._useScaledImagesAsOriginals && ((File)scaledFile).exists()) {
                        original = FileFilters.loadImage(scaledFile);
                    } else {
                        original = FileFilters.loadImage(file, subsampling, (ImageReadParam)ao.getProperties().get("imageReadParam"), new FileFilters.ReaderFlag[0]);
                        original = RotationSupport.adjustOrientation(original, orientation);
                    }
                }
                File attachedImage = ao.getAttachments().get(Attachments.Type.IMAGE);
                if (ao.getCategory() == Category.image && attachedImage != null && attachedImage.exists()) {
                    original = FileFilters.fastLoadImage(attachedImage, imageDim);
                }
                BufferedImage bi = imageRenderer.processThumbs(original, colorModel, repFile, filterPipeline, thumbsDir);
                OutputFormat format = OutputFormat.ofExtension(IO.extensionOf(thumbFile));
                int qualityPercent = format.getQualityPercent(this);
                FileFilters.saveImage(bi, (File)thumbFile, format, this, meta, this.highThumbnailCompressionQuality ? 0.95f : (float)qualityPercent / 100.0f);
                if (meta != null && orientation != Orientation.normal) {
                    try {
                        RotationSupport.setOrientation(1, thumbFile);
                    }
                    catch (IOException realImageDim) {
                        // empty catch block
                    }
                }
                if (!isFolderThumb) break block65;
                AlbumObjectProperties props = AlbumBean.propertiesOf(ao);
                props.put("folderThumbSettingsHash", this.folderThumbSettingsHash);
                props.put("lastRepresentingObject", rep.getPathFromRoot());
                try {
                    ViewSupport vs = new ViewSupport(ao);
                    Map<String, Object> vprops = vs.getProperties();
                    vprops.put("lastRepresentingObject", rep.getPathFromRoot());
                    vs.saveProperties();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                props.save(true);
            }
            catch (OperationAbortedException ex) {
                throw ex;
            }
            catch (XMPException | IOException | RuntimeException ex) {
                if (ex instanceof RuntimeException) {
                    System.out.println("Error processing " + String.valueOf(ao) + ":");
                    ex.printStackTrace(System.err);
                }
                if (JAlbum.logger.isLoggable(Level.FINE)) {
                    ex.printStackTrace(System.err);
                }
                this.fireErrorOccured(ex, ao);
            }
        }
    }

    private void injectCopyrightProperty(String existing, String def, XMPConsumer<String> consumer) throws XMPException {
        if (def.length() > 0 && (this.overrideExistingCopyright || existing == null || existing.length() == 0)) {
            consumer.accept(def);
        }
    }

    private boolean isImageSettingsChanged(File scaledFile, Boolean lastResult) {
        switch (this.getMakeMode().ordinal()) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        if (lastResult != null) {
            return lastResult;
        }
        if (scaledFile.lastModified() < this.lastMadeDate) {
            return !this.imageSettingsHash.equals(this.lastImageSettingsHash);
        }
        String currentSettingsHash = this.lastImageSettingsHash;
        try {
            String xml = Imaging2.getXmpXml(scaledFile);
            XMPMeta meta = XMPMetaFactory.parseFromString((String)xml);
            String current = meta.getPropertyString("http://ns.jalbum.net/1.0/", "jalbum:imageSettingsHash");
            if (current != null) {
                currentSettingsHash = current;
            }
        }
        catch (XMPException | IOException | RuntimeException ex) {
            JAlbum.logger.log(Level.FINE, "For file: {0}: {1}", new Object[]{scaledFile, ex.toString()});
        }
        return !this.imageSettingsHash.equals(currentSettingsHash);
    }

    ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        try (FileInputStream fis = new FileInputStream(file);){
            ii.setCollectComments(true);
            ii.setInput(fis);
            ii.setEncoding(this.textEncoding);
            if (!ii.check()) {
                throw new IOException(Msg.get("engine.unsupportedFileFormatError") + file.getName());
            }
            ImageInfo imageInfo = ii;
            return imageInfo;
        }
    }

    private Path getOriginalPath(AlbumObject ao) throws IOException {
        VideoProcessor vp = this.getVideoProcessor();
        vp.setAllowPrompting(true);
        if (vp.isFormatSupported(IO.extensionOf(ao.getFile()))) {
            if (this.copyOriginals || !this.includeOriginal(ao)) {
                Path base = this.isLinkInternally(ao) ? ((LinkAlbumObject)ao).getTarget().getPath().getParent() : ao.getParent().getPath();
                return this.translate(base).resolve(this.slideDirectory).resolve(ao.getWebName());
            }
            return ao.getFile().toPath();
        }
        if (ao.getCategory() == Category.webPage) {
            return this.translate(ao.getPath()).resolveSibling(IO.baseName(ao.getFile()) + this.getPageExtension());
        }
        if (this.copyOriginals) {
            return this.isLinkInternally(ao) ? this.translate(((LinkAlbumObject)ao).getTarget().getPath()) : this.translate(ao.getPath());
        }
        return ao.getFile().toPath();
    }

    static Map getFolderProperties(File dir) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            File mapFile = ControlFiles.meta(dir);
            if (!mapFile.exists()) {
                mapFile = new File(dir, "meta.properties");
            }
            if (mapFile.exists()) {
                Map props = IO.readMapFile(mapFile);
                Iterator it = props.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    if (!((String)e.getValue()).isEmpty()) continue;
                    it.remove();
                }
                Map map = props;
                return map;
            }
            HashMap hashMap = new HashMap();
            return hashMap;
        }
    }

    Path translate(Path p) {
        return this.rootOutputDir.toPath().resolve(this.rootImageDir.toPath().relativize(p));
    }

    @Unbound
    Includes getIncludes(AlbumObject ao) {
        return new Includes(ao, this);
    }

    boolean isLinkInternally(AlbumObject ao) {
        return this.useInternalLinking && ao.isInternalLink() && this.getSkinProperties().isSupportsInternalLinking() && ((LinkAlbumObject)ao).getTarget() != null && !((AlbumObjectImpl)((LinkAlbumObject)ao).getTarget()).isEffectivelyExcluded();
    }

    File addImageLinks(AlbumObject ao, File outputDir, File fromDir) throws IOException {
        return this.addImageLinks(ao, outputDir, fromDir, ao.getVars());
    }

    File addImageLinks(AlbumObject ao, File outputDir, File fromDir, Scope vars) throws IOException {
        Object thumbPath;
        Object imagePath;
        File representingFile;
        File file = ao.getFile();
        Includes includes = this.getIncludes(ao);
        Path rel = fromDir.toPath();
        Path base = outputDir.toPath();
        Path slides = base.resolve(this.slideDirectory);
        if (this.isLinkInternally(ao)) {
            Path translatedTarget = this.translate(((LinkAlbumObject)ao).getTarget().getPath());
            vars.put("targetPath", (Object)IO.webPath(translatedTarget, rel));
            base = translatedTarget.getParent();
            file = ((LinkFile)file).getTarget();
        }
        Path thumbs = base.resolve(this.thumbDirectory);
        Path closeups = base.resolve(this.closeupDirectory);
        Object closeupPath = null;
        String originalPath = null;
        String videoPath = null;
        String iconPath = null;
        String resPath = this.resDir != null ? IO.relativePath(this.resDir, fromDir) : IO.webPath(base.resolve(GIFS_DIR), rel);
        String targetURL = null;
        File repFile = ao.getRepresentingImageFile();
        Targets targets = Targets.of(ao);
        if (ao.isFolder()) {
            closeupPath = this.isLinkInternally(ao) ? IO.webPath(this.translate(((LinkAlbumObject)ao).getTarget().getPath()).resolve(this.getJAlbumWeb()), rel) : IO.webPath(base.resolve(ao.getName()).resolve(this.getJAlbumWeb()), rel);
            representingFile = ao.getRepresentingImageFile();
            if (representingFile != null) {
                if (this.folderThumbDim != null) {
                    thumbPath = imagePath = IO.webPath(thumbs.resolve(this.getTargetThumbName(file)), rel);
                } else {
                    AlbumObject rep = ao.getRepresentingAlbumObject();
                    if (rep == null) {
                        rep = ao;
                    }
                    targets = Targets.of(rep);
                    base = this.translate(rep.getPath().getParent());
                    representingFile = LinkFile.targetOf(representingFile);
                    thumbPath = IO.webPath(base.resolve(this.thumbDirectory).resolve(targets.thumb), rel);
                    imagePath = IO.webPath(base.resolve(this.slideDirectory).resolve(targets.closeup), rel);
                }
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                if (representingFile == null) {
                    throw new RuntimeException("null representing file for " + String.valueOf(file));
                }
                IO.copyFile(representingFile, this.resDir, false);
                imagePath = resPath + "/" + representingFile.getName();
                iconPath = imagePath;
                thumbPath = imagePath;
            }
        } else if (!AlbumBean.isSupportedImage(file)) {
            originalPath = videoPath = IO.webPath(this.getOriginalPath(ao), rel);
            closeupPath = videoPath;
            if (this.slideTemplate != null) {
                closeupPath = IO.webPath(slides.resolve(IO.baseName(file) + this.pageExtension), rel);
            }
            if (repFile != null && repFile.exists()) {
                thumbPath = IO.webPath(thumbs.resolve(targets.thumb), rel);
                imagePath = IO.webPath(closeups.resolve(targets.closeup), rel);
                representingFile = repFile;
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                if (ao.getFactory().isForAlbumMaking()) {
                    this.resDir.mkdirs();
                    IO.copyFile(representingFile, this.resDir, false);
                }
                imagePath = resPath + "/" + representingFile.getName();
                iconPath = imagePath;
                thumbPath = imagePath;
            }
        } else {
            thumbPath = IO.webPath(thumbs.resolve(this.getTargetThumbName(file)), rel);
            representingFile = repFile != null && repFile.exists() ? repFile : file;
            boolean hasSlide = this.slideTemplate != null;
            String scaled = IO.webPath(closeups.resolve(this.getTargetName(file)), rel);
            String original = IO.webPath(this.getOriginalPath(ao), rel);
            if (includes.original && !includes.closeup) {
                imagePath = original;
            } else {
                imagePath = scaled;
                if (includes.original) {
                    originalPath = original;
                }
            }
            closeupPath = hasSlide ? IO.webPath(slides.resolve(targets.base + this.pageExtension), rel) : imagePath;
        }
        if (ao.getCategory() == Category.webLocation) {
            WebLocation wl = new WebLocation(ao.getFile());
            originalPath = null;
            targetURL = wl.getURI().toASCIIString();
            closeupPath = targetURL;
            vars.put("targetURL", (Object)targetURL);
        }
        vars.put("thumbPath", thumbPath);
        if (iconPath != null) {
            vars.put("iconPath", (Object)iconPath);
        }
        vars.put("closeupPath", closeupPath);
        vars.put("imagePath", imagePath);
        vars.putNotNull("imageSrcset", ImageRenderer.buildSrcset((List)vars.get("imageRenditions"), (String)imagePath));
        vars.putNotNull("thumbSrcset", ImageRenderer.buildSrcset((List)vars.get("thumbRenditions"), (String)thumbPath));
        File audioClip = ao.getAttachments().get(Attachments.Type.AUDIO);
        if (audioClip != null) {
            vars.put("audioClipPath", (Object)IO.webPath(closeups.resolve(audioClip.getName()), rel));
        }
        if (AlbumBean.isSupportedImage(file)) {
            vars.put("contentPath", imagePath);
        } else {
            vars.put("contentPath", (Object)originalPath);
        }
        if (ao.getCategory() == Category.webLocation) {
            vars.put("contentPath", (Object)targetURL);
        }
        if (originalPath != null) {
            vars.put("originalPath", (Object)originalPath);
        }
        if (videoPath != null & ao.getCategory() == Category.video) {
            vars.put("videoPath", (Object)videoPath);
        }
        vars.put("representingFile", (Object)representingFile);
        return representingFile;
    }

    public String getJAlbumVersion() {
        return "39";
    }

    public void addGlobals(Map vars, boolean fullPreparation) {
        Dimension ftd;
        vars.put("generator", "jAlbum 39");
        vars.put("internalVersion", AlbumBean.getInternalVersion());
        vars.put("softwareVersion", new VersionNumber(AlbumBean.getInternalVersion()));
        vars.put("skinName", this.getSkin());
        vars.put("skinVersion", this.getSkinProperties().getVersion());
        vars.put("styleFile", STYLES_FILE);
        vars.put("skin", this.skin);
        vars.put("currentYear", Year.now().getValue());
        if (this.style != null) {
            vars.put("style", this.style);
        }
        vars.put("maxImageWidth", this.imageDim.width);
        vars.put("maxImageHeight", this.imageDim.height);
        vars.put("maxThumbWidth", this.thumbDim.width);
        vars.put("maxThumbHeight", this.thumbDim.height);
        try {
            ftd = AlbumBean.parseSize(this.folderThumbSize);
        }
        catch (IllegalArgumentException ex) {
            ftd = this.thumbDim;
        }
        vars.put("maxFolderThumbWidth", ftd.width);
        vars.put("maxFolderThumbHeight", ftd.height);
        vars.put("processFolderThumbs", this.processFolderThumbs);
        this.setProcessFolderThumbs(this.isProcessFolderThumbs());
        vars.put("rows", this.rows);
        vars.put("cols", this.cols);
        vars.put("engine", this);
        vars.put("albumEngine", this);
        vars.put("ctx", this.context);
        vars.put("window", this.context.getFrame());
        vars.put("context", this.context);
        vars.put("licenseManager", this.getLicenseManager());
        vars.put("excludeBacklinks", this.excludeBacklinks);
        vars.put("homepageAddress", this.homepageAddress);
        vars.put("homepageLinkText", this.homepageLinkText);
        if (this.context.getFrame() != null) {
            vars.put("explorer", this.context.getFrame().albumExplorer.explorer);
            vars.put("selectedObjects", this.context.getFrame().albumExplorer.explorer.listSelectedAlbumObjects());
        }
        vars.put("rootFolder", this.root);
        vars.put("album", this.album);
        vars.put("application", application);
        vars.put("programDirectory", this.cfg.progDir.getAbsoluteFile());
        vars.put("skinDirectory", this.skinDir);
        vars.put("rootImageDirectory", this.rootImageDir);
        vars.put("rootOutputDirectory", this.rootOutputDir);
        vars.put("widgetJavaScript", this.getWidgetInjectionCode(DEFAULT_INDEX_PAGE_NAME, ".", false));
        if (this.resDir != null) {
            vars.put("resDirectory", this.resDir);
        }
        if (this.srcResDir != null) {
            vars.put("skinResDirectory", this.srcResDir);
        }
        vars.put("currentDate", this.df.format(new Date()));
        int tf = this.totalFiles;
        if (this.updatedDirsOnly && this.root != null && fullPreparation) {
            try {
                tf = JAlbumUtilities.countCategories(this.root).getFileCount();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        vars.put("executedNormally", false);
        vars.put("totalAlbumImages", tf);
        vars.put("textEncoding", this.writeUTF8 ? "UTF-8" : this.textEncoding);
        this.addInternationalTexts(vars);
        vars.put("generatorUrl", JAlbumSite.getInstance().getGeneratorUrl((Locale)vars.get("localeObject")));
        if (this.root != null) {
            AlbumObjectProperties props = this.root.getProperties();
            String title = (String)props.get("title");
            if (title == null || title.length() == 0) {
                title = this.root.getName();
            }
            vars.put("albumTitle", title);
            vars.put("albumDescription", this.root.getComment());
            if (props.containsKey("tags")) {
                vars.put("albumTags", props.get("tags"));
            }
            if (!this.getLicenseManager().isLicenseValid()) {
                Set cancelledPromotions;
                String promotion = (String)props.get("promotion");
                if (promotion != null && (cancelledPromotions = (Set)JAlbum.getGlobal("cancelledPromotions")) != null && cancelledPromotions.contains(promotion)) {
                    props.remove("promotion");
                    props.save(true);
                    promotion = null;
                }
                if (promotion == null && (promotion = JAlbumSite.getPromotion()).length() > 0) {
                    props.put("promotion", promotion);
                }
            } else {
                props.remove("promotion");
            }
        }
        vars.putAll(this.skinVariables);
        vars.putAll(this.userVariables);
        if (!this.excludeBacklinks) {
            vars.put("creditText", this.getCreditText().toString());
        }
        if (this.root != null && this.root.getProperties().containsKey("promotion")) {
            vars.put("excludeBacklinks", true);
            vars.remove("creditText");
        }
    }

    String readEmbeddedComment(AlbumObject ao) {
        Metadata metadata;
        String comment = null;
        if (this.jpegComment) {
            try {
                ImageInfo ii = this.getImageInfo(ao.getFile());
                Object jpegComment = "";
                int ncomm = ii.getNumberOfComments();
                for (int i = 0; i < ncomm; ++i) {
                    if (i > 0) {
                        jpegComment = (String)jpegComment + ", ";
                    }
                    jpegComment = (String)jpegComment + ii.getComment(i);
                }
                if (AlbumBean.exists((String)jpegComment) && !AlbumBean.isCopyright((String)jpegComment)) {
                    return jpegComment;
                }
            }
            catch (IOException ii) {
                // empty catch block
            }
        }
        if ((this.iptcCaption || this.exifImageDescription || this.exifUserComment) && (metadata = ao.getMetadata().metadata) != null) {
            ExifSubIFDDirectory exifDir;
            ExtendedExifDescriptor desc;
            if (this.iptcCaption && metadata.containsDirectoryOfType(IptcDirectory.class)) {
                String iptcComment;
                Directory directory = metadata.getFirstDirectoryOfType(IptcDirectory.class);
                StringValue sv = directory.getStringValue(632);
                String string = sv != null ? (sv.getCharset() != null ? sv.toString() : sv.toString(Charset.forName(this.getTextEncoding()))) : (iptcComment = null);
                if (AlbumBean.exists(iptcComment) && !AlbumBean.isCopyright(iptcComment)) {
                    return iptcComment;
                }
            }
            if (this.exifUserComment && metadata.containsDirectoryOfType(ExifSubIFDDirectory.class) && AlbumBean.exists(comment = (desc = new ExtendedExifDescriptor((Directory)(exifDir = (ExifSubIFDDirectory)metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class)))).getUserCommentDescription())) {
                return comment;
            }
            if (this.exifImageDescription && metadata.containsDirectoryOfType(ExifIFD0Directory.class)) {
                String c;
                ExifIFD0Directory exifIDF0Dir = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                ExifIFD0Descriptor desc2 = new ExifIFD0Descriptor(exifIDF0Dir);
                comment = desc2.getWindowsCommentDescription();
                if (!AlbumBean.exists(comment) && !AlbumBean.isCopyright(c = exifIDF0Dir.getString(270, this.textEncoding))) {
                    comment = c;
                }
                if (AlbumBean.exists(comment)) {
                    return comment;
                }
            }
        }
        return "";
    }

    private void addInternationalTexts(Map vars) {
        try {
            Locale locale = this.skinVariables.containsKey("language") && !"jalbum".equalsIgnoreCase((String)this.skinVariables.get("language")) ? new Locale((String)this.skinVariables.get("language"), "") : Locale.getDefault();
            vars.put("localeObject", locale);
            SmartResourceBundle texts = null;
            try {
                texts = SmartResourceBundle.getBundle(new File(this.skinDir, "texts"), "texts", locale);
            }
            catch (MissingResourceException ex) {
                texts = SmartResourceBundle.getBundle(this.skinDir, "texts", locale);
            }
            for (String k : texts.getKeys()) {
                vars.put("text." + k, texts.getString(k));
            }
            vars.put("texts", texts);
            vars.put("text", texts);
        }
        catch (MissingResourceException ex) {
            JAlbum.logger.fine(ex.toString());
        }
    }

    private static boolean isCopyright(String s) {
        return s != null && (s.startsWith("ACD Systems Digital Imaging") || s.startsWith("LEAD Technologies") || s.startsWith("AppleMark") || s.startsWith("Intel(R) JPEG Library") || s.startsWith("Created with The GIMP") || s.startsWith("ASCII") || s.startsWith("OLYMPUS DIGITAL CAMERA") || s.startsWith("KONICA MINOLTA") || s.startsWith("File written by Adobe Photoshop"));
    }

    public void registerVariables(File file, File outputDir) throws IOException, javax.script.ScriptException {
        AlbumObject ao = this.getFactory().createInstance(file);
        this.registerVariables(ao, outputDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerVariables(AlbumObject ao, File outputDir, boolean calculateSizes) throws IOException, javax.script.ScriptException {
        try (Profiler.Sample _s = Profiler.profile();){
            Orientation orientation;
            Scope vars;
            block43: {
                String fileName;
                File file;
                block42: {
                    if (((AlbumObjectImpl)ao).peekVars() != null) {
                        return;
                    }
                    file = ao.getFile();
                    vars = new Scope(this.globalVariables).name("Album Object");
                    ao.setVars(vars);
                    vars.put("currentObject", (Object)ao);
                    vars.put("current", (Object)vars);
                    vars.put("pageType", (Object)(switch (ao.getCategory()) {
                        case Category.folder -> DEFAULT_INDEX_PAGE_NAME;
                        case Category.webPage -> "page";
                        default -> "slide";
                    }));
                    vars.put("fileCategory", (Object)ao.getCategory());
                    vars.put("local", (Object)vars.getMap());
                    vars.put("currentFile", (Object)file);
                    vars.put("comment", (Object)ao.getComment());
                    vars.put("fileTitle", (Object)ao.getTitle());
                    fileName = file.getName();
                    VideoProcessor vp = this.getVideoProcessor();
                    if (vp.isFormatSupported(file)) {
                        fileName = ao.isIncludeOriginal() ? ao.getName() : vp.getOutputVideoFile(file, outputDir).getName();
                    }
                    vars.put("fileName", (Object)fileName);
                    vars.put("fileDate", (Object)new FormattedDate(file.lastModified(), this.df));
                    vars.put("addedDate", (Object)new FormattedDate(ao.getWhenAdded(), this.df));
                    vars.put("addedDateRSS", (Object)this.mediaRssDf.format(new Date(ao.getWhenAdded())));
                    vars.put("fileDateRSS", (Object)this.mediaRssDf.format(new Date(file.lastModified())));
                    vars.put("rating", (Object)ao.getRating());
                    vars.put("flag", (Object)ao.getFlag());
                    XmpManager xmp = ao.getXmpManager();
                    if (xmp != null && ao.getCategory() == Category.image) {
                        try {
                            String from = xmp.getJAlbumProperty("from");
                            if (from == null) break block42;
                            AlbumBean albumBean = this;
                            synchronized (albumBean) {
                                this.contributors.add(from);
                            }
                        }
                        catch (XMPException from) {
                            // empty catch block
                        }
                    }
                }
                if (!ao.isFolder()) {
                    vars.put("fileSize", (Object)file.length());
                    vars.put("label", (Object)IO.baseName(fileName));
                    FileFilters.FileType ft = FileFilters.getFileType(file);
                    if (ft != null) {
                        vars.put("typeName", (Object)ft.name);
                        if (ft.mimeType != null) {
                            vars.put("mimeType", (Object)ft.mimeType);
                        }
                    }
                } else {
                    vars.put("folder", (Object)true);
                    vars.put("label", (Object)fileName);
                }
                if (ao.getCategory() == Category.webPage) {
                    this.assertPageUpdated(ao);
                    Interpreter i = new Interpreter();
                    NameSpace ns = i.getNameSpace();
                    ns.importPackage("se.datadosen.jalbum");
                    ns.importPackage("se.datadosen.util");
                    ns.importPackage("se.datadosen.component");
                    String doc = IO.readTextFile(LinkFile.getResolvedTarget(ao));
                    try {
                        Element elem = Elements.getElementByName("ja:ui", doc, false);
                        if (elem == null || !"ja:ui".equals(elem.getName())) break block43;
                        AlbumBean.setVars((Map<String, Object>)vars, i);
                        Object ret = i.eval(elem.getContent().toString());
                        if (ret instanceof Class) {
                            JComponent customUI = (JComponent)((Class)ret).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (customUI instanceof JAlbumPlugin) {
                                ((JAlbumPlugin)((Object)customUI)).init(this.context.getPluginContext());
                            }
                            if (customUI instanceof EditListener) {
                                ((EditListener)((Object)customUI)).setAlbumObject(ao);
                            }
                            if (customUI instanceof EditListener2) {
                                ((EditListener2)((Object)customUI)).saveState();
                            }
                            break block43;
                        }
                        throw new EvaluationException("Content of ja:ui element not evaluating to a class declaration");
                    }
                    catch (EvalError e) {
                        throw new javax.script.ScriptException(e.getMessage(), e.getErrorSourceFile(), e.getErrorLineNumber());
                    }
                    catch (ReflectiveOperationException | javax.script.ScriptException | EvaluationException | ElementException ex) {
                        throw new RuntimeException("Custum UI scripting error", ex);
                    }
                }
            }
            ao.getRepresentingImageFile();
            this.addProperties(ao, vars);
            if (vars.containsKey("videoDuration")) {
                TimeCode videoDuration = (TimeCode)vars.get("videoDuration");
                TimeCode videoClipLength = (TimeCode)vars.get("videoClipLength");
                TimeCode clipLength = videoClipLength != null ? videoClipLength : videoDuration;
                vars.put("clipLength", (Object)clipLength.toShortString());
            }
            if (this.metaData) {
                try {
                    this.addImageInfo(ao, vars);
                }
                catch (MetadataException | ArrayIndexOutOfBoundsException ex) {
                    System.err.println(ex);
                }
            }
            try {
                orientation = ao.getOrientation();
                vars.put("orientation", (Object)orientation);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.err.println("For file " + String.valueOf(ao));
                ex.printStackTrace(System.err);
                orientation = Orientation.normal;
            }
            this.addUserVariables(ao, vars);
            if (calculateSizes) {
                this.addFilteredImageSizes(ao, orientation);
            }
            this.addImageLinks(ao, outputDir, outputDir);
            AlbumObject rep = ao.getRepresentingAlbumObject();
            if (rep == null) {
                rep = ao;
            }
            FileFilters.BasicImageInfo info = rep.getImageInfo();
            int originalWidth = info.width;
            int originalHeight = info.height;
            vars.put("formatName", (Object)info.formatName);
            vars.put("originalWidth", (Object)originalWidth);
            vars.put("originalHeight", (Object)originalHeight);
            if (vars.containsKey("mostphotosImageId")) {
                vars.put("buyImageUrl", (Object)MessageFormat.format(JAlbumSite.getInstance().getBuyImageUrl(), vars.get("mostphotosImageId").toString()));
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Error processing " + String.valueOf(ao.getFile()), ex);
        }
    }

    private void addProperties(AlbumObject ao, Scope vars) {
        AlbumObjectProperties properties = ao.getProperties();
        File file = ao.getFile();
        for (String key : properties.keySet()) {
            vars.put(key, properties.get(key));
        }
        if (ao.isFolder() && !this.getSkinProperties().isSeparateDescription()) {
            vars.put("description", (Object)ao.getComment());
        }
        String title = ao.getTitle();
        vars.put("title", (Object)title);
        vars.put(ao.isFolder() ? "folderTitle" : "fileTitle", (Object)title);
        if (title == null || title.length() <= 0) {
            vars.put("title", (Object)(ao.isFolder() ? file.getName() : IO.baseName(file.getName())));
        }
    }

    private void addUserVariables(AlbumObject ao, Scope vars) {
        AlbumObjectProperties props = ao.getProperties();
        Map userVars = (Map)props.get("userVariables");
        if (userVars != null) {
            if (this.slideModel != null) {
                this.setDataTypes(userVars, this.slideModel, false);
            }
            vars.putAll(userVars);
        }
    }

    private Collection<AlbumObject> registerVariables(AlbumObject[] objects, File outputDir) {
        ArrayList<AlbumObject> errorObjects = new ArrayList<AlbumObject>();
        bigPool.process(Arrays.asList(objects), str -> str.forEach(ao -> {
            try {
                this.registerVariables((AlbumObject)ao, outputDir, true);
            }
            catch (IOException | UncheckedIOException | javax.script.ScriptException t) {
                t.printStackTrace(System.err);
                Collection collection = errorObjects;
                synchronized (collection) {
                    errorObjects.add((AlbumObject)ao);
                }
                this.fireErrorOccured(t, (AlbumObject)ao);
            }
        }));
        return errorObjects;
    }

    public void processScript(File f) throws IOException, javax.script.ScriptException {
        if (this.globalVariables == null) {
            this.globalVariables = new Scope();
            this.addGlobals(this.globalVariables, false);
        }
        this.processScript(f, this.globalVariables);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processScript(File f, Bindings vars) throws IOException, javax.script.ScriptException {
        if (!f.exists()) return;
        ScriptLanguage lang = ScriptLanguage.extensionOf(IO.extensionOf(f));
        ScriptEngine scriptEngine = null;
        try {
            if (this.scriptEnginePool == null) {
                this.initInterpreter();
            }
            if ((scriptEngine = this.scriptEnginePool.get(lang)) == null) {
                throw new RuntimeException("AAAAA it's null");
            }
            ScriptExceptions.pushFileName(f, scriptEngine);
            if (scriptEngine instanceof Compilable && !(scriptEngine instanceof BshScriptEngine)) {
                CompiledScript cs;
                Pair<Long, CompiledScript> cached = this.compiledScriptCache.get(f);
                if (cached == null || (Long)cached.getKey() < f.lastModified()) {
                    String content = IO.readTextFile(f);
                    if (JAlbum.logger.isLoggable(Level.FINE)) {
                        System.out.println("Compiling " + String.valueOf(f));
                    }
                    try (Profiler.Sample _s = Profiler.profile("Compiling script");){
                        cs = ((Compilable)((Object)scriptEngine)).compile(content);
                    }
                    this.compiledScriptCache.put(f, (Pair<Long, CompiledScript>)new Pair((Object)f.lastModified(), (Object)cs));
                } else {
                    cs = (CompiledScript)cached.getValue();
                    if (JAlbum.logger.isLoggable(Level.FINER)) {
                        System.out.println("Cache hit for " + String.valueOf(f));
                    }
                }
                this.processExpression(cs, vars, scriptEngine);
            } else {
                String content = IO.readTextFile(f);
                this.processExpression(content, vars, scriptEngine);
            }
            if (scriptEngine == null) return;
        }
        catch (javax.script.ScriptException ex) {
            try {
                throw ScriptException.of(ex, f, ex.getLineNumber());
            }
            catch (Throwable throwable) {
                if (scriptEngine == null) throw throwable;
                ScriptExceptions.popFileName(scriptEngine);
                throw throwable;
            }
        }
        ScriptExceptions.popFileName(scriptEngine);
        return;
    }

    @Deprecated
    public void processBeanShellFile(File f) throws ElementException, IOException {
        this.processBeanShellFile(f, this.globalVariables);
    }

    @Deprecated
    void processBeanShellFile(File f, Scope vars) throws ElementException, IOException {
        if (f.exists()) {
            String content = IO.readTextFile(f);
            ScriptEngine scriptEngine = this.scriptEnginePool.get(ScriptLanguage.BEANSHELL);
            try {
                ScriptExceptions.pushFileName(f, scriptEngine);
                this.processExpression(content, (Bindings)vars, scriptEngine);
            }
            catch (javax.script.ScriptException ex) {
                throw new ElementException(ex);
            }
            finally {
                ScriptExceptions.popFileName(scriptEngine);
            }
        }
    }

    Object processExpression(String expr, ScriptEngine scriptEngine) throws javax.script.ScriptException {
        return this.processExpression(expr, (Bindings)this.evaluator.getScope(), scriptEngine);
    }

    Object processExpression(String expr, Bindings vars, ScriptEngine scriptEngine) throws javax.script.ScriptException {
        AlbumBean.setVars((Map<String, Object>)vars, scriptEngine);
        return this.doProcessExpression(expr, scriptEngine);
    }

    Object doProcessExpression(String expr, ScriptEngine scriptEngine) throws javax.script.ScriptException {
        Profiler.Sample _s = Profiler.profile("Process expression");
        try {
            if (JAlbum.logger.isLoggable(Level.FINEST)) {
                System.out.println("-------------------------");
                System.out.println("Evaluating expression: ");
                System.out.println(expr);
                System.out.println("-------------------------");
            }
            Object object = scriptEngine.eval(expr);
            if (_s != null) {
                _s.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (_s != null) {
                    try {
                        _s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (javax.script.ScriptException ex) {
                if (ex.getCause() instanceof OperationAbortedException) {
                    throw (OperationAbortedException)ex.getCause();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                System.err.println("Encountering " + String.valueOf(ex) + " when evaluating: " + expr);
                throw ex;
            }
        }
    }

    private Object processExpression(CompiledScript script, Bindings vars, ScriptEngine scriptEngine) throws javax.script.ScriptException {
        Profiler.Sample _s = Profiler.profile("Process compiled expression");
        try {
            Object ret;
            AlbumBean.setVars((Map<String, Object>)vars, scriptEngine);
            Object object = ret = script.eval();
            if (_s != null) {
                _s.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (_s != null) {
                    try {
                        _s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (javax.script.ScriptException ex) {
                if (ex.getCause() instanceof OperationAbortedException) {
                    throw (OperationAbortedException)ex.getCause();
                }
                throw ex;
            }
            catch (RuntimeException ex) {
                System.err.println("Encountering " + String.valueOf(ex) + " when evaluating: " + String.valueOf(script));
                throw ex;
            }
        }
    }

    @Deprecated
    public int countFiles(File dir) throws IOException {
        return this.countFiles(dir, new LinkedHashSet<File>());
    }

    private int countFiles(File dir, LinkedHashSet<File> visited) throws IOException {
        int counter = 0;
        if (visited.contains(dir = LinkFile.targetOf(dir))) {
            throw new CircularFolderReferenceException(dir, visited);
        }
        visited.add(dir);
        FileCollection fc = new FileCollection(this, dir);
        Collection<File> filesDirs = fc.listFiles(new AlbumFileFilter(this));
        if (filesDirs == null) {
            visited.remove(dir);
            return 0;
        }
        for (File filesDir : filesDirs) {
            if (filesDir.isDirectory()) {
                if (!this.subdirs) continue;
                counter += this.countFiles(filesDir, visited);
                continue;
            }
            ++counter;
        }
        visited.remove(dir);
        return counter;
    }

    private long countTotalFiles(AlbumObject folder, File outputDir) throws IOException {
        try (Profiler.Sample _s = Profiler.profile();){
            if (this.subdirs && !this.updatedDirsOnly) {
                TreeCollection tc = new TreeCollection(folder, EnumSet.of(IncludeOption.EXCLUDED_FILES, IncludeOption.HIDDEN));
                tc.ordered(false);
                long l = bigPool.process(tc, str -> str.filter(ao -> Category.webPage != ao.getCategory()).filter(ao -> ao.isIncluded() || ao.getParent().getRepresentingAlbumObject() == ao).filter(ao -> !ao.isFolder() || this.folderThumbDim != null).count());
                return l;
            }
            long l = this.countTotalFiles(folder, outputDir, new LinkedHashSet<File>());
            return l;
        }
    }

    private int countTotalFiles(AlbumObject folder, File outputDir, LinkedHashSet<File> visited) throws IOException {
        int counter = 0;
        if (visited.contains(folder.getFile())) {
            throw new CircularFolderReferenceException(folder.getFile(), visited);
        }
        visited.add(folder.getFile());
        for (AlbumObject ao : folder.getChildren(false)) {
            Category cat = ao.getCategory();
            if (cat == Category.webPage || !ao.isIncluded() && ao.getParent().getRepresentingAlbumObject() != ao) continue;
            if (ao.isFolder()) {
                File outputSubDir = new File(outputDir, ao.getName());
                if (this.subdirs && this.needsToProcessDir(ao, outputSubDir)) {
                    counter += this.countTotalFiles(ao, outputSubDir, visited);
                }
                if (this.folderThumbDim == null) continue;
                ++counter;
                continue;
            }
            ++counter;
        }
        visited.remove(folder.getFile());
        return counter;
    }

    void quickInit() throws IOException, OperationAbortedException, javax.script.ScriptException {
        this.prepareMakeAlbum(false, false);
    }

    public void init() throws IOException, OperationAbortedException, javax.script.ScriptException {
        this.prepareMakeAlbum(false);
    }

    @Unbound
    public boolean isDirty() {
        try {
            this.init();
        }
        catch (IOException | javax.script.ScriptException | OperationAbortedException ex) {
            throw new RuntimeException(ex);
        }
        ProjectSettings last = (ProjectSettings)this.root.getProperties().get("projectSettings");
        if (last == null) {
            return true;
        }
        return !new ProjectSettings(this).unionEquals(last);
    }

    @Override
    public MakeResult makeAlbum() throws IllegalArgumentException, IOException, OperationAbortedException, ElementException, javax.script.ScriptException {
        return this.makeAlbum(false);
    }

    @Override
    public MakeResult smartMakeAlbum() throws IllegalArgumentException, IOException, OperationAbortedException, ElementException, javax.script.ScriptException {
        return this.makeAlbum(true);
    }

    AlbumObjectProperties getProjectProperties() {
        if (this.currentProject != null && this.currentProject.getRootFolder() != null) {
            return this.currentProject.getRootFolder().getProperties();
        }
        return this.root.getProperties();
    }

    private boolean isSkinOrStyleChanged() {
        AlbumObjectProperties props = this.getProjectProperties();
        ProjectSettings settings = (ProjectSettings)props.get("projectSettings");
        if (settings != null) {
            return !this.skin.equals(settings.main.get("skin")) || !this.style.equals(settings.main.get("style"));
        }
        return false;
    }

    private boolean isNoLongerIncludeOriginals() {
        AlbumObjectProperties props = this.getProjectProperties();
        ProjectSettings settings = (ProjectSettings)props.get("projectSettings");
        if (settings != null) {
            return "true".equals(settings.main.get("includeOriginals")) && !this.isIncludeOriginals();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MakeResult makeAlbum(boolean smart) throws IllegalArgumentException, IOException, OperationAbortedException, ElementException, javax.script.ScriptException {
        Profiler.getInstance().reset();
        this.stopwatch.reset();
        this.stopwatch.start();
        this.smartMake = smart;
        boolean restart = false;
        boolean imageSettingsChanged = false;
        do {
            try {
                File framesetFile;
                ProjectSettings projectSettings = new ProjectSettings(this);
                this.scriptLanguage = this.resolveScriptLanguage(AlbumBean.resolveScriptFile(this.skinDir, "init"));
                if (this.onMakeStarted != null) {
                    this.onMakeStarted.run();
                }
                this.prepareMakeAlbum(true);
                Tracer.getInstance().trace("make album", "skin:" + this.getSkin(), "style:" + this.getStyle());
                AlbumObjectProperties lastProps = this.getProjectProperties();
                lastProps.reload();
                this.lastMadeDate = lastProps.get("lastMadeDate", 0L);
                this.imageSettingsHash = this.getImageSettingsHash(EnumSet.of(ImageCategory.ALL, ImageCategory.CLOSEUP, ImageCategory.THUMBNAIL));
                this.lastImageSettingsHash = lastProps.get("imageSettingsHash", "");
                this.folderThumbSettingsHash = this.getImageSettingsHash(EnumSet.of(ImageCategory.FOLDER_THUMB));
                this.lastVideoSettingsHash = lastProps.get("videoSettingsHash", "");
                this.videoSettingsHash = this.getVideoProcessor().getVideoSettingsHash();
                imageSettingsChanged = !this.imageSettingsHash.equals(this.lastImageSettingsHash);
                boolean forcedMakeAll = false;
                if (smart || !this.isAppendImages()) {
                    lastProps.put("imageLinking", this.getImageLinking());
                    lastProps.save(true);
                    if (smart) {
                        if (imageSettingsChanged) {
                            this.setAppendImages(false);
                            forcedMakeAll = true;
                        } else {
                            this.setAppendImages(true);
                        }
                    }
                }
                if (this.totalFiles > 100 && Config.getConfig().isShowWarnings()) {
                    ProjectSettings lastProjectSettings = (ProjectSettings)lastProps.get("projectSettings");
                    if ((forcedMakeAll || smart && !lastProjectSettings.imageRelated().equals(projectSettings.imageRelated())) && this.rootOutputDir.exists() && new FileTreeCollection(this.rootOutputDir).stream().limit(10L).count() == 10L) {
                        this.fireRequestConfirmation(Msg.get("ui.lengthyMakeAllWarning", this.totalFiles));
                    }
                }
                this.fireAlbumMakingStarted(this.isAppendImages());
                boolean slideFiltersApplied = false;
                for (JAFilterNode fn : this.filters) {
                    switch (fn.getStage()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            slideFiltersApplied = true;
                        }
                    }
                }
                if (slideFiltersApplied && LINK_ORIGINALS.equals(this.getImageLinking())) {
                    this.fireWarning(Msg.get("ui.effectsIgnoredWarning"));
                }
                if (this.currentProject != null) {
                    System.out.println("\n" + Msg.get("ui.makingAlbumStarted", this.currentProject.getName(), this.isAppendImages() ? Msg.get("ui.changes") : Msg.get("ui.all")));
                }
                if (!lastProps.get("transformer", MirrorTransformer.instance).equals(lastProps.get("lastTransformer", MirrorTransformer.instance))) {
                    if (!lastProps.containsKey("transformer")) {
                        lastProps.remove("lastTransformer");
                    } else {
                        lastProps.put("lastTransformer", lastProps.get("transformer"));
                    }
                    lastProps.save(true);
                }
                if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
                    this.frames = true;
                    this.framesetPageName = this.indexPageName;
                    this.indexPageName = this.indexPageName + "-frame";
                }
                try {
                    this.indexAST = new AST(this, this.indexTemplate.toSection(this.globalVariables));
                    if (this.slideTemplate != null) {
                        this.slideAST = new AST(this, this.slideTemplate.toSection(this.globalVariables));
                    }
                    this.makeAlbumForFolder(this.root, this.rootOutputDir, 0);
                    if (this.getJSONMaker() != null && this.getSkinProperties().isMakeDeepJSONData()) {
                        this.getJSONMaker().makeDeepJSONData(this.getOutputDir());
                    }
                    if (this.cfg.isIncludeLifeboatFile()) {
                        File lifeboatFile = new File(this.getOutputDir(), "lifeboat.zip");
                        FileOutputStream fos = new FileOutputStream(lifeboatFile);
                        this.fireStatus(Msg.get("ui.creatingLifeboat") + "...");
                        RecoveryTool.createLifeboat(this.context, this, this.root, fos);
                    }
                    this.globalVariables.put("executedNormally", (Object)true);
                    this.stopwatch.stop();
                    if (this.currentProject != null) {
                        System.out.println(Msg.get("ui.makingAlbumDone", this.currentProject.getName(), this.stopwatch));
                    }
                }
                finally {
                    if (this.frames) {
                        this.frames = false;
                        this.indexPageName = this.framesetPageName;
                        this.framesetPageName = null;
                    }
                    this.processScript(AlbumBean.resolveScriptFile(this.skinDir, "finally"), this.globalVariables);
                    this.processScript(AlbumBean.resolveScriptFile(this.cfg.progDir, "system/finally"), this.globalVariables);
                    lastProps.reload();
                    if (Objects.equals(Boolean.TRUE, this.globalVariables.get("executedNormally"))) {
                        if (!this.isAppendImages()) {
                            lastProps.put("imageSettingsHash", this.imageSettingsHash);
                        }
                        lastProps.put("projectSettings", projectSettings);
                        lastProps.put("folderThumbSettingsHash", this.folderThumbSettingsHash);
                        lastProps.put("videoSettingsHash", this.videoSettingsHash);
                        long now = new Date().getTime();
                        if (!lastProps.containsKey("createdDate")) {
                            lastProps.put("createdDate", now);
                        }
                        lastProps.put("lastMadeDate", now);
                        if (!this.contributors.isEmpty()) {
                            lastProps.put("contributors", this.contributors);
                        } else {
                            lastProps.remove("contributors");
                        }
                        lastProps.save(true);
                    }
                    this.root = null;
                    this.chainedObjects = null;
                    this.currentObjects = null;
                    this.reallyAllObjects = null;
                    this.evaluator = null;
                    this.indexVariables = null;
                    this.fireAlbumMakingDone(Objects.equals(Boolean.TRUE, this.globalVariables.get("executedNormally")));
                }
            }
            catch (OperationRestartedException ex) {
                restart = true;
            }
            finally {
                if (this.threadPool != null) {
                    this.threadPool.shutdown();
                    this.threadPool = null;
                }
            }
        } while (restart);
        if (this.imagesProcessed) {
            return new MakeResult(false);
        }
        return new MakeResult(this.isAppendImages() && imageSettingsChanged);
    }

    @Unbound
    public boolean isMakingAlbum() {
        return this.threadPool != null && !this.threadPool.isShutdown();
    }

    private void makeViews(AlbumObject root) {
        try (Profiler.Sample _s = Profiler.profile("Make views");){
            root.getDescendants().stream().filter(ao -> ao instanceof ViewAlbumObject).forEach(ao -> {
                View view = ((ViewAlbumObject)ao).getView();
                this.fireStatus(Msg.get("ui.preparingName", view.getName()));
                Object transformer = view.getTransformer();
                VirtualFolder viewFolder = new VirtualFolder(ao.getFile(), ao.getParent(), ao.getFactory());
                List<AlbumObject> children = ao.getParent().getChildren();
                int index = children.indexOf(ao);
                children.remove(index);
                try {
                    transformer.transform(((ViewAlbumObject)ao).getViewSource(), viewFolder);
                    viewFolder.reorderAll();
                    if (!viewFolder.getChildren().isEmpty()) {
                        children.add(index, viewFolder);
                    }
                }
                catch (ObjectException ex) {
                    this.fireErrorOccured(ex, (AlbumObject)ao);
                }
                catch (Exception ex) {
                    this.fireErrorOccured(ex, (AlbumObject)ao);
                }
            });
        }
    }

    private void prepareMakeAlbum(boolean fullPreparation) throws IllegalArgumentException, IOException, OperationAbortedException, javax.script.ScriptException {
        this.prepareMakeAlbum(fullPreparation, true);
    }

    private void prepareMakeAlbum(boolean fullPreparation, boolean initInterpreter) throws IllegalArgumentException, IOException, OperationAbortedException, javax.script.ScriptException {
        this.myAssert(this.directory != null, Msg.get("engine.missingDirectoryError"));
        this.myAssert(this.outputDirectory != null, Msg.get("engine.missingOutputDirectoryError"));
        this.myAssert(this.thumbSize != null, Msg.get("engine.missingThumbSizeError"));
        this.myAssert(this.imageSize != null, Msg.get("engine.missingImageSizeError"));
        this.rootOutputDir = null;
        if (this.directory != null && this.directory.length() > 0 || fullPreparation) {
            if (!this.rootImageDir.isDirectory()) {
                throw new NotADirectoryException(Msg.get("engine.notADirectoryError"), this.rootImageDir);
            }
            this.rootOutputDir = this.getOutputDir();
        }
        this.skinProperties = new SkinProperties(this.skinDir);
        this.astCache = new ASTCache();
        this.jsonMaker = null;
        this.album = new PrintSafeHashMap();
        this.df = this.dateFormat != null && !this.dateFormat.isEmpty() ? new SafeSimpleDateFormat(this.dateFormat) : new SafeSimpleDateFormat();
        this.factory = null;
        this.factory = this.getFactory();
        this.factory.setCached(true);
        this.factory.setForAlbumMaking(true);
        this.root = this.factory.createInstance(this.rootImageDir);
        if (initInterpreter) {
            this.initInterpreter();
        }
        this.globalVariables = new Scope().name("Globals");
        this.srcResDir = new File(this.skinDir, "res");
        if (this.srcResDir.exists()) {
            this.resDir = new File(this.rootOutputDir, this.resourceDirectory);
        }
        if (!fullPreparation) {
            this.addGlobals(this.globalVariables, fullPreparation);
            return;
        }
        this.evaluator = new ASTEvaluator(this, this.globalVariables);
        this.addGlobals(this.globalVariables, false);
        this.globalVariables.put("engine", (Object)this);
        this.globalVariables.put("albumEngine", (Object)this);
        this.globalVariables.put("ctx", (Object)this.context);
        this.globalVariables.put("window", (Object)this.context.getFrame());
        this.globalVariables.put("context", (Object)this.context);
        this.globalVariables.put("factory", (Object)this.getFactory());
        this.globalVariables.put("root", (Object)this.root);
        this.makeViews(this.root);
        this.processScript(AlbumBean.resolveScriptFile(this.skinDir, "earlyinit"), this.globalVariables);
        this.setThemeImageProcessor(null);
        if (!this.getLicenseManager().isLicenseValid()) {
            if (this.context.getFrame() == null) {
                System.out.println("*** " + Msg.get("ui.unlicensed") + " ***");
            }
            LimitTransformer lt = new LimitTransformer(24);
            this.root = lt.transform(this.root);
            if (lt.isLimited()) {
                if (this.context.getFrame() == null) {
                    System.err.println("*** " + Msg.get("ui.sizeLimitExceeded") + " ***");
                    System.err.println(Msg.get("ui.sizeLimitExceededInfo", 24));
                } else {
                    FreeVersionDialogs fd = new FreeVersionDialogs(this.context);
                    fd.showOnMake();
                }
            }
        }
        if (!this.rootOutputDir.exists()) {
            IO.createDirectories(this.rootOutputDir.toPath(), new FileAttribute[0]);
        }
        this.srcResDir = new File(this.skinDir, "res");
        if (this.srcResDir.exists()) {
            this.resDir = new File(this.rootOutputDir, this.resourceDirectory);
            if (this.resDir.exists() && this.getSkinProperties().isSet("cleanResFolder") || this.cfg.isCleanOutputFiles() && this.isSkinOrStyleChanged()) {
                try (Profiler.Sample _s = Profiler.profile("Emptying res folder");){
                    IO.emptyDir(this.resDir);
                }
            } else {
                IO.createDirectories(this.resDir.toPath(), new FileAttribute[0]);
            }
        } else {
            this.resDir = null;
            this.srcResDir = new File(this.skinDir, GIFS_DIR);
        }
        if (this.isNoLongerIncludeOriginals()) {
            System.out.println(Msg.get("ui.deletingStaleOriginals"));
            AlbumSynchronizer as = new AlbumSynchronizer(this);
            Work.on(new AlbumObject[]{this.root}).titled(Msg.get("ui.deletingStaleOriginals")).filter(ao -> !ao.isFolder() && !ao.isIncludeOriginal()).forEach(ao -> as.deleteOriginal((AlbumObject)ao));
        }
        this.fireStatus(Msg.get("ui.initializing") + "...");
        this.processedFiles.set(0);
        this.totalFiles = (int)this.countTotalFiles(this.root, this.rootOutputDir);
        this.pageNamer = new StandardPageNamer(this);
        this.fileNamer = new StandardFileNamer();
        this.indexTemplate = new Template(new File(this.skinDir, "index.htt"));
        File slideTemplateFile = new File(this.skinDir, "slide.htt");
        this.slideTemplate = this.slides && slideTemplateFile.exists() && slideTemplateFile.length() > 0L ? new Template(slideTemplateFile) : null;
        this.addGlobals(this.globalVariables, fullPreparation);
        this.setUsing(null);
        this.contributors = new HashSet<String>();
        try (Profiler.Sample _s = Profiler.profile("init");){
            this.processScript(AlbumBean.resolveScriptFile(this.cfg.progDir, "system/init"), this.globalVariables);
            for (File f : AlbumBean.resolveScriptFiles(new File(this.skinDir, "lib"))) {
                this.processScript(f, this.globalVariables);
            }
            this.processScript(AlbumBean.resolveScriptFile(this.skinDir, "init"), this.globalVariables);
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        this.threadPool = Executors.newFixedThreadPool(this.cpuCores, new NamedThreadFactory("Album making"));
        VideoProcessor.setEnabled(true);
        this.getVideoProcessor().resetAbortedState();
        this.imagesProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String makeEmbedCode() throws IOException, javax.script.ScriptException, ParameterException, ElementException {
        this.prepareMakeAlbum(false);
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        try {
            String ret;
            this.threadPool = Executors.newFixedThreadPool(this.cpuCores, new NamedThreadFactory("Album making"));
            AlbumObject[] allObjects = AlbumBean.excludeHidden(AlbumBean.toArray(this.root.getChildren()));
            AlbumObject[] objects = AlbumBean.excludeCategory(allObjects, Category.folder);
            if (!this.subdirs && !this.includeDirectories) {
                allObjects = objects;
            }
            Collection<AlbumObject> errorObjects = this.registerVariables(allObjects, this.rootOutputDir);
            allObjects = this.excludeErrors(allObjects, errorObjects);
            objects = this.excludeErrors(objects, errorObjects);
            this.currentObjects = allObjects;
            String albumURL = (String)this.root.getProperties().get("albumURL");
            if (albumURL == null) {
                throw new IOException("Album not yet uploaded");
            }
            Scope embedVars = new Scope(this.globalVariables).name("Embed");
            embedVars.put("albumWidth", (Object)this.albumWidth);
            embedVars.put("albumHeight", (Object)this.albumHeight);
            embedVars.put("albumURL", (Object)IO.urlEncode(albumURL));
            embedVars.put("files", (Object)AlbumBean.toFileArray(allObjects));
            embedVars.put("totalImages", (Object)objects.length);
            embedVars.put("currentDate", (Object)this.df.format(new Date()));
            File embedFile = new File(this.skinDir, "embed.htt");
            if (!embedFile.exists()) {
                embedFile = new File(this.cfg.progDir, "system/embed.htt");
            }
            this.evaluator = new ASTEvaluator(this, embedVars);
            String string = ret = new AST(this, new Template(embedFile).toSection(embedVars)).eval(this.evaluator, embedVars);
            return string;
        }
        finally {
            this.threadPool.shutdown();
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    private Scope createFolderVars(AlbumObject folder, File outputDir, AlbumObject[] visibleObjects, AlbumObject[] objects, int level) {
        Dimension dim;
        int totalIndexes;
        Scope vars = new Scope(this.globalVariables).name("FolderVars");
        File imageDir = folder.getFile();
        this.imagesPerIndex = this.rows * this.cols;
        if (this.rows == 0) {
            this.imagesPerIndex = 999 * this.cols;
        }
        if ((totalIndexes = (int)Math.ceil((double)visibleObjects.length / (double)this.imagesPerIndex)) == 0) {
            totalIndexes = 1;
        }
        this.addProperties(folder, vars);
        vars.put("level", (Object)level);
        vars.put("imageDirectory", (Object)imageDir);
        vars.put("currentFolder", (Object)folder);
        vars.put("currentObject", (Object)folder);
        vars.put("parentImageDirectory", (Object)(folder.getParent() != null ? folder.getParent() : null));
        vars.put("outputDirectory", (Object)outputDir);
        vars.put("firstIndexPage", (Object)this.encode(this.pageNamer.getIndexName(imageDir, 0)));
        vars.put("lastIndexPage", (Object)this.encode(this.pageNamer.getIndexName(imageDir, totalIndexes - 1)));
        vars.put("files", (Object)AlbumBean.toFileArray(visibleObjects));
        vars.put("currentObjects", (Object)this.currentObjects);
        vars.put("fileVariables", (Object)this.fileVariables);
        vars.put("totalImages", (Object)objects.length);
        vars.put("currentDate", (Object)this.df.format(new Date()));
        vars.put("pageType", (Object)DEFAULT_INDEX_PAGE_NAME);
        vars.put("children", (Object)new Paginator(this, Arrays.asList(this.reallyAllObjects)));
        Locale locale = (Locale)vars.get("localeObject");
        if (locale != null) {
            vars.put("language", (Object)locale.getLanguage());
        }
        Object absolutePath = "";
        if (this.albumAddress.length() > 0 || this.root.getProperties().containsKey("albumURL")) {
            absolutePath = this.albumAddress;
            if (((String)absolutePath).length() == 0) {
                absolutePath = this.root.getProperties().get("albumURL", "");
            }
            if (((String)absolutePath).length() > 0) {
                if (!((String)absolutePath).trim().toLowerCase().startsWith("http")) {
                    absolutePath = "http://" + (String)absolutePath;
                }
                absolutePath = IO.combinePaths((String)absolutePath, folder.getPathFromRoot());
                absolutePath = IO.combinePaths((String)absolutePath, "/");
            }
            vars.put("absolutePath", (Object)this.encode((String)absolutePath));
        }
        if (folder.getParent() != null && !this.frames) {
            String name = (String)folder.getVars().get("indexPage");
            if (name == null) {
                name = this.pageNamer.getIndexName(folder.getParent().getFile(), 0);
            }
            vars.put("parentIndexPage", (Object)("../" + name));
        } else if (this.homepageAddress.length() > 0) {
            vars.put("parentIndexPage", (Object)this.homepageAddress);
        } else {
            String parentWeb = this.getExistingWeb(outputDir.getParentFile());
            if (parentWeb != null) {
                vars.put("parentIndexPage", (Object)("../" + parentWeb));
            }
        }
        if (this.getChainedObjects() != null) {
            vars.putNotNull("previousIndexPage", this.chainedObjects.getPreviousPath(folder, true));
            vars.putNotNull("nextIndexPage", this.chainedObjects.getNextPath(folder, true));
            vars.put("indexNum", (Object)1);
            vars.put("totalIndexes", (Object)1);
        }
        String rootPath = IO.relativePath(this.rootOutputDir, outputDir);
        vars.put("rootPath", (Object)rootPath);
        vars.put("resPath", (Object)(this.resDir != null ? IO.relativePath(this.resDir, outputDir) : GIFS_DIR));
        vars.put("stylePath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) + "/styles.css" : STYLES_FILE);
        if (this.themeImageProcessor != null && (dim = this.themeImageProcessor.getFinalThemeImageDim(folder)) != null) {
            vars.put("themePath", (Object)IO.urlEncode(this.themeImageProcessor.getThemePath(folder)));
            vars.put("themeWidth", (Object)dim.width);
            vars.put("themeHeight", (Object)dim.height);
        }
        this.addUserVariables(folder, vars);
        return vars;
    }

    private void makeIndexPages(AlbumObject folder, File outputDir, AlbumObject[] visibleObjects, Scope folderVars) throws IOException, ElementException, javax.script.ScriptException {
        try (Profiler.Sample _s = Profiler.profile();){
            File framesetFile;
            File imageDir = folder.getFile();
            int totalIndexes = (int)Math.ceil((double)visibleObjects.length / (double)this.imagesPerIndex);
            if (totalIndexes == 0) {
                totalIndexes = 1;
            }
            if (this.skinProperties.isSet("singleIndexPage")) {
                totalIndexes = 1;
            }
            if (this.resDir == null) {
                File styleFile = new File(this.skinDir, "styles/" + this.style);
                if (this.style != null && styleFile.exists()) {
                    this.processTemplateFile(styleFile, new File(outputDir, STYLES_FILE));
                }
            }
            if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
                this.processTemplateFile(framesetFile, new File(outputDir, this.framesetPageName + this.pageExtension));
            }
            Paginator children = new Paginator(this, Arrays.asList(this.reallyAllObjects));
            this.indexNum = 0;
            while (this.indexNum < totalIndexes) {
                TargetPage indexPage = new TargetPage(new File(outputDir, this.pageNamer.getIndexName(imageDir, this.indexNum)));
                this.indexVariables = new Scope(folderVars).name("IndexVars");
                this.indexVariables.put("indexPage", (Object)this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum)));
                this.indexImageCount = Math.min(this.imagesPerIndex, visibleObjects.length - this.indexNum * this.imagesPerIndex);
                this.indexVariables.put("indexImageCount", (Object)this.indexImageCount);
                this.currentRows = (int)Math.ceil((double)this.indexImageCount / (double)this.cols);
                this.indexVariables.put("currentRows", (Object)this.currentRows);
                if (totalIndexes > 1) {
                    this.indexVariables.put("children", (Object)children.page(this.indexNum));
                    this.indexVariables.put("indexNum", (Object)(this.indexNum + 1));
                    this.indexVariables.put("totalIndexes", (Object)totalIndexes);
                    if (this.indexNum > 0) {
                        this.indexVariables.put("previousIndexPage", (Object)this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum - 1)));
                    }
                    if (this.indexNum < totalIndexes - 1) {
                        this.indexVariables.put("nextIndexPage", (Object)this.encode(this.pageNamer.getIndexName(imageDir, this.indexNum + 1)));
                    }
                }
                for (int i = this.indexNum * this.imagesPerIndex; i < visibleObjects.length && i < this.imagesPerIndex * (this.indexNum + 1); ++i) {
                    Scope locals = visibleObjects[i].getVars();
                    locals.setOuter(this.indexVariables);
                    locals.put("imageNum", (Object)(i + 1));
                }
                String indexContent = this.indexAST.eval(this.evaluator, this.indexVariables);
                if (this.mediaRSS && !(folder instanceof VirtualFolder)) {
                    indexContent = this.injectMediaRssCode(indexContent, false);
                }
                if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
                    indexContent = this.injectWidgetCode(indexContent, DEFAULT_INDEX_PAGE_NAME, IO.relativePath(this.rootOutputDir, outputDir));
                }
                indexPage.writeChangesBg(indexContent, this.writeUTF8 ? "UTF-8" : this.textEncoding);
                if (this.mediaRSS && !(folder instanceof VirtualFolder)) {
                    File mediaRSSFile = new File(this.skinDir, mediaRSSPath);
                    if (!mediaRSSFile.exists()) {
                        mediaRSSFile = new File(this.cfg.progDir, "system/album.rss");
                    }
                    if (mediaRSSFile.exists()) {
                        TargetPage mediaRSSPage = new TargetPage(new File(outputDir, mediaRSSPath));
                        try (Profiler.Sample _s2 = Profiler.profile("Create MediaRSS");){
                            Scope rssVars = new Scope(folderVars);
                            rssVars.put("mediarssPath", (Object)mediaRSSPath);
                            rssVars.put("mediarssDate", (Object)this.mediaRssDf.format(new Date(outputDir.lastModified())));
                            ASTEvaluator rssEvaluator = this.evaluator;
                            if (rssEvaluator.getScriptLanguage() != ScriptLanguage.BEANSHELL) {
                                rssEvaluator = new ASTEvaluator(this, ScriptLanguage.BEANSHELL);
                                rssEvaluator.enterScope(this.globalVariables);
                                rssEvaluator.enterScope(folderVars);
                            }
                            rssEvaluator.enterScope(rssVars);
                            String data = new AST(this, new Template(mediaRSSFile).toSection(rssVars)).eval(rssEvaluator);
                            rssEvaluator.exitScope(rssVars);
                            if (rssEvaluator != this.evaluator) {
                                rssEvaluator.exitScope(folderVars);
                                rssEvaluator.exitScope(this.globalVariables);
                            }
                            mediaRSSPage.writeChangesBg(data, Charset.forName("UTF-8"));
                        }
                    }
                } else {
                    new File(outputDir, mediaRSSPath).delete();
                }
                ++this.indexNum;
            }
        }
    }

    private String injectMediaRssCode(String template, boolean slide) {
        int headIndex;
        String path = slide ? "../" : "";
        path = path.concat(mediaRSSPath);
        String injectCode = "<link rel=\"alternate\" href=\"" + path + "\" type=\"application/rss+xml\"" + (AlbumBean.isXHTML((String)template) ? "/>" : ">");
        int i1 = ((String)template).indexOf("</head>");
        int i2 = ((String)template).indexOf("</HEAD>");
        if (i1 < 0) {
            i1 = Integer.MAX_VALUE;
        }
        if (i2 < 0) {
            i2 = Integer.MAX_VALUE;
        }
        if ((headIndex = Math.min(i1, i2)) < Integer.MAX_VALUE) {
            String firstPart = ((String)template).substring(0, headIndex);
            String lastPart = ((String)template).substring(headIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    private String injectWidgetCode(String template, String pageType, String rootPath) {
        int i2;
        String injectCode = this.getWidgetInjectionCode(pageType, rootPath);
        int i1 = ((String)template).lastIndexOf("</body>");
        int bodyIndex = Math.max(i1, i2 = ((String)template).lastIndexOf("</BODY>"));
        if (bodyIndex > 0) {
            String firstPart = ((String)template).substring(0, bodyIndex);
            String lastPart = ((String)template).substring(bodyIndex);
            template = firstPart + injectCode + "\r\n" + lastPart;
        }
        return template;
    }

    public String getWidgetInjectionCode(String pageType, String rootPath) {
        return this.getWidgetInjectionCode(pageType, rootPath, true);
    }

    String getWidgetInjectionCode(String pageType, String rootPath, boolean includeTags) {
        StringBuilder injectionCode = new StringBuilder();
        if (includeTags) {
            injectionCode.append("<div id=\"jalbumwidgetcontainer\"></div>\n");
            injectionCode.append("<script>\n");
        }
        injectionCode.append("_jaSkin = \"");
        injectionCode.append(this.skin);
        injectionCode.append("\";\n");
        injectionCode.append("_jaStyle = \"");
        injectionCode.append(this.style);
        injectionCode.append("\";\n");
        injectionCode.append("_jaVersion = \"");
        injectionCode.append(AlbumBean.getInternalVersion());
        injectionCode.append("\";\n");
        injectionCode.append("_jaGeneratorType = \"");
        injectionCode.append(System.getProperty("generatorType", "desktop"));
        injectionCode.append("\";\n");
        injectionCode.append("_jaLanguage = \"");
        injectionCode.append(Config.getConfig().getInterpretedLanguage());
        injectionCode.append("\";\n");
        injectionCode.append("_jaPageType = \"");
        injectionCode.append(pageType);
        injectionCode.append("\";\n");
        injectionCode.append("_jaRootPath = \"");
        injectionCode.append(rootPath);
        injectionCode.append("\";\n");
        if (this.licenseManager.getUserId() != -1) {
            injectionCode.append("_jaUserId = \"");
            injectionCode.append(this.licenseManager.getUserId());
            injectionCode.append("\";\n");
        } else {
            injectionCode.append("_jaGuid = \"");
            injectionCode.append(JAlbum.getGUID());
            injectionCode.append("\";\n");
        }
        if (includeTags) {
            injectionCode.append("var script = document.createElement(\"script\");\n");
            injectionCode.append("script.type = \"text/javascript\";\n");
            injectionCode.append("script.src = \"http\"+(\"https:\"==document.location.protocol?\"s\":\"\")+\"://jalbum.net/widgetapi/load.js\";\n");
            injectionCode.append("document.getElementById(\"jalbumwidgetcontainer\").appendChild(script);\n");
            injectionCode.append("</script>\n");
        } else {
            injectionCode.append("var jalbumWidgetContainer = document.createElement('div');\n");
            injectionCode.append("jalbumWidgetContainer.setAttribute('id','jalbumwidgetcontainer');\n");
            injectionCode.append("var jalbumWidgetScript = document.createElement(\"script\");\n");
            injectionCode.append("jalbumWidgetScript.type = \"text/javascript\";\n");
            injectionCode.append("jalbumWidgetScript.src = \"http\"+(\"https:\"==document.location.protocol?\"s\":\"\")+\"://jalbum.net/widgetapi/load.js\";\n");
            injectionCode.append("jalbumWidgetScript.async = true;\n");
            injectionCode.append("jalbumWidgetContainer.appendChild(jalbumWidgetScript);\n");
            injectionCode.append("document.body.appendChild(jalbumWidgetContainer);\n");
        }
        return injectionCode.toString();
    }

    private static boolean isXHTML(String doc) {
        int doctypeIndex = doc.indexOf("<!DOCTYPE");
        if (doctypeIndex == -1) {
            return doc.contains("/>");
        }
        int endTagIndex = doc.indexOf(62, doctypeIndex);
        if (endTagIndex == -1) {
            return false;
        }
        return doc.substring(doctypeIndex, endTagIndex).toUpperCase().indexOf("XHTML") > 0;
    }

    static Dimension getThumbDim(Scope locals) {
        return new Dimension((Integer)AlbumBean.interpretDataType(locals.get("maxThumbWidth")), (Integer)AlbumBean.interpretDataType(locals.get("maxThumbHeight")));
    }

    static Dimension getImageDim(Scope locals) {
        return new Dimension((Integer)AlbumBean.interpretDataType(locals.get("maxImageWidth")), (Integer)AlbumBean.interpretDataType(locals.get("maxImageHeight")));
    }

    static Dimension getFolderThumbDim(Scope locals) {
        return new Dimension((Integer)AlbumBean.interpretDataType(locals.get("maxFolderThumbWidth")), (Integer)AlbumBean.interpretDataType(locals.get("maxFolderThumbHeight")));
    }

    private void addFilteredImageSizes(AlbumObject ao, Orientation orientation) throws IOException {
        Dimension newDim;
        AlbumObject rep;
        boolean hasIcon = !ao.isDisplayableImage();
        File repFile = ao.getRepresentingImageFile();
        Scope vars = ao.getVars();
        if (repFile != null) {
            hasIcon = false;
        }
        if ((rep = ao.getRepresentingAlbumObject(true)) == null) {
            rep = ao;
        }
        Dimension closeupDim = newDim = ao.getSize();
        if (rep.getCategory() == Category.video) {
            VideoResolution vr;
            int videoHeight;
            int videoWidth;
            AlbumObjectProperties props = rep.getProperties();
            if (orientation.isRotated()) {
                videoWidth = props.get("videoHeight", newDim.width);
                videoHeight = props.get("videoWidth", newDim.height);
            } else {
                videoWidth = props.get("videoWidth", newDim.width);
                videoHeight = props.get("videoHeight", newDim.height);
            }
            if (!rep.isIncludeOriginal() && (vr = this.getVideoResolution()) != VideoResolution.original && vr != VideoResolution.noProcessing) {
                Dimension scaledDim = GraphicsUtilities.fitWithinBounds(videoWidth, videoHeight, new Dimension(vr.getWidth(), vr.getHeight()));
                videoWidth = scaledDim.width;
                videoHeight = scaledDim.height;
            }
            vars.put("videoWidth", (Object)videoWidth);
            vars.put("videoHeight", (Object)videoHeight);
        }
        ImageRenderer imageRenderer = ao.getRenderer();
        Includes includes = this.getIncludes(ao);
        if (includes.closeup) {
            if (!hasIcon) {
                if (imageRenderer.getCloseupRenditions().size() > 1 && !PhotoSphere.isPhotoSphere(rep)) {
                    vars.put("imageRenditions", (Object)imageRenderer.getCloseupRenditions());
                }
                closeupDim = AlbumBean.getScaledDim(ImageRenderer.getTypical(imageRenderer.getCloseupRenditions()).getSize(), 1.0 / (double)this.imageScale);
            }
            vars.put("imageWidth", (Object)closeupDim.width);
            vars.put("imageHeight", (Object)closeupDim.height);
        } else {
            vars.put("imageWidth", (Object)(newDim.width / this.imageScale));
            vars.put("imageHeight", (Object)(newDim.height / this.imageScale));
        }
        Dimension thumbDim = GraphicsUtilities.fitWithinBounds(newDim.width, newDim.height, ao.isFolder() && this.folderThumbDim != null ? this.folderThumbDim : this.thumbDim);
        if (!hasIcon) {
            if (imageRenderer.getThumbRenditions().size() > 1) {
                vars.put("thumbRenditions", (Object)imageRenderer.getThumbRenditions());
            }
            thumbDim = AlbumBean.getScaledDim(ImageRenderer.getTypical(imageRenderer.getThumbRenditions()).getSize(), 1.0 / (double)this.thumbScale);
        }
        vars.put("thumbWidth", (Object)thumbDim.width);
        vars.put("thumbHeight", (Object)thumbDim.height);
    }

    static Replacer fillReplacer(Replacer replacer, Map variables) {
        for (Map.Entry e : variables.entrySet()) {
            if (e.getValue() == null || !Template.isPrintable(e.getValue())) continue;
            replacer.add("$" + (String)e.getKey(), e.getValue().toString());
        }
        return replacer;
    }

    private String getJAlbumWeb() {
        return (this.framesetPageName != null ? this.framesetPageName : this.indexPageName) + this.pageExtension;
    }

    private String getExistingWeb(File dir) {
        String[] indexFiles;
        for (String indexFile : indexFiles = new String[]{this.getJAlbumWeb(), "index.htm", "index.html", "index.jsp", "index.asp", "index.php3"}) {
            File test = new File(dir, indexFile);
            if (!test.exists()) continue;
            return indexFile;
        }
        return null;
    }

    public String getTargetThumbName(File file) {
        return this.getTargetThumbName(file, this.outputFormat.getExtension());
    }

    public String getTargetThumbName(File file, String defExt) {
        Object targetName = this.thumbnailPrefix + this.doGetTargetName(file, true, defExt);
        targetName = IO.webSafe((String)targetName);
        return targetName;
    }

    public String getTargetName(File file) {
        Object targetName = this.closeupPrefix + this.doGetTargetName(file, false);
        targetName = IO.webSafe((String)targetName);
        return targetName;
    }

    private String doGetTargetName(File file, boolean thumbs) {
        return this.doGetTargetName(file, thumbs, this.outputFormat.getExtension());
    }

    private String doGetTargetName(File file, boolean thumbs, String defExt) {
        if (file.isDirectory()) {
            return file.getName() + "." + defExt;
        }
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name + "." + defExt;
        }
        String ext = name.substring(dotIndex + 1).toLowerCase();
        if (ext.equals("htt")) {
            return name.substring(0, dotIndex) + this.getPageExtension();
        }
        if (this.outputFormat == OutputFormat.JPEG && (ext.equals("jpg") || ext.equals("jpeg"))) {
            return name;
        }
        if (thumbs && this.forceJPEGThumbs || !thumbs && this.forceJPEGImages) {
            return name.substring(0, dotIndex + 1) + defExt;
        }
        if (ext.equals("png")) {
            return name;
        }
        if (ext.equals("gif")) {
            return name.substring(0, dotIndex + 1) + "png";
        }
        return name.substring(0, dotIndex + 1) + defExt;
    }

    static File[] toFileArray(AlbumObject[] objects) {
        if (objects == null) {
            return null;
        }
        File[] files = new File[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            files[i] = objects[i].getFile();
        }
        return files;
    }

    private void adjustImageLinks(File outputDir, AlbumObject[] objects) throws IOException {
        if (this.slideTemplate != null) {
            File slidesDir = new File(outputDir, this.slideDirectory);
            String resPath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) : "../gifs";
            String stylePath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) + "/styles.css" : "../styles.css";
            File[] files = AlbumBean.toFileArray(objects);
            for (int i = 0; i < objects.length; ++i) {
                Scope locals = objects[i].getVars();
                locals.put("resPath", (Object)resPath);
                locals.put("stylePath", (Object)stylePath);
                this.addImageLinks(objects[i], outputDir, new File(outputDir, this.slideDirectory));
                locals.put("files", (Object)files);
                locals.put("currentObjects", (Object)objects);
                locals.put("imageNum", (Object)(i + 1));
                locals.put("totalImages", (Object)objects.length);
                locals.put("currentPage", (Object)this.encode(this.pageNamer.getSlideName(objects[i].getFile())));
                locals.put("firstPage", (Object)this.encode(this.pageNamer.getSlideName(objects[0].getFile())));
                locals.put("lastPage", (Object)this.encode(this.pageNamer.getSlideName(objects[objects.length - 1].getFile())));
                if (this.getChainedObjects() != null) {
                    AlbumObject prev = this.chainedObjects.getPrevious(objects[i], false);
                    if (prev != null) {
                        locals.put("previous", (Object)prev.getVars());
                        locals.putNotNull("previousPage", this.chainedObjects.getPreviousPath(objects[i], false));
                    } else if (i > 0) {
                        locals.put("previous", (Object)objects[i - 1].getVars());
                        locals.put("previousPage", (Object)this.encode(this.pageNamer.getSlideName(objects[i - 1].getFile())));
                    }
                    AlbumObject next = this.chainedObjects.getNext(objects[i], false);
                    if (next != null) {
                        locals.put("next", (Object)next.getVars());
                        locals.putNotNull("nextPage", this.chainedObjects.getNextPath(objects[i], false));
                        continue;
                    }
                    if (i >= objects.length - 1) continue;
                    locals.put("next", (Object)objects[i + 1].getVars());
                    locals.put("nextPage", (Object)this.encode(this.pageNamer.getSlideName(objects[i + 1].getFile())));
                    continue;
                }
                if (i > 0) {
                    locals.put("previous", (Object)objects[i - 1].getVars());
                    locals.put("previousPage", (Object)this.encode(this.pageNamer.getSlideName(objects[i - 1].getFile())));
                }
                if (i >= objects.length - 1) continue;
                locals.put("next", (Object)objects[i + 1].getVars());
                locals.put("nextPage", (Object)this.encode(this.pageNamer.getSlideName(objects[i + 1].getFile())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeSlide(AlbumObject ao, String rootPath) throws IOException, ElementException, javax.script.ScriptException {
        try (Profiler.Sample _s = Profiler.profile();){
            String slideContent;
            TargetPage slidePage = new TargetPage(new File(this.slidesDir, this.pageNamer.getSlideName(ao.getFile())));
            Scope locals = ao.getVars().name("Slide");
            Scope fix = new Scope(locals).name("Fix");
            fix.put("currentDate", (Object)this.df.format(new Date()));
            fix.put("rootPath", (Object)rootPath);
            fix.put("widgetJavaScript", (Object)this.getWidgetInjectionCode("slide", rootPath, false));
            ASTEvaluator aSTEvaluator = this.evaluator;
            synchronized (aSTEvaluator) {
                this.evaluator.enterScope(locals.getOuter());
                this.evaluator.enterScope(locals);
                this.evaluator.enterScope(fix);
                slideContent = this.slideAST.eval(this.evaluator);
                this.evaluator.exitScope(fix);
                this.evaluator.exitScope(locals);
                this.evaluator.exitScope(locals.getOuter());
            }
            if (this.mediaRSS) {
                slideContent = this.injectMediaRssCode(slideContent, true);
            }
            if (this.widgetInjection && this.skinProperties.isAutoWidgetInjection()) {
                slideContent = this.injectWidgetCode(slideContent, "slide", rootPath);
            }
            slidePage.writeChangesBg(slideContent, Charset.forName(this.writeUTF8 ? "UTF-8" : this.textEncoding));
        }
    }

    private void addImageInfo(AlbumObject ao, Map<String, Object> variables) throws MetadataException {
        XmpManager xmp;
        IptcDirectory dir;
        XmpManager xmp2;
        Metadata metadata = ao.getMetadata().getMetadata();
        if (metadata == null) {
            metadata = new Metadata();
        }
        this.formatter.setDateFormat(this.df);
        ExifIFD0Directory exifIDF0Dir = null;
        if (metadata.containsDirectoryOfType(ExifIFD0Directory.class) && (exifIDF0Dir = (ExifIFD0Directory)metadata.getFirstDirectoryOfType(ExifIFD0Directory.class)).containsTag(271) && exifIDF0Dir.containsTag(272)) {
            variables.put("cameraMake", exifIDF0Dir.getString(271));
            variables.put("cameraModel", exifIDF0Dir.getString(272));
        }
        if (ao.getCameraDate() != 0L) {
            variables.put("originalDate", new FormattedDate(new Date(ao.getCameraDate()), this.df));
            variables.put("originalDateRSS", this.mediaRssDf.format(new Date(ao.getCameraDate())));
        }
        if (metadata.containsDirectoryOfType(ExifSubIFDDirectory.class)) {
            ExifSubIFDDirectory exifDir = (ExifSubIFDDirectory)metadata.getFirstDirectoryOfType(ExifSubIFDDirectory.class);
            ExifSubIFDDescriptor desc = new ExifSubIFDDescriptor(exifDir);
            variables.put("digitizedDate", this.formatter.format(exifDir, 36868));
            if (exifDir.containsTag(40962)) {
                variables.put("resolution", String.valueOf(this.formatter.format(exifDir, 40962)) + " x " + String.valueOf(this.formatter.format(exifDir, 40963)));
            }
            variables.put("flash", desc.getFlashDescription());
            variables.put("focalLength", this.formatter.format(exifDir, 37386));
            String focalLength35mm = this.formatter.format35mmEq(exifIDF0Dir, exifDir);
            if (focalLength35mm != null) {
                variables.put("focalLength35mm", focalLength35mm);
            }
            variables.put("exposureTime", this.formatter.format(exifDir, 33434));
            variables.put("aperture", this.formatter.format(exifDir, 33437));
            variables.put("focusDistance", this.formatter.format(exifDir, 37382));
            variables.put("meteringMode", desc.getDescription(37383));
            variables.put("sensorType", this.formatter.format(exifDir, 41495));
            variables.put("compressionLevel", this.formatter.format(exifDir, 259));
            variables.put("originalWidthDpi", this.formatter.format(exifDir, 282));
            variables.put("originalHeightDpi", this.formatter.format(exifDir, 283));
            variables.put("isoEquivalent", this.formatter.format(exifDir, 34855));
        }
        Double latitude = null;
        Double longitude = null;
        if (metadata.containsDirectoryOfType(GpsDirectory.class)) {
            GpsDirectory dir2 = (GpsDirectory)metadata.getFirstDirectoryOfType(GpsDirectory.class);
            GeoLocation geoLoc = dir2.getGeoLocation();
            if (geoLoc != null) {
                latitude = geoLoc.getLatitude();
                longitude = geoLoc.getLongitude();
            }
            ExtendedGpsDescriptor desc = new ExtendedGpsDescriptor(dir2);
            variables.put("gpsAltitude", desc.getGpsAltitudeDescription());
        }
        if ((xmp2 = ao.getXmpManager()) != null) {
            try {
                latitude = xmp2.getGpsLatitude();
                longitude = xmp2.getGpsLongitude();
                String projectionType = xmp2.getXMPMeta().getPropertyString("http://ns.google.com/photos/1.0/panorama/", "ProjectionType");
                variables.put("projectionType", projectionType);
            }
            catch (XMPException projectionType) {
                // empty catch block
            }
        }
        if (latitude != null) {
            variables.put("gpsLatitude", GeoLocation.decimalToDegreesMinutesSecondsString((double)latitude));
            if (longitude != null) {
                variables.put("gpsLongitude", GeoLocation.decimalToDegreesMinutesSecondsString((double)longitude));
                variables.put("gpsLocation", XmpManager.toGpsLocation(latitude, longitude));
            }
        }
        String author = "";
        String photographer = "";
        String objectName = "";
        String keywords = ao.getKeywords();
        String copyright = "";
        String copyrightURL = "";
        String category = "";
        String headline = "";
        String price = "";
        if (metadata.containsDirectoryOfType(IptcDirectory.class)) {
            dir = (IptcDirectory)metadata.getFirstDirectoryOfType(IptcDirectory.class);
            author = dir.getString(634, this.textEncoding);
            photographer = dir.getString(592, this.textEncoding);
            objectName = dir.getString(517, this.textEncoding);
            headline = dir.getString(617, this.textEncoding);
            copyright = dir.getString(628, this.textEncoding);
            category = dir.getString(527, this.textEncoding);
        }
        if (this.isReadXmp() && (xmp = ao.getXmpManager()) != null) {
            try {
                author = xmp.getCreator();
                copyright = xmp.getRights();
                copyrightURL = xmp.getRightsURL();
                price = xmp.getJAlbumProperty("Price", "");
            }
            catch (XMPException xMPException) {
                // empty catch block
            }
        }
        variables.put("author", author);
        variables.put("writer", author);
        variables.put("creator", author);
        variables.put("photographer", photographer);
        variables.put("objectName", objectName);
        variables.put("headline", headline);
        variables.put("keywords", keywords);
        variables.put("copyright", copyright);
        variables.put("copyrightURL", copyrightURL);
        variables.put("category", category);
        variables.put("price", price);
        variables.put("meta", this.getMetaObjectContent(metadata));
        if (metadata.containsDirectoryOfType(XmpDirectory.class)) {
            dir = (XmpDirectory)metadata.getFirstDirectoryOfType(XmpDirectory.class);
            variables.put("xmp", new PrintSafeHashMap(dir.getXmpProperties()));
        }
    }

    Map getMetaObjectContent(Metadata imageInfo) {
        PrintSafeHashMap meta = new PrintSafeHashMap();
        for (Directory dir : imageInfo.getDirectories()) {
            Object prefix = dir.getName() + ".";
            if (((String)prefix).equalsIgnoreCase("exif.") || ((String)prefix).equalsIgnoreCase("Exif SubIFD.") || ((String)prefix).equalsIgnoreCase("Exif IFD0.")) {
                prefix = "";
            } else if (((String)prefix).length() >= 2) {
                prefix = Character.toUpperCase(((String)prefix).charAt(0)) + ((String)prefix).substring(1).toLowerCase();
            }
            for (Tag tag : dir.getTags()) {
                Object rawData = dir.getObject(tag.getTagType());
                if (rawData instanceof StringValue) {
                    StringValue sv = (StringValue)rawData;
                    String val = sv.getCharset() != null ? sv.toString() : sv.toString(Charset.forName(this.getTextEncoding()));
                    meta.put((String)prefix + tag.getTagName(), val);
                    continue;
                }
                meta.put((String)prefix + tag.getTagName(), tag.getDescription());
            }
        }
        if (imageInfo.containsDirectoryOfType(XmpDirectory.class)) {
            XmpDirectory dir = (XmpDirectory)imageInfo.getFirstDirectoryOfType(XmpDirectory.class);
            for (Map.Entry e : dir.getXmpProperties().entrySet()) {
                meta.put("xmp." + (String)e.getKey(), e.getValue());
            }
        }
        return meta;
    }

    private static boolean exists(String s) {
        return s != null && s.trim().length() > 0;
    }

    BufferedImage createBufferedImage(Image img) {
        int iw = img.getWidth(this);
        int ih = img.getHeight(this);
        return this.createBufferedImage(img, iw, ih);
    }

    private BufferedImage createBufferedImage(Image img, int iw, int ih) {
        int type = 4;
        if (img instanceof BufferedImage) {
            type = ((BufferedImage)img).getType();
        }
        BufferedImage bi = new BufferedImage(iw, ih, type);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return bi;
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method) {
        return this.scaleToFit(image, boundingBox, method, (float)this.sharpenPercent / 100.0f);
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method, float sharpenAmount) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return image instanceof BufferedImage ? (BufferedImage)image : this.createBufferedImage(image);
        }
        Dimension dim = GraphicsUtilities.fitWithinBounds(width, height, boundingBox);
        ImageScaler scaler = ImageScaler.getScaler(method, this.acceleratedScaling, this.smoothScalingType);
        BufferedImage bufImage = scaler.scale(image, dim.width, dim.height);
        image.flush();
        if ((double)sharpenAmount >= 0.05 && !SCALE_FAST.equals(method)) {
            BufferedImageOp sharpenOp = AlbumBean.getSharpenOperation((int)(sharpenAmount * 100.0f));
            bufImage = sharpenOp.filter(bufImage, null);
        }
        return bufImage;
    }

    public static Dimension getScaledDim(Dimension dim, double scale) {
        if (scale == 1.0) {
            return dim;
        }
        return new Dimension((int)(scale * (double)dim.width), (int)(scale * (double)dim.height));
    }

    private static BufferedImageOp getSharpenOperation(int percent) {
        float[] sharpenKernel = new float[]{-0.083333336f, -0.25f, -0.083333336f, -0.25f, 2.3333333f, -0.25f, -0.083333336f, -0.25f, -0.083333336f};
        float[] originalKernel = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] resultingKernel = new float[9];
        float w = (float)((double)percent / 120.0);
        for (int i = 0; i < resultingKernel.length; ++i) {
            resultingKernel[i] = w * sharpenKernel[i] + (1.0f - w) * originalKernel[i];
        }
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, resultingKernel), 1, null);
        return op;
    }

    private void myAssert(boolean test, String msg) throws IllegalArgumentException {
        if (!test) {
            throw new IllegalArgumentException(msg);
        }
    }

    static Dimension parseSize(String sizeString) throws IllegalArgumentException {
        String size = sizeString.toLowerCase();
        StringTokenizer tokens = new StringTokenizer(size, "x ");
        int w = 0;
        try {
            w = Integer.parseInt(tokens.nextToken());
            int h = Integer.parseInt(tokens.nextToken());
            if (w < 50 || h < 50) {
                throw new Exception();
            }
            return new Dimension(w, h);
        }
        catch (Exception ex) {
            if (w >= 50) {
                return new Dimension(w, w);
            }
            throw new IllegalArgumentException(Msg.get("engine.invalidSizeError", sizeString));
        }
    }

    private String encode(String s) {
        return IO.urlEncode(s);
    }

    static boolean isSupportedImage(File file) {
        return FileFilters.isFileSupported(file);
    }

    @Override
    public synchronized void removeAlbumBeanListener(AlbumBeanListener listener) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(listener)) {
            ArrayList list = (ArrayList)this.albumBeanListeners.clone();
            list.remove(listener);
            this.albumBeanListeners = list;
        }
    }

    public synchronized void removeAllAlbumBeanListeners() {
        this.albumBeanListeners = null;
    }

    @Override
    public synchronized void addAlbumBeanListener(AlbumBeanListener listener) {
        ArrayList list;
        ArrayList arrayList = list = this.albumBeanListeners == null ? new ArrayList(2) : (ArrayList)this.albumBeanListeners.clone();
        if (!list.contains(listener)) {
            list.add(listener);
            this.albumBeanListeners = list;
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void addFilter(JAFilter filter) {
        this.addFilter(filter, 2);
    }

    public Iterator<JAFilter> filterIterator(int stage) {
        Iterator all = this.filters.iterator();
        LinkedList<JAFilter> matching = new LinkedList<JAFilter>();
        while (all.hasNext()) {
            JAFilterNode node = (JAFilterNode)all.next();
            if (node.getStage() != stage) continue;
            matching.addLast(node.getFilter());
        }
        return matching.iterator();
    }

    public boolean addFilter(JAFilter filter, int stage) {
        this.filters.addLast(new JAFilterNode(filter, stage));
        return true;
    }

    public boolean removeFilter(JAFilter filter, int stage) {
        return this.filters.remove(new JAFilterNode(filter, stage));
    }

    public void removeAllFilters() {
        this.filters = new LinkedList();
    }

    private static BufferedImage copyImage(BufferedImage im) {
        BufferedImage bi = new BufferedImage(im.getWidth(), im.getHeight(), im.getType());
        Graphics2D g = bi.createGraphics();
        g.drawImage((Image)im, 0, 0, null);
        g.dispose();
        return bi;
    }

    private static Method getDeclaredMethodTravelUp(Class c, String name) throws NoSuchMethodException {
        while (c != null) {
            try {
                return c.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                c = c.getSuperclass();
            }
        }
        throw new NoSuchMethodException(name);
    }

    BufferedImage processFilters(FilterPipeline filterPipeline, BufferedImage im, AlbumObject ao, Scope vars, int stage) {
        return this.processFilters(filterPipeline, im, ao, vars, stage, 1.0f);
    }

    BufferedImage processFilters(FilterPipeline filterPipeline, BufferedImage im, AlbumObject ao, Scope vars, int stage, float scale) {
        try (Profiler.Sample _s = Profiler.profile();){
            Scope local = new Scope(vars).name("Process filters");
            local.put("stage", (Object)stage);
            local.put("scale", (Object)Float.valueOf(scale * (float)this.getScaleForStage(stage)));
            local.put("engine", (Object)this);
            if (filterPipeline != null && stage == 1) {
                im = filterPipeline.processPrescaleFilters(im);
            } else if (filterPipeline != null && stage == 2) {
                im = filterPipeline.processPostscaleFilters(im);
            }
            boolean isACopy = false;
            for (JAFilterNode node : this.filters) {
                try {
                    JAFilter filter;
                    if (node.getStage() != stage) continue;
                    if (stage == 3 && !isACopy) {
                        im = AlbumBean.copyImage(im);
                        isACopy = true;
                    }
                    if (this.isExcluded(filter = node.getFilter(), vars)) continue;
                    if (JAlbum.logger.isLoggable(Level.FINE)) {
                        System.out.println("Rendering with filter " + String.valueOf(filter.getClass()));
                    }
                    JAFilter clone = filter;
                    try {
                        if (filter instanceof Cloneable) {
                            Method cloneMethod = AlbumBean.getDeclaredMethodTravelUp(filter.getClass(), "clone");
                            cloneMethod.setAccessible(true);
                            clone = (JAFilter)cloneMethod.invoke((Object)filter, new Object[0]);
                            JAlbum.logger.finest(String.valueOf(filter.getClass()) + " cloned with Object.clone");
                        } else {
                            clone = (JAFilter)filter.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            BeanBinder.cloneProperties(filter, clone);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Error cloning filter " + String.valueOf(filter.getClass()));
                        ex.printStackTrace(System.err);
                    }
                    im = clone.filter(im, local);
                }
                catch (RuntimeException ex) {
                    System.err.println("Error applying filter '" + String.valueOf(node.getFilter().getClass()) + " to image " + ao.getName() + ":");
                    ex.printStackTrace();
                }
            }
            BufferedImage bufferedImage = im;
            return bufferedImage;
        }
    }

    private boolean isExcluded(JAFilter filter, Scope vars) {
        String excludeFilter;
        Set excluded;
        if (vars.containsKey("excludedFilters") && (excluded = (Set)vars.get("excludedFilters")).contains(filter.getClass().getName())) {
            return true;
        }
        Map userVars = (Map)vars.get("userVariables");
        if (userVars != null && (excludeFilter = (String)userVars.get("excludeFilters")) != null) {
            for (String name : excludeFilter.split("\\s?[, ]\\s?")) {
                if (!filter.getClass().getName().contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    Dimension getFilteredSize(FilterPipeline fp, Variant variant, Dimension size, Scope vars, int stage) {
        vars.put("stage", (Object)stage);
        vars.put("scale", (Object)Float.valueOf((float)this.getScaleForStage(stage) * variant.getScale()));
        if (fp != null) {
            if (stage == 1) {
                size = fp.getPrescaleFilteredSize(size);
            } else if (stage == 2) {
                size = fp.getPostscaleFilteredSize(size);
            }
        }
        for (JAFilterNode node : this.filters) {
            if (node.getStage() != stage || !(node.getFilter() instanceof ModifiesSize)) continue;
            size = ((ModifiesSize)((Object)node.getFilter())).getModifiedSize(size, vars);
        }
        return size;
    }

    public void fireStatus(String message) {
        JAlbum.logger.finer(message);
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.status(message);
            }
        }
    }

    public void fireWarning(String message) {
        System.out.println(message);
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.warning(message);
            }
        }
    }

    public void fireRequestConfirmation(String message) {
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                if (l.requestConfirmation(message, parent -> {
                    int result = JOptionPane.showConfirmDialog(parent, new JLabel("<html>" + message + "</html>"), Msg.get("ui.makeAlbum"), 0, 2);
                    return result == 0;
                })) continue;
                throw new OperationAbortedException();
            }
        }
    }

    protected void fireFolderProcessingStarted(AlbumObject folder) {
        JAlbum.logger.finest(folder.getName());
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                FolderVisitResult r = l.folderProcessingStarted(folder);
                if (r != FolderVisitResult.abort) continue;
                throw new OperationAbortedException();
            }
        }
    }

    protected void fireFolderProcessingFinished(AlbumObject folder) {
        JAlbum.logger.finest(folder.getName());
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                FolderVisitResult r = l.folderProcessingFinished(folder);
                if (r != FolderVisitResult.abort) continue;
                throw new OperationAbortedException();
            }
        }
    }

    protected void fireVideoProcessingProgress(AlbumBeanEvent e, float progress) {
        JAlbum.logger.finest(e.msg);
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.videoProcessingProgress(e, progress);
            }
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        JAlbum.logger.finest(e.msg);
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        JAlbum.logger.finest(e.msg);
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Throwable t, AlbumObject ao) {
        JAlbum.logger.finest(t.toString());
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.errorOccured(t, ao);
            }
        }
    }

    protected void fireAlbumMakingStarted(boolean changes) {
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.albumMakingStarted(changes);
            }
        }
    }

    protected void fireAlbumMakingDone(boolean success) {
        if (this.albumBeanListeners != null) {
            ArrayList listeners = this.albumBeanListeners;
            for (AlbumBeanListener l : listeners) {
                l.albumMakingDone(success);
            }
        }
    }

    public void setSubdirs(boolean newSubdirs) {
    }

    public boolean isSubdirs() {
        return this.subdirs;
    }

    @Override
    public void setAppendImages(boolean newAppendImages) {
        this.appendImages = newAppendImages;
    }

    @Override
    @Unbound
    public boolean isAppendImages() {
        return this.appendImages;
    }

    @Unbound
    private MakeMode getMakeMode() {
        if (this.smartMake) {
            return MakeMode.smart;
        }
        return this.appendImages ? MakeMode.changes : MakeMode.all;
    }

    public void setUpdatedDirsOnly(boolean newUpdatedDirsOnly) {
        this.updatedDirsOnly = newUpdatedDirsOnly;
    }

    public boolean isUpdatedDirsOnly() {
        return this.updatedDirsOnly;
    }

    public void setExcludeByDefault(boolean newExcludeByDefault) {
        this.excludeByDefault = newExcludeByDefault;
    }

    public boolean isExcludeByDefault() {
        return this.excludeByDefault;
    }

    public void setKeepMetaData(boolean newKeepMetaData) {
        this.keepMetaData = newKeepMetaData;
    }

    public boolean isKeepMetaData() {
        return this.keepMetaData;
    }

    public void setKeepXmpData(boolean newKeepXmpData) {
        this.keepXmpData = newKeepXmpData;
    }

    public boolean isKeepXmpData() {
        return this.keepXmpData;
    }

    public String getHomepageAddress() {
        return this.homepageAddress;
    }

    public void setHomepageAddress(String homepageAddress) {
        this.homepageAddress = homepageAddress;
    }

    public String getHomepageLinkText() {
        return this.homepageLinkText;
    }

    public void setHomepageLinkText(String homepageLinkText) {
        this.homepageLinkText = homepageLinkText;
    }

    @Override
    @CallOrder(value=2)
    public void setStyle(String newStyle) {
        if (!((String)newStyle).toLowerCase().endsWith(".css")) {
            newStyle = (String)newStyle + ".css";
        }
        this.style = newStyle;
        if (this.context.getFrame() == null) {
            try {
                File stylesDir = new File(this.skinDir, "styles");
                File hintsFile = new File(stylesDir, IO.baseName((String)newStyle) + ".jap");
                if (hintsFile.exists()) {
                    JAlbum.logger.log(Level.FINER, "Preparing album engine with hints from {0}", hintsFile);
                    this.setProperties(IO.readPropertyFile(hintsFile));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public void setIndexPageName(String newIndexPageName) {
        this.indexPageName = newIndexPageName.trim();
    }

    public String getIndexPageName() {
        return this.indexPageName;
    }

    public boolean isUrlEncode() {
        return true;
    }

    @Deprecated
    public void setUrlEncode(boolean b) {
    }

    public boolean isRemoveDiacritics() {
        return this.removeDiacritics;
    }

    public void setRemoveDiacritics(boolean removeDiacritics) {
        this.removeDiacritics = removeDiacritics;
    }

    public void setImageOrdering(String newImageOrdering) {
        switch (newImageOrdering) {
            case "OrderByDate": {
                this.imageOrdering = ORDER_BY_DATE;
                break;
            }
            case "OrderByAddedDate": {
                this.imageOrdering = ORDER_BY_ADDED_DATE;
                break;
            }
            case "OrderByCameraDate": {
                this.imageOrdering = ORDER_BY_CAMERA_DATE;
                break;
            }
            case "OrderByName": {
                this.imageOrdering = ORDER_BY_NAME;
                break;
            }
            default: {
                this.imageOrdering = ORDER_BY_SIMPLE_NAME;
            }
        }
        this.customImageOrdering = null;
    }

    public String getImageOrdering() {
        return this.imageOrdering;
    }

    public void setCustomImageOrdering(Comparator fileComparator) {
        this.customImageOrdering = fileComparator;
    }

    public Comparator getCustomImageOrdering() {
        return this.customImageOrdering;
    }

    public void setMediaRSS(boolean newMediaRSS) {
        this.mediaRSS = newMediaRSS;
    }

    public boolean isMediaRSS() {
        return this.mediaRSS;
    }

    public boolean isGenerateJSON() {
        return this.generateJSON;
    }

    public void setGenerateJSON(boolean generateJSON) {
        this.generateJSON = generateJSON;
    }

    public String getNotes() {
        return this.notes.trim();
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isNotifyNotes() {
        return this.notifyNotes;
    }

    public void setNotifyNotes(boolean notifyNotes) {
        this.notifyNotes = notifyNotes;
    }

    public void setWidgetInjection(boolean newWidgetInjection) {
        this.widgetInjection = newWidgetInjection || !this.getLicenseManager().isLicenseValid();
    }

    public boolean isWidgetInjection() {
        return this.widgetInjection;
    }

    public void setExcludeBacklinks(boolean newExcludeBacklinks) {
        this.excludeBacklinks = newExcludeBacklinks;
    }

    public boolean isExcludeBacklinks() {
        return this.excludeBacklinks;
    }

    @Unbound
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setMetaData(boolean newMetaData) {
        this.metaData = newMetaData;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    @Override
    public void setOutputDirectory(String newOutputDirectory) {
        String oldOutputDirectory = this.outputDirectory;
        this.outputDirectory = newOutputDirectory;
        this.firePropertyChange("outputDirectory", oldOutputDirectory, newOutputDirectory);
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Unbound
    @Deprecated
    public File getInterpretedOutputDirectory() {
        return this.getOutputDir();
    }

    @Unbound
    public File getOutputDir() {
        File f = new File(this.getOutputDirectory());
        if (!f.isAbsolute()) {
            f = IO.resolvePath(new File(this.directory), this.outputDirectory);
        }
        return f;
    }

    public void setAlbumAddress(String albumAddress) {
        this.albumAddress = albumAddress;
    }

    public String getAlbumAddress() {
        return this.albumAddress;
    }

    public void setRows(int newRows) {
        int oldRows = this.rows;
        this.rows = newRows;
        this.firePropertyChange("rows", oldRows, newRows);
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Unbound
    public int getLimit() {
        return this.limit;
    }

    @Deprecated
    public void setImageLinking(String newImageLinking) {
        switch (newImageLinking) {
            case "LinkOriginals": {
                this.makeImages = false;
                this.includeOriginals = true;
                break;
            }
            case "LinkOriginalsViaScaled": {
                this.makeImages = true;
                this.includeOriginals = true;
                break;
            }
            default: {
                this.makeImages = true;
                this.includeOriginals = false;
            }
        }
    }

    @Unbound
    @Deprecated
    public String getImageLinking() {
        if (this.includeOriginals && this.makeImages) {
            return LINK_ORIGINALS_VIA_SCALED;
        }
        if (this.includeOriginals) {
            return LINK_ORIGINALS;
        }
        return LINK_SCALED;
    }

    private boolean includeOriginal(AlbumObject ao) {
        if (ao.isUseOriginal()) {
            return false;
        }
        return this.includeOriginals || Boolean.TRUE.equals(ao.getVars().get("includeOriginal"));
    }

    public void setCopyOriginals(boolean newCopyOriginals) {
        this.copyOriginals = newCopyOriginals;
    }

    public boolean isCopyOriginals() {
        return this.copyOriginals;
    }

    public String getWebPassword() {
        return this.webPassword;
    }

    public void setWebPassword(String webPassword) {
        this.webPassword = webPassword;
    }

    public boolean isVisibleOnProfilePage() {
        return this.visibleOnProfilePage;
    }

    public void setVisibleOnProfilePage(boolean visibleOnProfilePage) {
        this.visibleOnProfilePage = visibleOnProfilePage;
    }

    @Override
    @CallOrder(value=1)
    public void setSkin(String newSkin) {
        if (newSkin == null) {
            throw new IllegalArgumentException("Passing null as skin name");
        }
        this.lastSkin = this.skin;
        this.skin = newSkin;
        this.skinDir = this.cfg.chainedSkinsDir.getFile(this.skin);
        this.srcResDir = new File(this.skinDir, "res");
        this.skinProperties = new SkinProperties(this.skinDir);
        this.slideModel = this.getSlideModel();
        this.scriptLanguage = this.resolveScriptLanguage(AlbumBean.resolveScriptFile(this.skinDir, "init"));
        if (this.classLoader == null || !newSkin.equals(this.lastSkin)) {
            this.scriptEnginePool = null;
            this.compiledScriptCache = new HashMap<File, Pair<Long, CompiledScript>>();
            this.setClassLoader();
        }
        if (this.context.getFrame() == null) {
            try {
                Properties props = new Properties();
                File headlessSettingsFile = new File(this.skinDir, HEADLESS_SETTINGS_NAME);
                if (headlessSettingsFile.exists()) {
                    JAlbum.logger.log(Level.FINER, "Preparing album engine with settings from {0}", headlessSettingsFile);
                    FileInputStream fis = new FileInputStream(headlessSettingsFile);
                    props.load(fis);
                    fis.close();
                }
                File hintsFile = new File(this.skinDir, "hints.jap");
                if (this.context.getFrame() == null && hintsFile.exists()) {
                    JAlbum.logger.log(Level.FINER, "Preparing album engine with hints from {0}", hintsFile);
                    props.putAll((Map<?, ?>)IO.readPropertyFile(hintsFile));
                }
                this.setProperties(props);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.firePropertyChange("skin", this.lastSkin, this.skin);
    }

    @Override
    public String getSkin() {
        return this.skin;
    }

    @Unbound
    public String getLastSkin() {
        return this.lastSkin;
    }

    public File getSkinDir() {
        return this.skinDir;
    }

    public void setPageExtension(String newPageExtension) {
        if (newPageExtension.indexOf(46) == -1) {
            throw new IllegalArgumentException("Passing illegal page extension: " + newPageExtension);
        }
        this.pageExtension = newPageExtension.trim();
    }

    public String getPageExtension() {
        return this.pageExtension;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getThumbnailDirectory() {
        return this.thumbDirectory;
    }

    public String getCloseupDirectory() {
        return this.closeupDirectory;
    }

    public String getSlideDirectory() {
        return this.slideDirectory;
    }

    public String getThumbnailPrefix() {
        return this.thumbnailPrefix;
    }

    public String getCloseupPrefix() {
        return this.closeupPrefix;
    }

    public boolean isReadJAlbumMetaData() {
        return this.readJAlbumMetaData;
    }

    public void setReadJAlbumMetaData(boolean readJAlbumMetaData) {
        this.readJAlbumMetaData = readJAlbumMetaData;
    }

    public void setReadXmp(boolean readXmp) {
        this.readXmp = readXmp;
    }

    public boolean isReadXmp() {
        return this.readXmp;
    }

    public void setJpegComment(boolean newjpegComment) {
        this.jpegComment = newjpegComment;
    }

    public boolean isJpegComment() {
        return this.jpegComment;
    }

    public void setIptcCaption(boolean newiptcCaption) {
        this.iptcCaption = newiptcCaption;
    }

    public boolean isIptcCaption() {
        return this.iptcCaption;
    }

    public void setExifUserComment(boolean newexifUserComment) {
        this.exifUserComment = newexifUserComment;
    }

    public boolean isExifUserComment() {
        return this.exifUserComment;
    }

    public TitleSource getTitleSource() {
        return this.titleSource;
    }

    public void setTitleSource(TitleSource titleSource) {
        this.titleSource = titleSource;
    }

    public void setHighQualityThumbs(boolean newhighQualityThumbs) {
        this.highQualityThumbs = newhighQualityThumbs;
    }

    public boolean isHighQualityThumbs() {
        return this.highQualityThumbs;
    }

    public boolean isForceProcessing() {
        return this.forceProcessing;
    }

    public void setForceProcessing(boolean forceProcessing) {
        this.forceProcessing = forceProcessing;
    }

    @Unbound
    public boolean isForceVideoProcessing() {
        return this.forceVideoProcessing;
    }

    @Unbound
    public void setForceVideoProcessing(boolean forceVideoProcessing) {
        this.forceVideoProcessing = forceVideoProcessing;
    }

    @Deprecated
    public void setForceJPEGWriting(boolean force) {
        this.forceJPEGThumbs = force;
        this.forceJPEGImages = force;
    }

    public boolean isForceJPEGThumbs() {
        return this.forceJPEGThumbs;
    }

    public void setForceJPEGThumbs(boolean forceJPEGThumbs) {
        this.forceJPEGThumbs = forceJPEGThumbs;
    }

    public boolean isForceJPEGImages() {
        return this.forceJPEGImages;
    }

    public void setForceJPEGImages(boolean forceJPEGImages) {
        this.forceJPEGImages = forceJPEGImages;
    }

    public boolean isSuperimposeFilmIcon() {
        return this.superimposeFilmIcon;
    }

    public void setSuperimposeFilmIcon(boolean superimposeFilmIcon) {
        this.superimposeFilmIcon = superimposeFilmIcon;
    }

    public void setExifImageDescription(boolean newexifImageDescription) {
        this.exifImageDescription = newexifImageDescription;
    }

    public boolean isExifImageDescription() {
        return this.exifImageDescription;
    }

    public void setIncludeDirectories(boolean newIncludeDirectories) {
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    @Override
    public void setUserVariables(Map newUserVariables) {
        this.userVariables = newUserVariables;
        File f = AlbumBean.resolveScriptFile(this.skinDir, "onload");
        if (f.exists()) {
            for (Map.Entry entry : this.userVariables.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                entry.setValue(AlbumBean.interpretDataType((String)entry.getValue()));
            }
        }
    }

    public VideoProcessor getVideoProcessor() {
        if (this.videoProcessor == null) {
            this.videoProcessor = VideoProcessor.createInstance(this);
        } else if (Config.getConfig().isVideoSupported()) {
            if (!(this.videoProcessor instanceof VideoProcessor.FfmpegVideoProcessor)) {
                this.videoProcessor = VideoProcessor.createInstance(this);
            }
        } else if (this.videoProcessor instanceof VideoProcessor.FfmpegVideoProcessor) {
            this.videoProcessor = VideoProcessor.createInstance(this);
        }
        return this.videoProcessor;
    }

    public Parameters getVideoParameters() {
        return this.getVideoProcessor().getVideoParameters();
    }

    public void setVideoParameters(Parameters videoParameters) {
        this.getVideoProcessor().setVideoParameters(videoParameters);
    }

    public boolean isUseCustomVideoSettings() {
        return this.useCustomVideoSettings;
    }

    public void setUseCustomVideoSettings(boolean useCustomVideoSettings) {
        this.useCustomVideoSettings = useCustomVideoSettings;
    }

    public int getVideoQuality() {
        return this.getVideoProcessor().getVideoQuality();
    }

    public void setVideoQuality(int videoQuality) {
        this.getVideoProcessor().setVideoQuality(videoQuality);
    }

    public VideoResolution getVideoResolution() {
        return this.getVideoProcessor().getVideoResolution();
    }

    public void setVideoResolution(VideoResolution videoResolution) {
        this.getVideoProcessor().setVideoResolution(videoResolution);
    }

    @Override
    public void setSkinVariables(Map newSkinVariables) {
        Set<String> mappedVars = this.setDataTypes(newSkinVariables, this.getSkinProperties().getProperty("skinModel", "SkinModel"));
        for (Map.Entry entry : newSkinVariables.entrySet()) {
            if (mappedVars.contains((String)entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            entry.setValue(AlbumBean.interpretDataType((String)entry.getValue()));
        }
        this.skinVariables = newSkinVariables;
        if (!this.getSkinProperties().isEditableThemeImageSize()) {
            this.setThemeImageSize((String)this.skinVariables.get(this.skinProperties.getThemeImageSizeName()));
        }
    }

    private static void printClassLoaders(ClassLoader loader) {
        while (loader != null) {
            System.out.println(loader);
            if (loader instanceof URLClassLoader) {
                for (URL u : ((URLClassLoader)loader).getURLs()) {
                    System.out.println("\t" + String.valueOf(u));
                }
            }
            loader = loader.getParent();
        }
    }

    private Class smartLoadClass(String className) throws ClassNotFoundException {
        try {
            if (this.classLoader == null) {
                this.setClassLoader();
            }
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            InputStream in = null;
            try {
                if (this.interpreter == null) {
                    this.initInterpreter();
                }
                if (!this.interpreter.getClassManager().classExists(className)) {
                    in = this.interpreter.getClassManager().getResourceAsStream("/" + className.replace('.', '/') + ".java");
                    if (in == null) {
                        throw ex;
                    }
                    this.interpreter.eval((Reader)new InputStreamReader(in));
                }
                Class clazz = this.interpreter.getNameSpace().getClass(className);
                return clazz;
            }
            catch (EvalError | UtilEvalError ex1) {
                throw new RuntimeException(ex1);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    Set<String> setDataTypes(Map vars, String modelClassName) {
        HashSet<String> names = new HashSet<String>();
        try {
            Class modelClass = this.smartLoadClass(modelClassName);
            Object instance = modelClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return this.setDataTypes(vars, instance, true);
        }
        catch (ClassNotFoundException modelClass) {
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedClassVersionError err) {
            throw new UnsupportedClassVersionError("The " + this.skin + " skin requires a more recent Java version)");
        }
        return names;
    }

    Set<String> setDataTypes(Map vars, Object template, boolean includeDefaults) {
        String name = null;
        HashSet<String> names = new HashSet<String>();
        try {
            Class<?> modelClass = template.getClass();
            for (Field f : modelClass.getFields()) {
                name = f.getName();
                if (name.startsWith("_bsh")) continue;
                if (vars.containsKey(name)) {
                    Class<?> modelType;
                    Object value = vars.get(name);
                    Class<?> currentType = value.getClass();
                    if (currentType.equals(modelType = f.getType())) {
                        f.set(template, value);
                    } else {
                        try {
                            String stringValue = value.toString();
                            if (stringValue.length() > 0) {
                                if (modelType.equals(Boolean.TYPE)) {
                                    f.setBoolean(template, Boolean.parseBoolean(stringValue));
                                } else if (modelType.equals(Byte.TYPE)) {
                                    f.setByte(template, Byte.parseByte(stringValue));
                                } else if (modelType.equals(Character.TYPE)) {
                                    f.setChar(template, stringValue.charAt(0));
                                } else if (modelType.equals(Double.TYPE)) {
                                    f.setDouble(template, Double.parseDouble(stringValue));
                                } else if (modelType.equals(Float.TYPE)) {
                                    f.setFloat(template, Float.parseFloat(stringValue));
                                } else if (modelType.equals(Integer.TYPE)) {
                                    f.setInt(template, Integer.parseInt(stringValue));
                                } else if (modelType.equals(Long.TYPE)) {
                                    f.setLong(template, Long.parseLong(stringValue));
                                } else if (modelType.equals(Short.TYPE)) {
                                    f.setShort(template, Short.parseShort(stringValue));
                                } else if (modelType.isEnum()) {
                                    f.set(template, Enum.valueOf(modelType, stringValue));
                                }
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            JAlbum.logger.fine("Illegal value given for \"" + name + "\": " + ex.getMessage() + ". Reverting to SkinModel default: " + String.valueOf(f.get(template)));
                        }
                    }
                }
                if (!vars.containsKey(name) && !includeDefaults) continue;
                Object res = f.get(template);
                if (res == null) {
                    res = "";
                }
                vars.put(name, res);
                names.add(name);
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedClassVersionError err) {
            throw new UnsupportedClassVersionError("The " + this.skin + " skin requires a more recent Java version)");
        }
        return names;
    }

    @Override
    public void setProperties(Properties props) {
        BeanBinder.setProperties(this, props);
        HashMap sv = new HashMap(this.skinVariables);
        sv.putAll(JAlbumUtilities.getSkinVariables(props));
        this.setSkinVariables(sv);
        Map uv = this.getUserVariables();
        uv.putAll(JAlbumUtilities.getUserVariables(props));
        this.setUserVariables(uv);
    }

    private static Object interpretDataType(Object o) {
        if (!(o instanceof String)) {
            return o;
        }
        String s = (String)o;
        if (s.indexOf(0) == 34 && s.length() >= 2) {
            return s.substring(1, s.length() - 2);
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double d = Double.valueOf(s);
                if (s.equals(d.toString())) {
                    return d;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
            return s;
        }
    }

    @Override
    public Map getUserVariables() {
        return this.userVariables;
    }

    @Override
    public Map getSkinVariables() {
        return this.skinVariables;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim().replace('\\', '/');
    }

    public String getRemoteDirectory() {
        String rd = this.remoteDirectory;
        if (this.currentProject != null && "VALUE_UNSET".equals(this.remoteDirectory)) {
            rd = this.currentProject.getName();
        }
        return rd;
    }

    public void setAccountProfileName(String newAccountProfileName) {
        String oldName = this.accountProfileName;
        this.accountProfileName = newAccountProfileName;
        this.firePropertyChange("accountProfileName", oldName, newAccountProfileName);
    }

    public String getAccountProfileName() {
        return this.accountProfileName;
    }

    public void setReverseOrder(boolean newReverseOrder) {
        this.reverseOrder = newReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setTextEncoding(String newTextEncoding) {
        this.textEncoding = newTextEncoding;
        System.setProperty("jalbum.file.encoding", this.textEncoding);
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setWriteUTF8(boolean newWriteUTF8) {
        this.writeUTF8 = newWriteUTF8;
    }

    public boolean isWriteUTF8() {
        return this.writeUTF8;
    }

    public void setDirectoriesFirst(boolean newDirectoriesFirst) {
        this.directoriesFirst = newDirectoriesFirst;
    }

    public boolean isDirectoriesFirst() {
        return this.directoriesFirst;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    private static Object primitiveWrapper(Object val) {
        if (val instanceof Integer) {
            return new Primitive((Object)((Integer)val));
        }
        if (val instanceof Long) {
            return new Primitive((Object)((Long)val));
        }
        if (val instanceof Short) {
            return new Primitive((Object)((Short)val));
        }
        if (val instanceof Byte) {
            return new Primitive((Object)((Byte)val));
        }
        if (val instanceof Character) {
            return new Primitive((Object)((Character)val));
        }
        if (val instanceof Double) {
            return new Primitive((Object)((Double)val));
        }
        if (val instanceof Float) {
            return new Primitive((Object)((Float)val));
        }
        if (val instanceof Boolean) {
            return new Primitive((Object)((Boolean)val));
        }
        if (val instanceof BigInteger) {
            return new Primitive((Object)((BigInteger)val));
        }
        if (val instanceof BigDecimal) {
            return new Primitive((Object)((BigDecimal)val));
        }
        return val;
    }

    @Deprecated
    public static void setVars(Map<String, Object> variables, Interpreter interpreter) throws javax.script.ScriptException {
        try {
            for (Map.Entry<String, Object> e : variables.entrySet()) {
                String name = e.getKey();
                if (name.indexOf(46) != -1) continue;
                interpreter.set(name, AlbumBean.primitiveWrapper(e.getValue()));
            }
        }
        catch (EvalError e) {
            throw new javax.script.ScriptException((Exception)((Object)e));
        }
    }

    public static void setVars(Map<String, Object> variables, ScriptEngine engine) {
        Bindings bindings = engine.getBindings(100);
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            String name = e.getKey();
            if (name.indexOf(46) != -1) continue;
            Object val = e.getValue();
            if (engine instanceof BshScriptEngine) {
                bindings.put(name, AlbumBean.primitiveWrapper(val));
                continue;
            }
            bindings.put(name, val);
        }
    }

    static synchronized void pushVars(Scope scope, ScriptEngine engine) {
        try (Profiler.Sample _s = Profiler.profile();){
            Map<String, Object> inner = scope.getMap();
            Bindings bindings = engine.getBindings(100);
            if (!(engine instanceof BshScriptEngine) && "Globals" != scope.getName()) {
                bindings.putAll((Map<? extends String, ? extends Object>)inner);
                return;
            }
            for (Map.Entry<String, Object> e : inner.entrySet()) {
                String name = e.getKey();
                if (name.indexOf(46) != -1) continue;
                Object val = e.getValue();
                if (engine instanceof BshScriptEngine) {
                    bindings.put(name, AlbumBean.primitiveWrapper(val));
                    continue;
                }
                bindings.put(name, val);
            }
        }
    }

    static Scope popVars(Scope scope, ScriptEngine engine) {
        try (Profiler.Sample _s = Profiler.profile();){
            Bindings bindings = engine.getBindings(100);
            Map<String, Object> inner = scope.getMap();
            Scope outer = scope.getOuter();
            HashMap<String, Object> toReAdd = new HashMap<String, Object>();
            for (String string : inner.keySet()) {
                if (outer == null || !outer.containsKey(string)) continue;
                toReAdd.put(string, outer.get(string));
            }
            if (bindings instanceof ScriptObjectMirror) {
                ((ScriptObjectMirror)bindings).removeAll(inner.keySet());
            } else {
                for (String string : inner.keySet()) {
                    bindings.remove(string);
                }
            }
            if (engine instanceof BshScriptEngine) {
                for (Map.Entry entry : toReAdd.entrySet()) {
                    bindings.put((String)entry.getKey(), AlbumBean.primitiveWrapper(entry.getValue()));
                }
            } else {
                bindings.putAll((Map<? extends String, ? extends Object>)toReAdd);
            }
            Scope scope2 = outer;
            return scope2;
        }
    }

    public void setUsing(Object using) {
        this.using = using;
    }

    public String getScalingMethod() {
        return this.scalingMethod;
    }

    public void setScalingMethod(String scalingMethod) {
        this.scalingMethod = scalingMethod;
    }

    public CustomScaler.Type getSmoothScalingType() {
        return this.smoothScalingType;
    }

    public void setSmoothScalingType(CustomScaler.Type smoothScalingType) {
        this.smoothScalingType = smoothScalingType;
    }

    public boolean isAcceleratedScaling() {
        return this.acceleratedScaling;
    }

    public void setAcceleratedScaling(boolean hardwareScaling) {
        this.acceleratedScaling = hardwareScaling;
    }

    public DirectoryChaining getDirectoryChaining() {
        return this.directoryChaining;
    }

    public void setDirectoryChaining(DirectoryChaining directoryChaining) {
        this.directoryChaining = directoryChaining;
        this.chainedObjects = null;
    }

    @Unbound
    public boolean isChainDirectories() {
        return this.directoryChaining != DirectoryChaining.NO_CHAINING;
    }

    @Deprecated
    public void setChainDirectories(boolean chain) {
        this.directoryChaining = chain ? DirectoryChaining.FULL_TREE : DirectoryChaining.NO_CHAINING;
    }

    public CreditText getCreditText() {
        if (this.creditText == null) {
            this.creditText = CreditText.values()[(int)(Math.random() * (double)CreditText.values().length)];
        }
        return this.creditText;
    }

    public void setCreditText(CreditText creditText) {
        this.creditText = creditText;
    }

    public AlbumObjectFactory getFactory() {
        if (this.factory == null) {
            this.factory = this.removeDiacritics ? new NoDiacriticsAlbumObjectFactory(this) : new AlbumObjectFactory(this);
            this.factory.setIncludeMissing(false);
        }
        return this.factory;
    }

    static {
        ignoredVars.add("explorer");
        ignoredVars.add("licenseManager");
        ignoredVars.add("engine");
        ignoredVars.add("window");
        ignoredVars.add("context");
        ignoredVars.add("licenseManager");
    }

    public class ASTCache {
        private Map<Object, AST> cache = new HashMap<Object, AST>();

        public void clear() {
            this.cache = new HashMap<Object, AST>();
        }

        public AST get(File f) throws IOException, ElementException {
            AST ast = this.cache.get(f);
            if (ast == null) {
                ast = new AST(AlbumBean.this, new Template(LinkFile.getResolvedTarget(f, AlbumBean.this)).toSection(AlbumBean.this.globalVariables));
                this.cache.put(f, ast);
            }
            return ast;
        }

        public AST get(Section sec) throws ElementException {
            AST ast = this.cache.get(sec);
            if (ast == null) {
                ast = new AST(AlbumBean.this, new Template(sec).toSection(AlbumBean.this.globalVariables));
                this.cache.put(sec, ast);
            }
            return ast;
        }
    }

    private static enum ImageCategory {
        ALL(1, 2),
        CLOSEUP(3),
        THUMBNAIL(4, 5),
        FOLDER_THUMB(6, 7);

        private final Set<Integer> stages = new HashSet<Integer>();

        private ImageCategory(int ... stages) {
            for (int stage : stages) {
                this.stages.add(stage);
            }
        }

        public Set<Integer> getStages() {
            return this.stages;
        }
    }

    private static enum MakeMode {
        smart,
        all,
        changes;

    }

    public static enum CreditText {
        credit1,
        credit2,
        credit3,
        credit4,
        credit5,
        credit6,
        credit7,
        credit8,
        credit9,
        credit10,
        credit11,
        credit12;


        public String toString() {
            return Msg.get("ui." + this.name());
        }
    }
}

