/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.util.Scanner;
import javax.script.ScriptException;
import se.datadosen.jalbum.ASTEvaluator;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ast.ASTNode;
import se.datadosen.jalbum.ast.CaseNode;
import se.datadosen.jalbum.ast.ColIteratorNode;
import se.datadosen.jalbum.ast.DefaultNode;
import se.datadosen.jalbum.ast.EnterNode;
import se.datadosen.jalbum.ast.ExpressionLanguageNode;
import se.datadosen.jalbum.ast.GroupNode;
import se.datadosen.jalbum.ast.IfElseNode;
import se.datadosen.jalbum.ast.IncludeNode;
import se.datadosen.jalbum.ast.IteratorNode;
import se.datadosen.jalbum.ast.PictureNode;
import se.datadosen.jalbum.ast.RowIteratorNode;
import se.datadosen.jalbum.ast.ScriptletNode;
import se.datadosen.jalbum.ast.SwitchNode;
import se.datadosen.jalbum.ast.WidgetNode;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.Section;
import se.datadosen.util.Scope;

public class AST {
    public static final int AVERAGE_PAGE_BUFFER_SIZE = 65536;
    private final File sourceFile;
    private final AlbumBean engine;
    private final GroupNode rootNode;
    private final String[] names = new String[]{"ja:ignore", "ja:if", "ja:switch", "ja:case", "ja:default", "ja:eval", "ja:include", "ja:rowiterator", "ja:coliterator", "ja:fileiterator", "ja:iterator", "ja:widget", "ja:picture", "ja:ui", "ja:enter", "%--", "%"};

    public AST(AlbumBean engine, Section section) throws ElementException {
        this.engine = engine;
        this.sourceFile = section.getSourceFile();
        this.rootNode = this.buildTree(section);
    }

    public String eval(ASTEvaluator ev) throws ScriptException, ElementException {
        StringBuilder out = new StringBuilder(65536);
        this.rootNode.eval(ev, out);
        return AST.removeEmptyLines(out.toString());
    }

    public String eval(ASTEvaluator ev, Scope scope) throws ScriptException, ElementException {
        StringBuilder out = new StringBuilder(65536);
        ev.enterScope(scope);
        this.rootNode.eval(ev, out);
        ev.exitScope(scope);
        return AST.removeEmptyLines(out.toString());
    }

    private static String removeEmptyLines(String res) {
        StringBuilder buf = new StringBuilder(res.length());
        Scanner sc = new Scanner(res);
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            if (line.indexOf(12) != -1 && (line = ASTNode.stripMagicChars(line)).trim().length() == 0) continue;
            buf.append(line);
            buf.append("\r\n");
        }
        return buf.toString();
    }

    public GroupNode getRootNode() {
        return this.rootNode;
    }

    public GroupNode buildTree(Section section) throws ElementException {
        Element elem;
        GroupNode nodes = new GroupNode();
        while ((elem = Elements.getNextElement(this.names, section, true)) != null) {
            nodes.addTextNode(elem.getPreElement());
            switch (elem.getName()) {
                case "ja:if": {
                    IfElseNode n = new IfElseNode(elem, this);
                    nodes.add(n);
                    Element elseElement = n.getElseElement();
                    if (elseElement == null) break;
                    elem = elseElement;
                    break;
                }
                case "ja:switch": {
                    nodes.add(new SwitchNode(elem, this));
                    break;
                }
                case "ja:case": {
                    nodes.add(new CaseNode(elem, this));
                    break;
                }
                case "ja:default": {
                    nodes.add(new DefaultNode(elem, this));
                    break;
                }
                case "ja:ignore": {
                    nodes.addTextNode(elem.getContent());
                    break;
                }
                case "ja:include": {
                    nodes.add(new IncludeNode(elem, this));
                    break;
                }
                case "%": 
                case "ja:eval": {
                    nodes.add(new ScriptletNode(elem));
                    break;
                }
                case "$": {
                    nodes.add(new ExpressionLanguageNode(elem.getContent()));
                    break;
                }
                case "ja:rowiterator": {
                    nodes.add(new RowIteratorNode(elem, this));
                    break;
                }
                case "ja:coliterator": {
                    nodes.add(new ColIteratorNode(elem, this));
                    break;
                }
                case "ja:fileiterator": {
                    nodes.add(new IteratorNode(elem, this, () -> this.engine.currentObjects));
                    break;
                }
                case "ja:iterator": {
                    nodes.add(new IteratorNode(elem, this, () -> this.engine.reallyAllObjects));
                    break;
                }
                case "ja:widget": {
                    nodes.add(new WidgetNode(elem));
                    break;
                }
                case "ja:picture": {
                    nodes.add(new PictureNode(elem, this));
                    break;
                }
                case "ja:ui": 
                case "%--": {
                    break;
                }
                case "ja:enter": {
                    nodes.add(new EnterNode(elem, this));
                    break;
                }
                default: {
                    throw new ElementException(Msg.get("scripting.unknownElementError") + elem.getName(), elem.getContent());
                }
            }
            section = elem.getPostElement();
        }
        if (section.length() > 0) {
            nodes.addTextNode(section);
        }
        return nodes;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Abstract Syntax Tree for " + String.valueOf(this.sourceFile) + ":\n");
        this.printNode(this.rootNode, "", out);
        out.append('\n');
        return out.toString();
    }

    private void printNode(GroupNode group, String indent, StringBuilder out) {
        if (group.getMembers() != null) {
            for (ASTNode node : group.getMembers()) {
                out.append(indent);
                out.append(node);
                out.append('\n');
                if (!(node instanceof GroupNode)) continue;
                this.printNode((GroupNode)node, indent + "    ", out);
            }
        }
    }
}

