/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import javax.sound.sampled.AudioFormat;

public class VUOutputStream
extends OutputStream {
    private AudioFormat inputFormat;
    final boolean bigEndian;
    private OutputStream out;
    private Consumer<Short> onRefresh;
    private long lastNanoTime;
    private short min;
    private short max;
    private short vu;

    public VUOutputStream(AudioFormat inputFormat, OutputStream out) {
        this.inputFormat = inputFormat;
        this.out = out;
        if (inputFormat.getChannels() != 1 || inputFormat.getSampleSizeInBits() != 16) {
            throw new IllegalArgumentException("Not supported audio format. Use 1 channel, 16 bits");
        }
        this.bigEndian = inputFormat.isBigEndian();
        this.lastNanoTime = System.nanoTime();
    }

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.out != null) {
            this.out.write(b, off, len);
        }
        for (int i = off; i < off + len; i += 2) {
            short value = this.bigEndian ? (short)(b[i] << 8 & 0xFF00 | (short)(b[i + 1] & 0xFF)) : (short)(b[i + 1] << 8 & 0xFF00 | (short)(b[i] & 0xFF));
            if (this.min > value) {
                this.min = value;
            }
            if (this.max < value) {
                this.max = value;
            }
            if (this.vu >= value) continue;
            this.vu = value;
        }
        long nanoTime = System.nanoTime();
        if ((nanoTime - this.lastNanoTime) / 1000000L > 100L) {
            if (this.onRefresh != null) {
                this.onRefresh.accept(this.vu);
                this.vu = 0;
            }
            this.lastNanoTime = nanoTime;
        }
    }

    public short getVU() {
        short vuTmp = this.vu;
        this.vu = 0;
        return vuTmp;
    }

    public short getMin() {
        return this.min;
    }

    public short getMax() {
        return this.max;
    }

    public void onRefresh(Consumer<Short> onRefresh) {
        this.onRefresh = onRefresh;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOut() {
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }
}

