/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import net.jalbum.avif.AVIFImageReaderSpi;
import net.jalbum.avif.AVIFImageWriterSpi;
import net.jalbum.component.JCheckBoxList;
import net.jalbum.component.Selectable;
import se.datadosen.util.PersistentList;
import se.datadosen.util.VersionNumber;

public class IIORegistryManager {
    private static List<ImageReaderWriterSelectable<ImageReaderSpi>> readerSpis;
    private static List<ImageReaderWriterSelectable<ImageWriterSpi>> writerSpis;
    private static AbstractListModel<Selectable<ImageReaderSpi>> readersModel;
    private static AbstractListModel<Selectable<ImageWriterSpi>> writersModel;

    public static AbstractListModel<Selectable<ImageReaderSpi>> getReadersModel() {
        return readersModel;
    }

    public static AbstractListModel<Selectable<ImageWriterSpi>> getWritersModel() {
        return writersModel;
    }

    private static void deregisterAVIF(IIORegistry registry) {
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, false);
        block0: while (it.hasNext()) {
            ImageReaderSpi spi = it.next();
            if (spi.getClass() == AVIFImageReaderSpi.class) {
                registry.deregisterServiceProvider(spi);
                break;
            }
            Iterator<ImageWriterSpi> it2 = registry.getServiceProviders(ImageWriterSpi.class, false);
            while (it2.hasNext()) {
                ImageWriterSpi spi2 = it2.next();
                if (spi2.getClass() != AVIFImageWriterSpi.class) continue;
                registry.deregisterServiceProvider(spi2);
                continue block0;
            }
        }
    }

    static {
        boolean okJava;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        boolean bl = okJava = new VersionNumber(System.getProperty("java.version")).compareTo(new VersionNumber("22")) >= 0;
        if (!okJava) {
            IIORegistryManager.deregisterAVIF(registry);
        }
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, true);
        readerSpis = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).map(spi -> new ImageReaderWriterSelectable<ImageReaderSpi>((ImageReaderSpi)spi)).collect(Collectors.toList());
        Iterator<ImageWriterSpi> it2 = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        writerSpis = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it2, 16), false).map(spi -> new ImageReaderWriterSelectable<ImageWriterSpi>((ImageWriterSpi)spi)).collect(Collectors.toList());
        readersModel = new AbstractListModel<Selectable<ImageReaderSpi>>(){

            @Override
            public int getSize() {
                return readerSpis.size();
            }

            @Override
            public Selectable<ImageReaderSpi> getElementAt(int index) {
                return readerSpis.get(index);
            }
        };
        writersModel = new AbstractListModel<Selectable<ImageWriterSpi>>(){

            @Override
            public int getSize() {
                return writerSpis.size();
            }

            @Override
            public Selectable<ImageWriterSpi> getElementAt(int index) {
                return writerSpis.get(index);
            }
        };
    }

    public static class ImageReaderWriterSelectable<T extends ImageReaderWriterSpi>
    extends Selectable<T> {
        public ImageReaderWriterSelectable(T object) {
            super(object);
            this.selected = true;
        }

        @Override
        public void setSelected(boolean selected) {
            if (selected) {
                IIORegistry.getDefaultInstance().registerServiceProvider(this.getObject());
                super.setSelected(selected);
            } else if (!((ImageReaderWriterSpi)this.getObject()).getPluginClassName().startsWith("com.sun")) {
                IIORegistry.getDefaultInstance().deregisterServiceProvider(this.getObject());
                super.setSelected(selected);
            }
        }

        @Override
        public String toString() {
            return ((ImageReaderWriterSpi)this.getObject()).getDescription(Locale.getDefault());
        }
    }

    public static class JReadersWritersList<T extends ImageReaderWriterSpi>
    extends JCheckBoxList<T>
    implements PersistentList {
        public JReadersWritersList(ListModel<Selectable<T>> dataModel) {
            super(dataModel);
            this.small();
            this.setCellRenderer(new JCheckBoxList.CheckBoxCellRenderer<T>(){

                @Override
                public Component getListCellRendererComponent(JList<? extends Selectable<T>> list, Selectable<T> value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setEnabled(!((ImageReaderWriterSpi)value.getObject()).getPluginClassName().startsWith("com.sun"));
                    return this;
                }
            });
        }

        @Override
        public List<String> getContent() {
            ListModel model = this.getModel();
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < model.getSize(); ++i) {
                Selectable e = (Selectable)model.getElementAt(i);
                if (e.isSelected()) continue;
                result.add(((ImageReaderWriterSpi)e.getObject()).getPluginClassName());
            }
            return result;
        }

        @Override
        public void setContent(List<String> data) {
            block0: for (String pluginClassName : data) {
                ListModel model = this.getModel();
                ArrayList result = new ArrayList();
                for (int i = 0; i < model.getSize(); ++i) {
                    Selectable e = (Selectable)model.getElementAt(i);
                    if (!((ImageReaderWriterSpi)e.getObject()).getPluginClassName().equals(pluginClassName)) continue;
                    e.setSelected(false);
                    continue block0;
                }
            }
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            int index = this.locationToIndex(me.getPoint());
            if (index > -1) {
                Selectable item = (Selectable)this.getModel().getElementAt(index);
                return ((ImageReaderWriterSpi)item.getObject()).getPluginClassName();
            }
            return null;
        }
    }
}

