/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import se.datadosen.jalbum.JAlbumUtilities;

public class ConsoleStream
extends OutputStream {
    private final JTextComponent console;
    private boolean debug = false;

    public ConsoleStream(JTextComponent console) {
        this.console = console;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        String aString = new String(b, off, len);
        Document doc = this.console.getDocument();
        if (doc != null) {
            JAlbumUtilities.runOnAWT(() -> {
                try {
                    if (this.console instanceof JTextArea) {
                        ((JTextArea)this.console).append(aString);
                    } else {
                        doc.insertString(doc.getLength(), aString, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            });
        }
        SwingUtilities.invokeLater(() -> {
            try {
                Rectangle2D r = this.console.modelToView2D(doc.getEndPosition().getOffset());
                this.console.scrollRectToVisible(r.getBounds());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        int x = 10;
    }

    @Override
    public void write(int b) {
    }
}

