/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jalbum.util.Profiler;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.SkinInfo;
import se.datadosen.util.IO;

public class ChainedSkinsDirectory
extends ChainedDirectory {
    public static final String BUNDLED_SKINS_NAME = "bundled-skins";
    FileFilter dirsFilter = f -> f.isDirectory();
    FileFilter dirsAndZippedSkinsFilter = f -> f.isDirectory() || IO.extensionOf(f).toLowerCase().equals("jaskin") || IO.extensionOf(f).toLowerCase().equals("zip");

    public ChainedSkinsDirectory(File dir) {
        super(dir);
    }

    public ChainedSkinsDirectory(File dir, ChainedDirectory backgroundDir) {
        super(dir, backgroundDir);
    }

    @Override
    public File getFile(String name) {
        SkinInfo skinInfo = this.listSkins(name).get(name);
        if (skinInfo != null) {
            if (skinInfo.isZipped()) {
                return skinInfo.install();
            }
            return skinInfo.getSkinFile();
        }
        return new File(this, name);
    }

    private static File[] safeListFiles(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    public Map<String, SkinInfo> listSkins() {
        return this.listSkins(null);
    }

    private Map<String, SkinInfo> listSkins(String name) {
        try (Profiler.Sample _s = Profiler.profile("Listing skins");){
            Map map = ChainedSkinsDirectory.streamSkins(this, name).collect(Collectors.toMap(SkinInfo::getName, Function.identity(), (existing, incoming) -> incoming.getVersion().compareTo(existing.getVersion()) > 0 ? incoming : existing, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
            return map;
        }
    }

    private static Stream<SkinInfo> streamSkins(ChainedSkinsDirectory dir, String nameFilter) {
        Stream<SkinInfo> main = Arrays.stream(ChainedSkinsDirectory.safeListFiles(dir.getDirectory(), dir.getBackgroundDirectory() == null ? dir.dirsAndZippedSkinsFilter : dir.dirsFilter)).map(SkinInfo::new).filter(skin -> nameFilter == null || skin.getName().equals(nameFilter));
        Stream bg = dir.getBackgroundDirectory() != null ? ChainedSkinsDirectory.streamSkins((ChainedSkinsDirectory)dir.getBackgroundDirectory(), nameFilter) : Stream.empty();
        return Stream.concat(main, bg);
    }
}

