/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import se.datadosen.io.Cached;
import se.datadosen.io.CachedFile;
import se.datadosen.io.LinkFile;

public class CachedLinkFile
extends LinkFile
implements Cached {
    private final Boolean directory;
    private Long lastMod;
    private final Long length;
    private final Boolean exists;
    private boolean cacheing = true;

    public CachedLinkFile(File parent, String name, CachedFile target) {
        super(parent, name, target);
        this.directory = target.isDirectory();
        this.lastMod = target.lastModified();
        this.length = target.length();
        this.exists = true;
    }

    @Override
    public boolean isCacheing() {
        return this.cacheing;
    }

    @Override
    public void setCacheing(boolean cacheing) {
        this.cacheing = cacheing;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public long lastModified() {
        if (!this.cacheing) {
            return super.lastModified();
        }
        return this.lastMod;
    }

    @Override
    public boolean setLastModified(long time) {
        boolean ok = super.setLastModified(time);
        if (ok) {
            this.lastMod = time;
        }
        return ok;
    }

    @Override
    public long length() {
        if (!this.cacheing) {
            return super.length();
        }
        return this.length;
    }

    @Override
    public boolean exists() {
        if (!this.cacheing) {
            return super.exists();
        }
        return this.exists;
    }

    @Override
    public File toFile() {
        return new LinkFile(this.link.getParentFile(), this.link.getName(), this.target);
    }
}

