/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.EnumSet;
import net.jalbum.util.Profiler;
import se.datadosen.io.CachedFile;
import se.datadosen.util.Platform;

class CachedFileSupport {
    CachedFileSupport() {
    }

    static CachedFile[] listContent(File file) throws IOException {
        final boolean isMac = Platform.isMac();
        try (Profiler.Sample _s = Profiler.profile("Reading file attributes");){
            Path start = file.toPath();
            final ArrayList files = new ArrayList();
            Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String s;
                    if (Thread.currentThread().isInterrupted()) {
                        System.out.println("Interrupt detected");
                        return FileVisitResult.TERMINATE;
                    }
                    if (isMac && !Normalizer.isNormalized(s = p.toString(), Normalizer.Form.NFC)) {
                        p = Paths.get(Normalizer.normalize(s, Normalizer.Form.NFC), new String[0]);
                    }
                    CachedFile cf = new CachedFile(p.toFile(), attrs.isDirectory(), attrs.isSymbolicLink(), attrs.lastModifiedTime().toMillis(), attrs.size());
                    files.add(cf);
                    return FileVisitResult.CONTINUE;
                }
            });
            CachedFile[] cachedFileArray = files.toArray(new CachedFile[files.size()]);
            return cachedFileArray;
        }
    }

    static boolean isSymbolicLink(File file) {
        Path p = file.toPath();
        return Files.isSymbolicLink(p);
    }
}

