/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;

class Stamp {
    Stamp() {
    }

    public static void press(BufferedImage bi, Image stamp) {
        Graphics g = bi.getGraphics();
        Stamp.press(g, bi.getWidth(), bi.getHeight(), stamp, 70, 1.0f);
        g.dispose();
    }

    public static void press(JComponent comp, Graphics g, Image stamp) {
        Stamp.press(comp, g, stamp, 70, 1.0f);
    }

    public static void press(JComponent comp, Graphics g, Image stamp, float alpha) {
        Stamp.press(comp, g, stamp, 70, alpha);
    }

    public static void press(JComponent comp, Graphics g, Image stamp, int percentage, float alpha) {
        Stamp.press(g, comp.getWidth(), comp.getHeight(), stamp, percentage, alpha);
    }

    private static void press(Graphics g2D, int width, int height, Image stamp, int maxPercentage, float alpha) {
        Graphics2D g = (Graphics2D)g2D.create();
        int w = stamp.getWidth(null) / 2;
        int h = stamp.getHeight(null) / 2;
        double ratio = (double)w / (double)h;
        if (alpha != 1.0f) {
            AlphaComposite composite = AlphaComposite.getInstance(3, alpha);
            g.setComposite(composite);
        }
        if (w > width * maxPercentage / 100 || h > height * maxPercentage / 100) {
            w = width * maxPercentage / 100;
            h = (int)((double)w / ratio);
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawImage(stamp, (width - w) / 2, (height - h) / 2, w, h, null);
        g.dispose();
    }

    public static void press(JComponent comp, Icon icon) {
        Stamp.press(comp, (Graphics)((Graphics2D)comp.getGraphics()), icon, 70, 1.0f);
    }

    private static void press(JComponent comp, Graphics g2D, Icon icon, int maxPercentage, float alpha) {
        int width = comp.getWidth();
        int height = comp.getHeight();
        Graphics2D g = (Graphics2D)g2D.create();
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        double ratio = (double)w / (double)h;
        if (alpha != 1.0f) {
            AlphaComposite composite = AlphaComposite.getInstance(3, alpha);
            g.setComposite(composite);
        }
        if (w > width * maxPercentage / 100 || h > height * maxPercentage / 100) {
            w = width * maxPercentage / 100;
            h = (int)((double)w / ratio);
        }
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(comp, g2D, (width - w) / 2, (height - h) / 2);
        g.dispose();
    }
}

