/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ScaledIcon
implements Icon {
    private final Icon target;
    private final JComponent comp;

    public ScaledIcon(Icon target, JComponent comp) {
        this.target = target;
        this.comp = comp;
    }

    public Icon getTarget() {
        return this.target;
    }

    @Override
    public void paintIcon(Component c, Graphics g2d, int x, int y) {
        Graphics2D g = (Graphics2D)g2d;
        AffineTransform backup = g.getTransform();
        g.translate(x, y);
        double scaleFactor = this.calcScaleFactor();
        if (scaleFactor != 1.0) {
            g.scale(scaleFactor, scaleFactor);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        this.target.paintIcon(c, g, 0, 0);
        g.setTransform(backup);
    }

    private double calcScaleFactor() {
        int width = this.target.getIconWidth();
        int height = this.target.getIconHeight();
        Dimension boundingBox = this.comp.getPreferredSize();
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double scaleFactor = 1.0 / Math.max(widthScale, heightScale);
        return scaleFactor;
    }

    @Override
    public int getIconWidth() {
        return (int)((double)this.target.getIconWidth() * this.calcScaleFactor());
    }

    @Override
    public int getIconHeight() {
        return (int)((double)this.target.getIconHeight() * this.calcScaleFactor());
    }
}

