/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.io.IOException;
import javax.swing.JTextArea;
import se.datadosen.component.Autocompleter;
import se.datadosen.component.WordList;
import se.datadosen.explorer.AbstractEditor;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.StringUtil;

class KeywordsEditor
extends AbstractEditor {
    public static final Color keywordsColor = new Color(0, 128, 0);

    public KeywordsEditor(JAlbumObject jao) {
        super(jao);
    }

    @Override
    public String readText() {
        return this.ao.getKeywords();
    }

    @Override
    public void writeText(String text) throws IOException {
        this.ao.setKeywords(text);
        WordList knownKeywords = this.jao.context.context.knownKeywords;
        knownKeywords.addAll(StringUtil.stringToSet(this.ao.getKeywords()));
        Tracer.getInstance().trace("keywords edited", "location:explorer");
    }

    @Override
    public String getPromptText() {
        return Msg.get("ui.addKeywords");
    }

    @Override
    protected Color getTextColor() {
        return keywordsColor;
    }

    @Override
    protected JTextArea getEditArea() {
        if (this.editArea == null) {
            super.getEditArea();
            new Autocompleter(this.editArea, this.jao.context.context.knownKeywords);
            this.editArea.setToolTipText(Msg.get("edit.keywordsToolTip"));
        }
        return this.editArea;
    }
}

