/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.jalbum.review.ReviewMode;
import net.jalbum.util.Work;
import net.jalbum.views.View;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JDividerBar;
import se.datadosen.component.JFadingText;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JNiceTextField;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JStackLabel;
import se.datadosen.component.NonCollapsableJTree;
import se.datadosen.component.RiverLayout2;
import se.datadosen.component.ToggleAction;
import se.datadosen.explorer.FolderTreeNode;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.explorer.JPeekPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.LinkAlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.VirtualFolder;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Platform;
import se.datadosen.util.WindowUtilities;
import se.datadosen.util.annotations.Icon;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JViewExplorer
extends JDialog {
    private static AlbumObject.Ordering[] orderings = new AlbumObject.Ordering[]{AlbumObject.Ordering.name, AlbumObject.Ordering.date, AlbumObject.Ordering.cameraDate, AlbumObject.Ordering.addedDate, AlbumObject.Ordering.rating, AlbumObject.Ordering.title, AlbumObject.Ordering.comment, AlbumObject.Ordering.category, AlbumObject.Ordering.extension, AlbumObject.Ordering.jalbum};
    private JAlbumExplorer context;
    private ViewAlbumObject viewObject;
    private VirtualFolder currentFolder;
    private JViewObjectsPanel explorer;
    private JAddressField addressField;
    private JScrollPane contentsScroller;
    private final JTree tree = new NonCollapsableJTree((TreeModel)null);
    private JScrollPane treeScroller = new JScrollPane(this.tree);
    private JPanel rightPanel = new JPanel(new BorderLayout());
    private JSplitPane splitter = new JSplitPane(1, this.treeScroller, this.rightPanel);
    private JStackLabel statusBar = new JStackLabel();
    private JPeekPanel peekPanel;
    private JProgressSpinner progressSpinner = new JProgressSpinner();
    @ToolTipText(value="ui.up")
    @Icon(value="16x16/folder-up.svg")
    public Action parentFolderAction = new LambdaAction(() -> {
        if (this.currentFolder.isWithin(this.viewObject) && this.currentFolder != this.viewObject) {
            try {
                this.tree.setSelectionPath(this.tree.getSelectionPath().getParentPath());
            }
            catch (Exception ex) {
                this.selectNode(this.currentFolder.getParent());
            }
        }
    }).enabled(false);
    @Text(value="edit.open")
    public Action openAction = new LambdaAction(() -> {
        AlbumObject selected = this.explorer.selectionModel.getSingleSelected().ao;
        if (selected.isFolder()) {
            this.selectNode(selected);
        }
    });
    @ToolTipText(value="ui.reload")
    @Icon(value="16x16/refresh.svg")
    final Action reloadAction = new LambdaAction(() -> {
        this.viewObject.invalidate();
        this.viewObject.updateRepresentingIcon();
        this.configureTree();
    });
    @ToolTipText(value="ui.editView")
    @Icon(value="16x16/edit.svg")
    final Action editAction = new LambdaAction(() -> {
        View view = this.viewObject.getView();
        JComponent ui = view.getUserInterface(this.viewObject, this.context);
        JOptionPane optPane = new JOptionPane(ui, -1, 2);
        JDialog dialog = optPane.createDialog(this, Msg.get("ui.editView"));
        ContextHelp.getInstance().installHelpButton(dialog, ContextHelp.Corner.TOP_RIGHT);
        dialog.pack();
        dialog.setVisible(true);
        if (optPane.getValue() instanceof Integer && (Integer)optPane.getValue() == 0) {
            ((EditListener)((Object)ui)).setAlbumObject(null);
            this.reloadAction.actionPerformed(null);
        } else {
            view.cancelEdit();
        }
    });
    @Text(value="ui.applyToSubFolders")
    @ToolTipText(value="ui.applyToSubFoldersToolTip")
    final Action applyToSubFoldersAction = new LambdaAction(() -> {
        VirtualFolder cf = this.currentFolder;
        Work.on(this.currentFolder.getDescendants().parallelStream()).filter(ao -> ao instanceof VirtualFolder).titled(Msg.get("ui.applyToSubFolders")).forEach(ao -> {
            ao.setReverseOrdering(cf.isReverseOrdering());
            ao.setOrdering(cf.getOrdering());
            ((VirtualFolder)ao).reorder();
        });
        this.configureTree();
    });
    @ToolTipText(value="ui.imageOrderingBorder")
    @Icon(value="16x16/ordering.svg")
    JMenuButton orderingButton = new JMenuButton(){

        @Override
        protected void onShowMenu() {
            this.menu.removeAll();
            AlbumObject.Ordering selectedOrdering = JViewExplorer.this.currentFolder.getOrdering();
            for (AlbumObject.Ordering o : orderings) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(o.toString());
                item.setActionCommand(o.name());
                if (o == selectedOrdering) {
                    item.setSelected(true);
                }
                item.addActionListener(ae -> JViewExplorer.this.setOrdering(AlbumObject.Ordering.valueOf(item.getActionCommand()), JViewExplorer.this.currentFolder.isReverseOrdering()));
                this.menu.add(item);
            }
            this.menu.addSeparator();
            JCheckBoxMenuItem reverse = new JCheckBoxMenuItem(Msg.get("edit.reverseOrdering"));
            reverse.setSelected(JViewExplorer.this.currentFolder.isReverseOrdering());
            if (JViewExplorer.this.currentFolder.getOrdering() == AlbumObject.Ordering.jalbum) {
                reverse.setSelected(false);
            }
            reverse.setEnabled(JViewExplorer.this.currentFolder.getOrdering() != AlbumObject.Ordering.jalbum);
            reverse.addActionListener(ae -> JViewExplorer.this.setOrdering(JViewExplorer.this.currentFolder.getOrdering(), reverse.isSelected()));
            this.menu.add(reverse);
            this.menu.addSeparator();
            this.menu.add(JViewExplorer.this.applyToSubFoldersAction);
        }
    };
    @Text(value="ui.showTarget")
    public Action showTargetAction = new LambdaAction(() -> {
        LinkAlbumObject link;
        AlbumObject target;
        JAlbumObject selected = this.explorer.selectionModel.getSingleSelected();
        if (selected != null && selected.ao instanceof LinkAlbumObject && (target = (link = (LinkAlbumObject)selected.ao).getTarget()) != null) {
            this.context.parent.toFront();
            this.context.gotoPath(target.getPathFromRoot());
        }
    });
    Action closeAction = new LambdaAction("close", () -> this.setVisible(false));
    @Text(value="edit.folderThumbnail")
    @Icon(value="16x16/folderthumb.svg")
    private ToggleAction useAsFolderThumbnailAction = new ToggleAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumObject jao = JViewExplorer.this.explorer.selectionModel.getSingleSelected();
            AlbumObjectImpl ao = (AlbumObjectImpl)jao.ao;
            JViewExplorer.this.currentFolder.setRepresentingAlbumObject(this.isSelected() ? ao : null);
        }
    };
    @Text(value="ui.review")
    public Action reviewModeAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JAlbumExplorer.space);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReviewMode rm = new ReviewMode(JViewExplorer.this.explorer, JViewExplorer.this.context);
            rm.setVisible(true);
        }
    };
    private PropertyChangeListener nameListener = pce -> this.updateTitle();
    private PropertyChangeListener rootFolderListener = pce -> this.setVisible(false);
    private PropertyChangeListener representingAlbumObjectListener = evt -> this.explorer.repaint();
    private PropertyChangeListener orderingListener = evt -> {
        JFadingText fadingText = new JFadingText(Msg.get("ui.orderingHint", this.currentFolder.getOrdering().toString()), (JComponent)this.getContentPane());
        fadingText.install(this);
        this.updateTitle();
    };
    private PropertyChangeListener modelChangedListener = evt -> this.reloadAction.actionPerformed(null);
    private TreeSelectionListener treeSelectionListener = e -> {
        TreePath tp = e.getNewLeadSelectionPath();
        if (tp != null) {
            FolderTreeNode selectedNode = (FolderTreeNode)tp.getLastPathComponent();
            this.viewFolder((VirtualFolder)selectedNode.getAlbumObject());
        }
    };
    private boolean initiated;

    private void setOrdering(AlbumObject.Ordering ordering, boolean reverse) {
        try {
            this.currentFolder.setOrdering(ordering);
            this.currentFolder.setReverseOrdering(reverse);
            this.currentFolder.reorder();
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
        this.configureTree();
    }

    private void updateTitle() {
        String title = this.viewObject.getName() + " (" + ((View)this.viewObject.getProperties().get("view")).getName();
        if (this.currentFolder != null && this.currentFolder.getOrdering() != AlbumObject.Ordering.jalbum) {
            title = title + " - ";
            if (this.currentFolder.isReverseOrdering()) {
                title = title + Msg.get("edit.reverseOrdering") + " ";
            }
            title = title + String.valueOf((Object)this.currentFolder.getOrdering());
        }
        title = title + ")";
        this.setTitle(title);
    }

    public JViewExplorer(JAlbumExplorer context, ViewAlbumObject viewObject) {
        super((Window)context.parent, Dialog.ModalityType.MODELESS);
        this.setAlwaysOnTop(false);
        this.context = context;
        this.viewObject = viewObject;
        viewObject.addPropertyChangeListener("name", this.nameListener);
        viewObject.addPropertyChangeListener("modelChanged", this.modelChangedListener);
        context.parent.addPropertyChangeListener("rootFolder", this.rootFolderListener);
        Msg.maintainTranslated(this);
        this.updateTitle();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        pane.registerKeyboardAction(this.closeAction, "close", ks, 2);
        this.explorer = new JViewObjectsPanel(context);
        this.peekPanel = new JPeekPanel(this.explorer);
        JComponent cp = (JComponent)this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1));
        this.contentsScroller = new JScrollPane(this.explorer);
        Config.getConfig().bind("explorerScrollSpeed", pce -> this.contentsScroller.getVerticalScrollBar().setUnitIncrement(Config.getConfig().getExplorerScrollSpeed()));
        this.addressField = new JAddressField();
        this.tree.setBackground(JAlbumColor.text);
        this.splitter.setContinuousLayout(true);
        this.treeScroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JAlbumColor.border));
        this.tree.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.rightPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JAlbumColor.border));
        this.contentsScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, JAlbumColor.border));
        this.configureTree();
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                JViewExplorer.this.adjustDivider();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                JViewExplorer.this.adjustDivider();
            }
        });
        Config.getConfig().addPropertyChangeListener("labelType", evt -> {
            if (this.currentFolder != null) {
                this.explorer.objects().forEach(jao -> jao.setupViewMode());
                this.validate();
                context.repaint();
            }
        });
        Config.getConfig().addPropertyChangeListener("thumbnailQuality", pce -> this.explorer.repaint());
        JCleanToolBar tb = new JCleanToolBar(this.parentFolderAction, this.reloadAction);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)tb, "West");
        topPanel.add((Component)this.addressField, "Center");
        JCleanToolBar rightToolBar = new JCleanToolBar();
        rightToolBar.add(this.editAction);
        rightToolBar.add(this.orderingButton);
        topPanel.add((Component)rightToolBar, "East");
        this.rightPanel.add((Component)topPanel, "North");
        this.rightPanel.add((Component)this.contentsScroller, "Center");
        JPanel southPanel = new JPanel(new RiverLayout2());
        southPanel.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
        southPanel.add(this.progressSpinner);
        JLabel sourceLabel = JViewExplorer.createViewSourceLabel(viewObject);
        if (Platform.isMac()) {
            this.statusBar.setFont(this.statusBar.getFont().deriveFont(this.statusBar.getFont().getSize2D() - 2.0f));
            sourceLabel.setFont(this.statusBar.getFont());
        }
        sourceLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        southPanel.add(this.statusBar);
        southPanel.add(new JDividerBar());
        southPanel.add(sourceLabel);
        cp.add((Component)southPanel, "South");
        this.explorer.configureKeys(this.contentsScroller);
        this.explorer.getInputMap(1).put(JAlbumExplorer.space, "reviewModeAction");
        this.explorer.getActionMap().put("reviewModeAction", this.reviewModeAction);
        this.explorer.getInputMap(1).put(JAlbumExplorer.backspace, "parentFolderAction");
        this.explorer.getActionMap().put("parentFolderAction", this.parentFolderAction);
        this.explorer.getInputMap(1).put(JAlbumExplorer.enter, "openAction");
        this.explorer.getActionMap().put("openAction", this.openAction);
        this.setPreferredSize(new Dimension(720, 520));
        this.pack();
        WindowUtilities.positionChildAtCorner(this, context.parent, 20);
    }

    private void postInit() {
        if (!this.initiated) {
            JComponent cp = (JComponent)this.getContentPane();
            if (this.viewObject.getChildren(Category.folder).isEmpty()) {
                cp.add((Component)this.rightPanel, "Center");
            } else {
                cp.add((Component)this.splitter, "Center");
            }
            this.validate();
            this.repaint();
            this.initiated = true;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        SwingUtilities.invokeLater(() -> this.explorer.requestFocusInWindow());
    }

    private void viewFolder(VirtualFolder folder) {
        if (this.currentFolder != null) {
            this.currentFolder.removePropertyChangeListener(this.representingAlbumObjectListener);
            this.currentFolder.removePropertyChangeListener(this.orderingListener);
        }
        this.currentFolder = folder;
        this.currentFolder.addPropertyChangeListener("representingAlbumObject", this.representingAlbumObjectListener);
        this.currentFolder.addPropertyChangeListener("ordering", this.orderingListener);
        this.addressField.setText(folder.getPathFromRoot());
        this.explorer.viewFolder(folder);
        this.selectNode(folder);
        this.parentFolderAction.setEnabled(this.currentFolder.isWithin(this.viewObject) && this.currentFolder != this.viewObject);
        this.updateStatusBar();
        this.updateTitle();
    }

    public void selectNode(AlbumObject folder) {
        TreePath path = this.getTreePathFor(folder);
        this.tree.setSelectionPath(path);
        this.tree.expandPath(path);
    }

    private void adjustDivider() {
        SwingUtilities.invokeLater(() -> {
            int newWidth = this.tree.getPreferredSize().width;
            this.splitter.setDividerLocation(newWidth += 12);
        });
    }

    private TreePath getTreePathFor(AlbumObject folder) {
        LinkedList<AlbumObject> ancestors = new LinkedList<AlbumObject>();
        AlbumObject ao = folder;
        while (ao.getParent() != null) {
            ancestors.addFirst(ao);
            ao = ao.getParent();
        }
        TreePath tp = new TreePath(this.tree.getModel().getRoot());
        block1: for (AlbumObject ao2 : ancestors) {
            FolderTreeNode node = (FolderTreeNode)tp.getLastPathComponent();
            Enumeration<TreeNode> tne = node.children();
            while (tne.hasMoreElements()) {
                FolderTreeNode child = (FolderTreeNode)tne.nextElement();
                if (child.getAlbumObject() != ao2) continue;
                tp = tp.pathByAddingChild(child);
                continue block1;
            }
        }
        return tp;
    }

    private void configureTree() {
        this.progressSpinner.workStarted();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            FolderTreeNode rootNode = new FolderTreeNode(this.viewObject);
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            this.tree.removeTreeSelectionListener(this.treeSelectionListener);
            this.tree.setModel(treeModel);
            this.tree.addTreeSelectionListener(this.treeSelectionListener);
            return rootNode;
        }).thenAcceptAsync(rootNode -> JAlbumUtilities.runOnAWT(() -> {
            this.viewFolder(this.currentFolder != null ? this.currentFolder : this.viewObject);
            this.postInit();
            this.adjustDivider();
        }))).whenComplete((rootNode, error) -> this.progressSpinner.workDone());
    }

    private void updateStatusBar() {
        this.statusBar.setText(this.currentFolder.getChildren().size() + " " + Msg.get("ui.objects"));
    }

    private static JLabel createViewSourceLabel(ViewAlbumObject viewObject) {
        String msg = Msg.get("info.source") + ": /";
        JLabel label = new JLabel();
        try {
            label.setText(msg + viewObject.getViewSource().getPathFromRoot());
        }
        catch (IllegalArgumentException ex) {
            label.setText(msg + String.valueOf(viewObject.getProperties().get("viewSource")));
            label.setForeground(Color.red);
        }
        return label;
    }

    private class JViewObjectsPanel
    extends JAlbumObjectsPanel {
        MouseAdapter mouseOnComponentAdapter;

        public JViewObjectsPanel(JAlbumExplorer context) {
            super(context);
            this.mouseOnComponentAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    JAlbumObject jao = (JAlbumObject)e.getComponent();
                    JViewExplorer.this.peekPanel.mousePressed(e, () -> JViewExplorer.this.peekPanel.scaleToFit(jao.ao.loadImage(true, JViewExplorer.this.peekPanel.getSize(), true)));
                    if (e.isConsumed()) {
                        return;
                    }
                    JViewObjectsPanel.this.handleSelection(e);
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JViewExplorer.this.peekPanel.mouseReleased(e);
                    JViewObjectsPanel.this.handleSelectionMouseReleased(e);
                    this.maybeShowPopup(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    JAlbumObject jao = (JAlbumObject)e.getComponent();
                    if (!jao.isFocusOwner()) {
                        jao.requestFocusInWindow();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    JAlbumObject jao = (JAlbumObject)e.getComponent();
                    if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                        if (jao.ao.isFolder()) {
                            JViewExplorer.this.viewFolder((VirtualFolder)jao.ao);
                        } else {
                            JViewExplorer.this.showTargetAction.actionPerformed(null);
                        }
                    }
                }

                private void maybeShowPopup(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JAlbumObject jao = (JAlbumObject)e.getComponent();
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(JViewExplorer.this.showTargetAction);
                        JViewExplorer.this.useAsFolderThumbnailAction.setSelected(((AlbumObjectImpl)jao.ao).isClosestRepObject());
                        popup.add(JViewExplorer.this.useAsFolderThumbnailAction.createJCheckBoxMenuItem());
                        popup.add(JViewExplorer.this.reviewModeAction);
                        popup.show(jao, e.getPoint().x, e.getPoint().y);
                    }
                }
            };
            this.setIconScale(0.8);
            this.explorerThumbsLayout.setHgap(12);
            this.explorerThumbsLayout.setVgap(6);
            this.setLayout(this.explorerThumbsLayout);
            this.setBackground(JAlbumColor.text);
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
        }

        private void viewFolder(AlbumObject folder) {
            this.removeAll();
            for (AlbumObject ao : folder.getChildren()) {
                JAlbumObject jao = new JAlbumObject(ao, this);
                jao.addMouseListener(this.mouseOnComponentAdapter);
                this.add(jao);
            }
            this.validate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            int width;
            Dimension pref = super.getPreferredSize();
            Container parent = this.getParent();
            if (parent instanceof JViewport && (width = ((JViewport)parent).getWidth()) > 0) {
                pref.width = width;
            }
            return pref;
        }

        @Override
        protected MouseAdapter getMouseOnComponentAdapter() {
            return this.mouseOnComponentAdapter;
        }
    }

    private class JAddressField
    extends JNiceTextField {
        public JAddressField() {
            this.setFont(JAlbumFrame.H3_FONT);
            this.setEditable(false);
        }
    }
}

