/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.browser.BrowserPanel;
import net.jalbum.component.JRememberedFrame;
import net.jalbum.component.RememberedName;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrameIcons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;

@RememberedName(value="Preview window")
public class JPreviewWindow
extends JRememberedFrame {
    private BrowserPanel browserPanel;
    private final JMenuBar menuBar = new JMenuBar();
    private final JMenu fileMenu = new JMenu(Msg.get("ui.fileMenu"));
    private final JMenu viewMenu = new JMenu(Msg.get("ui.view"));
    private final JMenu developerMenu = new JMenu(Msg.get("ui.developer"));
    private final Action fullScreenAction = new AbstractAction(Msg.get("ui.enterFullScreen")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(122, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPreviewWindow.this.browserPanel.getBrowserPane().getBrowser().setFullScreen(!JPreviewWindow.this.browserPanel.getBrowserPane().getBrowser().isFullScreen());
        }
    };
    private final Action viewSourceAction = new AbstractAction(Msg.get("ui.viewSource")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPreviewWindow.this.browserPanel.getBrowserPane().getBrowser().viewSource();
        }
    };
    private final Action developerToolsAction = new AbstractAction(Msg.get("ui.developerTools")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x200));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPreviewWindow.this.browserPanel.getBrowserPane().getBrowser().openDeveloperTools();
        }
    };
    private final Action closeWinAction = new AbstractAction(Msg.get("ui.closeWindow")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPreviewWindow.this.setVisible(false);
        }
    };
    private final Action showMainWindow = new AbstractAction(Msg.get("ui.showMainWindow")){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JAlbumContext.getInstance().getFrame().toFront();
        }
    };

    public JPreviewWindow() throws HeadlessException {
        super(Msg.get("ui.preview"));
        this.init();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            SwingUtilities.invokeLater(() -> this.browserPanel.requestFocus());
        }
    }

    private void init() {
        this.setIconImages(JAlbumFrameIcons.getInstance().getWindowIcons());
        if (!Platform.isMac()) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }
        this.fileMenu.add(this.closeWinAction);
        this.viewMenu.add(this.showMainWindow);
        this.developerMenu.add(this.viewSourceAction);
        this.developerMenu.add(this.developerToolsAction);
        this.viewMenu.add(this.developerMenu);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
    }

    void installBrowserPanel(BrowserPanel browserPanel) {
        this.browserPanel = browserPanel;
        if (this.getContentPane().getComponentCount() == 0) {
            this.getContentPane().add((Component)browserPanel, "Center");
            this.validate();
        }
    }

    static class MyMenuItem
    extends MenuItem {
        public MyMenuItem(String label) throws HeadlessException {
            super(label);
            this.setFont(new JMenuItem().getFont());
            this.setFont(this.getFont().deriveFont(this.getFont().getSize() + 2));
        }
    }

    static class MyMenu
    extends Menu {
        public MyMenu(String label) throws HeadlessException {
            super(label);
            this.setFont(new JMenu().getFont());
            this.setFont(this.getFont().deriveFont(this.getFont().getSize() + 2));
        }
    }
}

