/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JModalPanel;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObjectsPanel;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.util.GraphicsUtilities;

public class JPeekPanel
extends JModalPanel
implements DragGestureListener {
    private DragGestureListener secondListener;
    private static final BufferedImage cursorImg = new BufferedImage(1, 1, 2);
    private static final Cursor invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "invisibleCursor");
    private JBackgroundPanel image = new JBackgroundPanel();
    private final JAlbumObjectsPanel explorer;
    private Future longClickFuture = null;

    BufferedImage scaleToFit(Image im) {
        Dimension newSize = GraphicsUtilities.fitWithinBounds(im.getWidth(null), im.getHeight(null), this.getSize());
        newSize.width = (int)((double)newSize.width * 0.9);
        newSize.height = (int)((double)newSize.height * 0.9);
        return GraphicsUtilities.getFasterScaledInstance((BufferedImage)im, newSize.width, newSize.height, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
    }

    public JPeekPanel(JAlbumObjectsPanel panel) {
        super(panel);
        this.explorer = panel;
        this.setLayout(null);
        this.setCursor(invisibleCursor);
        this.setBorder(null);
        this.add(this.image);
        this.image.setOpaque(false);
        this.image.setImageBorder(JAlbumBorders.createImageBorder());
    }

    public void setImage(Image im) {
        this.image.setBackgroundImage(im);
        this.image.setSize(im.getWidth(null), im.getHeight(null));
        Rectangle wb = this.getContentPane().getBounds();
        this.image.setLocation((wb.width - im.getWidth(null)) / 2, (wb.height - im.getHeight(null)) / 2);
    }

    public void mousePressed(MouseEvent e, ImageSupplier imageSupplier) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.isShowing()) {
                try {
                    this.setImage(imageSupplier.getImage());
                }
                catch (IOException ex) {
                    Logger.getLogger(JPeekPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                if (this.longClickFuture != null) {
                    this.longClickFuture.cancel(true);
                }
                this.longClickFuture = JAlbumUtilities.schedule(() -> {
                    try {
                        if (this.explorer.selectionModel.getSelectionCount() == 1) {
                            this.setImage(imageSupplier.getImage());
                            this.activate();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(JAlbumExplorer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.longClickFuture != null) {
            this.longClickFuture.cancel(true);
            if (this.isShowing()) {
                this.close();
                e.consume();
            }
        }
    }

    public JPeekPanel chainListeners(DragGestureListener secondListener) {
        this.secondListener = secondListener;
        return this;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (this.longClickFuture != null) {
            this.longClickFuture.cancel(true);
        }
        if (this.isShowing()) {
            this.close();
        }
        if (this.secondListener != null) {
            this.secondListener.dragGestureRecognized(dge);
        }
    }

    @FunctionalInterface
    public static interface ImageSupplier {
        public Image getImage() throws IOException;
    }
}

