/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import se.datadosen.component.ChooserFactory;
import se.datadosen.component.DropZoneBorder;
import se.datadosen.component.FileChooser;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JFallbackLabel;
import se.datadosen.component.JNumberField;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartSyntaxTextArea;
import se.datadosen.component.RiverLayout;
import se.datadosen.component.RiverLayout2;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JCropFocusDialog;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumUtilities;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.LaF;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.Multilingual;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JFolderPropertyPanel
extends JPanel {
    private static final int THUMBNAIL_WIDTH = 120;
    private final JAlbumExplorer explorer;
    private final JLabel headerLabel = new JFallbackLabel();
    @Text(value="edit.titleLabel")
    private final JLabel titleLabel = new JPropertyPanel.JSmallLabel();
    private final JPropertyPanel.JSmallTextField title = new JPropertyPanel.JSmallTextField();
    @Text(value="edit.xmpPanelTitle")
    private final JLabel descriptionLabel = new JPropertyPanel.JSmallLabel();
    private final JSmartSyntaxTextArea description = (JSmartSyntaxTextArea)((Object)((JSmartSyntaxTextArea)((Object)new JSmallTextArea(4, 10).setFullHTMLEditing(true))).spelling());
    @Text(value="ui.thumbnail")
    private JLabel thumbnailLabel = new JPropertyPanel.JSmallLabel();
    @ToolTipText(value="ui.thumbnailToolTip")
    private final JThumbnailSelector thumbnailSelector = new JThumbnailSelector();
    @Text(value="ui.themeImage")
    private final JLabel themeImageLabel = new JPropertyPanel.JSmallLabel();
    private final JCropFocusSelector themeImageSelector = new JCropFocusSelector();
    private final JAlbumFrame window;
    private AlbumObject currentFolder;
    private final Dimension loadedDim = Config.ThumbnailQuality.HQ.getBounds();
    private final PropertyChangeListener onChanged = evt -> {
        if (this.currentFolder != null) {
            this.title.setInitialText(this.currentFolder.getTitle());
            this.description.setInitialText(this.readDescription());
            this.thumbnailSelector.setAlbumObject(this.currentFolder.getRepresentingAlbumObject());
            this.themeImageSelector.setAlbumObject(JAlbumUtilities.getThemeObject(this.currentFolder));
        }
    };
    private final PropertyChangeListener onSkinChanged = evt -> {
        AlbumBean engine = JAlbumContext.getInstance().getEngine();
        SkinProperties props = engine.getSkinProperties();
        this.themeImageSelector.setDroppable(props.isSeparateThemeImage());
        Dimension themeImageDim = engine.getThemeImageDim();
        this.themeImageSelector.setEnabled(themeImageDim != null || props.isSeparateThemeImage());
        this.themeImageLabel.setEnabled(themeImageDim != null || props.isSeparateThemeImage());
        if (themeImageDim != null) {
            this.themeImageSelector.setRatio(Float.valueOf((float)themeImageDim.width / (float)themeImageDim.height));
        } else {
            this.themeImageSelector.setRatio(null);
        }
        this.onChanged.propertyChange(evt);
    };

    JFolderPropertyPanel(JAlbumExplorer explorer) {
        super(new RiverLayout2());
        this.explorer = explorer;
        this.window = JAlbumContext.getInstance().getFrame();
        this.init();
    }

    public void reset() {
        this.thumbnailSelector.setAlbumObject(null);
        this.themeImageSelector.setAlbumObject(null);
        this.currentFolder = null;
    }

    private void init() {
        Msg.maintainTranslated(this);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.headerLabel.setMinimumSize(new Dimension(128, this.headerLabel.getMaximumSize().height));
        this.explorer.addPropertyChangeListener("currentFolder", evt -> SwingUtilities.invokeLater(() -> {
            AlbumObject previousFolder = this.currentFolder;
            this.currentFolder = this.explorer.getCurrentFolder();
            if (previousFolder != null) {
                previousFolder.removePropertyChangeListener(this.onChanged);
            }
            this.currentFolder.addPropertyChangeListener("representingAlbumObject", this.onChanged);
            this.currentFolder.addPropertyChangeListener("children", this.onChanged);
            this.headerLabel.setText(this.currentFolder.getName());
            this.onChanged.propertyChange(evt);
        }));
        FocusListener fl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    JFolderPropertyPanel.this.currentFolder.setTitle(JFolderPropertyPanel.this.title.getText());
                    JFolderPropertyPanel.this.writeDescription(JFolderPropertyPanel.this.description.getText(), JFolderPropertyPanel.this.currentFolder);
                }
                catch (IOException ex) {
                    Logger.getLogger(JFolderPropertyPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.title.addFocusListener(fl);
        this.description.addFocusListener(fl);
        this.thumbnailSelector.setPreferredSize(new Dimension(120, 120));
        this.thumbnailSelector.setForeground(JAlbumColor.controlShadow);
        this.thumbnailSelector.setDropTarget(new DropTarget(this.thumbnailSelector, this.thumbnailSelector));
        this.themeImageSelector.setPreferredSize(new Dimension(120, 120));
        this.themeImageSelector.setForeground(JAlbumColor.controlShadow);
        this.themeImageSelector.setDropTarget(new DropTarget(this.themeImageSelector, this.themeImageSelector));
        JAlbumContext.getInstance().addPropertyChangeListener("engine", evt -> {
            AlbumBean engine = (AlbumBean)evt.getNewValue();
            engine.addPropertyChangeListener("themeImageDim", this.onSkinChanged);
        });
        this.window.addPropertyChangeListener("skinLoaded", evt -> {
            if (!this.explorer.parent.mainSettingsPanel.isLoadingSkin()) {
                this.explorer.parent.skinUI2Engine(this.explorer.parent.engine);
                this.onSkinChanged.propertyChange(evt);
            }
        });
        final JScrollPane descriptionScroller = new JScrollPane((Component)((Object)this.description), 20, 31);
        this.description.addFocusListener(new FocusListener(){
            Border border;
            Insets in;
            final /* synthetic */ JFolderPropertyPanel this$0;
            {
                this.this$0 = this$0;
                this.border = descriptionScroller.getBorder();
                this.in = descriptionScroller.getInsets();
                this.focusLost(null);
            }

            @Override
            public void focusGained(FocusEvent e) {
                descriptionScroller.setBorder(this.border);
            }

            @Override
            public void focusLost(FocusEvent e) {
                descriptionScroller.setBorder(BorderFactory.createEmptyBorder(this.in.top, this.in.left, this.in.bottom, this.in.right));
            }
        });
        this.headerLabel.setFont(JAlbumFrame.TITLE_FONT);
        this.explorer.add(this.headerLabel);
        this.add(this.headerLabel);
        this.add((Component)this.titleLabel, "p");
        this.add((Component)this.title, "br hfill");
        this.add((Component)this.descriptionLabel, "p");
        this.add((Component)descriptionScroller, "br hfill");
        this.add((Component)this.thumbnailLabel, "p");
        this.add((Component)this.thumbnailSelector, "br hfill vfill");
        this.add((Component)this.themeImageLabel, "p");
        this.add((Component)this.themeImageSelector, "br hfill vfill");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = new Dimension(super.getPreferredSize());
        Config cfg = Config.getConfig();
        pref.width = Math.max(cfg.getFolderPropertiesWidth(), pref.width);
        return pref;
    }

    private String readDescription() {
        AlbumBean engine = JAlbumContext.getInstance().getEngine();
        SkinProperties sp = engine.getSkinProperties();
        return sp.isSeparateDescription() ? this.currentFolder.getProperties().get("description", "") : this.currentFolder.getComment();
    }

    private void writeDescription(String text, AlbumObject currentFolder) throws IOException {
        AlbumBean engine = JAlbumContext.getInstance().getEngine();
        SkinProperties sp = engine.getSkinProperties();
        if (sp.isSeparateDescription()) {
            AlbumObjectProperties props = currentFolder.getProperties();
            props.put("description", text);
            props.save(false);
        } else {
            currentFolder.setComment(text);
        }
    }

    private static float capValue(float value, float min, float max) {
        value = Math.max(value, min);
        value = Math.min(value, max);
        return value;
    }

    private static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale + 0.5), (int)((double)height / maxScale + 0.5));
    }

    static class JSmallTextArea
    extends JSmartSyntaxTextArea {
        public JSmallTextArea() {
            this.initialize();
        }

        public JSmallTextArea(int rows, int columns) {
            super(rows, columns);
            this.initialize();
        }

        public JSmallTextArea bordered() {
            Border border = new JPropertyPanel.JSmallTextField().getBorder();
            this.setBorder(border);
            return this;
        }

        private void initialize() {
            this.spelling();
            if (Platform.isMac()) {
                this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() - 2.0f));
            }
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }
    }

    private class JThumbnailSelector
    extends JDroppablePanel
    implements AlbumObjectDropTarget {
        private AlbumObject ao;

        private JThumbnailSelector() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    } else if (e.getClickCount() == 2) {
                        this.showFileSelector();
                    }
                }

                private void showFileSelector() {
                    FileChooser chooser = ChooserFactory.createFileChooser(JFolderPropertyPanel.this.window);
                    chooser.setCurrentDirectory(JFolderPropertyPanel.this.currentFolder.getFile());
                    int res = chooser.showOpenDialog(JFolderPropertyPanel.this);
                    if (res == 0) {
                        JThumbnailSelector.this.fileSelected(chooser.getSelectedFile());
                    }
                }

                private void showPopupMenu(MouseEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem selectItem = new JMenuItem(Msg.get("select") + "...");
                    selectItem.addActionListener(e2 -> this.showFileSelector());
                    popup.add(selectItem);
                    popup.show(JThumbnailSelector.this, e.getPoint().x, e.getPoint().y);
                }
            });
        }

        public void setAlbumObject(AlbumObject ao) {
            if (ao != this.ao) {
                try {
                    this.setBackgroundImage(ao != null ? ao.getRepresentingIcon(JFolderPropertyPanel.this.loadedDim, true).getImage() : null);
                    if (ao != null) {
                        this.setBackgroundImageAsync(() -> ao.loadImage(true, JFolderPropertyPanel.this.loadedDim));
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(JFolderPropertyPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.ao = ao;
            if (JFolderPropertyPanel.this.themeImageSelector.isDroppable() || JFolderPropertyPanel.this.currentFolder != null && !JFolderPropertyPanel.this.currentFolder.getProperties().containsKey("themeImagePath")) {
                JFolderPropertyPanel.this.themeImageSelector.setAlbumObject(ao);
            }
        }

        @Override
        public void albumObjectDropped(AlbumObject rep) {
            AlbumObject target = rep.getRepresentingAlbumObject();
            if (target == null) {
                target = rep;
            }
            this.setAlbumObject(target);
            JFolderPropertyPanel.this.explorer.getCurrentFolder().setRepresentingAlbumObject(rep);
        }

        @Override
        public AlbumObject getCurrentFolder() {
            return JFolderPropertyPanel.this.explorer.getCurrentFolder();
        }
    }

    class JCropFocusSelector
    extends JDroppablePanel
    implements AlbumObjectDropTarget,
    Multilingual {
        private float xWeight;
        private float yWeight;
        private Float ratio;
        private Rectangle cb;
        private AlbumObject ao;
        private Point plantPoint;
        private Rectangle plantCropBounds;
        private final MouseAdapter mouseAdapter;
        private final PropertyChangeListener listener;

        public JCropFocusSelector() {
            this.xWeight = 0.5f;
            this.yWeight = 0.2f;
            this.ratio = null;
            this.cb = new Rectangle();
            this.mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    JCropFocusSelector.this.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!this.isCropFocusEnabled()) {
                        return;
                    }
                    if (JCropFocusSelector.this.getBackgroundImage() != null) {
                        JCropFocusSelector.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }

                private boolean isCropFocusEnabled() {
                    return JCropFocusSelector.this.ratio != null;
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int hdiff;
                    if (!this.isCropFocusEnabled()) {
                        return;
                    }
                    if (JCropFocusSelector.this.getBackgroundImage() != null) {
                        JCropFocusSelector.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    if (JCropFocusSelector.this.plantPoint == null) {
                        JCropFocusSelector.this.plantPoint = e.getPoint();
                    }
                    e.translatePoint(-JCropFocusSelector.this.plantPoint.x, -JCropFocusSelector.this.plantPoint.y);
                    Point p = e.getPoint();
                    Rectangle bounds = JCropFocusSelector.this.getImageBounds();
                    Dimension sDim = bounds.getSize();
                    Dimension d = new Dimension(sDim.width, (int)((float)sDim.width / JCropFocusSelector.this.ratio.floatValue()));
                    Dimension dDim = JFolderPropertyPanel.calcDimension(d.width, d.height, sDim);
                    int cropX = JCropFocusSelector.this.plantCropBounds.x + p.x;
                    int cropY = JCropFocusSelector.this.plantCropBounds.y + p.y;
                    int wdiff = sDim.width - dDim.width;
                    if (wdiff > 0) {
                        JCropFocusSelector.this.setxWeight((float)cropX / (float)wdiff);
                    }
                    if ((hdiff = sDim.height - dDim.height) > 0) {
                        JCropFocusSelector.this.setyWeight((float)cropY / (float)hdiff);
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        this.showFileSelector();
                    }
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    } else if (this.isCropFocusEnabled()) {
                        JCropFocusSelector.this.plantPoint = e.getPoint();
                        JCropFocusSelector.this.plantCropBounds = JCropFocusSelector.this.getCropBounds();
                        JCropFocusSelector.this.requestFocusInWindow();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        this.showPopupMenu(e);
                    } else if (this.isDirty()) {
                        JCropFocusSelector.this.save();
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && JCropFocusSelector.this.isEditableThemeImageSize()) {
                        this.showSettingsDialog();
                    }
                }

                private boolean isDirty() {
                    float xWeight = 0.5f;
                    float yWeight = 0.2f;
                    if (JCropFocusSelector.this.ao != null) {
                        AlbumObjectProperties aop = JCropFocusSelector.this.ao.getProperties();
                        Map userVars = aop.get("userVariables", new LinkedHashMap());
                        try {
                            xWeight = Float.parseFloat((String)userVars.get("xWeight"));
                            yWeight = Float.parseFloat((String)userVars.get("yWeight"));
                        }
                        catch (NullPointerException | NumberFormatException runtimeException) {
                            // empty catch block
                        }
                    }
                    return xWeight != JCropFocusSelector.this.getxWeight() || yWeight != JCropFocusSelector.this.getyWeight();
                }

                private void showSettingsDialog() {
                    JCropSettingsDialog settingsDialog = new JCropSettingsDialog(JFolderPropertyPanel.this.window);
                    settingsDialog.modelRead();
                    settingsDialog.setVisible(true);
                }

                private void showFileSelector() {
                    FileChooser chooser = ChooserFactory.createFileChooser(JFolderPropertyPanel.this.window);
                    chooser.setCurrentDirectory(JFolderPropertyPanel.this.currentFolder.getFile());
                    int res = chooser.showOpenDialog(JFolderPropertyPanel.this);
                    if (res == 0) {
                        JCropFocusSelector.this.fileSelected(chooser.getSelectedFile());
                    }
                }

                private void showPopupMenu(MouseEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new LambdaAction(Msg.get("ui.edit") + "...", ae -> {
                        JCropFocusDialog dialog = new JCropFocusDialog(JAlbumContext.getInstance(), JCropFocusSelector.this.ao);
                        dialog.setLocationRelativeTo(popup);
                        dialog.setVisible(true);
                    }));
                    JMenuItem setCroppingItem = new JMenuItem(Msg.get("ui.setCropping") + "...");
                    if (JCropFocusSelector.this.isEditableThemeImageSize()) {
                        setCroppingItem.addActionListener(e2 -> this.showSettingsDialog());
                    } else {
                        setCroppingItem.setEnabled(false);
                        setCroppingItem.setToolTipText(Msg.get("ui.controlledBySkin"));
                    }
                    popup.add(setCroppingItem);
                    popup.addSeparator();
                    JMenuItem resetItem = new JMenuItem(Msg.get("ui.reset"));
                    resetItem.addActionListener(e2 -> {
                        JFolderPropertyPanel.this.currentFolder.getProperties().remove("hasThemeImage");
                        JCropFocusSelector.this.setAlbumObject(JFolderPropertyPanel.this.currentFolder.getRepresentingAlbumObject(true));
                        JCropFocusSelector.this.save();
                    });
                    popup.add(resetItem);
                    JMenuItem removeItem = new JMenuItem(Msg.get("remove"));
                    removeItem.addActionListener(e2 -> {
                        JFolderPropertyPanel.this.currentFolder.getProperties().putHidden("hasThemeImage", false);
                        JCropFocusSelector.this.setAlbumObject(null);
                        JCropFocusSelector.this.save();
                    });
                    popup.add(removeItem);
                    JMenuItem selectItem = new JMenuItem(Msg.get("select") + "...");
                    selectItem.addActionListener(e2 -> this.showFileSelector());
                    popup.add(selectItem);
                    popup.show(JCropFocusSelector.this, e.getPoint().x, e.getPoint().y);
                }
            };
            this.listener = evt -> this.updateVisuals();
            this.init();
        }

        public float getxWeight() {
            return this.xWeight;
        }

        public void setxWeight(float xWeight) {
            this.xWeight = JFolderPropertyPanel.capValue(xWeight, 0.0f, 1.0f);
            this.repaint();
        }

        public float getyWeight() {
            return this.yWeight;
        }

        public void setyWeight(float yWeight) {
            this.yWeight = JFolderPropertyPanel.capValue(yWeight, 0.0f, 1.0f);
            this.repaint();
        }

        public Float getRatio() {
            return this.ratio;
        }

        public void setRatio(Float ratio) {
            this.ratio = ratio;
            this.repaint();
        }

        public Rectangle getCropBounds() {
            return new Rectangle(this.cb);
        }

        @Override
        public void setDroppable(boolean droppable) {
            super.setDroppable(droppable);
            this.languageUpdated();
        }

        @Override
        public void setBackgroundImage(Image bg) {
            super.setBackgroundImage(bg);
            this.languageUpdated();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.removeMouseListener(this.mouseAdapter);
            this.removeMouseMotionListener(this.mouseAdapter);
            if (enabled) {
                this.addMouseListener(this.mouseAdapter);
                this.addMouseMotionListener(this.mouseAdapter);
            }
            this.languageUpdated();
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            super.paintComponent(g2d);
            Graphics2D g = (Graphics2D)g2d;
            if (this.bg != null) {
                Rectangle bounds = this.getImageBounds();
                Dimension sDim = bounds.getSize();
                float r = this.ratio != null ? this.ratio.floatValue() : (float)sDim.width / (float)sDim.height;
                Dimension d = new Dimension(sDim.width, (int)((float)sDim.width / r));
                Dimension dDim = JFolderPropertyPanel.calcDimension(d.width, d.height, sDim);
                int cropX = (int)((float)(sDim.width - dDim.width) * this.xWeight);
                int cropY = (int)((float)(sDim.height - dDim.height) * this.yWeight);
                this.cb.x = cropX;
                this.cb.y = cropY;
                this.cb.width = dDim.width;
                this.cb.height = dDim.height;
                AffineTransform backup = g.getTransform();
                g.translate(bounds.x, bounds.y);
                BufferedImage bi = this.getGraphicsConfiguration().createCompatibleImage(bounds.width, bounds.height, 3);
                Graphics2D big = bi.createGraphics();
                Color dimmed = LaF.isDark() ? new Color(0, 0, 0, 180) : new Color(255, 255, 255, 180);
                big.setColor(dimmed);
                big.fillRect(0, 0, bi.getWidth(), bi.getHeight());
                if (this.isEnabled()) {
                    big.setComposite(AlphaComposite.Clear);
                    big.fillRect(this.cb.x, this.cb.y, this.cb.width, this.cb.height);
                    big.dispose();
                }
                g.drawImage((Image)bi, 0, 0, this);
                g.setTransform(backup);
            }
        }

        private boolean isEditableThemeImageSize() {
            AlbumBean engine = JFolderPropertyPanel.this.window.getEngine();
            return engine.getSkinProperties().isEditableThemeImageSize();
        }

        public void save() {
            if (this.ao != null) {
                AlbumObjectProperties aop = this.ao.getProperties();
                Map userVars = aop.get("userVariables", new LinkedHashMap());
                userVars.put("xWeight", "" + this.getxWeight());
                userVars.put("yWeight", "" + this.getyWeight());
                aop.put("userVariables", userVars);
                aop.save(false);
            }
            AlbumObjectProperties props = JFolderPropertyPanel.this.currentFolder.getProperties();
            if (this.ao != null && !this.ao.equals(JFolderPropertyPanel.this.currentFolder.getRepresentingAlbumObject(true))) {
                props.putHidden("themeImagePath", this.ao.getPathFrom(JFolderPropertyPanel.this.currentFolder));
            } else {
                props.remove("themeImagePath");
            }
            props.save(true);
        }

        private float getIncrement(ActionEvent e) {
            return (e.getModifiers() & 0x40) != 0 ? 0.01f : 0.001f;
        }

        private void init() {
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    JCropFocusSelector.this.setForeground(JAlbumColor.textHighlight);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    JCropFocusSelector.this.setForeground(JAlbumColor.controlShadow);
                }
            });
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseAdapter);
            InputMap im = this.getInputMap();
            ActionMap am = this.getActionMap();
            im.put(KeyStroke.getKeyStroke(38, 0), "up");
            im.put(KeyStroke.getKeyStroke(38, 64), "up");
            am.put("up", new LambdaAction(e -> this.setyWeight(this.getyWeight() - this.getIncrement(e))));
            im.put(KeyStroke.getKeyStroke(40, 0), "down");
            im.put(KeyStroke.getKeyStroke(40, 64), "down");
            am.put("down", new LambdaAction(e -> this.setyWeight(this.getyWeight() + this.getIncrement(e))));
            im.put(KeyStroke.getKeyStroke(37, 0), "left");
            im.put(KeyStroke.getKeyStroke(37, 64), "left");
            am.put("left", new LambdaAction(e -> this.setxWeight(this.getxWeight() - this.getIncrement(e))));
            im.put(KeyStroke.getKeyStroke(39, 0), "right");
            im.put(KeyStroke.getKeyStroke(39, 64), "right");
            am.put("right", new LambdaAction(e -> this.setxWeight(this.getxWeight() + this.getIncrement(e))));
        }

        public void setAlbumObject(AlbumObject ao) {
            if (ao == this.ao) {
                return;
            }
            if (this.ao != null) {
                this.ao.removePropertyChangeListener(this.listener);
            }
            if (ao != null && !JFolderPropertyPanel.this.currentFolder.getProperties().get("hasThemeImage", true).booleanValue()) {
                this.setAlbumObject(null);
                return;
            }
            this.ao = ao;
            if (ao != null) {
                ao.addPropertyChangeListener(this.listener);
            }
            try {
                this.setBackgroundImage(ao != null ? ao.getRepresentingIcon(JFolderPropertyPanel.this.loadedDim, true).getImage() : null);
                if (ao != null) {
                    this.setBackgroundImageAsync(() -> ao.loadImage(true, JFolderPropertyPanel.this.loadedDim));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JFolderPropertyPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateVisuals();
        }

        private void updateVisuals() {
            if (this.ao != null) {
                AlbumObjectProperties aop = this.ao.getProperties();
                Map userVars = aop.get("userVariables", new LinkedHashMap());
                try {
                    this.setxWeight(Float.parseFloat((String)userVars.get("xWeight")));
                    this.setyWeight(Float.parseFloat((String)userVars.get("yWeight")));
                }
                catch (NullPointerException | NumberFormatException ex) {
                    this.setxWeight(0.5f);
                    this.setyWeight(0.2f);
                }
            }
        }

        @Override
        public void albumObjectDropped(AlbumObject dropped) {
            AlbumObjectProperties props;
            AlbumObject target = dropped.getRepresentingAlbumObject();
            if (target == null) {
                target = dropped;
            }
            if ((props = JFolderPropertyPanel.this.currentFolder.getProperties()).containsKey("hasThemeImage")) {
                props.remove("hasThemeImage");
                props.save(true);
            }
            this.setAlbumObject(target);
            if (target != null) {
                // empty if block
            }
            this.save();
        }

        @Override
        public AlbumObject getCurrentFolder() {
            return JFolderPropertyPanel.this.explorer.getCurrentFolder();
        }

        @Override
        public void languageUpdated() {
            if (this.isEnabled()) {
                if (this.isDroppable() && this.getBackgroundImage() == null) {
                    this.setToolTipText(Msg.get("ui.themeImageToolTip"));
                } else {
                    this.setToolTipText(Msg.get("ui.themeImageToolTip2"));
                }
            } else {
                this.setToolTipText(Msg.get("ui.notSupportedBySkin"));
            }
        }

        private class JCropSettingsDialog
        extends JSmartDialog {
            JComboBox<CropPreset> preset;
            JNumberField width;
            JNumberField height;

            public JCropSettingsDialog(JAlbumFrame window) throws HeadlessException {
                super((Window)window, true);
                this.preset = new JComboBox<CropPreset>(CropPreset.values());
                this.width = new JNumberField(3);
                this.height = new JNumberField(3);
                this.onOk(e -> {
                    this.writeModel();
                    this.setVisible(false);
                    this.dispose();
                });
                this.setTitle(Msg.get("ui.setCropping"));
                this.setLayout(new RiverLayout());
                this.add("br", new JLabel(Msg.get("ui.presetsMenu")));
                this.add(this.preset);
                this.add("tab", this.width);
                this.add(new JLabel("x"));
                this.add(this.height);
                this.add(new JLabel("px"));
                this.preset.addActionListener(al -> {
                    CropPreset cp = (CropPreset)((Object)((Object)this.preset.getSelectedItem()));
                    this.width.setText(cp.width);
                    this.height.setText(cp.height);
                    this.writeModel();
                });
                this.pack();
            }

            public void writeModel() {
                Dimension dim = null;
                try {
                    dim = new Dimension(Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                JFolderPropertyPanel.this.window.getEngine().setThemeImageDim(dim);
            }

            public void modelRead() {
                Dimension themeImageDim = JFolderPropertyPanel.this.window.getEngine().getThemeImageDim();
                if (themeImageDim != null) {
                    this.width.setText(Integer.toString(themeImageDim.width));
                    this.height.setText(Integer.toString(themeImageDim.height));
                }
            }
        }
    }

    private static enum CropPreset {
        custom("", ""),
        square("1200", "1200"),
        banner("1600", "240"),
        noCropping("", "");

        String width;
        String height;

        private CropPreset(String width, String height) {
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return Msg.get("cropPreset." + this.name());
        }
    }

    private class JDroppablePanel
    extends JBackgroundPanel {
        private JDroppablePanel() {
            this.setBorder(new DropZoneBorder());
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            int minSize = Math.min(width, height);
            super.setBounds(x, y, minSize, minSize);
        }

        public boolean isDroppable() {
            DropTarget dt = this.getDropTarget();
            return dt != null ? dt.isActive() : false;
        }

        public void setDroppable(boolean droppable) {
            this.getDropTarget().setActive(droppable);
            this.setBorder(droppable ? new DropZoneBorder() : BorderFactory.createLineBorder(this.getForeground()));
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g2d) {
            super.paintComponent(g2d);
            Graphics2D g = (Graphics2D)g2d.create();
            if (this.getBackgroundImage() == null && this.isDroppable()) {
                g2d.setColor(this.getForeground());
                int w = this.getWidth() / 3;
                int h = this.getHeight() / 3;
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine(w, this.getHeight() / 2, 2 * w, this.getHeight() / 2);
                g.drawLine(this.getWidth() / 2, h, this.getWidth() / 2, h * 2);
                g.dispose();
            }
        }
    }

    private static interface AlbumObjectDropTarget
    extends DropTargetListener {
        default public boolean flavorOk(DropTargetDragEvent dtde) {
            return dtde.isDataFlavorSupported(AlbumObject.albumObjectFlavor) || dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        }

        @Override
        default public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.flavorOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(2);
            JComponent comp = (JComponent)dtde.getDropTargetContext().getComponent();
            comp.setForeground(LaF.isDark() ? Color.white : Color.black);
        }

        @Override
        default public void dragOver(DropTargetDragEvent dtde) {
            if (!this.flavorOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(2);
        }

        @Override
        default public void dropActionChanged(DropTargetDragEvent dtde) {
            if (!this.flavorOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
        }

        @Override
        default public void dragExit(DropTargetEvent dte) {
            JComponent comp = (JComponent)dte.getDropTargetContext().getComponent();
            comp.setForeground(JAlbumColor.controlShadow);
        }

        default public void restoreBorder() {
        }

        default public void fileSelected(File f) {
            try {
                AlbumObject rep;
                AlbumObject folder = this.getCurrentFolder();
                String relPath = IO.relativePath(f, folder.getFile());
                if (!relPath.startsWith("../") && (rep = folder.getChild(relPath)) != null) {
                    this.albumObjectDropped(rep);
                    return;
                }
                if (Config.getConfig().getFileAddMethod() == Config.FileAddMethod.LINK) {
                    rep = folder.getFactory().createInstance((File)new LinkFile(folder.getFile(), f.getName(), f), folder);
                } else {
                    File dest = new File(this.getCurrentFolder().getFile(), f.getName());
                    IO.copyFile(f, dest);
                    rep = folder.getFactory().createInstance(dest, folder);
                }
                folder.add(rep);
                rep.setIncluded(false);
                folder.fireModelChanged();
                this.albumObjectDropped(rep);
            }
            catch (IOException ex) {
                Debug.showErrorDialog(JAlbumContext.getInstance().getFrame(), ex);
            }
        }

        @Override
        default public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(3);
            try {
                if (dtde.isDataFlavorSupported(AlbumObject.albumObjectFlavor)) {
                    List list = (List)dtde.getTransferable().getTransferData(AlbumObject.albumObjectFlavor);
                    dtde.dropComplete(true);
                    AlbumObject rep = (AlbumObject)list.get(0);
                    rep = this.getCurrentFolder().getChild(rep.getName());
                    this.albumObjectDropped(rep);
                } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    dtde.dropComplete(true);
                    this.fileSelected((File)files.get(0));
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(JFolderPropertyPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (RuntimeException ex) {
                ex.printStackTrace(System.err);
            }
            dtde.dropComplete(false);
            JComponent comp = (JComponent)dtde.getDropTargetContext().getComponent();
            comp.setForeground(JAlbumColor.controlShadow);
        }

        public void albumObjectDropped(AlbumObject var1);

        public AlbumObject getCurrentFolder();
    }
}

