/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;

public class JEffectsMenu
extends JMenu {
    private JAlbumContext context;
    private static final String FILTER_CLASS_NAME = "filterName";
    public static final String EXCLUDED_FILTERS_KEY = "excludedFilters";

    public JEffectsMenu(JAlbumContext context) {
        this.context = context;
    }

    public void updateMenuState(AlbumObject ao) {
        this.removeAll();
        for (JAFilter filter : this.context.getFrame().settingsWindow.imageEffectsPanel.getEnabledFilters()) {
            this.add(this.createMenuItem(filter));
        }
        AlbumObjectProperties props = ao.getProperties();
        Set excluded = props.get(EXCLUDED_FILTERS_KEY, new HashSet());
        Set parentExcluded = ao.getParent().getProperties().get(EXCLUDED_FILTERS_KEY, new HashSet());
        for (int i = 0; i < this.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            item.setSelected(!excluded.contains((String)(item = (JCheckBoxMenuItem)this.getItem(i)).getClientProperty(FILTER_CLASS_NAME)));
            if (!parentExcluded.contains((String)item.getClientProperty(FILTER_CLASS_NAME))) continue;
            item.setSelected(false);
            item.setEnabled(false);
            item.setToolTipText(Msg.get("ui.excludedByParentFolder"));
        }
        this.setEnabled(this.getItemCount() > 0);
    }

    private JMenuItem createMenuItem(JAFilter filter) {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(filter.getName());
        menuItem.putClientProperty(FILTER_CLASS_NAME, filter.getClass().getName());
        menuItem.addActionListener(e -> {
            HashSet<String> excluded = new HashSet<String>();
            for (int i = 0; i < this.getItemCount(); ++i) {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)this.getItem(i);
                if (item.isSelected()) continue;
                excluded.add((String)item.getClientProperty(FILTER_CLASS_NAME));
            }
            try {
                for (AlbumObject ao : this.context.getExplorer().explorer.getSelectedAlbumObjects()) {
                    this.saveState(excluded, ao);
                }
            }
            catch (FileNotFoundException ex) {
                Debug.showFriendlyErrorDialog(this.context.getFrame(), ex);
            }
        });
        return menuItem;
    }

    private void saveState(Set<String> state, AlbumObject ao) throws FileNotFoundException {
        AlbumObjectProperties props = ao.getProperties();
        if (state.isEmpty()) {
            props.remove(EXCLUDED_FILTERS_KEY);
        } else {
            props.put(EXCLUDED_FILTERS_KEY, state);
        }
        props.save(false);
    }
}

