/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.jalbum.component.JImageComponent;
import net.jalbum.component.JZoomControlPanel;
import net.jalbum.component.JZoomScrollPane;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.JAlbumImageFilter;
import net.jalbum.jlibraw.RAWImageReadParam;
import net.jalbum.views.View;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.Hour;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JCleanToolBar;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JFadePanel;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JLineSplitPane;
import se.datadosen.component.JMenuButton;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JToolBarButton;
import se.datadosen.component.WaitCursor;
import se.datadosen.component.slider.RangeSlider;
import se.datadosen.component.slider.SliderInfo;
import se.datadosen.explorer.ImageToolActions;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JCommentPanel;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.explorer.JScrollablePanel;
import se.datadosen.explorer.Stamp;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Attachments;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.EditListener2;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.EvaluationException;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.JPhotoSphereSettingsPanel;
import se.datadosen.jalbum.JRawSettingsPanel;
import se.datadosen.jalbum.JWebLocationEditPanel;
import se.datadosen.jalbum.MediaPlayerProcessor;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ScriptEnvironment;
import se.datadosen.jalbum.TimeCode;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.VideoProcessor;
import se.datadosen.jalbum.ViewAlbumObject;
import se.datadosen.jalbum.WebLocation;
import se.datadosen.jalbum.event.ImageListener;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.AliasAction;
import se.datadosen.util.ContextHelp;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.IO;
import se.datadosen.util.IdleExecutor;
import se.datadosen.util.LambdaAction;
import se.datadosen.util.MenuAction;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class JEditPanel
extends JPanel
implements EditPanel,
FilterManagerFriend,
PropertyChangeListener {
    public static final String NAME = "editPanel";
    Action audioClipAction;
    final JAlbumExplorer context;
    final KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
    final KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
    final KeyStroke up = KeyStroke.getKeyStroke(38, 0);
    final KeyStroke down = KeyStroke.getKeyStroke(40, 0);
    final KeyStroke left = KeyStroke.getKeyStroke(37, 0);
    final KeyStroke right = KeyStroke.getKeyStroke(39, 0);
    final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    static final KeyStroke space = KeyStroke.getKeyStroke(32, 0);
    AlbumObject ao;
    ControlPanel metaPanel = new ControlPanel();
    JCleanToolBar toolBar = new JCleanToolBar();
    JPanel centerPanel = new JPanel();
    private BooleanProperty imageLoading = new SimpleBooleanProperty();
    private static final Icon excludeIcon = Icons.get("exclude-64", 64);
    JZoomScrollPane imageScrollPane = new JZoomScrollPane(){

        @Override
        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (JEditPanel.this.ao != null && !JEditPanel.this.ao.isIncluded()) {
                Dimension dim = new Dimension(excludeIcon.getIconWidth(), excludeIcon.getIconHeight());
                excludeIcon.paintIcon(this, g, (this.getWidth() - dim.width) / 2, (this.getHeight() - dim.height) / 2);
            }
        }
    };
    JImageComponent imageComp;
    JScrollPane basicScrollPane = new JScrollPane();
    JBackgroundPanel basicPanel = new JBackgroundPanel();
    JComponent customUI;
    JFadePanel glassPanel = new JFadePanel();
    JProgressSpinner progressSpinner = new JProgressSpinner(36);
    ImageToolActions toolActions = new ImageToolActions(this);
    FilterManager filterManager = new FilterManager(this);
    JAlbumImageFilter currentFilter;
    JPanel filterUIContainer = new JPanel(new BorderLayout());
    JCollapsiblePanel filterUITab = new JCollapsiblePanel();
    JPanel filterUI;
    JPanel filterManagerControls;
    JCommentPanel commentPanel = new JCommentPanel(this);
    JPanel rightPanel = new JScrollablePanel(new BorderLayout());
    JPropertyPanel propertyPanel = new JPropertyPanel(this);
    JSplitPane hSplitPane = new JSplitPane(1);
    MediaPlayerProcessor mediaPlayerProcessor = new MediaPlayerProcessor();
    private List<ImageListener> imageListeners = new ArrayList<ImageListener>();
    @Text(value="ui.effectsPanel")
    JMenuButton effectsButton = new JMenuButton();
    @ToolTipText(value="edit.previousImageToolTip")
    public Action previousImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgUp);
            this.putValue("SmallIcon", Icons.get("previous-30", 30));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getPreviousComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject previous = JEditPanel.this.getPreviousComponent(dest.ao);
                JEditPanel.this.context.imageCache.preload(previous != null ? previous.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.nextImageToolTip")
    public Action nextImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgDown);
            this.putValue("SmallIcon", Icons.get("next-30", 30));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getNextComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject next = JEditPanel.this.getNextComponent(dest.ao);
                JEditPanel.this.context.imageCache.preload(next != null ? next.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.leaveTooltip")
    Action cancelAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.get("index-30", 30));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.context.setExplorerView();
            TipOfTheDay.showSpeechBubble(JEditPanel.this.context.parent.mainSettingsPanel.makeAlbumButton, new Hour(3), Msg.get("tip.updateChanges", Msg.get("ui.makeAlbum")), 8);
        }
    };
    JGlassButton previousButton = new JGlassButton(this.previousImageAction);
    JGlassButton nextButton = new JGlassButton(this.nextImageAction);
    JGlassButton returnButton = new JGlassButton(this.cancelAction);
    @ToolTipText(value="edit.chooseThumbnailToolTip")
    JSlider timeSlider = new JSlider();
    @ToolTipText(value="edit.trimVideoToolTip")
    RangeSlider clipSlider = new RangeSlider();
    FileFilters.BasicImageInfo imageInfo;
    RAWImageReadParam lastRAWsettings;
    private int moveCounter = 1;
    private static final ImageIcon faintFolderIcon = (ImageIcon)Icons.get("folder_closed_faint_1", 448);
    JLayeredPane overlayPanel = new JLayeredPane();
    private IdleExecutor videoBrowser = new IdleExecutor(200, TimeUnit.MILLISECONDS);
    private ChangeListener timeSliderChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            AlbumObjectProperties props = JEditPanel.this.ao.getProperties();
            TimeCode videoPos = TimeCode.fromMillis(JEditPanel.this.timeSlider.getValue());
            props.put("videoPosition", videoPos);
            try {
                props.store(false);
            }
            catch (IOException ex) {
                Debug.showFriendlyErrorDialog(JEditPanel.this, ex);
            }
            JEditPanel.this.context.imageCache.clear();
            try {
                JEditPanel.this.mediaPlayerProcessor.setMedia(JEditPanel.this.ao.getFile());
                BufferedImage bi = JEditPanel.this.mediaPlayerProcessor.createSnapshot(videoPos);
                JEditPanel.this.imageComp.setImage(bi);
                if (!JEditPanel.this.timeSlider.getValueIsAdjusting()) {
                    props.save(false);
                    File repFile = JEditPanel.this.ao.getRepresentingImageFile();
                    FileFilters.saveJPEG(bi, repFile, JEditPanel.this.context.parent.engine);
                    JEditPanel.this.ao.updateRepresentingIcon();
                }
            }
            catch (IOException ex) {
                JEditPanel.this.videoBrowser.onIdle(() -> {
                    try {
                        JEditPanel.this.context.parent.progressSpinner.workStarted();
                        AlbumObject currentAO = JEditPanel.this.ao;
                        File repFile = currentAO.getRepresentingImageFile();
                        repFile.delete();
                        currentAO.getRepresentingImageFile();
                        currentAO.updateRepresentingIcon();
                        if (JEditPanel.this.videoBrowser.isCancelled()) {
                            return;
                        }
                        try {
                            JEditPanel.this.updateImage(false);
                        }
                        catch (IOException ex1) {
                            ex1.printStackTrace(System.err);
                        }
                    }
                    finally {
                        JEditPanel.this.context.parent.progressSpinner.workDone();
                    }
                });
            }
        }
    };
    private ChangeListener clipSliderChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                if (JEditPanel.this.clipSlider.isLowerDragging() || JEditPanel.this.clipSlider.isUpperDragging()) {
                    int value;
                    AlbumObjectProperties props = JEditPanel.this.ao.getProperties();
                    int n = value = JEditPanel.this.clipSlider.isUpperDragging() ? JEditPanel.this.clipSlider.getUpperValue() : JEditPanel.this.clipSlider.getValue();
                    if (value >= JEditPanel.this.clipSlider.getMaximum()) {
                        value -= 10;
                    }
                    TimeCode currentPos = TimeCode.fromMillis(value);
                    try {
                        JEditPanel.this.mediaPlayerProcessor.setMedia(JEditPanel.this.ao.getFile());
                        BufferedImage bi = JEditPanel.this.mediaPlayerProcessor.createSnapshot(currentPos);
                        JEditPanel.this.imageComp.setImage(bi);
                        props.put("videoClipStart", TimeCode.fromMillis(JEditPanel.this.clipSlider.getValue()));
                        props.put("videoClipLength", TimeCode.fromMillis(JEditPanel.this.clipSlider.getUpperValue() - JEditPanel.this.clipSlider.getValue()));
                        props.save(false);
                        JEditPanel.this.ao.getFile().setLastModified(new Date().getTime());
                    }
                    catch (IOException ex) {
                        if (JEditPanel.this.videoBrowser != null) {
                            JEditPanel.this.videoBrowser.cancel(false);
                        }
                        JEditPanel.this.videoBrowser.onIdle(() -> {
                            try {
                                JEditPanel.this.context.parent.progressSpinner.workStarted();
                                VideoProcessor vp = JEditPanel.this.context.parent.engine.getVideoProcessor();
                                File tmp = File.createTempFile("clip", ".jpg");
                                tmp.delete();
                                vp.createThumbnailFile(JEditPanel.this.ao.getFile(), tmp, currentPos);
                                BufferedImage bi = FileFilters.loadImage(tmp);
                                tmp.delete();
                                bi = RotationSupport.adjustOrientation(bi, JEditPanel.this.ao.getOrientation());
                                if (JEditPanel.this.videoBrowser.isCancelled()) {
                                    return;
                                }
                                JEditPanel.this.imageComp.setImage(bi);
                                props.put("videoClipStart", TimeCode.fromMillis(JEditPanel.this.clipSlider.getValue()));
                                props.put("videoClipLength", TimeCode.fromMillis(JEditPanel.this.clipSlider.getUpperValue() - JEditPanel.this.clipSlider.getValue()));
                                props.save(false);
                                JEditPanel.this.ao.getFile().setLastModified(new Date().getTime());
                            }
                            catch (IOException ex1) {
                                ex1.printStackTrace(System.err);
                            }
                            finally {
                                JEditPanel.this.context.parent.progressSpinner.workDone();
                            }
                        });
                    }
                } else {
                    JEditPanel.this.updateImage(true);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(JEditPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    };
    private int origWidth = 0;
    private int origHeight = 0;
    BufferedImage bufferedImage;
    MouseConverter mouseConverter = new MouseConverter();
    private transient Vector<EditListener> editListeners;

    private String getUndoText() {
        int pos;
        FilterList fl = this.filterManager.getFilterList();
        if (fl != null && (pos = fl.getPosition() - 1) >= 0) {
            return Msg.get("edit.undo") + " " + fl.getFilters().get(pos).getProperties().getShortName();
        }
        return Msg.get("edit.undo");
    }

    private String getRedoText() {
        int pos;
        FilterList fl = this.filterManager.getFilterList();
        if (fl != null && (pos = fl.getPosition()) < fl.getFilters().size()) {
            return Msg.get("edit.redo") + " " + fl.getFilters().get(pos).getProperties().getShortName();
        }
        return Msg.get("edit.redo");
    }

    private void initToolBar() {
        this.audioClipAction = new AliasAction(this.context.recordAudioClipAction){
            {
                this.putValue("ShortDescription", Msg.get("ui.audioClip"));
            }
        };
        this.toolBar.addGroup(this.context.excludeSelectedAction, this.context.rotateLeftAction, this.context.rotateRightAction, this.context.flipAction);
        this.toolBar.addSeparator();
        this.toolBar.addGroup(this.toolActions.toolActions);
        this.effectsButton.addActions(this.toolActions.effectActions);
        this.toolBar.add(this.effectsButton);
        this.toolBar.add(this.audioClipAction);
        this.toolBar.addFirst(new JToolBarButton(this.toolActions.undoAction, false){

            @Override
            public String getToolTipText(MouseEvent event) {
                return JEditPanel.this.getUndoText();
            }
        });
        this.toolBar.addLast(new JToolBarButton(this.toolActions.redoAction, false){

            @Override
            public String getToolTipText(MouseEvent event) {
                return JEditPanel.this.getRedoText();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("included".equals(evt.getPropertyName())) {
            this.imageScrollPane.repaint();
        }
        if ("properties".equals(evt.getPropertyName())) {
            this.updateAudioClipIndicator();
        }
    }

    private void updateAudioClipIndicator() {
        if (this.ao != null && this.ao.getAttachments().isPresent(Attachments.Type.AUDIO)) {
            this.audioClipAction.putValue("SmallIcon", Icons.get("music-note-present"));
        } else {
            this.audioClipAction.putValue("SmallIcon", Icons.get("music-note"));
        }
    }

    public void initMenus(JMenu editMenu, JMenu imageToolsMenu, JMenu imageEffectsMenu) {
        editMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JEditPanel.this.toolActions.undoAction.putValue("Name", JEditPanel.this.getUndoText());
                JEditPanel.this.toolActions.redoAction.putValue("Name", JEditPanel.this.getRedoText());
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        editMenu.add(new MenuAction(this.toolActions.undoAction));
        editMenu.add(new MenuAction(this.toolActions.redoAction));
        editMenu.addSeparator();
        editMenu.add(new MenuAction(this.context.excludeSelectedAction));
        imageToolsMenu.add(new MenuAction(this.context.rotateLeftAction));
        imageToolsMenu.add(new MenuAction(this.context.rotateRightAction));
        imageToolsMenu.add(new MenuAction(this.context.flipAction));
        for (Action a : this.toolActions.toolActions) {
            imageToolsMenu.add(new MenuAction(a));
        }
        for (Action a : this.toolActions.effectActions) {
            imageEffectsMenu.add(new MenuAction(a));
        }
    }

    @Override
    public BooleanExpression imageLoadingProperty() {
        return this.imageLoading;
    }

    public JEditPanel(JAlbumExplorer context) {
        this.context = context;
        context.editor = this;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void reload() {
        this.imageComp.scheduleReload(this.context.imageCache.imageDim);
    }

    private static boolean isRawImage(AlbumObject ao) {
        try {
            return ao.getFile().exists() && ao.getCategory() == Category.image && ao.getImageInfo().isRaw();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setAO(AlbumObject ao) {
        RAWImageReadParam currentRAWSettings;
        if (this.ao != null && JEditPanel.isRawImage(this.ao) && !Objects.equals(currentRAWSettings = ((AlbumObjectImpl)this.ao).getRAWSettings(), this.lastRAWsettings)) {
            ((AlbumObjectImpl)this.ao).setRAWSettings(currentRAWSettings, this.lastRAWsettings);
        }
        this.lastRAWsettings = null;
        if (ao != null && JEditPanel.isRawImage(ao)) {
            RAWImageReadParam last = ((AlbumObjectImpl)ao).getRAWSettings();
            RAWImageReadParam rAWImageReadParam = this.lastRAWsettings = last != null ? (RAWImageReadParam)last.clone() : null;
        }
        if (this.ao != null) {
            this.ao.removePropertyChangeListener(this);
        }
        if (ao != null) {
            ao.addPropertyChangeListener(this);
        }
        this.videoBrowser.cancel(true);
        Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            JFormattedTextField tf = (JFormattedTextField)focusOwner;
            try {
                tf.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.ao = ao;
        this.commentPanel.setAlbumObject(ao);
        this.propertyPanel.setAlbumObject(ao);
        if (this.customUI != null && this.customUI instanceof EditListener) {
            ((EditListener)((Object)this.customUI)).setAlbumObject(ao);
        }
        try (WaitCursor.WaitToken _wt = this.context.parent.waitCursor.getToken();){
            this.fireEditingAlbumObject(ao);
            if (ao != null) {
                if (ao.hasDisplayableImage()) {
                    this.imageInfo = ao.getImageInfo();
                }
                this.refreshUI();
                JAlbumObject jao = this.context.explorer.getJAlbumObject(ao);
                if (jao != null) {
                    this.context.explorer.selectionModel.selectSingle(jao);
                }
            } else {
                this.imageComp.setImage(null);
                this.updateImage(false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.updateAudioClipIndicator();
    }

    public void saveState() {
        if (this.customUI instanceof EditListener2) {
            ((EditListener2)((Object)this.customUI)).saveState();
        }
        this.fireSaveState();
    }

    public AlbumObject getAO() {
        return this.ao;
    }

    void moveTo(AlbumObject dest) {
        if (dest == null) {
            return;
        }
        if (this.moveCounter++ == 3) {
            TipOfTheDay.showInBackground(Msg.get("tip.editModeMoveBetweenImages"));
        }
        this.setAO(dest);
    }

    void setFiltersViewMode() {
        this.propertyPanel.remove(this.filterUITab);
        this.rightPanel.validate();
    }

    private JAlbumObject getPreviousComponent(AlbumObject ao) {
        return this.context.explorer.getPreviousComponent(this.context.explorer.getJAlbumObject(ao));
    }

    private JAlbumObject getPreviousComponent() {
        return this.getPreviousComponent(this.ao);
    }

    private JAlbumObject getNextComponent(AlbumObject ao) {
        return this.context.explorer.getNextComponent(this.context.explorer.getJAlbumObject(ao));
    }

    private JAlbumObject getNextComponent() {
        return this.getNextComponent(this.ao);
    }

    private BufferedImage loadAndPrepareImage(AlbumObject ao, Dimension newDim) throws IOException {
        ao.updateRepresentingIcon();
        Logger.getLogger(JEditPanel.class.getName()).log(Level.FINEST, "Loading dim " + String.valueOf(newDim));
        BufferedImage img = (BufferedImage)ao.loadImage(true, newDim);
        this.context.imageCache.setImage(ao, img);
        Logger.getLogger(JEditPanel.class.getName()).log(Level.FINEST, "Loaded: " + img.getWidth());
        img = this.filterManager.setImage(img, this.filterManager.getFilterList());
        return img;
    }

    private void init() throws Exception {
        this.basicPanel.setBorder(BorderFactory.createEmptyBorder(80, 10, 8, 8));
        this.setLayout(new BorderLayout());
        this.setBackground(JAlbumColor.text);
        this.setFocusable(true);
        this.initToolBar();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.setBackground(JAlbumColor.text);
        this.setToolTipText(Msg.get("edit.tipLabel"));
        this.setPreferredSize(new Dimension(760, 600));
        this.filterUITab.setContentPanel(this.filterUIContainer);
        this.previousButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.previousButton.setBorderRadius(8);
        this.previousButton.setBorderOpacity(0.35f);
        this.nextButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.nextButton.setBorderRadius(8);
        this.nextButton.setBorderOpacity(0.35f);
        this.returnButton.setBorder(BorderFactory.createEmptyBorder(14, 16, 14, 12));
        this.returnButton.setBorderRadius(8);
        this.returnButton.setBorderOpacity(0.35f);
        ContextHelp.getInstance().add(this.timeSlider, "Edit#Video");
        this.timeSlider.setVisible(false);
        this.timeSlider.setOpaque(false);
        this.timeSlider.setPaintLabels(true);
        this.timeSlider.setSnapToTicks(false);
        new SliderInfo(this.timeSlider){

            @Override
            protected String getInfoText() {
                return TimeCode.fromMillis(this.slider.getValue()).toString();
            }
        };
        this.clipSlider.setVisible(false);
        this.clipSlider.setOpaque(false);
        this.clipSlider.setPaintLabels(true);
        this.clipSlider.setSnapToTicks(false);
        this.clipSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JEditPanel.this.clipSliderChangeListener.stateChanged(null);
            }
        });
        new SliderInfo(this.clipSlider){

            @Override
            protected String getInfoText() {
                return TimeCode.fromMillis(JEditPanel.this.clipSlider.isUpperDragging() ? (long)JEditPanel.this.clipSlider.getUpperValue() : (long)JEditPanel.this.clipSlider.getValue()).toString();
            }
        };
        this.registerKeyboardAction(this.cancelAction, "cancel-dialog", this.escape, 2);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.pgUp, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.pgDown, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.up, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.down, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.left, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.right, 1);
        this.registerKeyboardAction(new LambdaAction(e -> this.context.reviewModeAction.actionPerformed(e)), "reviewModeAction", space, 0);
        this.hSplitPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, JAlbumColor.border));
        this.hSplitPane.setBackground(JAlbumColor.text);
        this.basicPanel.setLayout(new BorderLayout());
        this.basicPanel.setImageBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.basicPanel.setBackground(JAlbumColor.text);
        this.basicScrollPane.setViewportView(this.basicPanel);
        this.basicScrollPane.getViewport().setScrollMode(2);
        this.basicScrollPane.setBorder(null);
        this.imageComp = this.imageScrollPane.getImageComponent();
        this.imageComp.setImageProvider(dim -> {
            try {
                this.context.parent.progressSpinner.workStarted();
                this.imageLoading.set(true);
                BufferedImage bufferedImage = this.loadAndPrepareImage(this.ao, dim);
                return bufferedImage;
            }
            finally {
                this.context.parent.progressSpinner.workDone();
                this.imageLoading.set(false);
            }
        });
        this.imageComp.addPropertyChangeListener("imageReplaced", pce -> this.fireImageUpdated());
        this.imageComp.setLayout(new BorderLayout());
        this.imageScrollPane.addPropertyChangeListener(this);
        this.imageScrollPane.setBorder(null);
        this.centerPanel.setOpaque(true);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                JEditPanel.this.glassPanel.setVisible(JEditPanel.this.filterUI == null);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!JEditPanel.this.glassPanel.getBounds().contains(e.getPoint())) {
                    JEditPanel.this.glassPanel.setVisible(false);
                }
            }
        };
        this.addMouseListener(ml);
        this.basicPanel.addMouseListener(ml);
        this.centerPanel.addMouseListener(ml);
        this.imageScrollPane.getViewport().addMouseListener(ml);
        this.overlayPanel.setLayout(new OverlayLayout(this.overlayPanel));
        Dimension hScrollSize = this.imageScrollPane.getHorizontalScrollBar().getPreferredSize();
        Dimension vScrollSize = this.imageScrollPane.getVerticalScrollBar().getPreferredSize();
        this.glassPanel.setBorder(BorderFactory.createEmptyBorder(14, vScrollSize.width, hScrollSize.height, vScrollSize.width));
        this.glassPanel.setOpaque(false);
        Box top = Box.createVerticalBox();
        Box north = Box.createHorizontalBox();
        north.add(this.previousButton);
        north.add(Box.createHorizontalStrut(8));
        north.add(this.returnButton);
        north.add(Box.createHorizontalStrut(8));
        north.add(this.nextButton);
        north.setAlignmentX(0.5f);
        top.add(north);
        this.glassPanel.add((Component)top, "North");
        Box sliderBox = Box.createVerticalBox();
        sliderBox.add(this.clipSlider);
        sliderBox.add(this.timeSlider);
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setOpaque(false);
        southPanel.add((Component)sliderBox, "South");
        southPanel.add((Component)new JZoomControlPanel(this.imageScrollPane), "East");
        this.glassPanel.add((Component)southPanel, "South");
        this.overlayPanel.add((Component)this.glassPanel, JLayeredPane.PALETTE_LAYER);
        this.overlayPanel.add((Component)this.imageScrollPane, JLayeredPane.DEFAULT_LAYER);
        JLineSplitPane split = new JLineSplitPane(0);
        split.setTopComponent(this.overlayPanel);
        split.setBottomComponent(this.commentPanel);
        split.setResizeWeight(0.9);
        split.setBorder(null);
        this.centerPanel.add((Component)split, "Center");
        this.hSplitPane.setLeftComponent(this.centerPanel);
        this.rightPanel.setBackground(JAlbumColor.control.darker());
        this.rightPanel.add((Component)this.propertyPanel, "North");
        JScrollPane scroller = new JScrollPane(this.rightPanel, 20, 31){

            @Override
            public Dimension getMinimumSize() {
                if (this.getViewport().getView() != null) {
                    return this.getViewport().getView().getMinimumSize();
                }
                return super.getMinimumSize();
            }
        };
        scroller.getVerticalScrollBar().setUnitIncrement(30);
        scroller.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, JAlbumColor.border));
        this.hSplitPane.setRightComponent(scroller);
        this.hSplitPane.setDividerSize(3);
        this.hSplitPane.setResizeWeight(1.0);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.hSplitPane, "Center");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle(JEditPanel.this);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        Msg.maintainTranslated(this);
        ContextHelp.getInstance().add(this, "Edit");
        try {
            new JRawSettingsPanel(this.context.parent.context.getPluginContext());
        }
        catch (NoClassDefFoundError err) {
            System.err.println("RAW support missing");
        }
        new JPhotoSphereSettingsPanel(this.context.parent.context.getPluginContext());
    }

    private void refreshUI() throws IOException {
        AlbumObject ao = this.ao;
        this.context.updateRotateActions(this.ao);
        this.updateImage(true);
        this.enableImageBrowseActions();
        this.toolActions.setEnabled(ao != null && !ao.isFolder() && ao.hasDisplayableImage());
        this.effectsButton.setEnabled(ao != null && !ao.isFolder() && ao.hasDisplayableImage());
        if (ao != null) {
            this.context.parent.statusBar.setText(Msg.get("ui.editModeStatusText", ao.getFile().getName()));
        }
        this.context.parent.setTitle();
        this.timeSlider.setVisible(false);
        this.timeSlider.removeChangeListener(this.timeSliderChangeListener);
        this.clipSlider.setVisible(false);
        this.clipSlider.removeChangeListener(this.clipSliderChangeListener);
        AlbumObjectProperties props = ao.getProperties();
        if (ao.getCategory() == Category.video) {
            TimeCode videoDuration = (TimeCode)props.get("videoDuration");
            TimeCode videoPosition = props.get("videoPosition", new TimeCode(0));
            if (videoDuration == null) {
                File repFile = ao.getRepresentingImageFile();
                videoDuration = (TimeCode)props.get("videoDuration");
                if (repFile != null && videoDuration == null && !ao.getAttachments().isPresent(Attachments.Type.IMAGE)) {
                    repFile.delete();
                    ao.getRepresentingImageFile();
                    videoDuration = (TimeCode)props.get("videoDuration");
                }
            }
            if (videoDuration != null) {
                this.timeSlider.setMinimum(0);
                this.timeSlider.setMaximum((int)videoDuration.asMillis() - 10);
                this.timeSlider.setMinorTickSpacing(1000);
                this.timeSlider.setPaintTicks(true);
                this.timeSlider.setValue((int)videoPosition.asMillis());
                Hashtable<Integer, JGlassLabel> table = new Hashtable<Integer, JGlassLabel>();
                ((Dictionary)table).put(0, new JGlassLabel(new TimeCode(0).toString() + "s"));
                ((Dictionary)table).put((int)videoDuration.asMillis(), new JGlassLabel(videoDuration.toString() + "s"));
                this.timeSlider.setLabelTable(table);
                this.timeSlider.setVisible(true);
                this.timeSlider.addChangeListener(this.timeSliderChangeListener);
                this.clipSlider.setMinimum(0);
                this.clipSlider.setMaximum((int)videoDuration.asMillis());
                this.clipSlider.setMinorTickSpacing(1000);
                this.clipSlider.setPaintTicks(true);
                TimeCode clipStart = props.get("videoClipStart", new TimeCode(0));
                TimeCode clipLength = props.get("videoClipLength", videoDuration);
                this.clipSlider.setValue(0);
                int cs = (int)clipStart.asMillis();
                this.clipSlider.setUpperValue(cs + (int)clipLength.asMillis());
                this.clipSlider.setValue(cs);
                table = new Hashtable();
                ((Dictionary)table).put(0, new JGlassLabel(new TimeCode(0).toString() + "s"));
                ((Dictionary)table).put((int)videoDuration.asMillis(), new JGlassLabel(videoDuration.toString() + "s"));
                this.clipSlider.setLabelTable(table);
                this.clipSlider.setVisible(true);
                this.clipSlider.addChangeListener(this.clipSliderChangeListener);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateImage(boolean loadStack) throws IOException {
        Component displayedPane = this.overlayPanel.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)[0];
        this.imageComp.setImage(null);
        this.basicPanel.setBackgroundImage(null);
        if (this.customUI != null) {
            this.imageComp.removeAll();
            this.imageComp.validate();
            this.basicPanel.removeAll();
            this.basicPanel.validate();
            this.customUI = null;
        }
        if (this.ao == null) {
            return;
        }
        if (this.ao.getCategory() == Category.webLocation) {
            JWebLocationEditPanel panel = new JWebLocationEditPanel(this.ao.getParent(), this.context.explorer.findInsertIndex());
            this.customUI = panel;
            WebLocation wl = new WebLocation(this.ao.getFile());
            panel.setTargetURI(wl.getURI().toASCIIString());
            panel.setImageURL(this.ao.getProperties().get("imageURI", ""));
            File repFile = this.ao.getRepresentingImageFile();
            if (repFile != null) {
                panel.setImage(ImageIO.read(repFile));
            }
            this.basicPanel.add((Component)panel, "Center");
            this.basicPanel.validate();
            this.basicPanel.repaint();
            panel.onChange(evt -> {
                AlbumObjectProperties props = this.ao.getProperties();
                if (panel.getImageURL().length() == 0 && repFile != null) {
                    repFile.delete();
                }
                props.putHidden("imageURI", panel.getImageURL());
                props.save();
                try {
                    WebLocation webLoc = new WebLocation(panel.getTargetURI());
                    if (this.ao.getCategory() == Category.webLocation) {
                        webLoc.writeToFile(this.ao.getFile());
                        if (panel.getImage() != null) {
                            this.ao.setRepresentingIcon(panel.getImage(), true);
                        }
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    Logger.getLogger(JEditPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        } else if (this.ao.getCategory() == Category.view) {
            View view = ((ViewAlbumObject)this.ao).getView();
            this.customUI = view.getUserInterface((ViewAlbumObject)this.ao, this.context);
            if (this.customUI != null) {
                this.basicPanel.add((Component)this.customUI, "North");
                this.basicPanel.validate();
                this.basicPanel.repaint();
            }
        }
        if (this.ao.hasDisplayableImage() && this.ao.getCategory() != Category.webLocation && this.ao.getCategory() != Category.view) {
            if (!displayedPane.equals(this.imageScrollPane)) {
                this.overlayPanel.remove(displayedPane);
                this.overlayPanel.add((Component)this.imageScrollPane, JLayeredPane.DEFAULT_LAYER);
                this.overlayPanel.revalidate();
            }
            if (loadStack) {
                AlbumObjectProperties props = this.ao.getProperties();
                Object stack = props.get("filterList");
                if (stack != null) {
                    this.filterManager.setFilterList((FilterList)stack);
                } else {
                    this.filterManager.setFilterList(null);
                }
            }
            Image closeup = this.context.imageCache.getImage(this.ao);
            if (Category.image == this.ao.getCategory()) {
                Dimension size = this.ao.getSize();
                this.origWidth = size.width;
                this.origHeight = size.height;
            }
            closeup = this.filterManager.setImage((BufferedImage)closeup, this.filterManager.getFilterList());
            if (this.ao.isFolder()) {
                Stamp.press((BufferedImage)closeup, faintFolderIcon.getImage());
            }
            Dimension fullSize = null;
            if (Category.image == this.ao.getCategory() && this.origWidth > closeup.getWidth(null)) {
                fullSize = new Dimension(this.origWidth, this.origHeight);
                fullSize = this.filterManager.getPrescaleFilteredSize(fullSize);
            }
            this.imageComp.setImage(closeup, fullSize);
            this.imageScrollPane.repaint();
        } else {
            if (!displayedPane.equals(this.basicScrollPane)) {
                this.overlayPanel.remove(displayedPane);
                this.overlayPanel.add((Component)this.basicScrollPane, JLayeredPane.DEFAULT_LAYER);
                this.overlayPanel.revalidate();
            }
            switch (this.ao.getCategory()) {
                case webPage: {
                    String doc = IO.readTextFile(LinkFile.getResolvedTarget(this.ao));
                    try {
                        Element elem = Elements.getElementByName("ja:ui", doc, false);
                        if (elem == null || !"ja:ui".equals(elem.getName())) break;
                        JAlbumFrame ui = this.context.parent;
                        ScriptEnvironment se = ui.engine.getScriptEnvironment();
                        Interpreter interpreter = new Interpreter();
                        interpreter.setClassLoader((ClassLoader)se.classLoader);
                        NameSpace ns = interpreter.getNameSpace();
                        ns.importPackage("se.datadosen.jalbum");
                        ns.importPackage("se.datadosen.util");
                        ns.importPackage("se.datadosen.component");
                        PrintSafeHashMap vars = new PrintSafeHashMap();
                        ui.engine.init();
                        ui.engine.addGlobals(vars, false);
                        vars.put("rootFolder", ui.albumExplorer.getRootFolder());
                        vars.put("currentFolder", ui.albumExplorer.getCurrentFolder());
                        Map userVariables = ui.engine.getUserVariables();
                        if (userVariables != null) {
                            vars.putAll(userVariables);
                        }
                        AlbumBean cfr_ignored_0 = ui.engine;
                        AlbumBean.setVars((Map<String, Object>)vars, interpreter);
                        Object ret = interpreter.eval(elem.getContent().toString());
                        if (!(ret instanceof Class)) {
                            throw new EvaluationException("Content of ja:ui element not evaluating to a class declaration");
                        }
                        this.customUI = (JComponent)((Class)ret).getConstructor(new Class[0]).newInstance(new Object[0]);
                        ContextHelp.getInstance().addTree(this.customUI);
                        JPanel opaquePanel = new JPanel(new BorderLayout());
                        opaquePanel.add((Component)this.customUI, "Center");
                        this.basicPanel.add((Component)opaquePanel, "Center");
                        this.basicPanel.validate();
                        this.basicPanel.repaint();
                        if (this.customUI instanceof JAlbumPlugin) {
                            ((JAlbumPlugin)((Object)this.customUI)).init(this.context.parent.context.getPluginContext());
                        }
                        if (!(this.customUI instanceof EditListener)) break;
                        ((EditListener)((Object)this.customUI)).setAlbumObject(this.ao);
                    }
                    catch (InvocationTargetException ex) {
                        Debug.showStackTraceDialog(this.context, ex.getCause());
                    }
                    catch (EvalError | IOException | ReflectiveOperationException | ScriptException | EvaluationException | OperationAbortedException | ElementException ex) {
                        Debug.showCopyableError(this.context, ex, "Custum UI scripting error");
                    }
                    break;
                }
                default: {
                    Image closeup = this.ao.getRepresentingIcon(this.imageComp.getSize(), false).getImage();
                    this.basicPanel.setBackgroundImage(closeup);
                }
            }
        }
        this.fireImageUpdated();
    }

    void saveFilters() {
        AlbumObjectProperties props = this.ao.getProperties();
        props.putHidden("filterList", this.filterManager.getFilterList());
        try {
            props.store(false);
        }
        catch (IOException ex) {
            Debug.showFriendlyErrorDialog(this, ex);
        }
        this.ao.updateRepresentingIcon();
    }

    @Override
    public synchronized void addImageListener(ImageListener listener) {
        this.imageListeners.add(listener);
    }

    @Override
    public synchronized void removeImageListener(ImageListener listener) {
        this.imageListeners.remove(listener);
    }

    public synchronized void fireImageUpdated() {
        if (this.imageComp.getImage() instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)this.imageComp.getImage();
            for (ImageListener listener : this.imageListeners) {
                listener.imageUpdated(bi);
            }
        }
    }

    void useFilter(JAlbumImageFilter filter) throws IOException {
        this.imageComp.zoomToMin();
        this.filterManager.cancel();
        this.currentFilter = filter = this.filterManager.addFilter(filter);
        this.imageComp.addMouseListener(this.mouseConverter);
        this.imageComp.addMouseMotionListener(this.mouseConverter);
        this.imageComp.addMouseWheelListener(this.mouseConverter);
        this.imageComp.addKeyListener(filter);
        this.cancelAction.setEnabled(false);
        this.glassPanel.setVisible(false);
        this.filterUITab.setTitle(filter.getProperties().getShortName());
        this.switchFilterUI(this.filterManager.getFilterControls());
        this.disableImageBrowseActions();
        this.switchFilterManagerControls(this.filterManager.getFilterManagerControls());
        this.toolActions.setUndoRedoEnabled(false);
        this.context.setTopBarActionsEnabled(false);
        this.commentPanel.setFocusable(false);
        this.propertyPanel.setFocusable(false);
        this.propertyPanel.add((Component)this.filterUITab, 0);
        this.filterUITab.setExpanded(true);
        this.commentPanel.setFocusable(true);
        this.propertyPanel.setFocusable(true);
        this.rightPanel.validate();
        this.rightPanel.repaint();
    }

    void setImageInFilter() {
        try {
            this.bufferedImage = (BufferedImage)this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage(this.bufferedImage, this.filterManager.getFilterList());
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void switchFilterUI(JPanel filterControls) {
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterUI);
        }
        this.filterUI = filterControls;
        if (this.filterUI != null) {
            this.filterUIContainer.add((Component)this.filterUI, "Center");
        }
    }

    private void switchFilterManagerControls(JPanel managerControls) {
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
        }
        this.filterManagerControls = managerControls;
        if (this.filterManagerControls != null) {
            this.filterUIContainer.add((Component)this.filterManagerControls, "South");
        }
    }

    private void disableImageBrowseActions() {
        this.nextImageAction.setEnabled(false);
        this.propertyPanel.nextImage.setEnabled(false);
        this.previousImageAction.setEnabled(false);
        this.propertyPanel.previousImage.setEnabled(false);
    }

    private void enableImageBrowseActions() {
        boolean hasNext = this.getNextComponent() != null;
        boolean hasPrevious = this.getPreviousComponent() != null;
        this.nextImageAction.setEnabled(hasNext);
        this.propertyPanel.nextImage.setEnabled(hasNext);
        this.previousImageAction.setEnabled(hasPrevious);
        this.propertyPanel.previousImage.setEnabled(hasPrevious);
    }

    @Override
    public BufferedImage scaleImage(BufferedImage bi) {
        AlbumImage ai = new AlbumImage(bi, this.context.parent.engine);
        ai = ai.scaleToFit(this.imageComp.getSize());
        return ai.getBufferedImage();
    }

    @Override
    public void filterMenuClosed(BufferedImage bi, boolean saveBeforeClose) {
        this.setImage(bi);
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterUI);
            this.filterUI = null;
        }
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
            this.filterManagerControls = null;
        }
        this.propertyPanel.remove(this.filterUITab);
        this.propertyPanel.validate();
        this.enableImageBrowseActions();
        if (saveBeforeClose) {
            this.saveFilters();
        }
        this.toolActions.setUndoRedoEnabled(true);
        this.context.setTopBarActionsEnabled(true);
        this.cancelAction.setEnabled(true);
        this.glassPanel.setVisible(true);
        this.cleanFilterListeners();
        this.currentFilter = null;
        this.validate();
        this.requestFocusInWindow();
        try {
            this.updateImage(true);
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    protected void cleanFilterListeners() {
        if (this.currentFilter != null) {
            this.imageComp.removeMouseListener(this.mouseConverter);
            this.imageComp.removeMouseMotionListener(this.mouseConverter);
            this.imageComp.removeMouseWheelListener(this.mouseConverter);
            this.imageComp.removeKeyListener(this.currentFilter);
        }
    }

    @Override
    public void setImage(BufferedImage bi) {
        this.imageComp.setImage(bi);
        this.fireImageUpdated();
    }

    @Override
    public JComponent getImageComponent() {
        return this.imageComp;
    }

    public Point getImageCoordinates(MouseEvent e) {
        Point p = e.getPoint();
        Point p2 = new Point(p);
        Rectangle ib = this.imageComp.getImageBounds();
        p2.translate(-ib.x, -ib.y);
        double factor = 1.0 / this.imageComp.toZoomFactor(this.imageComp.getZoomLevel());
        p2.x = (int)((double)p2.x * factor);
        p2.y = (int)((double)p2.y * factor);
        JAlbum.logger.finest("Before: " + String.valueOf(p) + " After: " + String.valueOf(p2));
        return p2;
    }

    @Override
    public synchronized void addEditListener(EditListener l) {
        Vector v;
        Vector vector = v = this.editListeners == null ? new Vector(2) : (Vector)this.editListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            if (this.ao != null) {
                l.setAlbumObject(this.ao);
            }
            this.editListeners = v;
        }
    }

    @Override
    public void removeEditListener(EditListener l) {
        if (this.editListeners != null && this.editListeners.contains(l)) {
            Vector v = (Vector)this.editListeners.clone();
            v.removeElement(l);
            this.editListeners = v;
        }
    }

    protected void fireEditingAlbumObject(AlbumObject ao) {
        if (this.editListeners != null) {
            for (EditListener listener : this.editListeners) {
                listener.setAlbumObject(ao);
            }
        }
    }

    protected void fireSaveState() {
        if (this.editListeners != null) {
            for (EditListener listener : this.editListeners) {
                if (!(listener instanceof EditListener2)) continue;
                ((EditListener2)listener).saveState();
            }
        }
    }

    @Override
    public void addCustomTab(String title, JComponent panel) {
        this.propertyPanel.addTab(title, panel);
        ContextHelp.getInstance().addTree(panel);
    }

    @Override
    public void addCustomTab(JCollapsiblePanel panel) {
        this.propertyPanel.addTab(panel);
        ContextHelp.getInstance().addTree(panel.getContentPanel());
    }

    @Override
    public void removeCustomTab(JComponent panel) {
        this.propertyPanel.removeTab(panel);
    }

    class MouseConverter
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        MouseConverter() {
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point p = JEditPanel.this.getImageCoordinates(e);
            MouseEvent correctedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiersEx(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            return correctedEvent;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseClicked(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseEntered(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseExited(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mousePressed(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseReleased(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseDragged(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseMoved(this.convertMouseEvent(e));
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                Point p = JEditPanel.this.getImageCoordinates(e);
                MouseWheelEvent correctedEvent = new MouseWheelEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiersEx(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                JEditPanel.this.currentFilter.mouseWheelMoved(correctedEvent);
            }
        }
    }

    private static class JGlassLabel
    extends JLabel {
        public JGlassLabel(String string) {
            super(string);
            this.setOpaque(true);
            Color bg = this.getBackground();
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 128));
        }
    }

    private class RatingAction
    extends AbstractAction {
        private int rating;

        public RatingAction(int rating) {
            this.rating = rating;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditPanel.this.propertyPanel.rating.changeValue(this.rating);
        }
    }
}

