/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.prefs.Preferences;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.SwingWorker;
import se.datadosen.component.CenterLayout;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.component.JSmartDialog;
import se.datadosen.explorer.JCropFocusSelector;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.JAlbumColor;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.util.Debug;

public class JCropFocusDialog
extends JSmartDialog {
    public static final int IMAGE_SIZE = 800;
    private static final Dimension imageBounds = new Dimension(800, 800);
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private final JAlbumContext context;
    private AlbumObject ao;
    JCropFocusSelector display = new JCropFocusSelector();
    JProgressSpinner spinner = new JProgressSpinner(32);
    AlbumBean engine;
    private Action cancelAction = new AbstractAction(Msg.get("cancel")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JCropFocusDialog.this.setVisible(false);
            JCropFocusDialog.this.releaseResources();
        }
    };
    private Action okAction = new AbstractAction(Msg.get("ok")){

        @Override
        public void actionPerformed(ActionEvent e) {
            JCropFocusDialog.this.prefs.putInt("displayWidth", JCropFocusDialog.this.display.getWidth());
            JCropFocusDialog.this.prefs.putInt("displayHeight", JCropFocusDialog.this.display.getHeight());
            AlbumObjectProperties aop = JCropFocusDialog.this.ao.getProperties();
            Map userVars = aop.get("userVariables", new LinkedHashMap());
            userVars.put("xWeight", "" + JCropFocusDialog.this.display.getxWeight());
            userVars.put("yWeight", "" + JCropFocusDialog.this.display.getyWeight());
            aop.put("userVariables", userVars);
            aop.save(false);
            JCropFocusDialog.this.setVisible(false);
            JCropFocusDialog.this.releaseResources();
        }
    };

    private void releaseResources() {
        this.display = null;
        this.spinner = null;
        this.removeAll();
        this.dispose();
    }

    public JCropFocusDialog(JAlbumContext context, AlbumObject ao) {
        super(context.getFrame(), Msg.get("ui.setCropFocus"), false);
        this.context = context;
        this.ao = ao;
        this.init();
    }

    private void init() {
        this.engine = this.context.getEngine();
        try {
            this.engine.init();
        }
        catch (IOException | ScriptException | OperationAbortedException ex) {
            throw new RuntimeException(ex);
        }
        this.registerActions(this.okAction, this.cancelAction);
        this.display.setLayout(new CenterLayout());
        this.display.add(this.spinner);
        this.display.setBackground(JAlbumColor.text);
        this.display.setImageBorder(BorderFactory.createLineBorder(JAlbumColor.border));
        this.display.setPreferredSize(new Dimension(this.prefs.getInt("displayWidth", 500), this.prefs.getInt("displayHeight", 500)));
        this.spinner.workStarted();
        new SwingWorker<Image, Object>(){

            @Override
            protected Image doInBackground() throws Exception {
                return JCropFocusDialog.this.ao.loadImage(true, imageBounds);
            }

            @Override
            protected void done() {
                try {
                    JCropFocusDialog.this.spinner.workDone();
                    JCropFocusDialog.this.display.validate();
                    JCropFocusDialog.this.display.setBackgroundImage((Image)this.get());
                    JCropFocusDialog.this.display.setCursor(Cursor.getPredefinedCursor(12));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException ex) {
                    Debug.showErrorDialog(JCropFocusDialog.this, ex);
                }
            }
        }.execute();
        AlbumObjectProperties aop = this.ao.getProperties();
        Map userVars = aop.get("userVariables", new LinkedHashMap());
        try {
            this.display.setxWeight(Float.parseFloat((String)userVars.get("xWeight")));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        try {
            this.display.setyWeight(Float.parseFloat((String)userVars.get("yWeight")));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        this.context.getFrame().ui2Engine();
        Dimension d = this.engine.getThemeImageDim();
        if (d != null) {
            this.display.setRatio((float)d.width / (float)d.height);
        }
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)this.display, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JCropFocusDialog.this.cancelAction.actionPerformed(null);
            }
        });
        this.pack();
    }

    private static Dimension parseSize(String sizeString) throws IllegalArgumentException {
        String size = sizeString.toLowerCase();
        StringTokenizer tokens = new StringTokenizer(size, "x ");
        int w = 0;
        try {
            w = Integer.parseInt(tokens.nextToken());
            int h = Integer.parseInt(tokens.nextToken());
            if (w < 0 || h < 0) {
                throw new Exception();
            }
            return new Dimension(w, h);
        }
        catch (Exception ex) {
            if (w != 0) {
                return new Dimension(w, w);
            }
            throw new IllegalArgumentException(Msg.get("engine.invalidSizeError", sizeString));
        }
    }
}

