/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.datadosen.component.WrappableJLabel;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;

public class JCopyWarningDialog
extends JDialog
implements ActionListener {
    JLabel upperLabel = new JLabel();
    JLabel icon = new JLabel(Icons.get("warning-24", 48));
    WrappableJLabel message;
    public JCheckBox applyToAll = new JCheckBox(Msg.get("ui.applyToAll"));
    public JButton keepBothButton = new JButton(Msg.get("ui.keepBoth"));
    public JButton dontReplaceButton = new JButton(Msg.get("ui.dontReplace"));
    public JButton stopButton = new JButton(Msg.get("ui.stop"));
    public JButton replaceButton = new JButton(Msg.get("ui.replace"));
    File file;
    public JButton buttonPressed = this.stopButton;

    public JCopyWarningDialog(JFrame owner, String title, File file) {
        super(owner, title, true);
        this.file = file;
        this.init();
    }

    private void init() {
        this.setResizable(false);
        this.message = new WrappableJLabel(Msg.get("ui.fileAlreadyExistsWarning", this.file.getName()));
        this.message.setPreferredWidth(340);
        if (Platform.isMac()) {
            this.setSmallerFont(this.message);
            this.setSmallerFont(this.applyToAll);
            this.setSmallerFont(this.applyToAll);
            this.setSmallerFont(this.keepBothButton);
            this.setSmallerFont(this.dontReplaceButton);
            this.setSmallerFont(this.stopButton);
            this.setSmallerFont(this.replaceButton);
        }
        this.keepBothButton.addActionListener(this);
        this.dontReplaceButton.addActionListener(this);
        this.stopButton.addActionListener(this);
        this.replaceButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.dontReplaceButton);
        JPanel outer = new JPanel(new BorderLayout(8, 0));
        outer.setBorder(BorderFactory.createEmptyBorder(12, 12, 6, 2));
        this.setContentPane(outer);
        outer.add((Component)this.icon, "West");
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 0));
        messagePanel.add((Component)this.message, "Center");
        outer.add((Component)messagePanel, "Center");
        JPanel buttonBar = new JPanel(new FlowLayout(1, 4, 4));
        outer.add((Component)buttonBar, "South");
        buttonBar.add(this.applyToAll);
        buttonBar.add(Box.createHorizontalGlue());
        buttonBar.add(this.keepBothButton);
        buttonBar.add(this.dontReplaceButton);
        buttonBar.add(this.stopButton);
        buttonBar.add(this.replaceButton);
        this.setMinimumSize(new Dimension(420, 1));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private void setSmallerFont(JComponent comp) {
        Font f = comp.getFont();
        comp.setFont(f.deriveFont(f.getSize2D() - 1.0f));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buttonPressed = (JButton)e.getSource();
        this.setVisible(false);
    }
}

