/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.explorer.JEditPanel;
import se.datadosen.jalbum.ActionTracker;
import se.datadosen.jalbum.FilterPluginList;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Main;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.StringUtil;
import se.datadosen.util.annotations.Shortcut;
import se.datadosen.util.annotations.Text;
import se.datadosen.util.annotations.ToolTipText;

public class ImageToolActions {
    private final JEditPanel context;
    public Action[] toolActions;
    public Action[] effectActions = new Action[0];
    @Text(value="edit.undo")
    @ToolTipText(value="edit.undoToolTip")
    @Shortcut(value="cmd Z")
    public Action undoAction = new AbstractAction(null, Icons.small("undo")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageToolActions.this.context.filterManager.hasFiltersInList()) {
                try {
                    ImageToolActions.this.context.setImageInFilter();
                    ImageToolActions.this.context.filterManager.undo();
                    ImageToolActions.this.context.saveFilters();
                    ImageToolActions.this.context.updateImage(false);
                    ImageToolActions.this.setUndoRedoEnabled(true);
                    ImageToolActions.this.context.requestFocusInWindow();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(ImageToolActions.this.context, ex);
                }
            }
        }
    };
    @Text(value="edit.redo")
    @ToolTipText(value="edit.redoToolTip")
    @Shortcut(value="cmd shift Z")
    public Action redoAction = new AbstractAction(null, Icons.small("redo")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImageToolActions.this.context.filterManager.hasFiltersInList()) {
                try {
                    ImageToolActions.this.context.setImageInFilter();
                    ImageToolActions.this.context.filterManager.redo();
                    ImageToolActions.this.context.saveFilters();
                    ImageToolActions.this.context.updateImage(false);
                    ImageToolActions.this.setUndoRedoEnabled(true);
                    ImageToolActions.this.context.requestFocusInWindow();
                }
                catch (IOException ex) {
                    Debug.showErrorDialog(ImageToolActions.this.context, ex);
                }
            }
        }
    };

    public ImageToolActions(JEditPanel context) {
        this.context = context;
        this.init();
    }

    private void init() {
        Msg.maintainTranslated(this);
        List<String> filters = FilterPluginList.getInstance().getFilterClasses();
        ArrayList<ActionTracker> ta = new ArrayList<ActionTracker>();
        ArrayList ea = new ArrayList();
        ArrayList<ActionTracker> target = ta;
        for (String filter : filters) {
            try {
                target.add(new ActionTracker(new ImageToolAction(filter)));
                if (filter.equals("net.jalbum.filters.GammaFilterPlugin")) {
                    this.toolActions = target.toArray(new Action[target.size()]);
                    target = ea;
                }
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace(System.err);
            }
            this.effectActions = target.toArray(new Action[target.size()]);
        }
    }

    public void setEnabled(boolean enabled) {
        this.setUndoRedoEnabled(enabled);
        for (Action a : this.toolActions) {
            a.setEnabled(enabled);
        }
        for (Action a : this.effectActions) {
            a.setEnabled(enabled);
        }
    }

    void setUndoRedoEnabled(boolean isImage) {
        this.undoAction.setEnabled(isImage && this.context.filterManager.isUndoPossible());
        this.redoAction.setEnabled(isImage && this.context.filterManager.isRedoPossible());
    }

    private class ImageToolAction
    extends AbstractAction {
        private final String filterName;

        public ImageToolAction(String filterName) throws ReflectiveOperationException {
            this.filterName = filterName;
            JAlbumImageFilter filter = this.getFilter();
            String actionCommand = StringUtil.stripSuffix(filter.getClass().getSimpleName(), "Plugin");
            this.putValue("ActionCommandKey", actionCommand);
            String shortcut = Msg.getShortcut(actionCommand);
            if (shortcut != null && shortcut.length() > 0) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(shortcut));
            }
            this.putValue("Name", filter.getProperties().getShortName());
            this.putValue("SmallIcon", filter.getProperties().getIcon());
            if (filter.getProperties().getDescription() != null && !filter.getProperties().getDescription().isEmpty()) {
                this.putValue("ShortDescription", filter.getProperties().getDescription());
            }
        }

        private JAlbumImageFilter getFilter() throws ReflectiveOperationException {
            ClassLoader cl = Main.getJAlbumClassLoader();
            return (JAlbumImageFilter)cl.loadClass(this.filterName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JAlbumImageFilter filter = this.getFilter();
                if (!ImageToolActions.this.context.context.isEditMode()) {
                    ImageToolActions.this.context.context.propertiesAction.actionPerformed(null);
                    SwingUtilities.invokeLater(() -> {
                        try {
                            ImageToolActions.this.context.useFilter(filter);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(ImageToolActions.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    });
                } else {
                    ImageToolActions.this.context.useFilter(filter);
                }
            }
            catch (IOException | ReflectiveOperationException ex) {
                Debug.showErrorDialog(ImageToolActions.this.context, ex);
            }
        }
    }
}

