/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.AlbumObject;

class HistoryNavigator {
    private JAlbumExplorer explorer;
    private final List<AlbumObject> history = new ArrayList<AlbumObject>();
    private int currentPos = -1;
    public final Action backAction = new AbstractAction("back"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HistoryNavigator.this.currentPos > 0) {
                --HistoryNavigator.this.currentPos;
                HistoryNavigator.this.explorer.doViewFolder(HistoryNavigator.this.history.get(HistoryNavigator.this.currentPos));
                HistoryNavigator.this.explorer.selectNode(HistoryNavigator.this.history.get(HistoryNavigator.this.currentPos));
                HistoryNavigator.this.updateEnabledStates();
            }
        }
    };
    public final Action forwardAction = new AbstractAction("forward"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (HistoryNavigator.this.currentPos < HistoryNavigator.this.history.size() - 1) {
                ++HistoryNavigator.this.currentPos;
                HistoryNavigator.this.explorer.doViewFolder(HistoryNavigator.this.history.get(HistoryNavigator.this.currentPos));
                HistoryNavigator.this.explorer.selectNode(HistoryNavigator.this.history.get(HistoryNavigator.this.currentPos));
                HistoryNavigator.this.updateEnabledStates();
            }
        }
    };

    public HistoryNavigator(JAlbumExplorer explorer) {
        this.explorer = explorer;
        this.updateEnabledStates();
    }

    public void track(AlbumObject folder) {
        if (!this.history.isEmpty()) {
            if (HistoryNavigator.rootOf(folder) != HistoryNavigator.rootOf(this.history.get(0))) {
                this.history.clear();
                this.currentPos = -1;
            } else if (folder == this.history.get(this.currentPos)) {
                return;
            }
        }
        for (int i = this.history.size() - 1; i > this.currentPos; --i) {
            this.history.remove(i);
        }
        this.history.add(folder);
        ++this.currentPos;
        this.updateEnabledStates();
    }

    private static AlbumObject rootOf(AlbumObject ao) {
        if (ao.getParent() == null) {
            return ao;
        }
        return HistoryNavigator.rootOf(ao.getParent());
    }

    private void updateEnabledStates() {
        this.forwardAction.setEnabled(this.currentPos < this.history.size() - 1);
        this.backAction.setEnabled(this.currentPos > 0);
    }
}

