/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.util.IO;

public class FolderTreeNode
extends DefaultMutableTreeNode {
    private final AlbumObject ao;
    private volatile boolean initialized = false;
    private volatile Boolean hasSubfolders = null;

    public FolderTreeNode(AlbumObject ao) {
        super(ao.getName());
        this.ao = ao;
    }

    @Override
    public boolean isLeaf() {
        if (this.hasSubfolders == null) {
            this.lazyCheckForSubfolders();
            return false;
        }
        return this.hasSubfolders == false;
    }

    public AlbumObject getAlbumObject() {
        return this.ao;
    }

    private void ensureInitialized() {
        if (!this.initialized) {
            this.initialized = true;
            this.initialize();
        }
    }

    @Override
    public int getChildCount() {
        this.ensureInitialized();
        return super.getChildCount();
    }

    @Override
    public Enumeration<TreeNode> children() {
        this.ensureInitialized();
        return super.children();
    }

    public void invalidate() {
        this.removeAllChildren();
        this.initialized = false;
        this.hasSubfolders = null;
    }

    private void initialize() {
        List<AlbumObject> albumObjectChildren = this.ao.getChildren();
        if (albumObjectChildren == null) {
            return;
        }
        for (AlbumObject child : albumObjectChildren) {
            if (child.getCategory() != Category.folder) continue;
            this.add(new FolderTreeNode(child));
        }
        this.initialized = true;
    }

    private void lazyCheckForSubfolders() {
        if (this.hasSubfolders != null) {
            return;
        }
        this.hasSubfolders = Boolean.TRUE;
        IO.workerPool.submit(() -> {
            boolean found = false;
            List<AlbumObject> children = this.ao.getChildren();
            if (children != null) {
                for (AlbumObject child : children) {
                    if (child.getCategory() != Category.folder) continue;
                    found = true;
                    break;
                }
            }
            boolean result = found;
            SwingUtilities.invokeLater(() -> {
                this.hasSubfolders = result;
                DefaultTreeModel model = this.getTreeModel();
                if (model != null) {
                    model.nodeChanged(this);
                }
            });
        });
    }

    private DefaultTreeModel getTreeModel() {
        Object maybeModel;
        TreeNode node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        FolderTreeNode root = node;
        if (root instanceof FolderTreeNode && (maybeModel = root.getUserObject()) instanceof DefaultTreeModel) {
            return (DefaultTreeModel)maybeModel;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode(this.ao);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FolderTreeNode) {
            return Objects.equals(this.ao, ((FolderTreeNode)obj).ao);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.ao.getName();
    }
}

